/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.export.util.ConvertUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImportingEntryEndPlugin
extends ImportPermissionPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(ImportingEntryEndPlugin.class);
    private static final String KEY_MYFIELDCONTAINER = "resultpanel";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNIKNOW = "iknowbtn";
    private static final String EXPORTERRMSG = "exporterrmsg";
    private static final String EXPORTALLERRMSG = "exportallerrmsg";
    private static final String FAILED = "failed";
    private static final String FLEXPANELAP82 = "flexpanelap82";
    private static final String BOS_IMPORT = "bos-import";
    private static final String RESULT_ENTRY_ENTITY = "result_entryentity";
    private static final String ENTRY_NAME = "entryname";
    private static final String SUCCESS_ROWS = "success_rows";
    private static final String FAIL_ROWS = "fail_rows";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, EXPORTERRMSG, EXPORTALLERRMSG});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject info = (JSONObject)view.getFormShowParameter().getCustomParams().get("info");
        Boolean exportAll = (Boolean)view.getFormShowParameter().getCustomParams().get("exportall");
        String failed = info.getString(FAILED);
        int failedNum = Integer.parseInt(failed);
        if (failedNum > 0) {
            view.setVisible(Boolean.TRUE, new String[]{BTNCANCEL});
            view.setVisible(Boolean.FALSE, new String[]{BTNIKNOW});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{BTNIKNOW});
            view.setVisible(Boolean.FALSE, new String[]{BTNCANCEL});
        }
        view.setVisible(Boolean.valueOf(failedNum > 0), new String[]{BTNOK});
        view.setVisible(Boolean.valueOf(failedNum != 0), new String[]{FLEXPANELAP82});
        view.setVisible(exportAll, new String[]{EXPORTALLERRMSG});
        view.setVisible(Boolean.valueOf(exportAll == false), new String[]{EXPORTERRMSG});
        view.setVisible(Boolean.TRUE, new String[]{KEY_MYFIELDCONTAINER});
        JSONObject importLoggerMap = info.getJSONObject("importLoggerMap");
        JSONObject entryNameBindName = info.getJSONObject("entryNameBindName");
        this.initImportResultInfo(importLoggerMap, entryNameBindName);
    }

    private void initImportResultInfo(JSONObject importLoggerMap, JSONObject entryNameBindName) {
        if (importLoggerMap == null || importLoggerMap.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(RESULT_ENTRY_ENTITY, importLoggerMap.size());
        CardEntry cardEntry = (CardEntry)this.getControl(RESULT_ENTRY_ENTITY);
        int index = 0;
        for (String entryKey : importLoggerMap.keySet()) {
            Integer total = Integer.valueOf(importLoggerMap.getJSONObject(entryKey).getString("total"));
            Integer failed = Integer.valueOf(importLoggerMap.getJSONObject(entryKey).getString(FAILED));
            String entryName = entryNameBindName.getString(entryKey);
            this.getModel().setValue(ENTRY_NAME, (Object)entryName, index);
            this.getModel().setValue(SUCCESS_ROWS, (Object)(total - failed), index);
            this.getModel().setValue(FAIL_ROWS, (Object)failed, index);
            if (index > 0 && (index + 1) % 2 == 0) {
                cardEntry.setCustomProperties(RESULT_ENTRY_ENTITY, index, ImportingEntryEndPlugin.getBackColorStyle());
            }
            ++index;
        }
    }

    public static Map<String, Object> getBackColorStyle() {
        HashMap<String, Object> rowStyle = new HashMap<String, Object>(1);
        HashMap<String, String> labelStyle = new HashMap<String, String>(1);
        labelStyle.put("bc", "#F5F5F5");
        rowStyle.put("row_panelap", labelStyle);
        return rowStyle;
    }

    public void click(EventObject evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        String controlKey = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(controlKey)) {
            this.continueImport(result, importPermissionParamBuidler);
        }
        if (EXPORTERRMSG.equals(controlKey) || EXPORTALLERRMSG.equals(controlKey)) {
            this.exportExcelErrMsg(result, importPermissionParamBuidler, controlKey);
        }
    }

    private void exportExcelErrMsg(OperationResult result, ImportPermissionParam.Buidler importPermissionParamBuidler, String controlKey) {
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            this.doFailCheckRight(result);
            return;
        }
        try {
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            String stringLogger = this.getView().getViewNoPlugin(parentPageId).getPageCache().get("Cached_Import_Entry_Logger_DATA");
            ImportLogger logger = (ImportLogger)JSON.parseObject((String)stringLogger, ImportLogger.class);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object billFormId = formShowParameter.getCustomParam("BillFormId");
            if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
                String url = logger.getErrFile();
                proxy.addAction("download", (Object)(url + "&a=t&fId=" + billFormId));
                this.createOperateLog(true, url, controlKey);
                return;
            }
            if (logger.getFailed() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ImportingPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else {
                String msg = logger.toString().trim();
                if (!msg.isEmpty()) {
                    this.getView().showErrorNotification(msg);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportingPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        this.createOperateLog(false, "", controlKey);
    }

    private void createOperateLog(boolean isSucceed, String url, String controlKey) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billFormId = (String)formShowParameter.getCustomParam("BillFormId");
        String opName = ResManager.loadKDString((String)"\u5bfc\u51fa\u9519\u8bef\u6570\u636e", (String)"ImportingEntryEndPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u9519\u8bef\u6570\u636e", "ImportingEntryEndPlugin_0", BOS_IMPORT);
        if (StringUtils.equals((CharSequence)controlKey, (CharSequence)EXPORTALLERRMSG)) {
            opName = ResManager.loadKDString((String)"\u5bfc\u51fa\u5168\u91cf\u9519\u8bef\u6570\u636e", (String)"ImportingEntryEndPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
            opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u5168\u91cf\u9519\u8bef\u6570\u636e", "ImportingEntryEndPlugin_1", BOS_IMPORT);
        }
        String fileNameFromUrl = ConvertUtil.convertFileNameFromUrl((String)url, (String)"unresolved.xlsx", (String)"");
        if (isSucceed) {
            ImportOperationLog.getInstance().createAppLog(billFormId, opNameBridge, new MultiLangEnumBridge("\u5355\u636e\u4f53\u5bfc\u5165\u7ed3\u679c%1$s%2$s\u6210\u529f", "ImportingEntryEndPlugin_2", BOS_IMPORT), new String[]{opName, fileNameFromUrl});
            return;
        }
        ImportOperationLog.getInstance().createAppLog(billFormId, opNameBridge, new MultiLangEnumBridge("\u5355\u636e\u4f53\u5bfc\u5165\u7ed3\u679c%1$s%2$s\u5931\u8d25", "ImportingEntryEndPlugin_3", BOS_IMPORT), new String[]{opName, fileNameFromUrl});
    }

    private void continueImport(OperationResult result, ImportPermissionParam.Buidler importPermissionParamBuidler) {
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            this.doFailCheckRight(result);
            return;
        }
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        IFormView parentView = view.getViewNoPlugin(parameter.getParentPageId());
        parentView.invokeOperation((String)parameter.getCustomParam("OperateKey"));
        view.close();
        view.sendFormAction(parentView);
    }
}

