/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.form.plugin.ImportingPlugin;
import kd.bos.form.plugin.importentry.insertentryrows.ImportEntryInsertRows;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import kd.bos.form.plugin.importentry.resolving.ImportEntryContext;
import kd.bos.form.plugin.importentry.resolving.ImportEntryResolve;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.util.ImportAndExportEntryUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ImportingEntryPlugin
extends ImportPermissionPlugin
implements ProgresssListener {
    private static final String IMPORTENTRY = "2";
    private static final String IMPORTTYPE = "importtype";
    private static final String NAME = "name";
    private static final String BILLSTATUS = "billstatus";
    private static final String IMPORTSTATUS = "importstatus";
    private static final String CREATETIME = "createtime";
    private static final String SOURCE_OBJ_ID = "sourceObj_id";
    private static final String BILLNO = "billno";
    private static final String BOS_IMPORT_ENTRY_RESULT = "bos_import_entry_result";
    private static final Log log = LogFactory.getLog(ImportingPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BILLFORMID = "BillFormId";
    protected static ThreadPool THREADPOOL = ThreadPools.newCachedThreadPool((String)"ImportEntryThreadPool", (int)6, (int)12);
    private static final String BOS_IMPORTLOG = "bos_importlog";
    private static final String IMPORT_LABEL = "importlabel";
    private static final String ENTRY_DETAIL = "entry_detail";
    private static final String ENTRY_NAME = "entryname";
    private static final String ENTRY_PROGRESS = "entry_progress";
    private static final String BOS_IMPORT = "bos-import";

    public void registerListener(EventObject e) {
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter params = this.getView().getFormShowParameter();
        String billFormId = (String)params.getCustomParam(BILLFORMID);
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
        this.initImportEntryDetail();
        try {
            String appid = (String)params.getCustomParam("ServiceAppId");
            String listName = (String)params.getCustomParam("ListName");
            Object logId = this.createImportLog(billFormId, listName);
            String checkRightAppId = (String)params.getCustomParam("CheckRightAppId");
            String url = (String)params.getCustomParam("Url");
            Boolean setNULL = Boolean.valueOf((String)params.getCustomParam("SetNULL"));
            String validSheetNamesString = (String)params.getCustomParam("validSheetNames");
            List validSheetNames = JSON.parseArray((String)validSheetNamesString, String.class);
            ImportEntryContext ctx = new ImportEntryContext(view, (String)params.getCustomParam("topPageId"), appid, checkRightAppId, listName, billFormId, url, validSheetNames);
            ctx.setExportAll((Boolean)params.getCustomParam("exportall"));
            ctx.setImportEntryLogPk(logId.toString());
            ctx.addOption("SetNULL", setNULL);
            ctx.setImportType(ImportEntryTypeEnum.getImportTypeEnum((String)params.getCustomParam("importType")));
            ctx.setFirePlugin((Boolean)params.getCustomParam("firePlugin"));
            ctx.setRequestContext(RequestContext.get());
            progress.start();
            ImportEntryResolve importEntryResolve = new ImportEntryResolve(ctx, new HeartBeat());
            ImportEntryInsertRows importEntryInsertRows = new ImportEntryInsertRows(ctx);
            THREADPOOL.submit((Callable)importEntryResolve);
            THREADPOOL.submit((Callable)importEntryInsertRows);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportingPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportingPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    private void initImportEntryDetail() {
        Object importEntryNamesMap = this.getView().getFormShowParameter().getCustomParam("importEntryNamesMap");
        if (StringUtils.isBlank((Object)importEntryNamesMap)) {
            return;
        }
        Map entryNames = (Map)SerializationUtils.fromJsonString((String)((String)importEntryNamesMap), Map.class);
        this.getModel().batchCreateNewEntryRow(ENTRY_DETAIL, entryNames.size());
        HashMap<String, Integer> entryIndexMap = new HashMap<String, Integer>(entryNames.size());
        int index = 0;
        for (Map.Entry entry : entryNames.entrySet()) {
            String key = (String)entry.getKey();
            String name = (String)entry.getValue();
            this.getModel().setValue(ENTRY_NAME, (Object)name, index);
            this.getModel().setValue(ENTRY_PROGRESS, (Object)ResManager.loadKDString((String)"\u5f85\u5bfc\u5165", (String)"ImportingEntryPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]), index);
            entryIndexMap.put(key, index);
            ++index;
        }
        this.getPageCache().put("Entry_Progress_Index_Mapping", SerializationUtils.toJsonString(entryIndexMap));
    }

    public void onProgress(ProgressEvent evt) {
        int importProgress = 1;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Entry_Logger");
        log.debug("Cached_Import_Logger<----" + cacheLogStr);
        IFormView view = this.getView();
        JSONObject info = JSON.parseObject((String)cacheLogStr);
        if (info != null) {
            importProgress = info.getIntValue("progress");
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            int row = info.getIntValue("failed") + info.getIntValue("succeed");
            int lastrow = Math.max(0, info.getIntValue("total"));
            JSONObject importLoggerMap = info.getJSONObject("importLoggerMap");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastrow);
            }
            if (lastrow > 0) {
                HashMap<String, Integer> meta = new HashMap<String, Integer>();
                meta.put("itime", 3000);
                view.updateControlMetadata(PROGRESSBARAP, meta);
            }
            if (null != importLoggerMap && !importLoggerMap.isEmpty()) {
                this.updateImportingEntryProgress(importLoggerMap);
            }
            if (importProgress < 0 || info.containsKey((Object)"err")) {
                String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef", (String)"ImportingPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]);
                ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
                progressbar.stop();
                evt.setProgress(100);
                this.getView().showErrorNotification(err);
                return;
            }
            if (this.getPageCache().get("firstIn") != null && importProgress >= 100) {
                this.showEndForm(info);
                evt.setProgress(importProgress);
                return;
            }
            this.getPageCache().put("firstIn", "false");
        }
        evt.setProgress(importProgress - 1);
    }

    private void updateImportingEntryProgress(JSONObject importLoggerMap) {
        String indexMapping = this.getPageCache().get("Entry_Progress_Index_Mapping");
        if (StringUtils.isBlank((CharSequence)indexMapping)) {
            return;
        }
        Map entryIndex = (Map)SerializationUtils.fromJsonString((String)indexMapping, Map.class);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRY_DETAIL);
        for (String entryKey : importLoggerMap.keySet()) {
            Integer index = (Integer)entryIndex.get(entryKey);
            if (null == index) continue;
            JSONObject importLogger = importLoggerMap.getJSONObject(entryKey);
            int lastRowIndex = importLogger.getIntValue("lastRowIndex") - 4;
            int total = importLogger.getIntValue("total");
            String progress = ResManager.loadKDString((String)"\u5f85\u5bfc\u5165", (String)"ImportingEntryPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]);
            String importing = "";
            if (lastRowIndex > 0 && lastRowIndex == total) {
                progress = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ImportingEntryPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
                cardEntry.setCustomProperties(ENTRY_DETAIL, index.intValue(), ImportAndExportEntryUtil.getImportedOrExportedStyles((String)IMPORT_LABEL, (String)ENTRY_NAME, (String)ENTRY_PROGRESS));
            } else if (lastRowIndex > 0) {
                progress = String.format(ResManager.loadKDString((String)"%1$s/%2$s\u884c", (String)"ImportingEntryPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]), total, lastRowIndex);
                importing = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165", (String)"ImportingEntryPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]);
                cardEntry.setCustomProperties(ENTRY_DETAIL, index.intValue(), ImportAndExportEntryUtil.getImportingOrExportingStyles((String)IMPORT_LABEL, (String)ENTRY_NAME, (String)ENTRY_PROGRESS));
            }
            this.getModel().setValue(ENTRY_PROGRESS, (Object)progress, index.intValue());
            this.getModel().setValue(IMPORT_LABEL, (Object)importing, index.intValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String checkConfirm = this.getPageCache().get("checkClose");
        if (!Boolean.parseBoolean(checkConfirm)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u8be5\u5f39\u7a97\u4e0d\u4f1a\u7ec8\u6b62\u5355\u636e\u4f53\u5bfc\u5165\uff0c\u4f46\u65e0\u6cd5\u67e5\u770b\u5bfc\u5165\u8fdb\u5ea6\uff0c\u60a8\u786e\u5b9a\u5173\u95ed\u5417\uff1f", (String)"ImportingEntryPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)"CLOSE_CONFIRMED", (CharSequence)messageBoxClosedEvent.getCallBackId()) && result == MessageBoxResult.Yes) {
            this.getPageCache().put("checkClose", String.valueOf(true));
            this.getView().close();
        }
    }

    private Object createImportLog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)BOS_IMPORTLOG);
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set(NAME, (Object)name);
        dyn.set(BILLSTATUS, (Object)"C");
        dyn.set(IMPORTSTATUS, (Object)"1");
        dyn.set(CREATETIME, (Object)new TimeService().now());
        dyn.set(IMPORTTYPE, (Object)IMPORTENTRY);
        if (StringUtils.isNotBlank((CharSequence)billFormId)) {
            dyn.set(SOURCE_OBJ_ID, (Object)billFormId);
        }
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber(BOS_IMPORTLOG, dyn, null);
        dyn.set(BILLNO, (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }

    private void showEndForm(JSONObject info) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_IMPORT_ENTRY_RESULT);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        showParameter.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        showParameter.setCustomParam("info", (Object)info);
        showParameter.setCustomParam("exportall", this.getView().getFormShowParameter().getCustomParam("exportall"));
        showParameter.setCustomParam("OperateKey", this.getView().getFormShowParameter().getCustomParam("OperateKey"));
        showParameter.setCustomParam(BILLFORMID, this.getView().getFormShowParameter().getCustomParam(BILLFORMID));
        this.getView().showForm(showParameter);
    }
}

