/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.resolving;

import java.io.InputStream;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.importentry.resolving.ImportEntryContext;
import kd.bos.form.plugin.importentry.resolving.ImportEntrySheetHandler;
import kd.bos.form.plugin.importentry.strategy.ImportEntryThread;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.impt.ExcelReaderForEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ImportEntryResolve
extends ImportEntryThread {
    private static final Log log = LogFactory.getLog(ImportEntryResolve.class);
    protected ImportEntryContext ctx;
    private HeartBeat heartbeat = new HeartBeat();
    protected MainEntityType mainEntityType;

    public ImportEntryResolve(ImportEntryContext ctx, HeartBeat heartbeat) {
        super("resolve");
        this.ctx = ctx;
        this.heartbeat = heartbeat;
    }

    @Override
    public final Object call() {
        try {
            if (!"resolve".equals(this.getType())) {
                return null;
            }
            this.resolveExcel();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode(null, e.getMessage()), new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveExcel() {
        FileService tempFileCache = FileServiceFactory.getAttachmentFileService();
        ExcelReaderForEntry reader = new ExcelReaderForEntry();
        Map<String, Object> option = this.ctx.getOption();
        String url = this.ctx.getFileUrl();
        try (InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, tempFileCache.getInputStream(url));){
            this.mainEntityType = this.buildMainEntityType();
            reader.read(this.ctx.getValidSheetNames(), in, new ImportEntrySheetHandler(this.ctx, this.mainEntityType, option, this.heartbeat));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String importErrMsg = e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"BatchImportPlugin_1", (String)"bos-import", (Object[])new Object[0]);
            this.ctx.getImportLogger().log(Integer.valueOf(0), importErrMsg);
            this.ctx.feedbackProgress("", 0, true);
        }
        finally {
            this.ctx.setCompleted(true);
        }
    }

    protected MainEntityType buildMainEntityType() {
        if (this.mainEntityType == null) {
            this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBillFormId());
        }
        if (this.mainEntityType instanceof QueryEntityType) {
            this.mainEntityType = ((QueryEntityType)this.mainEntityType).getMainEntityType();
        }
        return this.mainEntityType;
    }

    public String getBillFormId() {
        return this.ctx.getBillFormId();
    }
}

