/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.strategy;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import org.apache.commons.collections4.CollectionUtils;

public interface ImportTreeRowIteratorStategy {
    default public void iterate(ImportTreeRowInfo.RowInfo rowInfo, Consumer<ImportTreeRowInfo.RowInfo> func) {
        this.iterateLevel(rowInfo, rowInfos -> rowInfos.forEach(func));
    }

    public void iterateLevel(ImportTreeRowInfo.RowInfo var1, Consumer<List<ImportTreeRowInfo.RowInfo>> var2);

    public static class SmoothStategy
    implements ImportTreeRowIteratorStategy {
        @Override
        public void iterateLevel(ImportTreeRowInfo.RowInfo rowInfo, Consumer<List<ImportTreeRowInfo.RowInfo>> func) {
            List<List<ImportTreeRowInfo.RowInfo>> rowInfosLevel = this.smoothRowInfoWithPoint(rowInfo);
            rowInfosLevel.forEach(func);
        }

        private List<List<ImportTreeRowInfo.RowInfo>> smoothRowInfoWithPoint(ImportTreeRowInfo.RowInfo root) {
            ArrayList<List<ImportTreeRowInfo.RowInfo>> list = new ArrayList<List<ImportTreeRowInfo.RowInfo>>(10);
            if (root == null) {
                return list;
            }
            LinkedList<ImportTreeRowInfo.RowInfo> queue = new LinkedList<ImportTreeRowInfo.RowInfo>();
            queue.offer(root);
            while (!queue.isEmpty()) {
                int size = queue.size();
                ArrayList<ImportTreeRowInfo.RowInfo> levelList = new ArrayList<ImportTreeRowInfo.RowInfo>(10);
                for (int i = 0; i < size; ++i) {
                    ImportTreeRowInfo.RowInfo levelNode = (ImportTreeRowInfo.RowInfo)queue.poll();
                    levelList.add(levelNode);
                    for (ImportTreeRowInfo.RowInfo childNode : levelNode.getChildTreeRows()) {
                        queue.offer(childNode);
                    }
                }
                list.add(levelList);
            }
            return list;
        }
    }

    public static class ListStategy
    implements ImportTreeRowIteratorStategy {
        @Override
        public void iterateLevel(ImportTreeRowInfo.RowInfo rowInfo, Consumer<List<ImportTreeRowInfo.RowInfo>> func) {
        }

        public List<ImportTreeRowInfo.RowInfo> iterateAll(ImportTreeRowInfo.RowInfo rowInfo, Consumer<List<ImportTreeRowInfo.RowInfo>> func) {
            List<ImportTreeRowInfo.RowInfo> rowInfosLevel = this.collectRowInfoToList(rowInfo);
            func.accept(rowInfosLevel);
            return rowInfosLevel;
        }

        private List<ImportTreeRowInfo.RowInfo> collectRowInfoToList(ImportTreeRowInfo.RowInfo root) {
            ArrayList<ImportTreeRowInfo.RowInfo> list = new ArrayList<ImportTreeRowInfo.RowInfo>();
            if (root == null) {
                return list;
            }
            LinkedList<ImportTreeRowInfo.RowInfo> queue = new LinkedList<ImportTreeRowInfo.RowInfo>();
            queue.offer(root);
            while (!queue.isEmpty()) {
                int size = queue.size();
                ArrayList<ImportTreeRowInfo.RowInfo> levelList = new ArrayList<ImportTreeRowInfo.RowInfo>(10);
                for (int i = 0; i < size; ++i) {
                    ImportTreeRowInfo.RowInfo levelNode = (ImportTreeRowInfo.RowInfo)queue.poll();
                    levelList.add(levelNode);
                    if (levelNode.getChildTreeRows() == null) continue;
                    for (ImportTreeRowInfo.RowInfo childNode : levelNode.getChildTreeRows()) {
                        queue.offer(childNode);
                    }
                }
                list.addAll(levelList);
            }
            return list;
        }
    }

    public static class CollectStategy
    implements ImportTreeRowIteratorStategy {
        @Override
        public void iterateLevel(ImportTreeRowInfo.RowInfo rowInfo, Consumer<List<ImportTreeRowInfo.RowInfo>> func) {
            List<List<ImportTreeRowInfo.RowInfo>> rowInfosLevel = this.collectChildrens(rowInfo);
            rowInfosLevel.forEach(func);
        }

        private List<List<ImportTreeRowInfo.RowInfo>> collectChildrens(ImportTreeRowInfo.RowInfo root) {
            ArrayList<List<ImportTreeRowInfo.RowInfo>> list = new ArrayList<List<ImportTreeRowInfo.RowInfo>>();
            if (root == null) {
                return list;
            }
            LinkedList<ImportTreeRowInfo.RowInfo> queue = new LinkedList<ImportTreeRowInfo.RowInfo>();
            queue.offer(root);
            while (!queue.isEmpty()) {
                int size = queue.size();
                for (int i = 0; i < size; ++i) {
                    ImportTreeRowInfo.RowInfo levelNode = (ImportTreeRowInfo.RowInfo)queue.poll();
                    List<ImportTreeRowInfo.RowInfo> childTreeRows = levelNode.getChildTreeRows();
                    if (CollectionUtils.isEmpty(childTreeRows)) continue;
                    for (ImportTreeRowInfo.RowInfo childNode : childTreeRows) {
                        queue.offer(childNode);
                    }
                    list.add(childTreeRows);
                }
            }
            return list;
        }
    }
}

