/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.importentry.model.PictureCheckBase;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.form.plugin.impt.ReferenceInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.svc.util.SystemParamUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import kd.bos.util.SecurityUtils;
import org.apache.commons.io.FilenameUtils;

public class ImportHelper {
    private static final Log log = LogFactory.getLog(ImportHelper.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String ROWNUM = "rowNum";
    private static final int FILE_SIZE_MB = 0x100000;
    public static final String BILLPARAMTER_ENTRYNUMBER_LIMIT = "import_entry_number_limit";
    public static final Integer ENTRYNUMBER_LIMIT = 20000;

    public static void invalidBill(List<ImportBillData> billdatas, ImportLogger logger) {
        ImportHelper.invalidBill(billdatas, logger, new HashMap<String, Object>());
    }

    public static void invalidBill(List<ImportBillData> billdatas, ImportLogger logger, Map<String, Object> cachedAdminDivision) {
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        boolean importPreInvalid = Boolean.TRUE.equals(systemParamService.loadPublicParameterFromCache("importpreinvalid"));
        HashMap<Integer, List<String>> needInput = new HashMap<Integer, List<String>>(billdatas.size());
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            if (bill.isEmpty()) continue;
            try {
                if (ImportHelper.mustInputValid(logger, cachedAdminDivision, needInput, it, bill, importPreInvalid) || !ImportHelper.entryRowLimitValid(logger, it, bill)) continue;
            }
            catch (Throwable throwable) {
                log.error(throwable);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), throwable);
                } else {
                    logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790", (String)"ImportHelper_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                it.remove();
                logger.fail();
                logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            }
        }
    }

    public static void invalidImg(List<ImportBillData> billdatas, ImportLogger logger, ImportContext ctx) {
        if (StringUtils.isEmpty((CharSequence)ctx.getImgZipUrl())) {
            return;
        }
        ImportHelper.uploadImages(billdatas, ctx);
        ImportHelper.reSetJsonImgUrl(billdatas, logger, ctx.getImgInfoWithServerUrl());
    }

    private static void uploadImages(List<ImportBillData> billdatas, ImportContext ctx) {
        HashMap<String, Long> pictureSizeCache = new HashMap<String, Long>();
        Map<PictureCheckBase, String> imgInfoWithServerUrl = ctx.getImgInfoWithServerUrl();
        List<PictureCheckBase> pictureImportCheckInfos = ImportHelper.collectImgData(billdatas, imgInfoWithServerUrl);
        if (pictureImportCheckInfos.isEmpty()) {
            return;
        }
        FileService imageService = FileServiceFactory.getImageFileService();
        for (PictureCheckBase checkBase : pictureImportCheckInfos) {
            String uploadImgInfo = ImportHelper.uploadImg(checkBase, imageService, ctx.getOption().get("imgDirPath").toString(), ctx, pictureSizeCache, imgInfoWithServerUrl);
            if (!StringUtils.isNotEmpty((CharSequence)uploadImgInfo)) continue;
            imgInfoWithServerUrl.put(checkBase, uploadImgInfo);
        }
        pictureSizeCache.clear();
    }

    private static void reSetJsonImgUrl(List<ImportBillData> billdatas, ImportLogger logger, Map<PictureCheckBase, String> imgDataWithServerUrl) {
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportEntityMapping entityMapping;
            ImportBillData bill = it.next();
            JSONObject sourceJson = bill.getData();
            boolean resetForBill = ImportHelper.resetForBill(logger, imgDataWithServerUrl, sourceJson, entityMapping = bill.getEntityMapping());
            if (resetForBill) continue;
            it.remove();
            logger.fail();
            logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
        }
    }

    private static boolean resetForBill(ImportLogger logger, Map<PictureCheckBase, String> imgDataWithServerUrl, JSONObject sourceJson, ImportEntityMapping entityMapping) {
        boolean resetSucceed = true;
        for (Map.Entry<String, ImportEntityMapping.ColInfo> entry : entityMapping.getCols().entrySet()) {
            String fieldKey = entry.getKey();
            ImportEntityMapping.ColInfo colInfo = entry.getValue();
            IDataEntityProperty prop = colInfo.getProperty();
            String value = sourceJson.getString(fieldKey);
            if (!(prop instanceof PictureProp) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
            PictureCheckBase checkBase = new PictureCheckBase(prop.getName(), value);
            String uploadInfo = imgDataWithServerUrl.get(checkBase);
            if (uploadInfo != null && !uploadInfo.startsWith("error")) {
                sourceJson.put(fieldKey, (Object)uploadInfo);
                continue;
            }
            resetSucceed = false;
            if (null == uploadInfo) {
                logger.log(sourceJson.getInteger(ROWNUM), String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u5bfc\u5165\u5931\u8d25\uff0c\u201c%2$s\u201d\u5728\u538b\u7f29\u5305\u5185\u4e0d\u5b58\u5728\u6216\u4e0a\u4f20\u5931\u8d25", (String)"ImportHelper_11", (String)BOS_IMPORT, (Object[])new Object[0]), prop.getDisplayName().getLocaleValue(), value));
                continue;
            }
            uploadInfo = uploadInfo.replaceFirst("error", "");
            logger.log(sourceJson.getInteger(ROWNUM), uploadInfo);
        }
        for (Map.Entry<String, Object> entry : entityMapping.getEntries().entrySet()) {
            JSONArray entryJsonArray = sourceJson.getJSONArray(entry.getKey());
            for (int i = 0; i < entryJsonArray.size(); ++i) {
                JSONObject entryJsonObject = entryJsonArray.getJSONObject(i);
                resetSucceed = ImportHelper.resetForBill(logger, imgDataWithServerUrl, entryJsonObject, (ImportEntityMapping)entry.getValue()) && resetSucceed;
            }
        }
        return resetSucceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String uploadImg(PictureCheckBase checkBase, FileService service, String imgDirPath, ImportContext ctx, Map<String, Long> pictureSizeCache, Map<PictureCheckBase, String> imgDataWithServerUrl) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream imageInTemp;
        InputStream imageIn;
        block16: {
            String string2;
            block15: {
                String string3;
                block14: {
                    if (null != imgDataWithServerUrl.get(checkBase)) {
                        return null;
                    }
                    if (StringUtils.isEmpty((CharSequence)imgDirPath)) return null;
                    if (!new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)imgDirPath)), FilenameUtils.getName((String)SecurityUtils.normalize((String)imgDirPath))).isDirectory()) {
                        return null;
                    }
                    imageIn = null;
                    imageInTemp = null;
                    byteArrayOutputStream = null;
                    try {
                        String imgUrlContext = SerializationUtils.toJsonString(imgDataWithServerUrl);
                        log.debug("current imgUrlContext is:" + imgUrlContext);
                        long allowedSize = ImportHelper.getAllowedSizeOfImg(ctx.getBillFormId(), checkBase.getPropName(), pictureSizeCache);
                        File tempFile = new File(imgDirPath + File.separator, FilenameUtils.getName((String)checkBase.getImageName()));
                        if (!tempFile.exists()) {
                            String string4 = null;
                            return string4;
                        }
                        long fileLength = tempFile.length();
                        if (allowedSize != 0L && allowedSize < fileLength) {
                            BigDecimal allowedSizeMB = new BigDecimal(allowedSize).divide(new BigDecimal(0x100000), 0, RoundingMode.HALF_DOWN);
                            String pictureFieldName = ImportHelper.getPictureFieldName(ctx.getBillFormId(), checkBase.getPropName());
                            string3 = String.format(ResManager.loadKDString((String)"error\u56fe\u7247\u538b\u7f29\u5305\u4e2d%1$s\uff0c\u8d85\u8fc7\u7cfb\u7edf\u53c2\u6570\u3001\u8bbe\u8ba1\u5668\u4e2d\u56fe\u7247\u5b57\u6bb5\u201c%2$s\u201d\u6216MC\u53c2\u6570\u8bbe\u7f6e\u7684\u4e0a\u4f20\u56fe\u7247\u6700\u5927\u503c%3$sMb\u3002", (String)"ImportHelper_15", (String)BOS_IMPORT, (Object[])new Object[0]), checkBase.getImageName(), pictureFieldName, allowedSizeMB);
                            FileSecurityUtil.safeClose((Closeable)imageInTemp);
                            break block14;
                        }
                        String fileName = tempFile.getName();
                        imageIn = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);
                        byteArrayOutputStream = ImportHelper.cloneInputStream(imageIn);
                        imageIn.close();
                        imageIn = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        imageInTemp = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        ImageIO.setUseCache(false);
                        BufferedImage read = ImageIO.read(imageIn);
                        if (read == null) {
                            log.error("image in is null");
                            string2 = null;
                            FileSecurityUtil.safeClose((Closeable)imageInTemp);
                            break block15;
                        }
                        RequestContext requestContext = RequestContext.getOrCreate();
                        String path = FileNameUtils.getImageFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)ctx.getAppId(), (String)ctx.getBillFormId(), (Object)0L, (String)(Uuid8.generateShortUuid() + "/" + fileName));
                        String url = service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)path, (InputStream)imageInTemp, (FileSource)FileSource.EXCEL_IMPORT));
                        if (StringUtils.isBlank((CharSequence)url)) {
                            log.error("upload image failed");
                        }
                        string = url;
                        FileSecurityUtil.safeClose((Closeable)imageInTemp);
                        break block16;
                    }
                    catch (IOException e) {
                        log.error("[\u5bfc\u5165\u56fe\u7247\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff1a]" + e);
                        return null;
                    }
                }
                FileSecurityUtil.safeClose((Closeable)imageIn);
                FileSecurityUtil.safeClose((Closeable)byteArrayOutputStream);
                return string3;
            }
            FileSecurityUtil.safeClose((Closeable)imageIn);
            FileSecurityUtil.safeClose((Closeable)byteArrayOutputStream);
            return string2;
        }
        FileSecurityUtil.safeClose((Closeable)imageIn);
        FileSecurityUtil.safeClose((Closeable)byteArrayOutputStream);
        return string;
        finally {
            FileSecurityUtil.safeClose(imageInTemp);
            FileSecurityUtil.safeClose(imageIn);
            FileSecurityUtil.safeClose(byteArrayOutputStream);
        }
    }

    private static long getAllowedSizeOfImg(String formId, String fieldName, Map<String, Long> pictureSizeCache) {
        Object sizeMb;
        String key = "formId:" + formId + ",fieldName:" + fieldName;
        if (null != pictureSizeCache.get(key)) {
            return pictureSizeCache.get(key);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        Map map = entityType.getAllFields();
        long propSetSizeByte = ((PictureProp)map.get(fieldName)).getMaxImgSize();
        propSetSizeByte *= 0x100000L;
        long sysSize = 0L;
        FileService fileService = FileServiceFactory.getImageFileService();
        long mcSizeByte = fileService.maxUploadSize() == 0L ? 0x3200000L : fileService.maxUploadSize();
        Map pubSysParam = ParameterReader.loadPublicParameterFromCache();
        if (pubSysParam != null && (sizeMb = pubSysParam.get("maxuploadimagesize")) != null && !"0".equals(sizeMb.toString())) {
            sysSize = Long.parseLong(String.valueOf(sizeMb));
            sysSize *= 0x100000L;
        }
        sysSize = sysSize == 0L ? mcSizeByte : Math.min(sysSize, mcSizeByte);
        long returnValue = propSetSizeByte == 0L ? sysSize : Math.min(propSetSizeByte, sysSize);
        pictureSizeCache.put(key, returnValue);
        log.debug("getAllowedSizeOfImg id:" + key + ",and size:" + returnValue);
        return returnValue;
    }

    private static String getPictureFieldName(String formId, String fieldName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        Map map = entityType.getAllFields();
        return ((IDataEntityProperty)map.get(fieldName)).getDisplayName().toString();
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) throws IOException {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    private static List<PictureCheckBase> collectImgData(List<ImportBillData> billdatas, Map<PictureCheckBase, String> imgDataWithServerUrl) {
        ArrayList<PictureCheckBase> checkBaseList = new ArrayList<PictureCheckBase>();
        for (ImportBillData bill : billdatas) {
            ImportEntityMapping entityMapping = bill.getEntityMapping();
            JSONObject sourceJson = bill.getData();
            ImportHelper.collectSingleBillImg(checkBaseList, imgDataWithServerUrl, entityMapping, sourceJson);
        }
        return checkBaseList;
    }

    private static void collectSingleBillImg(List<PictureCheckBase> checkBaseList, Map<PictureCheckBase, String> imgInfoWithServerUrl, ImportEntityMapping entityMapping, JSONObject sourceJson) {
        for (Map.Entry<String, ImportEntityMapping.ColInfo> colInfoEntry : entityMapping.getCols().entrySet()) {
            String fieldKey = colInfoEntry.getKey();
            ImportEntityMapping.ColInfo colInfo = colInfoEntry.getValue();
            IDataEntityProperty prop = colInfo.getProperty();
            String value = sourceJson.getString(fieldKey);
            if (prop instanceof PictureProp && StringUtils.isNotEmpty((CharSequence)value)) {
                List<PictureCheckBase> repeatList;
                PictureCheckBase checkBase = new PictureCheckBase();
                checkBase.setImageName(value);
                checkBase.setPropName(prop.getName());
                if (imgInfoWithServerUrl.get(checkBase) == null && CollectionUtils.isEmpty(repeatList = ImportHelper.getExistCheckImageInfo(checkBaseList, value, prop.getName()))) {
                    checkBaseList.add(checkBase);
                }
            }
            for (Map.Entry<String, ImportEntityMapping> entryMappingColInfoEntry : entityMapping.getEntries().entrySet()) {
                JSONArray entryJsonArray = sourceJson.getJSONArray(entryMappingColInfoEntry.getKey());
                if (entryJsonArray.isEmpty()) continue;
                for (int i = 0; i < entryJsonArray.size(); ++i) {
                    JSONObject entryJsonObject = entryJsonArray.getJSONObject(i);
                    ImportHelper.collectSingleBillImg(checkBaseList, imgInfoWithServerUrl, entryMappingColInfoEntry.getValue(), entryJsonObject);
                }
            }
        }
    }

    private static List<PictureCheckBase> getExistCheckImageInfo(List<PictureCheckBase> checkBaseList, String imageName, String propName) {
        return checkBaseList.stream().filter(item -> item.getImageName().equals(imageName) && item.getPropName().equals(propName)).collect(Collectors.toList());
    }

    private static boolean mustInputValid(ImportLogger logger, Map<String, Object> cachedAdminDivision, Map<Integer, List<String>> needInput, Iterator<ImportBillData> it, ImportBillData bill, boolean importPreInvalid) {
        if (!ImportHelper.checkValues(bill.getEntityMapping(), bill.getData(), needInput, logger, new ReferenceInteger(bill.getStartIndex()), cachedAdminDivision, importPreInvalid)) {
            if (!needInput.isEmpty()) {
                for (Map.Entry<Integer, List<String>> required : needInput.entrySet()) {
                    logger.log(required.getKey(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a%s\u3002", (String)"ImportHelper_4", (String)BOS_IMPORT, (Object[])new Object[0]), String.join((CharSequence)"\uff0c", (Iterable<? extends CharSequence>)required.getValue())));
                }
                needInput.clear();
            }
            logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            logger.fail();
            it.remove();
            return true;
        }
        return false;
    }

    private static boolean entryRowLimitValid(ImportLogger logger, Iterator<ImportBillData> it, ImportBillData bill) {
        HashMap entityKeyMap = new HashMap();
        for (Map.Entry<String, ImportEntityMapping> entrySet : bill.getEntityMapping().getEntries().entrySet()) {
            LinkedList<String> zentryEntityKeys = new LinkedList<String>();
            entityKeyMap.putIfAbsent(entrySet.getKey(), zentryEntityKeys);
            zentryEntityKeys.addAll(entrySet.getValue().getEntries().keySet());
        }
        if (bill.getEntityMapping().getEntityType() == null) {
            log.warn("bill.getEntityMapping().getEntityType() is null ,entryRowLimitValid result is true");
            return true;
        }
        Optional billParam = SystemParamUtil.getBillParam((String)bill.getEntityMapping().getEntityType().getName(), (String)BILLPARAMTER_ENTRYNUMBER_LIMIT);
        int entryNumberLimit = Integer.parseInt(((Object)billParam.orElse(ENTRYNUMBER_LIMIT)).toString());
        int currentRow = 0;
        for (Map.Entry entrySet : entityKeyMap.entrySet()) {
            Object entryJsonArr = bill.getData().get(entrySet.getKey());
            if (!(entryJsonArr instanceof JSONArray)) continue;
            currentRow += ((JSONArray)entryJsonArr).size();
            for (Object jsonEntryDatum : (JSONArray)entryJsonArr) {
                for (String zentryKey : (List)entrySet.getValue()) {
                    Object zentryJsonArr = ((JSONObject)jsonEntryDatum).get((Object)zentryKey);
                    if (!(zentryJsonArr instanceof JSONArray)) continue;
                    currentRow += ((JSONArray)zentryJsonArr).size();
                }
            }
        }
        if (currentRow > entryNumberLimit) {
            logger.log(Integer.valueOf(bill.getStartIndex()), String.format(ResManager.loadKDString((String)"\u5355\u636e\u5206\u5f55\u884c\u6570\u8d85\u8fc7\u5bfc\u5165\u5206\u5f55\u9650\u5236\uff0c\u5f53\u524d\u9650\u5236\u6570 %s \u6761\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u5206\u5f55\u6216\u4fee\u6539\u5355\u636e\u53c2\u6570\u914d\u7f6e\u3002", (String)"ImportHelper_10", (String)BOS_IMPORT, (Object[])new Object[0]), entryNumberLimit));
            it.remove();
            logger.fail();
            logger.signTotalRow(bill.getEndIndex() - bill.getStartIndex() + 1);
            return true;
        }
        return false;
    }

    public static int calcColumnWidth(String caption, int defColWidth) {
        int colWidth = 0;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes().length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public static int calcColumnWidth(String caption, int defColWidth, double designatedColWidth) {
        if (designatedColWidth > 0.0) {
            return (int)(designatedColWidth * 8.0 * 32.0);
        }
        return ImportHelper.calcColumnWidth(caption, defColWidth);
    }

    private static boolean checkValues(ImportEntityMapping mapping, JSONObject data, Map<Integer, List<String>> needInput, ImportLogger logger, ReferenceInteger index, Map<String, Object> cachedAdminDivision, boolean importPreInvalid) {
        boolean isValid = true;
        if (data == null) {
            return true;
        }
        Object val = null;
        for (Map.Entry<String, ImportEntityMapping.ColInfo> entry : mapping.getCols().entrySet()) {
            String fieldKey = entry.getKey();
            ImportEntityMapping.ColInfo colInfo = entry.getValue();
            String displayName = colInfo.getDisplayName();
            IDataEntityProperty prop = colInfo.getProperty();
            val = data.get((Object)fieldKey);
            if (data.containsKey((Object)fieldKey) && val == null) continue;
            if (StringUtils.isBlank((Object)val) || val instanceof Map && ((Map)val).isEmpty()) {
                if (!colInfo.isMustInput() || !importPreInvalid) continue;
                List needInputFields = needInput.computeIfAbsent(index.getValue(), k -> new ArrayList(32));
                needInputFields.add(colInfo.getDisplayName());
                isValid = false;
                continue;
            }
            if (prop instanceof AdminDivisionProp) {
                String fullName = ((String)val).replace('/', '_');
                Object adminId = cachedAdminDivision.get(fullName);
                if (adminId == null) {
                    adminId = ORMUtil.getAdminDivisionByName((String)fullName);
                    cachedAdminDivision.put(fullName, adminId);
                }
                if (StringUtils.isNotBlank((Object)adminId)) {
                    data.put(fieldKey, adminId);
                    continue;
                }
                if (!importPreInvalid) continue;
                logger.log(index.getValue(), String.format(ResManager.loadKDString((String)"%1$s\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u5339\u914d\u5230%2$s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImportHelper_13", (String)BOS_IMPORT, (Object[])new Object[0]), displayName, val));
                isValid = false;
                continue;
            }
            if (prop instanceof ComboProp) {
                List items = ((ComboProp)prop).getComboItems();
                if (items == null || items.isEmpty()) continue;
                Set<String> values = ImportHelper.getComboValues(prop, (String)val, items);
                if (StringUtils.isNotBlank((Object)val) && values.isEmpty() && importPreInvalid) {
                    logger.log(index.getValue(), String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%2$s\u3002", (String)"ImportHelper_14", (String)BOS_IMPORT, (Object[])new Object[0]), prop.getDisplayName(), val));
                    isValid = false;
                }
                if (StringUtils.isNotBlank((Object)val) && values.isEmpty() && !importPreInvalid) continue;
                data.put(fieldKey, (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)values));
                continue;
            }
            if (prop instanceof BooleanProp) {
                HashSet<String> trueSet = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"ImportHelper_0", (String)BOS_IMPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"ImportHelper_1", (String)BOS_IMPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"ImportHelper_2", (String)BOS_IMPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"ImportHelper_3", (String)BOS_IMPORT, (Object[])new Object[0]), "true", "yes", "ok"));
                data.put(fieldKey, (Object)trueSet.contains(((String)val).toLowerCase()));
                continue;
            }
            if (!(prop instanceof FlexProp) || !(val instanceof Map) || !importPreInvalid) continue;
            Map flexItem = (Map)val;
            for (Map.Entry entry2 : flexItem.entrySet()) {
                Object flexValueObj = entry2.getValue();
                if (!(flexValueObj instanceof Map) || !((Map)flexValueObj).isEmpty()) continue;
                String msg = colInfo.getDisplayName() + ":\"" + (String)entry2.getKey() + "\"";
                msg = String.format(ResManager.loadKDString((String)"%s\u7684\u7f16\u7801\u6216\u540d\u79f0\u81f3\u5c11\u586b\u4e00\u9879", (String)"ImportHelper_9", (String)BOS_IMPORT, (Object[])new Object[0]), msg);
                logger.log(index.getValue(), msg);
                isValid = false;
            }
        }
        for (Map.Entry<String, Object> entry : mapping.getEntries().entrySet()) {
            JSONArray rows = data.getJSONArray(entry.getKey());
            if (rows == null || rows.isEmpty()) continue;
            int n = rows.size();
            for (int i = 0; i < n; ++i) {
                JSONObject dataObj = rows.getJSONObject(i);
                Integer rowNum = dataObj.getInteger(ROWNUM);
                if (rowNum == null) {
                    boolean bl = isValid = ImportHelper.checkValues((ImportEntityMapping)entry.getValue(), dataObj, needInput, logger, index, cachedAdminDivision, importPreInvalid) && isValid;
                    if (((ImportEntityMapping)entry.getValue()).getEntries().size() != 0) continue;
                    index.setValue(index.getValue() + 1);
                    continue;
                }
                isValid = ImportHelper.checkValues((ImportEntityMapping)entry.getValue(), dataObj, needInput, logger, new ReferenceInteger(rowNum), cachedAdminDivision, importPreInvalid) && isValid;
            }
        }
        return isValid;
    }

    public static Set<String> getComboValues(IDataEntityProperty prop, String val, List<ValueMapItem> items) {
        List<String> cellValueSplit = Arrays.asList(val.split(","));
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        boolean isMulCombo = prop instanceof MulComboProp;
        if (isMulCombo) {
            for (String cellValue : cellValueSplit) {
                ImportHelper.findAndInsertComboValue(items, values, cellValue);
            }
        } else {
            String cellValue = cellValueSplit.get(0);
            ImportHelper.findAndInsertComboValue(items, values, cellValue);
        }
        return values;
    }

    private static void findAndInsertComboValue(List<ValueMapItem> items, Set<String> values, String cellValue) {
        Optional<ValueMapItem> optionalValueMapItem = items.stream().filter(item -> StringUtils.equals((CharSequence)cellValue, (CharSequence)item.getName().getLocaleValue())).findFirst();
        optionalValueMapItem.ifPresent(valueMapItem -> values.add(valueMapItem.getValue()));
    }
}

