/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.entity.report.ReportCotent;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.impt.background.ImportProgress;
import kd.bos.form.impt.background.ImportProgressImpl;
import kd.bos.form.impt.monitor.ImportConfigHelper;
import kd.bos.form.impt.monitor.ImportMonitor;
import kd.bos.form.impt.monitor.ReportMoudleEnum;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.IImportDataPluginSupportKS;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.svc.util.PermissionParam;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.utils.ImportPluginUtils;
import kd.sdk.kingscript.host.HostObjectUtil;
import kd.sdk.kingscript.host.ScriptProxyFactory;
import org.apache.commons.collections4.MapUtils;

public class ImportService
extends AbstractTask {
    private static final String BOS_IMPORT = "bos-import";
    public static final String PAGE_ID = "pageId";
    public static final String LOG_ID = "logId";
    public static final String FORM_ID = "bos_importlog";
    public static final String IS_DELETED = "isdeleted";
    private static final Log log = LogFactory.getLog(ImportService.class);
    private static final String BTN_OK = "btnok";
    private static final String SUCCESSPANEL = "successpanel";
    private static final String FAILPANEL = "failpanel";
    private static final String BTNCLOSE = "buttonap";
    private static final String SUSPENDPANEL = "suspendpanel";
    private static final String BILLFORMID = "BillFormId";
    protected String taskId = null;
    private ImportProgress importProgress;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private Boolean isFromTask = Boolean.FALSE;
    private static final String IMPORTPLUGIN_TYPE = "ImportPlugin_type";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ImportThreadPool", (int)2, (int)ImportPluginUtils.parseInt(System.getProperty("bos.importing.thread.max", "12"), 12));

    public void startImport(String pageId, String logId) {
        IImportDataPlugin pluginCheck;
        IImportDataPlugin plugin;
        SessionManager sm = SessionManager.getCurrent();
        sm.setRequestThread(true);
        IFormView formView = sm.getView(pageId);
        formView.setVisible(Boolean.FALSE, new String[]{FAILPANEL, SUCCESSPANEL, BTNCLOSE, BTN_OK, SUSPENDPANEL});
        FormShowParameter params = formView.getFormShowParameter();
        String appid = (String)params.getCustomParam("ServiceAppId");
        String checkRightAppId = (String)params.getCustomParam("CheckRightAppId");
        String formShowParameterAppId = params.getAppId();
        String billFormId = (String)params.getCustomParam(BILLFORMID);
        String listName = (String)params.getCustomParam("ListName");
        String pluginName = (String)params.getCustomParam("ImportPlugin");
        String pluginType = (String)params.getCustomParam(IMPORTPLUGIN_TYPE);
        String url = (String)params.getCustomParam("Url");
        String imgZipUrl = (String)params.getCustomParam("imgZipUrl");
        String attZipUrl = (String)params.getCustomParam("attZipUrl");
        String opSaveKey = (String)params.getCustomParam("OpSave");
        String importType = (String)params.getCustomParam("Type");
        String keyfields = (String)params.getCustomParam("KeyFields");
        Map customParamMap = (Map)params.getCustomParam("customParamMap");
        Boolean overrideEntry = Boolean.valueOf((String)params.getCustomParam("OverrideEntry"));
        Boolean setNULL = Boolean.valueOf((String)params.getCustomParam("SetNULL"));
        Boolean splitSubEntries = Boolean.valueOf((String)params.getCustomParam("SplitSubEntries"));
        Boolean forUpdateMultiLangFields = Boolean.valueOf((String)params.getCustomParam("ForUpdateMultiLangFields"));
        ImportMonitor importMonitor = new ImportMonitor();
        importMonitor.setMonitorEnable(ImportConfigHelper.getSettingOfMonitorEnable(billFormId));
        RequestContext rc = RequestContext.get();
        String readOriginalNumString = System.getProperty("import.readOriginalNum", Boolean.toString(false));
        Boolean readOriginalNum = Boolean.parseBoolean(readOriginalNumString);
        ImportContext ctx = new ImportContext(formView, logId, appid, checkRightAppId, listName, billFormId, opSaveKey, url, formShowParameterAppId, this.isFromTask, this.taskId, this.countDownLatch, this.getImportProgress(), imgZipUrl, importMonitor, readOriginalNum).addOption("importtype", importType).addOption("KeyFields", keyfields).addOption("ForUpdateMultiLangFields", forUpdateMultiLangFields).addOption("OverrideEntry", overrideEntry).addOption("SetNULL", setNULL).addOption("SplitSubEntries", splitSubEntries);
        if (MapUtils.isNotEmpty((Map)customParamMap)) {
            ctx.addOption("customParamMap", customParamMap);
        }
        ctx.setAttZipUrl(attZipUrl);
        ctx.addOption("appid", appid);
        HashMap<ReportMoudleEnum, ReportCotent> reportCotentMap = new HashMap<ReportMoudleEnum, ReportCotent>(3);
        ReportCotent importParamReportCotent = importMonitor.buildReportCotent(1, logId, 3, ReportMoudleEnum.IMPORTPARM);
        reportCotentMap.put(ReportMoudleEnum.IMPORTPARM, importParamReportCotent);
        ReportCotent pluginMonitorReportCotent = importMonitor.buildReportCotent(2, logId, 3, ReportMoudleEnum.PLUGINMONITOR);
        reportCotentMap.put(ReportMoudleEnum.PLUGINMONITOR, pluginMonitorReportCotent);
        ReportCotent importLogReportCotent = importMonitor.buildReportCotent(3, logId, 3, ReportMoudleEnum.IMPORTLOG);
        reportCotentMap.put(ReportMoudleEnum.IMPORTLOG, importLogReportCotent);
        importMonitor.setReportCotentMap(reportCotentMap);
        importMonitor.addParam("appId", appid, ResManager.loadKDString((String)"\u5e94\u7528ID", (String)"ImportService_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("checkRightAppId", checkRightAppId, ResManager.loadKDString((String)"\u9a8c\u6743\u5e94\u7528ID", (String)"ImportService_1", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("billFormId", billFormId, ResManager.loadKDString((String)"\u5bfc\u5165\u5b9e\u4f53\u6807\u8bc6", (String)"ImportService_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("opSaveKey", opSaveKey, ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5ckey", (String)"ImportService_3", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("url", url, ResManager.loadKDString((String)"\u5bfc\u5165\u539f\u59cb\u6587\u4ef6url", (String)"ImportService_4", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("isFromTask", this.isFromTask, ResManager.loadKDString((String)"\u662f\u5426\u901a\u8fc7\u8c03\u5ea6\u4efb\u52a1\u5bfc\u5165", (String)"ImportService_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("taskId", this.taskId, ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1ID", (String)"ImportService_6", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("importtype", importType, ResManager.loadKDString((String)"\u5bfc\u5165\u7c7b\u578b", (String)"ImportService_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("keyfields", keyfields, ResManager.loadKDString((String)"\u5bfc\u5165\u5339\u914d\u6761\u4ef6", (String)"ImportService_8", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("ForUpdateMultiLangFields", forUpdateMultiLangFields, ResManager.loadKDString((String)"#ForUpdateMultiLangFields\u53c2\u6570\u503c", (String)"ImportService_9", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("OverrideEntry", overrideEntry, ResManager.loadKDString((String)"#OverrideEntry\u53c2\u6570\u503c", (String)"ImportService_10", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("SetNULL", setNULL, ResManager.loadKDString((String)"#SetNULL\u53c2\u6570\u503c", (String)"ImportService_11", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("SplitSubEntries", splitSubEntries, ResManager.loadKDString((String)"#SplitSubEntries\u53c2\u6570\u503c", (String)"ImportService_12", (String)BOS_IMPORT, (Object[])new Object[0]));
        importMonitor.addParam("pluginName", pluginName, ResManager.loadKDString((String)"\u5bfc\u5165\u64cd\u4f5c\u63d2\u4ef6\u7c7b\u5168\u8def\u5f84", (String)"ImportService_13", (String)BOS_IMPORT, (Object[])new Object[0]));
        if (StringUtils.equals((CharSequence)pluginType, (CharSequence)String.valueOf(4))) {
            plugin = (IImportDataPlugin)ScriptProxyFactory.createPluginProxy((String)pluginName, ProjectInitializerManager::getEngineAutoDebug);
            pluginCheck = (IImportDataPlugin)HostObjectUtil.getHostObject((Object)plugin);
        } else {
            pluginCheck = plugin = forUpdateMultiLangFields == false && StringUtils.isNotBlank((CharSequence)pluginName) ? (IImportDataPlugin)TypesContainer.createInstance((String)pluginName) : new BatchImportPlugin();
        }
        String importModel = ResManager.loadKDString((String)"\u8001\u5bfc\u5165\uff08\u63d2\u4ef6\u57fa\u7c7b\u4e0d\u662fBatchImportPlugin\uff0c\u901a\u8fc7\u4e24\u4e2a\u8c03\u5ea6\u4efb\u52a1\u542f\u52a8\uff09", (String)"ImportService_14", (String)BOS_IMPORT, (Object[])new Object[0]);
        if (pluginCheck instanceof BatchImportPlugin) {
            importModel = ResManager.loadKDString((String)"\u65b0\u5bfc\u5165\uff08\u63d2\u4ef6\u57fa\u7c7b\u662fBatchImportPlugin\uff0c\u901a\u8fc7\u4e24\u4e2a\u5bfc\u5165\u7ebf\u7a0b\u542f\u52a8\uff09", (String)"ImportService_15", (String)BOS_IMPORT, (Object[])new Object[0]);
            BatchImportPlugin batchPlugin = ((IImportDataPluginSupportKS)plugin).setContext(rc, ctx, Arrays.asList("resolveExcel", "importData"));
            threadPool.submit((Callable)batchPlugin);
            threadPool.submit((Callable)batchPlugin);
        } else {
            ImportConfig conf = new ImportConfig(formView, ctx, this.isFromTask, this.countDownLatch);
            threadPool.submit((Callable)new ImportDataTask(rc, conf, "resolveExcel"));
            threadPool.submit((Callable)new ImportDataTask(rc, conf, "importData"));
        }
        importMonitor.addParam("importModel", importModel, ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u5f0f", (String)"ImportService_16", (String)BOS_IMPORT, (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            Object context = map.get("requestcontext");
            if (StringUtils.isNotBlank((Object)context)) {
                RequestContext reqctx = context instanceof RequestContext ? (RequestContext)context : (RequestContext)((JSONObject)context).toJavaObject(RequestContext.class);
                RequestContext.set((RequestContext)reqctx);
            }
            this.isFromTask = Boolean.TRUE;
            String logId = String.valueOf(map.get(LOG_ID));
            this.startImport((String)map.get(PAGE_ID), logId);
            this.countDownLatch.await();
            this.getImportProgress().feedbackLogId(map.get(LOG_ID));
            this.getImportProgress().complete();
        }
        catch (InterruptedException e) {
            try {
                log.error("\u5bfc\u5165\u8c03\u5ea6\u4efb\u52a1\u7ebf\u7a0b\u5f02\u5e38" + e, (Throwable)e);
                this.getImportProgress().feedbackLogId(map.get(LOG_ID));
                this.getImportProgress().complete();
            }
            catch (Throwable throwable) {
                this.getImportProgress().feedbackLogId(map.get(LOG_ID));
                this.getImportProgress().complete();
                if (map.get("concurrentID") != null && StringUtils.isNotEmpty((CharSequence)map.get("concurrentID").toString())) {
                    ConcurrencyLimiter.release((String)map.get("concurrentID").toString());
                }
                if (PermissionParam.isClearImpExpFiles()) {
                    FileHandlerUtil.tryDelFile(map.get("Url") != null ? map.get("Url").toString() : null);
                    FileHandlerUtil.tryDelFile(map.get("imgZipUrl") != null ? map.get("imgZipUrl").toString() : null);
                    FileHandlerUtil.tryDelFile(map.get("attZipUrl") != null ? map.get("attZipUrl").toString() : null);
                    DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)map.get(LOG_ID), (String)FORM_ID);
                    logObj.set(IS_DELETED, (Object)"2");
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("updateModifyDate", "false");
                    SaveServiceHelper.update((DynamicObject)logObj, (OperateOption)option);
                }
                throw throwable;
            }
            if (map.get("concurrentID") != null && StringUtils.isNotEmpty((CharSequence)map.get("concurrentID").toString())) {
                ConcurrencyLimiter.release((String)map.get("concurrentID").toString());
            }
            if (PermissionParam.isClearImpExpFiles()) {
                FileHandlerUtil.tryDelFile(map.get("Url") != null ? map.get("Url").toString() : null);
                FileHandlerUtil.tryDelFile(map.get("imgZipUrl") != null ? map.get("imgZipUrl").toString() : null);
                FileHandlerUtil.tryDelFile(map.get("attZipUrl") != null ? map.get("attZipUrl").toString() : null);
                DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)map.get(LOG_ID), (String)FORM_ID);
                logObj.set(IS_DELETED, (Object)"2");
                OperateOption option = OperateOption.create();
                option.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject)logObj, (OperateOption)option);
            }
        }
        if (map.get("concurrentID") != null && StringUtils.isNotEmpty((CharSequence)map.get("concurrentID").toString())) {
            ConcurrencyLimiter.release((String)map.get("concurrentID").toString());
        }
        if (PermissionParam.isClearImpExpFiles()) {
            FileHandlerUtil.tryDelFile(map.get("Url") != null ? map.get("Url").toString() : null);
            FileHandlerUtil.tryDelFile(map.get("imgZipUrl") != null ? map.get("imgZipUrl").toString() : null);
            FileHandlerUtil.tryDelFile(map.get("attZipUrl") != null ? map.get("attZipUrl").toString() : null);
            DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)map.get(LOG_ID), (String)FORM_ID);
            logObj.set(IS_DELETED, (Object)"2");
            OperateOption option = OperateOption.create();
            option.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.update((DynamicObject)logObj, (OperateOption)option);
        }
    }

    public void setTaskId(String id) {
        this.taskId = id;
    }

    public ImportProgress getImportProgress() {
        if (this.isFromTask.booleanValue() && this.importProgress == null && StringUtils.isNotBlank((CharSequence)this.taskId)) {
            this.importProgress = new ImportProgressImpl(this.taskId);
        }
        return this.importProgress;
    }
}

