/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.xml.sax.SAXException;

public class ImportSheetHandler
extends SheetHandler {
    private static final Log log = LogFactory.getLog(ExcelReader.class);
    private static final String BOS_IMPORT = "bos-import";
    private final ImportConfig conf;
    private final String url;
    private final LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private boolean errorData = false;
    private JSONObject data;
    private SheetHandler.ParsedRow currentRow;

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public ImportSheetHandler(ImportConfig conf, String path, LinkedBlockingQueue<ImportBillData> linkedBlockingQueue) {
        this.conf = conf;
        this.url = path;
        this.dataQueue = linkedBlockingQueue;
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        this.conf.getUrlLoggers().get(this.url).setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.conf.getUrlLoggers().get(this.url).setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                log.error(this.conf.getPageId() + "...\u83ab\u540d\u5176\u5999\u8bfb\u5230\u7684\u6570\u636e\u4e3a\u7a7a...\u5148\u8df3\u8fc7");
                return;
            }
            String entityName = row.get(0);
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(1);
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.conf.getEntityType().getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.conf.setComplete(this.url);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u81f4\u5bfc\u5165\u5931\u8d25\u3002\u6570\u636e\uff1a%s", (String)"ImportSheetHandler_0", (String)BOS_IMPORT, (Object[])new Object[0]), entityName));
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
            this.conf.setNewFormat(this.isNewFormat);
        }
        if (currRowNum >= 2) {
            if (this.isNewFormat) {
                this.buildBill(row);
            } else {
                this.buildBillOld(row);
            }
        }
    }

    private void buildBill(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.conf.getEntityType(), this.nameRow, row.getData());
        } else if (currRowNum > 3) {
            List<String> errMsg;
            if (!this.entityMapping.isEntityEmpty(row.getData())) {
                if (this.data != null) {
                    if (this.errorData) {
                        this.conf.getUrlLoggers().get(this.url).fail().tick();
                    } else {
                        this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum - 1, this.entityMapping));
                    }
                    this.errorData = false;
                }
                log.debug(this.conf.getPageId() + "...\u5bfc\u5165\u89e3\u6790Excel\u7684\u7b2c\u4e00\u6761\u6570\u636e\uff1a" + JSON.toJSONString(row.getData()));
                this.data = new JSONObject();
                this.startRowNum = currRowNum;
            }
            if (!(errMsg = this.entityMapping.push(row, this.data != null ? this.data : new JSONObject())).isEmpty()) {
                this.errorData = true;
                this.conf.getUrlLoggers().get(this.url).log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
            }
        }
    }

    private void buildBillOld(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (currRowNum == 2) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.conf.getEntityType(), this.nameRow);
        } else if (currRowNum > 2) {
            List<String> errMsg;
            if (!this.entityMapping.isEntityEmpty(row.getData())) {
                if (this.data != null) {
                    if (this.errorData) {
                        this.conf.getUrlLoggers().get(this.url).fail().tick();
                    } else {
                        this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum - 1, this.entityMapping));
                    }
                    this.errorData = false;
                }
                log.debug(this.conf.getPageId() + "...\u5bfc\u5165\u89e3\u6790Excel\u7684\u7b2c\u4e00\u6761\u6570\u636e\uff1a" + JSON.toJSONString(row.getData()));
                this.data = new JSONObject();
                this.startRowNum = currRowNum;
            }
            if (!(errMsg = this.entityMapping.push(row, this.data != null ? this.data : new JSONObject())).isEmpty()) {
                this.errorData = true;
                this.conf.getUrlLoggers().get(this.url).log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
            }
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!billData.isEmpty()) {
                this.fillBlankValues(this.entityMapping, billData.getData());
            }
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"ImportSheetHandler_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            log.error("\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", e);
            throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"ImportSheetHandler_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500) {
            this.conf.feedbackProgress(0, this.conf.getUrlLoggers().get(this.url), null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    private void fillBlankValues(ImportEntityMapping mapping, JSONObject data) {
        if (data != null) {
            for (String string : mapping.getCols().keySet()) {
                if (data.containsKey((Object)string)) continue;
                data.put(string, null);
            }
            for (Map.Entry entry : mapping.getEntries().entrySet()) {
                JSONArray rows = data.getJSONArray((String)entry.getKey());
                if (rows == null || rows.isEmpty()) continue;
                int size = rows.size();
                for (int i = 0; i < size; ++i) {
                    this.fillBlankValues((ImportEntityMapping)entry.getValue(), rows.getJSONObject(i));
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            this.conf.setComplete(this.url);
            if (this.errorData) {
                this.conf.getUrlLoggers().get(this.url).fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum, this.entityMapping);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, this.entityMapping);
            }
            this.addBillData(lastBillData);
            log.debug(this.conf.getPageId() + "...doAfterAllAnalysed..." + this.errorData + "..." + currRowNum);
        }
    }
}

