/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.impt;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.importentry.model.ImportEntryValid;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelReaderForEntry {
    private static final Log log = LogFactory.getLog(ExcelReaderForEntry.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readForEntryValid(InputStream in, ImportEntryValid importEntryValid, SheetHandler sheetHandler) throws Exception {
        File tempFile = null;
        OPCPackage pkg = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            pkg = OPCPackage.open((File)tempFile);
            XSSFReader.SheetIterator sheets = this.getSheets(sheetHandler, pkg);
            XMLReader parser = this.getParser(sheetHandler);
            while (sheets.hasNext()) {
                InputStream sheet = sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName()) || this.dealWithSheets(sheetHandler, sheets, new ArrayList<String>())) continue;
                importEntryValid.setValidSeq(0);
                importEntryValid.setHasErrorCol(false);
                try {
                    parser.parse(sheetSource);
                }
                catch (KDBizException e) {
                    if (StringUtils.equals((CharSequence)"nextSheet", (CharSequence)e.getErrorCode().getCode())) continue;
                    log.error((Throwable)e);
                    throw e;
                }
                finally {
                    sheet.close();
                }
            }
        }
        finally {
            if (pkg != null) {
                pkg.revert();
            }
            FileSecurityUtil.safeDeleteFile((File)tempFile);
        }
    }

    private boolean dealWithSheets(SheetHandler sheetHandler, XSSFReader.SheetIterator sheets, List<String> entryNames) {
        if (StringUtils.equals((CharSequence)"dropdown_items_sheet", (CharSequence)sheets.getSheetName())) {
            return true;
        }
        if (!entryNames.isEmpty() && !entryNames.contains(sheets.getSheetName())) {
            return true;
        }
        sheetHandler.setSheetName(sheets.getSheetName());
        Comments comments = sheets.getSheetComments();
        if (comments != null) {
            sheetHandler.addSheetComments(sheets.getSheetName(), (CommentsTable)comments);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(List<String> entryNames, InputStream in, SheetHandler sheetHandler) throws Exception {
        File tempFile = null;
        OPCPackage pkg = null;
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            pkg = OPCPackage.open((File)tempFile);
            XSSFReader.SheetIterator sheets = this.getSheets(sheetHandler, pkg);
            XMLReader parser = this.getParser(sheetHandler);
            while (sheets.hasNext()) {
                InputStream sheet = sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName()) || this.dealWithSheets(sheetHandler, sheets, entryNames)) continue;
                parser.parse(sheetSource);
                sheet.close();
                if (!sheetHandler.isInterrupt()) continue;
                break;
            }
        }
        finally {
            if (pkg != null) {
                pkg.revert();
            }
            FileSecurityUtil.safeDeleteFile((File)tempFile);
        }
    }

    private XSSFReader.SheetIterator getSheets(SheetHandler sheetHandler, OPCPackage pkg) throws Exception {
        XSSFReader r = new XSSFReader(pkg);
        r.setUseReadOnlySharedStringsTable(false);
        sheetHandler.setSharedStringsTable((SharedStringsTable)r.getSharedStringsTable());
        sheetHandler.setStylesTable(r.getStylesTable());
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        HashSet<String> sheetNames = new HashSet<String>(16);
        while (sheets.hasNext()) {
            sheets.next();
            if (!StringUtils.isNotBlank((CharSequence)sheets.getSheetName())) continue;
            sheetNames.add(sheets.getSheetName());
        }
        sheetHandler.setSheetNames(sheetNames);
        sheets = (XSSFReader.SheetIterator)r.getSheetsData();
        return sheets;
    }

    private XMLReader getParser(SheetHandler sheetHandler) throws Exception {
        XMLReader parser = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parser.setContentHandler(sheetHandler);
        return parser;
    }

    public ImportEntryValid getImportEntryValid() {
        return new ImportEntryValid();
    }
}

