/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;

public class MulImportBooleanPropConvert
extends MulImportPropConvert {
    private String[] trueValues = new String[4];
    private String[] falseValues = new String[4];

    public MulImportBooleanPropConvert(IDataEntityProperty property) {
        super(property);
    }

    public BooleanProp getProperty() {
        return (BooleanProp)super.getProperty();
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Boolean booleanValue = this.convertBooleanValue(value);
        if (null == booleanValue) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a%2$s\u6839\u636e\u6620\u5c04\u5b57\u6bb5\u201c%3$s\u201d\u65e0\u6cd5\u627e\u5230\u5339\u914d\u503c\u3002", (String)"BOS_IMPORT_19", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
            return;
        }
        this.getProperty().setValueFast((Object)data, (Object)booleanValue);
    }

    private Boolean convertBooleanValue(String value) {
        this.initArr();
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        for (String trueValue : this.trueValues) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)trueValue, (CharSequence)value)) continue;
            return Boolean.TRUE;
        }
        for (String falseValue : this.falseValues) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)falseValue, (CharSequence)value)) continue;
            return Boolean.FALSE;
        }
        return null;
    }

    private void initArr() {
        this.trueValues[0] = this.getTrueBooleanValue();
        this.trueValues[1] = "1";
        this.trueValues[2] = "true";
        this.trueValues[3] = "yes";
        this.falseValues[0] = this.getFalseBooleanValue();
        this.falseValues[1] = "0";
        this.falseValues[2] = "false";
        this.falseValues[3] = "no";
    }

    private String getTrueBooleanValue() {
        return ResManager.loadKDString((String)"\u662f", (String)"BOS_IMPORT_20", (String)"bos-import", (Object[])new Object[0]);
    }

    private String getFalseBooleanValue() {
        return ResManager.loadKDString((String)"\u5426", (String)"BOS_IMPORT_21", (String)"bos-import", (Object[])new Object[0]);
    }
}

