/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.util.Strings;

public class MulImportComboPropConvert
extends MulImportPropConvert {
    public MulImportComboPropConvert(IDataEntityProperty property) {
        super(property);
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (!this.checkImportValue(value = this.convertValueFormat(value))) {
            String itemValue = this.getItemValue(value);
            if (StringUtils.isNotBlank((CharSequence)itemValue)) {
                super.setValue(data, this.fixValue(itemValue));
                return;
            }
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u65e0\u6cd5\u5339\u914d\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u4e0b\u62c9\u9879\u3002", (String)"BOS_IMPORT_8", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
            return;
        }
        super.setValue(data, this.fixValue(value));
    }

    private String getItemValue(String value) {
        List comboItems = this.getProperty().getComboItems();
        if (CollectionUtils.isEmpty((Collection)comboItems)) {
            return null;
        }
        String[] nameValues = value.split(",");
        ArrayList<String> itemValues = new ArrayList<String>();
        block0: for (String itemValue : nameValues) {
            for (ValueMapItem comboItem : comboItems) {
                String comboItemValue = comboItem.getValue();
                LocaleString name = comboItem.getName();
                if (null == name || CollectionUtils.isEmpty((Collection)name.values()) || !name.containsValue((Object)itemValue)) continue;
                itemValues.add(comboItemValue);
                continue block0;
            }
        }
        return String.join((CharSequence)",", itemValues);
    }

    private String convertValueFormat(String value) {
        if (value.contains(";")) {
            return value.replaceAll(";", ",");
        }
        if (value.contains("\uff0c")) {
            return value.replaceAll("\uff0c", ",");
        }
        if (value.contains("\uff1b")) {
            return value.replaceAll("\uff1b", ",");
        }
        return value;
    }

    private boolean checkImportValue(String value) {
        String[] itemValues;
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        ComboProp comboProp = this.getProperty();
        if (comboProp.isEditable()) {
            return true;
        }
        if (comboProp.isEmptyItems()) {
            return true;
        }
        for (String itemValue : itemValues = value.split(",")) {
            if (StringUtils.isBlank((CharSequence)itemValue) || comboProp.isExistItem(itemValue)) continue;
            return false;
        }
        return true;
    }

    private String fixValue(String value) {
        String newValue = value;
        if (this.getProperty() instanceof MulComboProp && value != null) {
            List splitValues = Arrays.stream(value.split(",")).filter(t -> !StringUtils.isBlank((CharSequence)t)).collect(Collectors.toList());
            newValue = "," + Strings.join(splitValues, (char)',') + ",";
        }
        return newValue;
    }

    public ComboProp getProperty() {
        return (ComboProp)super.getProperty();
    }
}

