/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.ReadCellData;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import org.apache.commons.collections4.BidiMap;
import org.apache.poi.ss.usermodel.DateUtil;

public class MulImportDateTimePropConvert
extends MulImportPropConvert {
    private static final Log log = LogFactory.getLog(MulImportDateTimePropConvert.class);
    private static final long minTimestamp = -2209017600000L;
    private static final long maxTimestamp = 253402185600000L;

    public MulImportDateTimePropConvert(IDataEntityProperty property) {
        super(property);
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        DateTimeProp property = this.getProperty();
        BigDecimal numberValue = this.getCellData().getOriginalNumberValue();
        if (numberValue != null) {
            Date date = DateUtil.getJavaDate((double)numberValue.doubleValue());
            property.setValueFast((Object)data, (Object)date);
            return;
        }
        if (!this.validateTimeFormat(value, property)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u683c\u5f0f\u8981\u6c42\u3002", (String)"MulImportDateTimePropConvert_1", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
            return;
        }
        DateFormat dateFormat = property.getDateFormat();
        try {
            Date date = dateFormat.parse(value);
            if (!this.validateDateRange(date, value)) {
                return;
            }
            property.setValueFast((Object)data, (Object)date);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25\uff1a" + value, (Throwable)e);
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u683c\u5f0f\u8981\u6c42\u3002", (String)"MulImportDateTimePropConvert_1", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
        }
    }

    private boolean validateDateRange(Date date, String value) {
        DateTimeProp property = this.getProperty();
        String relateDateTimeRange = property.getRelateDateTimeRange();
        if (StringUtils.isBlank((CharSequence)relateDateTimeRange)) {
            return true;
        }
        Integer relatePropIndex = null;
        BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap = this.getCurSheetInfo().getExcelCol2PropInfoMap();
        for (Map.Entry entry : excelCol2PropInfoMap.entrySet()) {
            MulImportPropColMapping propColMapping = (MulImportPropColMapping)entry.getValue();
            if (!StringUtils.equals((CharSequence)propColMapping.getPropNumber(), (CharSequence)relateDateTimeRange)) continue;
            relatePropIndex = (Integer)entry.getKey();
            break;
        }
        IDataEntityProperty relateDateProp = (IDataEntityProperty)property.getParent().getProperties().get((Object)relateDateTimeRange);
        if (relatePropIndex == null || !(relateDateProp instanceof DateTimeProp)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6839\u636e\u6620\u5c04\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6cd5\u627e\u5230\u8d77\u59cb\u6216\u7ed3\u675f\u65e5\u671f\u3002", (String)"MulImportDateTimePropConvert_0", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), property.getDisplayName().getLocaleValue()));
            return false;
        }
        Date relateDate = this.getRelateDate(relatePropIndex, (DateTimeProp)relateDateProp);
        if (relateDate == null) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6839\u636e\u6620\u5c04\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6cd5\u627e\u5230\u8d77\u59cb\u6216\u7ed3\u675f\u65e5\u671f\u3002", (String)"MulImportDateTimePropConvert_0", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), property.getDisplayName().getLocaleValue()));
            return false;
        }
        if (property.isStartDateTimeRange() && date.after(relateDate) || ((DateTimeProp)relateDateProp).isStartDateTimeRange() && relateDate.after(date)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u8d77\u59cb\u65e5\u671f\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f\u7684\u8981\u6c42\u3002", (String)"MulImportDateTimePropConvert_2", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, property.getDisplayName().getLocaleValue()));
            return false;
        }
        return true;
    }

    private Date getRelateDate(Integer relatePropIndex, DateTimeProp relateDateProp) {
        ReadCellData cellData;
        BigDecimal numberValue;
        Cell cell = (Cell)this.getReadRowHolder().getCellMap().get(relatePropIndex);
        Date relateDate = null;
        if (cell instanceof ReadCellData && (numberValue = (cellData = (ReadCellData)cell).getNumberValue()) != null) {
            relateDate = DateUtil.getJavaDate((double)numberValue.doubleValue());
        }
        if (relateDate != null) {
            return relateDate;
        }
        String relateValue = this.getCurRowData().get(relatePropIndex);
        if (StringUtils.isNotBlank((CharSequence)relateValue) && this.validateTimeFormat(relateValue, relateDateProp)) {
            try {
                relateDate = relateDateProp.getDateFormat().parse(relateValue);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return relateDate;
    }

    private boolean validateTimeFormat(String value, DateTimeProp prop) {
        DateFormat dateFormat = prop.getDateFormat();
        String displayName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().getLocaleValue();
        dateFormat.setLenient(false);
        String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiDateTimePropConverter_0", (String)"bos-import", (Object[])new Object[0]), displayName, value);
        try {
            SimpleDateFormat dateTimeFormat;
            Date dateTime;
            Date date = dateFormat.parse(String.valueOf(value));
            if (date.getTime() < -2209017600000L || date.getTime() > 253402185600000L) {
                return false;
            }
            if (value.equals(dateFormat.format(date))) {
                return true;
            }
            if (prop instanceof DateProp && date.compareTo(dateTime = (dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(String.valueOf(value))) == 0) {
                return true;
            }
            String[] timeValue = String.valueOf(value).split(":");
            if (timeValue.length > 3 && timeValue[timeValue.length - 1].length() > 0) {
                SimpleDateFormat msFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                msFormat.setLenient(false);
                Date msdate = msFormat.parse(String.valueOf(value));
                if (value.equals(msFormat.format(msdate))) {
                    return true;
                }
            }
            return false;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public DateTimeProp getProperty() {
        return (DateTimeProp)super.getProperty();
    }
}

