/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;
import kd.bos.mulimport.resolve.model.MulImportConvertData;
import org.apache.commons.collections4.CollectionUtils;

public class MulImportDecimalPropConvert
extends MulImportPropConvert {
    private static final Log log = LogFactory.getLog(MulImportDecimalPropConvert.class);

    public MulImportDecimalPropConvert(IDataEntityProperty property) {
        super(property);
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        BigDecimal numberValue = this.getCellData().getNumberValue();
        if (numberValue == null) {
            try {
                numberValue = new BigDecimal(value);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u683c\u5f0f\u8981\u6c42\u3002", (String)"MulImportDecimalPropConvert_0", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
                return;
            }
        }
        if (!this.checkScope(numberValue)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u6570\u503c\u8303\u56f4\u4e3a\u201c%4$s\u201d\u7684\u8981\u6c42\u3002", (String)"MulImportDecimalPropConvert_1", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue(), this.getProperty().getDataScope()));
            return;
        }
        if (this.convertPrecision(numberValue, data)) {
            this.getProperty().setValue((Object)data, (Object)numberValue);
        }
    }

    private boolean checkScope(BigDecimal numberValue) {
        DecimalProp property = this.getProperty();
        if (property.getMin() != null && (property.isInclMin() ? numberValue.compareTo(property.getMin()) < 0 : numberValue.compareTo(property.getMin()) <= 0)) {
            return false;
        }
        if (property.getMax() != null) {
            if (property.isInclMax()) {
                return numberValue.compareTo(property.getMax()) <= 0;
            }
            return numberValue.compareTo(property.getMax()) < 0;
        }
        return true;
    }

    private boolean convertPrecision(BigDecimal value, DynamicObject data) {
        BigDecimal oldValue;
        Object controlPropValue;
        IDataEntityProperty controlProp;
        DecimalProp property = this.getProperty();
        if (value.precision() - value.scale() > property.getPrecision() - property.getScale() && !value.equals(BigDecimal.valueOf(0L))) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%4$s\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%5$s\u4f4d\u7684\u8981\u6c42\u3002", (String)"MulImportDecimalPropConvert_2", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue(), property.getPrecision() - property.getScale(), property.getScale()));
            return false;
        }
        int scale = property.getScale();
        String controlPropName = property.getControlPropName();
        if (this.isControlField() && StringUtils.isNotBlank((CharSequence)controlPropName) && (controlProp = this.getControlProp(controlPropName)) instanceof BasedataProp && (controlPropValue = this.getControlPropData(controlProp, data)) instanceof DynamicObject) {
            scale = ((DynamicObject)controlPropValue).getInt(this.getPrecisionPropName());
        }
        if (value.scale() != scale && (oldValue = new BigDecimal(value.toString())).compareTo(value = value.setScale(scale, property.getRoundingMode())) != 0) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%4$s\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e%5$s\u4f4d\u7684\u8981\u6c42\u3002", (String)"MulImportDecimalPropConvert_2", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue(), property.getPrecision() - property.getScale() + scale, scale));
            return false;
        }
        return true;
    }

    private IDataEntityProperty getControlProp(String controlPropName) {
        IDataEntityType entityType = this.getProperty().getParent();
        IDataEntityProperty controlProp = (IDataEntityProperty)entityType.getProperties().get((Object)controlPropName);
        if (controlProp == null && entityType.getParent() != null) {
            entityType = entityType.getParent();
            controlProp = (IDataEntityProperty)entityType.getProperties().get((Object)controlPropName);
        }
        if (controlProp == null && entityType.getParent() != null) {
            entityType = entityType.getParent();
            controlProp = (IDataEntityProperty)entityType.getProperties().get((Object)controlPropName);
        }
        return controlProp;
    }

    private Object getControlPropData(IDataEntityProperty controlProp, DynamicObject data) {
        IDataEntityProperty property = (IDataEntityProperty)data.getDynamicObjectType().getProperties().get((Object)controlProp.getName());
        if (property != null) {
            return controlProp.getValueFast((Object)data);
        }
        IDataEntityType controlEntity = controlProp.getParent();
        String curDataEntity = data.getDynamicObjectType().getName();
        if (controlEntity instanceof SubEntryType) {
            return controlProp.getValueFast((Object)data);
        }
        if (controlEntity instanceof EntryType) {
            Map<String, Map<String, MulImportConvertData>> entryContactData = this.getConvertedData().getEntryContactData();
            Map<String, MulImportConvertData> convertDataMap = entryContactData.get(controlEntity.getName());
            for (MulImportConvertData entryDatum : convertDataMap.values()) {
                DynamicObjectCollection dynamicObjectCollection;
                DynamicObject entryData = entryDatum.getData();
                if (entryData.getDynamicObjectType().getProperties().get((Object)curDataEntity) == null || !CollectionUtils.isNotEmpty((Collection)(dynamicObjectCollection = entryData.getDynamicObjectCollection(curDataEntity))) || !dynamicObjectCollection.contains((Object)data)) continue;
                return controlProp.getValueFast((Object)entryData);
            }
        }
        return controlProp.getValueFast((Object)this.getConvertedData().getData());
    }

    private String getPrecisionPropName() {
        DecimalProp property = this.getProperty();
        if (property instanceof PriceProp) {
            return "priceprecision";
        }
        if (property instanceof AmountProp) {
            return "amtprecision";
        }
        if (property instanceof QtyProp) {
            return "precision";
        }
        return "";
    }

    private boolean isControlField() {
        DecimalProp property = this.getProperty();
        return property instanceof AmountProp || property instanceof QtyProp;
    }

    public DecimalProp getProperty() {
        return (DecimalProp)super.getProperty();
    }
}

