/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import com.alibaba.excel.support.ExcelTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.operate.imptapi.ApiFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.model.MulImportCheckedBaseDataKey;
import kd.bos.mulimport.resolve.model.MulImportCheckedMainOrgKey;
import kd.bos.mulimport.resolve.model.MulImportCollectModel;
import kd.bos.mulimport.resolve.model.MulImportCollectTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulImportTypeEnum;
import kd.bos.mulimport.resolve.service.AbstractImportResolveService;
import kd.bos.mulimport.resolve.utils.MulImportConvertUtils;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.utils.ImportCreateViewUtil;
import kd.bos.utils.ImportFilterUtil;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MulImportCollectService
extends AbstractImportResolveService {
    private static final Log log = LogFactory.getLog(MulImportCollectService.class);
    private Map<String, Set<Object>> dataReplaceRuleFieldVals = new HashMap<String, Set<Object>>();
    private final Map<String, IFormView> formViewMap = new HashMap<String, IFormView>();
    private final Map<String, Map<String, String>> bd2UseNameOrgMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, Map<String, String>>> bd2UseOrgValMap = new HashMap<String, Map<String, Map<String, String>>>();

    public MulImportCollectService(MulImportContext mulImportContext) {
        super(mulImportContext);
    }

    private void handleData4Collect(Map<Integer, String> map, MulImportDataMappingRule rule, Integer excelRow) {
        List<MulImportCollectModel> needCollectColIndexList = rule.getNeedCollectColIndexList();
        BidiMap<Integer, MulImportPropColMapping> excel2ColMap = rule.getExcelCol2PropInfoMap();
        EntityType dataEntityType = rule.getEntityType();
        block4: for (MulImportCollectModel collectModel : needCollectColIndexList) {
            String bdPropName;
            String excelColValue;
            Integer excelColIndex = collectModel.getExcelColIndex();
            if (excelColIndex == null || StringUtils.isEmpty((CharSequence)(excelColValue = map.get(excelColIndex)))) continue;
            MulImportPropColMapping colMapping = (MulImportPropColMapping)excel2ColMap.get((Object)excelColIndex);
            DynamicProperty property = dataEntityType.getProperty(colMapping.getPropNumber());
            switch (collectModel.getMulImportCollectTypeEnum()) {
                case MAIN_ORG: {
                    if (!(property instanceof MainOrgProp)) continue block4;
                    this.mulImportContext.getMainOrgList4SearchNoCtrl().computeIfAbsent(colMapping.getMatchProp(), k -> new HashSet()).add(excelColValue);
                    continue block4;
                }
                case COMMON_ORG: {
                    if (!(property instanceof OrgProp)) continue block4;
                    this.mulImportContext.getOrgList4SearchNoCtrl().computeIfAbsent(colMapping.getMatchProp(), k -> new HashSet()).add(excelColValue);
                    continue block4;
                }
            }
            if (!(property instanceof IBasedataField)) continue;
            ArrayList<String> searchValList = new ArrayList<String>(1);
            if (property instanceof MulBasedataProp) {
                bdPropName = ((MulBasedataProp)property).getComplexType().getName();
                String[] split = excelColValue.split(",");
                if (split.length == 1) {
                    split = excelColValue.split(";");
                }
                searchValList.addAll(Arrays.asList(split));
            } else {
                bdPropName = ((BasedataProp)property).getComplexType().getName();
                searchValList.add(excelColValue);
            }
            for (String searchVal : searchValList) {
                this.mulImportContext.getBaseDataListMap4SearchNoCtrl().computeIfAbsent(bdPropName, s -> new HashMap()).computeIfAbsent(colMapping.getMatchProp(), k -> new HashSet()).add(searchVal);
            }
        }
        this.collectQueryValue(rule, map, excelRow);
    }

    private void handleData4CollectWithMainEntityName(Map<Integer, String> map, MulImportDataMappingRule rule, Integer excelRow) {
        List<MulImportCollectModel> needList = rule.getNeedCollectColIndexList();
        Integer contactFieldCol = rule.getContactFieldCol();
        String mainEntityName = rule.getMainEntityNumber();
        IFormView view = this.getView(mainEntityName);
        String mainOrgName = view.getModel().getDataEntityType().getMainOrg();
        BidiMap<Integer, MulImportPropColMapping> excel2ColMap = rule.getExcelCol2PropInfoMap();
        for (MulImportCollectModel collectModel : needList) {
            String orgValue;
            String contactFieldVal;
            String excelColValue;
            Integer excelColIndex = collectModel.getExcelColIndex();
            if (excelColIndex == null || StringUtils.isEmpty((CharSequence)(excelColValue = map.get(excelColIndex)))) continue;
            String contactFieldColVal = map.get(contactFieldCol);
            MulImportPropColMapping colMapping = (MulImportPropColMapping)excel2ColMap.get((Object)excelColIndex);
            IDataEntityProperty property = view.getModel().getProperty(colMapping.getPropNumber());
            if (collectModel.getMulImportCollectTypeEnum() == MulImportCollectTypeEnum.MAIN_ORG) {
                if (!(property instanceof MainOrgProp)) continue;
                this.mulImportContext.getCheckedMainOrgMap4Search().computeIfAbsent(mainEntityName, s -> new HashSet()).add(new MulImportCheckedMainOrgKey(colMapping.getColName(), excelRow, excelColValue, colMapping.getMatchProp()));
                if (!CollectionUtils.isNotEmpty(rule.getContactRules())) continue;
                this.mulImportContext.getRedundancyFieldMap().computeIfAbsent(mainEntityName, s -> new HashMap()).putIfAbsent(contactFieldColVal, excelColValue);
                continue;
            }
            if (collectModel.getMulImportCollectTypeEnum() == MulImportCollectTypeEnum.COMMON_ORG) {
                if (!(property instanceof OrgProp)) continue;
                this.mulImportContext.getCheckedOrgMap4Search().computeIfAbsent(mainEntityName, s -> new HashMap()).computeIfAbsent(colMapping.getPropNumber(), k -> new HashMap()).computeIfAbsent(colMapping.getMatchProp(), k -> new HashSet()).add(excelColValue);
                this.bd2UseOrgValMap.computeIfAbsent(mainEntityName, i -> new HashMap()).computeIfAbsent(colMapping.getColName(), i -> new HashMap()).putIfAbsent(contactFieldColVal, excelColValue);
                continue;
            }
            if (collectModel.getMulImportCollectTypeEnum() != MulImportCollectTypeEnum.CTRL_BASE_DATA && collectModel.getMulImportCollectTypeEnum() != MulImportCollectTypeEnum.COMMON_BASE_DATA || !(property instanceof IBasedataField)) continue;
            String useOrgProp = this.getBd2Org(mainEntityName, colMapping);
            if (StringUtils.isEmpty((CharSequence)useOrgProp)) {
                useOrgProp = mainOrgName;
            }
            if (rule.getMulImportResolveTypeEnum() == MulImportResolveTypeEnum.HEAD) {
                String orgValue2 = null;
                Integer useOrgIndex = (Integer)excel2ColMap.getKey((Object)new MulImportPropColMapping(useOrgProp, "number"));
                if (useOrgIndex != null && map.get(useOrgIndex) != null) {
                    orgValue2 = map.get(useOrgIndex);
                    useOrgProp = useOrgProp + ".number";
                }
                if (StringUtils.isEmpty(orgValue2) && (useOrgIndex = (Integer)excel2ColMap.getKey((Object)new MulImportPropColMapping(useOrgProp, "name"))) != null && map.get(useOrgIndex) != null) {
                    orgValue2 = map.get(useOrgIndex);
                    useOrgProp = useOrgProp + ".name";
                }
                this.addSearchBd(mainEntityName, excelColValue, colMapping, property, useOrgProp, orgValue2);
            }
            if (rule.getMulImportResolveTypeEnum() == MulImportResolveTypeEnum.ENTRY) {
                contactFieldVal = map.get(rule.getParentContactFieldCol());
                orgValue = null;
                if (!StringUtils.isEmpty((CharSequence)useOrgProp) && !StringUtils.equals((CharSequence)useOrgProp, (CharSequence)mainOrgName) && this.bd2UseOrgValMap.get(mainEntityName) != null && this.bd2UseOrgValMap.get(mainEntityName).get(useOrgProp) != null) {
                    orgValue = this.bd2UseOrgValMap.get(mainEntityName).get(useOrgProp).get(contactFieldVal);
                } else if (this.mulImportContext.getRedundancyFieldMap().size() > 0 && this.mulImportContext.getRedundancyFieldMap().get(mainEntityName) != null) {
                    orgValue = this.mulImportContext.getRedundancyFieldMap().get(mainEntityName).get(contactFieldVal);
                }
                this.addSearchBd(mainEntityName, excelColValue, colMapping, property, useOrgProp, orgValue);
            }
            if (rule.getMulImportResolveTypeEnum() != MulImportResolveTypeEnum.SUB_ENTRY) continue;
            contactFieldVal = map.get(rule.getParentContactFieldCol());
            orgValue = null;
            if (!StringUtils.isEmpty((CharSequence)useOrgProp) && !StringUtils.equals((CharSequence)useOrgProp, (CharSequence)mainOrgName) && this.bd2UseOrgValMap.get(mainEntityName) != null && this.bd2UseOrgValMap.get(mainEntityName).get(useOrgProp) != null) {
                orgValue = this.bd2UseOrgValMap.get(mainEntityName).get(useOrgProp).get(contactFieldVal);
            } else {
                Map<String, String> entryRedundancyMiddleMap = this.mulImportContext.getEntryRedundancyMiddleMap().get(mainEntityName + "_" + rule.getParentEntityNumber());
                if (entryRedundancyMiddleMap != null && this.mulImportContext.getRedundancyFieldMap().get(mainEntityName) != null) {
                    String pReVal = entryRedundancyMiddleMap.get(contactFieldVal);
                    Map<String, String> redundancyFieldMap = this.mulImportContext.getRedundancyFieldMap().get(mainEntityName);
                    orgValue = redundancyFieldMap.get(pReVal);
                }
            }
            this.addSearchBd(mainEntityName, excelColValue, colMapping, property, useOrgProp, orgValue);
        }
        if (rule.getMulImportResolveTypeEnum() == MulImportResolveTypeEnum.ENTRY && CollectionUtils.isNotEmpty(rule.getContactRules()) && CollectionUtils.isNotEmpty((Collection)this.mulImportContext.getCheckedMainOrgMap4Search().get(mainEntityName))) {
            String entryEntityName = rule.getCurrentEntityNumber();
            String valForSub = map.get(contactFieldCol);
            Integer parentContactFieldCol = rule.getParentContactFieldCol();
            String parentVal = map.get(parentContactFieldCol);
            this.mulImportContext.getEntryRedundancyMiddleMap().computeIfAbsent(mainEntityName + "_" + entryEntityName, s -> new HashMap()).putIfAbsent(valForSub, parentVal);
        }
        this.collectQueryValue(rule, map, excelRow);
    }

    private void addSearchBd(String mainEntityName, String excelColValue, MulImportPropColMapping colMapping, IDataEntityProperty property, String useOrgProp, String orgValue) {
        ArrayList<String> searchValList = new ArrayList<String>(1);
        if (property instanceof MulBasedataProp) {
            String[] split = excelColValue.split(",");
            if (split.length == 1) {
                split = excelColValue.split(";");
            }
            searchValList.addAll(Arrays.asList(split));
        } else {
            searchValList.add(excelColValue);
        }
        for (String searchVal : searchValList) {
            this.mulImportContext.getCheckedBaseDataMap4Search().computeIfAbsent(mainEntityName, s -> new HashSet()).add(new MulImportCheckedBaseDataKey(orgValue, useOrgProp, colMapping.getPropNumber(), searchVal, colMapping.getMatchProp()));
        }
    }

    private String getBd2Org(String mainEntityName, MulImportPropColMapping colMapping) {
        String orgProp = this.bd2UseNameOrgMap.computeIfAbsent(mainEntityName, i -> new HashMap()).computeIfAbsent(colMapping.getColName(), i -> {
            IFormView view = this.getView(mainEntityName);
            view.getModel().getProperty(colMapping.getPropNumber());
            IBasedataField bdProp = (IBasedataField)view.getModel().getProperty(colMapping.getPropNumber());
            return bdProp.getOrgProp() == null ? "" : bdProp.getOrgProp();
        });
        return orgProp;
    }

    @Override
    public void collect() {
        if (this.getMulImportContext().isCheckBaseDataPerm()) {
            List<MulImportDataMappingRule> ruleList = this.getMulImportContext().getMulImportDataMappingRuleList();
            for (MulImportDataMappingRule rule : ruleList) {
                List<MulImportCollectModel> needList = rule.getNeedCollectColIndexList();
                needList.sort(Comparator.comparingInt(o -> o.getMulImportCollectTypeEnum().getType()));
            }
            this.readExcelFile(ExcelTypeEnum.XLSX, this::handleData4CollectWithMainEntityName);
            return;
        }
        this.readExcelFile(ExcelTypeEnum.XLSX, this::handleData4Collect);
    }

    private void collectQueryValue(MulImportDataMappingRule rule, Map<Integer, String> row, Integer excelRow) {
        MulImportTypeEnum importType = rule.getImportType();
        if (importType == MulImportTypeEnum.NEW_IMPORT) {
            return;
        }
        MulEntityImportResult importResult = MulImportConvertUtils.getEntityImportResult(this.mulImportContext, rule.getCurrentUniqueEntityKey());
        Object queryVal = MulImportConvertUtils.covert4Query(row, rule, importResult, excelRow);
        if (queryVal == null) {
            return;
        }
        Set dataReplaceRuleFieldVals = this.dataReplaceRuleFieldVals.computeIfAbsent(rule.getCurrentUniqueEntityKey(), c -> new HashSet());
        dataReplaceRuleFieldVals.add(queryVal);
    }

    @Override
    public void loadBaseData() {
        MulImportContext mulImportContext = this.getMulImportContext();
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        if (mulImportContext.isCheckBaseDataPerm()) {
            Map<String, Map<String, DynamicObject>> checkedMainOrgMapDynMap = mulImportContext.getCheckedMainOrgMapDynMap();
            Map<String, Map<String, Map<String, DynamicObject>>> checkedOrgDynMap = mulImportContext.getCheckedOrgDynMap();
            Map<BasedataItem, DynamicObject> checkedBaseDataDynMap = mulImportContext.getCheckedBaseDataDynMap();
            Map<String, Set<MulImportCheckedMainOrgKey>> checkedMainOrgMap4Search = mulImportContext.getCheckedMainOrgMap4Search();
            Map<String, Map<String, Map<String, Set<String>>>> checkedOrgMap4Search = mulImportContext.getCheckedOrgMap4Search();
            Map<String, Set<MulImportCheckedBaseDataKey>> checkedBaseDataMap4Search = mulImportContext.getCheckedBaseDataMap4Search();
            HashSet<Long> loadingMainOrgIDs = new HashSet<Long>();
            this.searchMainOrgIds4Checked(baseDataService, checkedMainOrgMap4Search, loadingMainOrgIDs);
            this.batchLoadMainOrgData(loadingMainOrgIDs);
            HashSet<Long> loadingOrgIDs = new HashSet<Long>();
            this.searchOrgIds4Checked(baseDataService, checkedOrgDynMap, checkedOrgMap4Search, loadingOrgIDs);
            this.batchLoadOrgData(loadingOrgIDs);
            this.searchBd4Checked(baseDataService, checkedMainOrgMapDynMap, checkedBaseDataDynMap, checkedBaseDataMap4Search);
            return;
        }
        Map<String, DynamicObject> orgDynMap = mulImportContext.getOrgDynMapNoCtrl();
        Map<String, DynamicObject> mainOrgDynMap = mulImportContext.getMainOrgDynMapNoCtrl();
        Map<BasedataItem, DynamicObject> baseDataDynMap = mulImportContext.getBaseDataDynMapNoCtrl();
        Map<String, Set<String>> mainOrgList4SearchNoCtrl = mulImportContext.getMainOrgList4SearchNoCtrl();
        this.search4MainOrg(baseDataService, mainOrgDynMap, mainOrgList4SearchNoCtrl);
        Map<String, Set<String>> orgList4SearchNoCtrl = mulImportContext.getOrgList4SearchNoCtrl();
        this.search4Org(baseDataService, orgDynMap, orgList4SearchNoCtrl);
        Map<String, Map<String, Set<String>>> baseDataListMap4SearchNoCtrl = mulImportContext.getBaseDataListMap4SearchNoCtrl();
        this.search4Bd(baseDataService, baseDataDynMap, baseDataListMap4SearchNoCtrl);
    }

    @Override
    public void loadUpdateDataSource() {
        for (MulImportDataMappingRule rule : this.mulImportContext.getMulImportDataMappingRuleList()) {
            if (rule.getImportType() == MulImportTypeEnum.NEW_IMPORT) {
                return;
            }
            if (rule.getMulImportResolveTypeEnum() != MulImportResolveTypeEnum.HEAD) continue;
            String uniqueEntityKey = rule.getCurrentUniqueEntityKey();
            EntityType entityType = rule.getEntityType();
            String entityName = entityType.getName();
            Set<Object> dataReplaceRuleFieldVals = this.dataReplaceRuleFieldVals.get(uniqueEntityKey);
            String queryKey = MulImportConvertUtils.getQueryKey(rule);
            QFilter qFilter = new QFilter(queryKey, "in", dataReplaceRuleFieldVals);
            ArrayList idList = new ArrayList();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)("mulimportdata." + entityName), (String)entityName, (String)entityType.getPrimaryKey().getName(), (QFilter[])new QFilter[]{qFilter}, (String)"");){
                dataSet.forEach(data -> idList.add(data.get(0)));
            }
            DynamicObject[] sourceDymObj = BusinessDataReader.load((Object[])idList.toArray(), (DynamicObjectType)entityType, (Boolean)Boolean.TRUE);
            List<DynamicObject> sourceDymObjs = Arrays.asList(sourceDymObj);
            Map<Object, List<DynamicObject>> collect = sourceDymObjs.stream().collect(Collectors.groupingBy(source -> source.get(queryKey)));
            HashMap<String, List<DynamicObject>> collectStr = new HashMap<String, List<DynamicObject>>(8);
            for (Map.Entry<Object, List<DynamicObject>> entry : collect.entrySet()) {
                Object fieldVal = entry.getKey();
                collectStr.put(MulImportConvertUtils.covertSourceValue(fieldVal), entry.getValue());
            }
            Map collectedUpdateData = this.mulImportContext.getCollectedUpdateData().computeIfAbsent(uniqueEntityKey, c -> new HashMap());
            collectedUpdateData.putAll(collectStr);
        }
        this.dataReplaceRuleFieldVals.clear();
    }

    private void search4Bd(IBaseDataService baseDataService, Map<BasedataItem, DynamicObject> baseDataDynMap, Map<String, Map<String, Set<String>>> baseDataListMap4SearchNoCtrl) {
        for (Map.Entry<String, Map<String, Set<String>>> baseDataSearchMapEntry : baseDataListMap4SearchNoCtrl.entrySet()) {
            Map<String, Set<String>> gpByImpProp = baseDataSearchMapEntry.getValue();
            String baseDataPropName = baseDataSearchMapEntry.getKey();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseDataPropName);
            int dbType = dataEntityType.getPrimaryKey().getDbType();
            for (Map.Entry<String, Set<String>> gpByImpPropEn : gpByImpProp.entrySet()) {
                HashSet<Object> bsIds = new HashSet<Object>();
                if (!StringUtils.equals((CharSequence)gpByImpPropEn.getKey(), (CharSequence)"id")) {
                    String selectFields = gpByImpPropEn.getKey() + ",id";
                    DynamicObjectCollection baseDataDynamicObjects = baseDataService.queryBaseDataByDate(baseDataPropName, null, new QFilter(gpByImpPropEn.getKey(), "in", gpByImpPropEn.getValue()), selectFields, new Date());
                    baseDataDynamicObjects.forEach(dynamicObject -> bsIds.add(dynamicObject.get("id")));
                } else {
                    Set<String> value = gpByImpPropEn.getValue();
                    if (CollectionUtils.isNotEmpty(value)) {
                        for (String id : value) {
                            if (!StringUtils.isNumeric((CharSequence)id)) continue;
                            bsIds.add(MulImportConvertUtils.safeConvert(dbType, id));
                        }
                    }
                }
                if (!CollectionUtils.isNotEmpty(bsIds)) continue;
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])bsIds.toArray(), (String)baseDataPropName);
                for (DynamicObject baseDataDyn : loadFromCache.values()) {
                    baseDataDynMap.putIfAbsent(new BasedataItem(null, baseDataPropName, null, baseDataDyn.getString(gpByImpPropEn.getKey())), baseDataDyn);
                }
            }
        }
    }

    private void search4Org(IBaseDataService baseDataService, Map<String, DynamicObject> orgDynMap, Map<String, Set<String>> orgList4SearchNoCtrl) {
        this.searchOrg(baseDataService, orgDynMap, orgList4SearchNoCtrl);
    }

    private void search4MainOrg(IBaseDataService baseDataService, Map<String, DynamicObject> mainOrgDynMap, Map<String, Set<String>> mainOrgList4SearchNoCtrl) {
        this.searchOrg(baseDataService, mainOrgDynMap, mainOrgList4SearchNoCtrl);
    }

    private void searchOrg(IBaseDataService baseDataService, Map<String, DynamicObject> mainOrgDynMap, Map<String, Set<String>> mainOrgList4SearchNoCtrl) {
        for (Map.Entry<String, Set<String>> gpByImpProp : mainOrgList4SearchNoCtrl.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>();
            if (!StringUtils.equals((CharSequence)gpByImpProp.getKey(), (CharSequence)"id")) {
                String selectFields = gpByImpProp.getKey() + ",id";
                DynamicObjectCollection mainOrgDynamicObjects = baseDataService.queryBaseDataByDate("bos_org", null, new QFilter(gpByImpProp.getKey(), "in", gpByImpProp.getValue()), selectFields, new Date());
                mainOrgDynamicObjects.forEach(dynamicObject -> ids.add((Long)dynamicObject.get("id")));
            } else if (!gpByImpProp.getValue().isEmpty()) {
                for (String id : gpByImpProp.getValue()) {
                    if (!StringUtils.isNumeric((CharSequence)id)) continue;
                    ids.add(Long.parseLong(id));
                }
            }
            if (!CollectionUtils.isNotEmpty(ids)) continue;
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"bos_org");
            for (DynamicObject mainOrg4SearchDyn : loadFromCache.values()) {
                String searchVal = mainOrg4SearchDyn.getString(gpByImpProp.getKey());
                mainOrgDynMap.putIfAbsent(searchVal, mainOrg4SearchDyn);
            }
        }
    }

    private void searchBd4Checked(IBaseDataService baseDataService, Map<String, Map<String, DynamicObject>> checkedMainOrgMapDynMap, Map<BasedataItem, DynamicObject> checkedBaseDataDynMap, Map<String, Set<MulImportCheckedBaseDataKey>> checkedBaseDataMap4Search) {
        for (Map.Entry<String, Set<MulImportCheckedBaseDataKey>> bdEntry : checkedBaseDataMap4Search.entrySet()) {
            String mainEntityName = bdEntry.getKey();
            IFormView entityView = this.getView(mainEntityName);
            String appId = entityView.getFormShowParameter().getFormConfig().getAppId();
            Set<MulImportCheckedBaseDataKey> checkedBdKeySet = bdEntry.getValue();
            Map<String, List<MulImportCheckedBaseDataKey>> bdGroupByProp = checkedBdKeySet.stream().collect(Collectors.groupingBy(MulImportCheckedBaseDataKey::getBaseDataPropName));
            for (Map.Entry<String, List<MulImportCheckedBaseDataKey>> bdGroupByPropEntry : bdGroupByProp.entrySet()) {
                String bdName = bdGroupByPropEntry.getKey();
                IBasedataField property = (IBasedataField)entityView.getModel().getProperty(bdName);
                String bdPropComplexTypeName = property.getComplexType().getName();
                BasedataEntityType bdType = (BasedataEntityType)property.getComplexType();
                Map<String, List<MulImportCheckedBaseDataKey>> bdGroupByOrg = bdGroupByPropEntry.getValue().stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.getCtrlOrgVal()).orElse("0")));
                for (Map.Entry<String, List<MulImportCheckedBaseDataKey>> bdNode : bdGroupByOrg.entrySet()) {
                    Object pkValue;
                    Long mainOrgId = null;
                    if (!StringUtils.equals((CharSequence)bdNode.getKey(), (CharSequence)"0") && MapUtils.isNotEmpty(checkedMainOrgMapDynMap.get(mainEntityName)) && checkedMainOrgMapDynMap.get(mainEntityName).get(bdNode.getKey()) != null && (pkValue = checkedMainOrgMapDynMap.get(mainEntityName).get(bdNode.getKey()).getPkValue()) != null) {
                        mainOrgId = Long.valueOf(pkValue.toString());
                    }
                    Map<String, List<MulImportCheckedBaseDataKey>> gpByImpProp = bdNode.getValue().stream().collect(Collectors.groupingBy(MulImportCheckedBaseDataKey::getImpProp));
                    HashSet<Object> ids = new HashSet<Object>();
                    for (Map.Entry<String, List<MulImportCheckedBaseDataKey>> gpByImpPropEn : gpByImpProp.entrySet()) {
                        String mainOrg;
                        ApiFilter apiFilter = new ApiFilter();
                        List toSearchList = gpByImpPropEn.getValue().stream().map(MulImportCheckedBaseDataKey::getSearchVal).filter(Objects::nonNull).collect(Collectors.toList());
                        List<QFilter> filters = ImportFilterUtil.buildBaseDataF7QFilters(property, entityView.getModel(), appId, bdPropComplexTypeName, new ArrayList<QFilter>(), "47150e89000000ac", true);
                        filters.add(new QFilter(gpByImpPropEn.getKey(), "in", toSearchList));
                        apiFilter.getFilters().addAll(filters);
                        if (mainOrgId == null && StringUtils.isNotEmpty((CharSequence)(mainOrg = entityView.getModel().getDataEntityType().getMainOrg())) && entityView.getModel().getValue(mainOrg) instanceof DynamicObject) {
                            mainOrgId = (Long)((DynamicObject)entityView.getModel().getValue(mainOrg)).getPkValue();
                        }
                        if (!StringUtils.equals((CharSequence)gpByImpPropEn.getKey(), (CharSequence)"id")) {
                            String selectFields = gpByImpPropEn.getKey() + ",id";
                            DynamicObjectCollection bdColl = baseDataService.queryBaseDataByDate(bdPropComplexTypeName, mainOrgId, apiFilter.toQFilter(), selectFields, new Date());
                            log.info(String.format(ResManager.loadKDString((String)"[\u591a\u5b9e\u4f53\u5bfc\u5165\uff1a\u53d7\u63a7\u57fa\u7840\u8d44\u6599\u67e5\u8be2\u6761\u4ef6\uff0c\u5f53\u524d\u5bfc\u5165]%1$s\u7ec4\u7ec7ID\u4e3a%2$s\u8fc7\u6ee4\u6761\u4ef6\uff1a%3$s", (String)"BOS_IMPORT_17", (String)"bos-import", (Object[])new Object[0]), bdPropComplexTypeName, mainOrgId, apiFilter.toQFilter().toString()));
                            bdColl.forEach(dynamicObject -> ids.add(dynamicObject.get("id")));
                        } else {
                            int dbType = bdType.getPrimaryKey().getDbType();
                            List idList = gpByImpPropEn.getValue().stream().map(MulImportCheckedBaseDataKey::getSearchVal).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(idList)) {
                                for (String id : idList) {
                                    if (!StringUtils.isNumeric((CharSequence)id)) continue;
                                    ids.add(MulImportConvertUtils.safeConvert(dbType, id));
                                }
                            }
                        }
                        if (CollectionUtils.isEmpty(ids)) continue;
                        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)bdPropComplexTypeName);
                        for (DynamicObject bdDyn : loadFromCache.values()) {
                            String importVal = bdDyn.getString(gpByImpPropEn.getKey());
                            checkedBaseDataDynMap.putIfAbsent(new BasedataItem(bdName, mainEntityName, bdType, mainOrgId, gpByImpPropEn.getKey(), importVal), bdDyn);
                        }
                    }
                }
            }
        }
    }

    private void searchOrgIds4Checked(IBaseDataService baseDataService, Map<String, Map<String, Map<String, DynamicObject>>> checkedOrgDynMap, Map<String, Map<String, Map<String, Set<String>>>> checkedOrgMap4Search, Set<Long> loadingOrgIDs) {
        for (Map.Entry<String, Map<String, Map<String, Set<String>>>> orgEntry : checkedOrgMap4Search.entrySet()) {
            String mainEntityName = orgEntry.getKey();
            Map<String, Map<String, Set<String>>> orgByNameMap = orgEntry.getValue();
            for (Map.Entry<String, Map<String, Set<String>>> entry : orgByNameMap.entrySet()) {
                String orgPropName = entry.getKey();
                for (Map.Entry<String, Set<String>> groupByImProp : entry.getValue().entrySet()) {
                    Set<String> searchValues = groupByImProp.getValue();
                    ApiFilter apiFilter = new ApiFilter();
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    filters.add(new QFilter(groupByImProp.getKey(), "in", searchValues));
                    apiFilter.getFilters().addAll(filters);
                    if (!StringUtils.equals((CharSequence)groupByImProp.getKey(), (CharSequence)"id")) {
                        String selectFields = groupByImProp.getKey() + ",id";
                        DynamicObjectCollection orgDynColl = baseDataService.queryBaseDataByDate("bos_org", null, apiFilter.toQFilter(), selectFields, new Date());
                        log.info("[MulImport:org search filters]\uff1a" + apiFilter.toQFilter().toString());
                        for (DynamicObject orgDyn : orgDynColl) {
                            String importPropVal = orgDyn.getString(groupByImProp.getKey());
                            loadingOrgIDs.add(orgDyn.getLong("id"));
                            checkedOrgDynMap.computeIfAbsent(mainEntityName, s -> new HashMap()).computeIfAbsent(orgPropName, s -> new HashMap()).putIfAbsent(importPropVal, orgDyn);
                        }
                        continue;
                    }
                    Set<String> ids = groupByImProp.getValue();
                    if (!CollectionUtils.isNotEmpty(ids)) continue;
                    for (String id : ids) {
                        if (!StringUtils.isNumeric((CharSequence)id)) continue;
                        loadingOrgIDs.add(Long.valueOf(id));
                    }
                }
            }
        }
    }

    private void searchMainOrgIds4Checked(IBaseDataService baseDataService, Map<String, Set<MulImportCheckedMainOrgKey>> checkedMainOrgMap4Search, Set<Long> loadingMainOrgIDs) {
        for (Map.Entry<String, Set<MulImportCheckedMainOrgKey>> checkedMainOrgMapEntry : checkedMainOrgMap4Search.entrySet()) {
            String mainEntityName = checkedMainOrgMapEntry.getKey();
            IFormView entityView = this.getView(mainEntityName);
            IDataModel model = entityView.getModel();
            ApiFilter apiFilter = new ApiFilter();
            Map<String, List<MulImportCheckedMainOrgKey>> groupByImportProp = checkedMainOrgMapEntry.getValue().stream().collect(Collectors.groupingBy(MulImportCheckedMainOrgKey::getImportProp));
            for (Map.Entry<String, List<MulImportCheckedMainOrgKey>> groupByImportPropEntry : groupByImportProp.entrySet()) {
                List mainOrgList = groupByImportPropEntry.getValue().stream().map(MulImportCheckedMainOrgKey::getMainOrgValue).collect(Collectors.toList());
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter(groupByImportPropEntry.getKey(), "in", mainOrgList));
                apiFilter.getFilters().addAll(filters);
                QFilter qFilter = apiFilter.toQFilter();
                String importPropField = groupByImportPropEntry.getKey();
                HashMap<String, Long> mainOrgIdMap = new HashMap<String, Long>();
                if (!StringUtils.equals((CharSequence)importPropField, (CharSequence)"id")) {
                    String selectFields = importPropField + ",id";
                    DynamicObjectCollection mainOrgDynamicObjects = baseDataService.queryBaseDataByDate("bos_org", null, qFilter, selectFields, new Date());
                    log.info("[MulImport:mainOrg search filters] \uff1a" + apiFilter.toQFilter().toString());
                    for (DynamicObject mainOrgDynamicObject : mainOrgDynamicObjects) {
                        String importPropFieldVal = mainOrgDynamicObject.getString(importPropField);
                        Long id = mainOrgDynamicObject.getLong("id");
                        loadingMainOrgIDs.add(id);
                        mainOrgIdMap.put(importPropFieldVal, id);
                    }
                } else {
                    for (String idVal : mainOrgList) {
                        if (!StringUtils.isNumeric((CharSequence)idVal)) continue;
                        loadingMainOrgIDs.add(Long.valueOf(idVal));
                    }
                }
                for (MulImportCheckedMainOrgKey mainOrgKey : checkedMainOrgMapEntry.getValue()) {
                    Long mainOrgId = (Long)mainOrgIdMap.get(mainOrgKey.getMainOrgValue());
                    if (mainOrgId == null) continue;
                    mainOrgKey.setMainOrgId(mainOrgId);
                }
            }
        }
    }

    private void batchLoadOrgData(Set<Long> loadingOrgIDs) {
        if (CollectionUtils.isEmpty(loadingOrgIDs)) {
            return;
        }
        Map orgCollection = BusinessDataServiceHelper.loadFromCache((Object[])loadingOrgIDs.toArray(), (String)"bos_org");
        MulImportContext mulImportContext = this.getMulImportContext();
        Map<String, Map<String, Map<String, DynamicObject>>> checkedOrgMapDynMap = mulImportContext.getCheckedOrgDynMap();
        for (Map<String, Map<String, DynamicObject>> orgInfo : checkedOrgMapDynMap.values()) {
            for (Map<String, DynamicObject> orgValue : orgInfo.values()) {
                for (Map.Entry<String, DynamicObject> entry : orgValue.entrySet()) {
                    DynamicObject orgEntityData;
                    DynamicObject value = entry.getValue();
                    if (value == null || (orgEntityData = (DynamicObject)orgCollection.get(value.get("id"))) == null) continue;
                    entry.setValue(orgEntityData);
                }
            }
        }
    }

    private void batchLoadMainOrgData(Set<Long> loadingMainOrgIDs) {
        if (CollectionUtils.isEmpty(loadingMainOrgIDs)) {
            return;
        }
        Map orgCollection = BusinessDataServiceHelper.loadFromCache((Object[])loadingMainOrgIDs.toArray(), (String)"bos_org");
        MulImportContext mulImportContext = this.getMulImportContext();
        Map<String, Map<String, DynamicObject>> checkedMainOrgMapDynMap = mulImportContext.getCheckedMainOrgMapDynMap();
        Map<String, Set<MulImportCheckedMainOrgKey>> checkedMainOrgMap4Search = mulImportContext.getCheckedMainOrgMap4Search();
        for (Map.Entry<String, Set<MulImportCheckedMainOrgKey>> entry : checkedMainOrgMap4Search.entrySet()) {
            String entityNumber = entry.getKey();
            Set<MulImportCheckedMainOrgKey> mainOrgKeys = entry.getValue();
            if (CollectionUtils.isEmpty(mainOrgKeys)) continue;
            for (MulImportCheckedMainOrgKey mainOrgKey : mainOrgKeys) {
                DynamicObject dynamicObject;
                Object mainOrgId = mainOrgKey.getMainOrgId();
                if (mainOrgId == null || (dynamicObject = (DynamicObject)orgCollection.get(mainOrgId)) == null) continue;
                checkedMainOrgMapDynMap.computeIfAbsent(entityNumber, o -> new HashMap()).put(mainOrgKey.getMainOrgValue(), dynamicObject);
            }
        }
    }

    private IFormView getView(String billFormId) {
        if (this.formViewMap.get(billFormId) == null) {
            FormShowParameter parameter = ImportCreateViewUtil.createShowParameter(billFormId);
            IFormView formView = parameter.createViewForWebApi();
            formView.initialize(parameter);
            formView.getModel().beginInit();
            formView.getModel().putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)true);
            formView.getModel().putContextVariable("fireAfterCreateNewData", (Object)false);
            formView.getModel().createNewData((Object)ImportCreateViewUtil.getBlankDataEntity(formView.getModel(), null, true));
            this.formViewMap.put(billFormId, formView);
        }
        return this.formViewMap.get(billFormId);
    }
}

