/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.service;

import java.io.InputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MulImportExcelReader {
    private static final Log log = LogFactory.getLog(MulImportExcelReader.class);

    public void read(XMLReader parser, String sheetName, XSSFReader.SheetIterator sheets) {
        try {
            SheetHandler sheetHandler = (SheetHandler)parser.getContentHandler();
            CommonReaderWay readerWay = new CommonReaderWay(sheetHandler, parser, sheets);
            while (sheets.hasNext()) {
                InputStream sheet = sheets.next();
                if (!sheets.getSheetName().equals(sheetName)) continue;
                readerWay.handle(sheet, sheetName);
                if (!readerWay.interrupt(sheet, sheetName)) continue;
                break;
            }
        }
        catch (Exception e) {
            log.error("MulImportExcelReader parse failed:", (Throwable)e);
        }
    }

    static class CommonReaderWay
    implements ReaderWay {
        protected SheetHandler sheetHandler;
        protected XMLReader parser;
        protected XSSFReader.SheetIterator sheets;

        public CommonReaderWay(SheetHandler sheetHandler, XMLReader parser, XSSFReader.SheetIterator sheets) {
            this.sheetHandler = sheetHandler;
            this.parser = parser;
            this.sheets = sheets;
        }

        @Override
        public void handle(InputStream sheet, String sheetName) throws Exception {
            InputSource sheetSource = new InputSource(sheet);
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                this.sheetHandler.setSheetName(this.sheets.getSheetName());
                this.parser.parse(sheetSource);
                sheet.close();
            }
        }

        @Override
        public boolean interrupt(InputStream sheet, String sheetName) {
            if (StringUtils.isNotBlank((CharSequence)this.sheets.getSheetName())) {
                return this.sheetHandler.isInterrupt();
            }
            return true;
        }
    }

    static interface ReaderWay {
        public void handle(InputStream var1, String var2) throws Exception;

        public boolean interrupt(InputStream var1, String var2);
    }
}

