/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.AttachmentResultListener;
import kd.bos.form.control.events.BeforeAttachmentUploadEvent;
import kd.bos.form.control.events.BeforeAttachmentUploadListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadResultEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.schemeplugin.model.SchemeOpenTypeEnum;
import kd.bos.mulimport.stepplugin.MulImportStepBasePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MulImportStepOnePlugin
extends MulImportStepBasePlugin
implements ICloseCallBack,
BeforeAttachmentUploadListener,
AttachmentResultListener,
ProgresssListener {
    private static final Log log = LogFactory.getLog(MulImportStepOnePlugin.class);
    private static final String UPLOAD_PANEL = "attachmentpanelap";
    public static final String CACHE_KEY_MUL_SCHEME_FILE_PATH = "mul_scheme_file_path";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (!StringUtils.equals((CharSequence)"baritenext", (CharSequence)key)) {
            return;
        }
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        if (!StringUtils.equals((CharSequence)"tabpageap", (CharSequence)currentTab)) {
            return;
        }
        Object importEntity = this.getModel().getValue("mulbasedatafield");
        AttachmentPanel uploadPanel = (AttachmentPanel)this.getControl(UPLOAD_PANEL);
        List attachData = uploadPanel.getAttachmentData();
        if (ObjectUtils.isEmpty((Object)importEntity) || CollectionUtils.isEmpty((Collection)attachData)) {
            this.showMessage(importEntity, attachData);
            evt.setCancel(true);
            this.setWizardStatus(0, "error");
            return;
        }
        this.setWizardStatus(0, "finish");
        this.setWizardStatus(1, "");
    }

    private void showMessage(Object importEntity, List<Map<String, Object>> attachmentInfo) {
        if (ObjectUtils.isEmpty((Object)importEntity) && CollectionUtils.isEmpty(attachmentInfo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u5bfc\u5165\u6570\u636e\u7684\u4e1a\u52a1\u5355\u636e\u6216\u8005\u57fa\u7840\u8d44\u6599\uff0c\u5e76\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"MulImportStepPlugin_3", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        if (CollectionUtils.isEmpty(attachmentInfo)) {
            String cacheKey = "UploadingAtt" + this.getView().getPageId();
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            if (StringUtils.isBlank((CharSequence)cache.get(cacheKey))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"MulImportStepPlugin_2", (String)"bos-import", (Object[])new Object[0]));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7b49\u5019\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"MulImportStepPlugin_2", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)importEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5c06\u6570\u636e\u5bfc\u5165\u5230\u201d\u53c2\u6570\u672a\u586b\uff0c\u8bf7\u9009\u62e9\u9700\u5bfc\u5165\u6570\u636e\u7684\u4e1a\u52a1\u5355\u636e\u6216\u8005\u57fa\u7840\u8d44\u6599", (String)"MulImportStepPlugin_1", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("opentips".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipscontent", "closetips"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"opentips"});
            return;
        }
        if ("closetips".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tipscontent", "closetips"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"opentips"});
            return;
        }
        if ("downloadschemefile".equals(key) || "schemeoldfile".equals(key)) {
            this.downloadSchemeFile();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("baritecancel".equals(key)) {
            this.getView().close();
            this.deleteFile();
            return;
        }
        if ("baritenext".equals(key)) {
            this.next();
        }
    }

    private void downloadSchemeFile() {
        String path = this.getView().getPageCache().get(CACHE_KEY_MUL_SCHEME_FILE_PATH);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("download", (Object)path);
    }

    public void afterRemove(UploadEvent evt) {
        this.deleteFile();
        this.clearPageCache("mul_import");
        Map schemeParam = (Map)this.getView().getFormShowParameter().getCustomParam("schemeParam");
        if (MapUtils.isNotEmpty((Map)schemeParam)) {
            this.getView().getPageCache().put("mul_import_scheme_reupload", "1");
            if (StringUtils.isBlank(schemeParam.get("newScheme"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"schemeoldfile"});
                this.getView().getPageCache().put("all_mul_import_auto_match", "1");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bariteimport", "savescheme1", "bariteprev", "savescheme2", "progressflex", "downloadschemefile", "opentips", "schemeoldfile"});
        String openFormId = (String)this.getView().getFormShowParameter().getCustomParam("currentFormId");
        this.getView().getPageCache().put("mul_import_choose_scheme", String.valueOf(SchemeOpenTypeEnum.NOT_CHOOSE.getType()));
        this.getView().getPageCache().put("all_mul_import_auto_match", "1");
        if (StringUtils.isNotBlank((CharSequence)openFormId)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)openFormId)});
            if (null != dynamicObject) {
                String id = dynamicObject.getPkValue().toString();
                Set<String> hasPermEntity = this.getHasImportPermEntity();
                if (null == hasPermEntity || hasPermEntity.contains(id)) {
                    this.getModel().setValue("mulbasedatafield", (Object)new String[]{id});
                }
            }
        } else {
            Map schemeParam = (Map)this.getView().getFormShowParameter().getCustomParam("schemeParam");
            if (MapUtils.isNotEmpty((Map)schemeParam)) {
                Wizard wizard = (Wizard)this.getView().getControl("wizardap");
                List stepsOptions = wizard.getStepsOptions();
                ((StepsOption)stepsOptions.get(3)).getTitle().setLocaleValue(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848", (String)"MulImportSchemePlugin_2", (String)"bos-import", (Object[])new Object[0]));
                wizard.setWizardStepsOptions(stepsOptions);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"choosescheme"});
                this.getView().getPageCache().put("mul_import_from_scheme", "1");
                if (StringUtils.isBlank(schemeParam.get("newScheme"))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulbasedatafield"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap21"});
                    this.getView().getPageCache().put("all_mul_import_auto_match", "0");
                    Object id = schemeParam.get("id");
                    this.setFirstPageByChooseScheme(id);
                }
            }
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bariteimport"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bariteprev"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritecancel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritenext"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        if ("mulbasedatafield".equals(changedName)) {
            if (oldValue instanceof MulBasedataDynamicObjectCollection && newValue instanceof MulBasedataDynamicObjectCollection) {
                List<String> newIdList;
                MulBasedataDynamicObjectCollection oldValueCol = (MulBasedataDynamicObjectCollection)oldValue;
                MulBasedataDynamicObjectCollection newValueCol = (MulBasedataDynamicObjectCollection)newValue;
                List<String> oldIdList = this.getMulBaseDataIdList(oldValueCol);
                if (!oldIdList.equals(newIdList = this.getMulBaseDataIdList(newValueCol))) {
                    this.getView().getPageCache().put("mul_import_set_flag", "");
                }
                if (null != this.getView().getFormShowParameter().getCustomParam("schemeParam")) {
                    this.getView().getPageCache().put("mul_import_scheme_reset", "1");
                }
            }
        } else if ("choosescheme".equals(changedName)) {
            if (newValue instanceof DynamicObject) {
                this.getView().getPageCache().put("all_mul_import_auto_match", "0");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"downloadschemefile"});
                this.getView().getPageCache().put("mul_import_choose_scheme", String.valueOf(SchemeOpenTypeEnum.CHOOSE.getType()));
                DynamicObject schemeInfo = (DynamicObject)newValue;
                Object id = schemeInfo.getPkValue();
                this.removeOldFile();
                this.getView().getPageCache().put("mul_import_choose_scheme_id", id.toString());
                boolean right = this.setEntityByScheme(id, false);
                if (!right) {
                    this.getModel().beginInit();
                    this.getModel().setValue("choosescheme", null);
                    this.getModel().endInit();
                    return;
                }
                this.setAttachmentByScheme(id, false);
                this.getView().updateView(UPLOAD_PANEL);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulbasedatafield"});
            }
            if (newValue == null) {
                this.getView().getPageCache().remove("mul_import_choose_scheme_id");
                this.getView().getPageCache().put("all_mul_import_auto_match", "1");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"downloadschemefile"});
                this.getModel().setValue("mulbasedatafield", null);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"mulbasedatafield"});
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public void beforeAttachmentUpload(BeforeAttachmentUploadEvent evt) {
        this.setProgressColor("#5582F3");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"progressflex"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"percentflex"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"success_vectorap"});
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
        try {
            this.removeProgressStatus();
            progress.start();
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    public void uploadResult(UploadResultEvent evt) {
        List attachResultInfo = evt.getAttachResultInfo();
        if (CollectionUtils.isEmpty((Collection)attachResultInfo)) {
            return;
        }
        String status = String.valueOf(((Map)attachResultInfo.get(0)).get("status"));
        if (StringUtils.equals((CharSequence)"success", (CharSequence)status)) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"progressflex"});
        this.removeProgressStatus();
    }

    public void remove(UploadEvent evt) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"progressflex"});
        this.removeProgressStatus();
    }

    private void removeProgressStatus() {
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.setPercent(0);
        progress.stop();
        ((Label)this.getControl("percentlabel")).setText("0");
        String percentCacheKey = "uploadingpercent" + this.getView().getPageId();
        this.getPageCache().remove(percentCacheKey);
    }

    public void onProgress(ProgressEvent evt) {
        int percent;
        String cacheKey = "UploadingAtt" + this.getView().getPageId();
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(cacheKey))) {
            this.finishImporting(evt);
            return;
        }
        String percentCacheKey = "uploadingpercent" + this.getView().getPageId();
        String percentStr = this.getPageCache().get(percentCacheKey);
        if (StringUtils.isBlank((CharSequence)percentStr)) {
            percentStr = "0";
        }
        if ((percent = Integer.parseInt(percentStr)) > 99) {
            this.continueImporting(evt);
            return;
        }
        if ((percent += 25) > 99) {
            this.continueImporting(evt);
            return;
        }
        evt.setProgress(percent);
        ((Label)this.getControl("percentlabel")).setText(String.valueOf(percent));
        this.getPageCache().put(percentCacheKey, String.valueOf(percent));
    }

    private List<String> getMulBaseDataIdList(MulBasedataDynamicObjectCollection dynamicObjects) {
        ArrayList<String> idList = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject baseData = dynamicObject.getDynamicObject("fbasedataid");
            idList.add(baseData.getPkValue().toString());
        }
        return idList;
    }

    private void bindAttachment(String path, long fileSize, String fileName) {
        try {
            AttachmentPanel panel = (AttachmentPanel)this.getControl(UPLOAD_PANEL);
            HashMap<String, Object> bindingParam = new HashMap<String, Object>();
            bindingParam.put("path", path);
            bindingParam.put("url", UrlService.getAttachmentDownloadUrl((String)path));
            bindingParam.put("previewurl", UrlService.getAttachmentPreviewUrl((String)path));
            bindingParam.put("name", fileName);
            bindingParam.put("size", fileSize);
            bindingParam.put("status", "success");
            bindingParam.put("uid", AttachmentServiceHelper.generateUid());
            List attachList = Collections.singletonList(bindingParam);
            panel.upload(attachList);
        }
        catch (Exception e) {
            log.error("mul import scheme bindAttachment failed:", (Throwable)e);
        }
    }

    protected void setWizardStatus(int step, String status) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", status);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private void setFirstPageByChooseScheme(Object id) {
        IPageCache pageCache = this.getView().getPageCache();
        boolean setEntityResult = this.setEntityByScheme(id, true);
        if (!setEntityResult) {
            return;
        }
        this.setAttachmentByScheme(id, true);
        pageCache.put("mul_import_scheme_save", "1");
    }

    private boolean setEntityByScheme(Object id, boolean isFromList) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_multi_import_scheme");
        DynamicObjectCollection importDynCol = dynamicObject.getDynamicObjectCollection("mulbasedatafield");
        String[] importDynIds = new String[importDynCol.size()];
        Set<String> hasPermEntity = this.getHasImportPermEntity();
        for (int i = 0; i < importDynCol.size(); ++i) {
            DynamicObject importDyn = (DynamicObject)importDynCol.get(i);
            String baseDataId = importDyn.getString("fbasedataid_id");
            if (null != hasPermEntity && !hasPermEntity.contains(baseDataId)) {
                if (isFromList) {
                    IFormView parentView = this.getView().getParentView();
                    parentView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u65b9\u6848\u7684\u76ee\u6807\u5bfc\u5165\u5355\u636e\u7684\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u6216\u65b0\u589e\u5bfc\u5165\u6743\u9650\u3002", (String)"MulImportStepPlugin_39", (String)"bos-import", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u65b9\u6848\u7684\u76ee\u6807\u5bfc\u5165\u5355\u636e\u7684\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b9\u6848\u6216\u65b0\u589e\u5bfc\u5165\u6743\u9650\u3002", (String)"MulImportStepPlugin_39", (String)"bos-import", (Object[])new Object[0]));
                }
                return false;
            }
            importDynIds[i] = importDyn.getString("fbasedataid_id");
        }
        this.getModel().setValue("mulbasedatafield", (Object)importDynIds);
        return true;
    }

    private void setAttachmentByScheme(Object id, boolean isFromList) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_multi_import_scheme");
        String path = dynamicObject.getString("filepath");
        if (isFromList) {
            String fileName = dynamicObject.getString("filename");
            this.bindAttachment(path, dynamicObject.getLong("filesize"), fileName);
        }
        this.getView().getPageCache().put(CACHE_KEY_MUL_SCHEME_FILE_PATH, UrlService.getAttachmentFullUrl((String)path));
    }

    private void removeOldFile() {
        try {
            AttachmentPanel panel = (AttachmentPanel)this.getControl(UPLOAD_PANEL);
            List attachmentDataList = panel.getAttachmentData();
            for (Map attachmentData : attachmentDataList) {
                panel.remove(attachmentData);
            }
            this.deleteFile();
            this.getView().updateView(UPLOAD_PANEL);
        }
        catch (Exception e) {
            log.error("old file remove failed:", (Throwable)e);
        }
    }
}

