/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin;

import com.alibaba.excel.support.ExcelTypeEnum;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NameVersionEntryType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MobBasedataField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.NameField;
import kd.bos.metadata.entity.businessfield.PeriodField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.GeoPointField;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RichTextField;
import kd.bos.metadata.entity.commonfield.SignatureField;
import kd.bos.metadata.entity.commonfield.StepperField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.mulimport.resolve.model.MulImportResolveTypeEnum;
import kd.bos.mulimport.resolve.model.MulNodeDetailVo;
import kd.bos.mulimport.resolve.model.MulSheetVo;
import kd.bos.mulimport.stepplugin.MulImportStepOnePlugin;
import kd.bos.mulimport.stepplugin.util.MulImportStepPluginUtil;
import kd.bos.util.CollectionUtils;

public class MulImportStepTwoPlugin
extends MulImportStepOnePlugin {
    private static final Log log = LogFactory.getLog(MulImportStepTwoPlugin.class);
    public static final String STARTROW = "startrow";
    public static final String STARTCOLUMN = "startcolumn";
    private static final String FIELD_IMPORTPROP = "importprop";
    private static final String EXPORTPROPNAME = "exportpropname";
    private static final String TREEENTRYENTITY = "treeentryentity";
    public static final String FILED_IMPORTTYPECHOOSE = "importtypechoose";
    public static final String FILED_IMPORTENTITY = "importentity";
    private static final String ENTRY_ENTITY = "treeentryentity";
    private static final String FILTER = "filter";
    private static final String SORT = "sort";
    private List<String> autoMappingSheetList;

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addPackageDataListener(this::handlePackageDataEvent);
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("treeentryentity", "setColEditorProp", new Object[]{"datareplacevalueshow", "isDynamicOption", true});
        clientViewProxy.invokeControlMethod("treeentryentity", "setColEditorProp", new Object[]{FILED_IMPORTTYPECHOOSE, "isDynamicOption", true});
        EntryGrid grid = (EntryGrid)this.getView().getControl("treeentryentity");
        grid.setColumnProperty("datareplacevalueshow", SORT, (Object)false);
        grid.setColumnProperty("datareplacevalueshow", FILTER, (Object)false);
        grid.setColumnProperty(FILED_IMPORTTYPECHOOSE, SORT, (Object)false);
        grid.setColumnProperty(FILED_IMPORTTYPECHOOSE, FILTER, (Object)false);
    }

    private void handlePackageDataEvent(PackageDataEvent packageDataEvent) {
        Object ctl = packageDataEvent.getSource();
        int rowIndex = packageDataEvent.getRowIndex();
        if (!(ctl instanceof ComboEdit)) {
            return;
        }
        String fieldKey = ((ComboEdit)ctl).getKey();
        if ("datareplacevalueshow".equals(fieldKey)) {
            packageDataEvent.setComboList(this.getAllFieldsByRowId(rowIndex));
        }
        if (FILED_IMPORTTYPECHOOSE.equals(fieldKey)) {
            List<ComboItem> importTypeChooseItems = this.getImportTypeChooseItemFromCache(rowIndex);
            if (importTypeChooseItems == null || importTypeChooseItems.size() == 0) {
                return;
            }
            List collect = importTypeChooseItems.stream().map(importType -> importType).collect(Collectors.toList());
            packageDataEvent.setComboList(collect);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tabpageap1", (CharSequence)this.getCurrentTab())) {
            if ("baritenext".equals(key)) {
                this.next();
                this.reCacheMulNodeDetail();
            } else if ("bariteprev".equals(key)) {
                this.previous();
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        Tab tab;
        String currentTab;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("baritenext".equals(key) && "tabpageap1".equals(currentTab = (tab = (Tab)this.getView().getControl("guidecontent")).getCurrentTab())) {
            String message = this.checkData();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showErrorNotification(message);
                evt.setCancel(true);
                this.setWizardStatus(1, "error");
            } else {
                this.setWizardStatus(1, "finish");
                this.setWizardStatus(2, "");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        if (StringUtils.equals((CharSequence)"mul_confirm_import_type", (CharSequence)closedEvent.getCallBackId()) && closedEvent.getResult() == MessageBoxResult.Yes) {
            this.next();
        }
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        super.tabSelected(tabSelectEvent);
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap1".equals(tabKey) || "tabpageap2".equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bariteimport"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritecancel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savescheme2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritenext"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bariteprev"});
            if (StringUtils.isBlank((CharSequence)this.getView().getPageCache().get("mul_import_set_flag"))) {
                this.initTabPageParam();
                this.setFirstImportEntityCombo();
                this.fillValueByScheme();
                this.initExcelHeadOfAllSheet();
                this.changeStartCol();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        boolean hasChoose;
        FieldEdit fieldEdit;
        if (e.getSource() instanceof FieldEdit && StringUtils.equalsIgnoreCase((CharSequence)(fieldEdit = (FieldEdit)e.getSource()).getKey(), (CharSequence)"detailsheetchoose") && (hasChoose = this.checkSheetHasChoose((String)e.getValue(), e.getRowIndex()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9875\u7b7e\u5df2\u88ab\u9009\u62e9\u3002", (String)"MulImportStepPlugin_38", (String)"bos-import", (Object[])new Object[0]));
            this.getView().updateView();
            e.setCancel(true);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!StringUtils.equals((CharSequence)"tabpageap1", (CharSequence)this.getCurrentTab())) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String changedName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if ("detailsheetchoose".equals(changedName)) {
            List mulNodeDetailVos;
            MulNodeDetailVo mulNodeDetailVo;
            int nodeType;
            int currentIndex = changeData.getRowIndex();
            if (ObjectUtils.isEmpty((Object)newValue)) {
                this.getModel().setValue(FILED_IMPORTTYPECHOOSE, (Object)"", currentIndex);
                return;
            }
            String mulNodeDetailVosStr = pageCache.get("mul_import_mulTreeNodeMapping");
            if (StringUtils.isNotBlank((CharSequence)mulNodeDetailVosStr) && (nodeType = (mulNodeDetailVo = (MulNodeDetailVo)(mulNodeDetailVos = SerializationUtils.fromJsonStringToList((String)mulNodeDetailVosStr, MulNodeDetailVo.class)).get(currentIndex)).getNodeType()) != MulImportResolveTypeEnum.HEAD.getType()) {
                int parentRowId = mulNodeDetailVo.getParentRowId();
                MulNodeDetailVo parentMulNodeDetailVo = (MulNodeDetailVo)mulNodeDetailVos.get(parentRowId);
                int rowId = parentMulNodeDetailVo.getRowId();
                String sheetName = String.valueOf(this.getModel().getValue("detailsheetchoose", rowId));
                String importType = String.valueOf(this.getModel().getValue(FILED_IMPORTTYPECHOOSE, rowId));
                if (StringUtils.isNotBlank((CharSequence)sheetName) && importType.equals("0")) {
                    this.getModel().setValue(FILED_IMPORTTYPECHOOSE, (Object)"0", currentIndex);
                }
            }
            if (ObjectUtils.isEmpty((Object)newValue) || !newValue.equals(changeData.getOldValue())) {
                this.getView().getPageCache().remove("mul_import_mul_field_mapping_" + currentIndex);
                DynamicObjectCollection entryCollection = this.getModel().getEntryEntity("treeentryentity");
                if (entryCollection.size() <= currentIndex) {
                    return;
                }
                String startRowStr = ((DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(currentIndex)).getString(STARTROW);
                if (StringUtils.isNotBlank((CharSequence)startRowStr)) {
                    this.cacheExcelHead(currentIndex, Integer.parseInt(startRowStr));
                    this.changeStartCol();
                }
                this.getView().getPageCache().put("all_mul_import_auto_match", "1");
            }
            return;
        }
        if (FILED_IMPORTTYPECHOOSE.equals(changedName)) {
            this.getModel().beginInit();
            int currentIndex = changeData.getRowIndex();
            List<Integer> lowerNodeIds = this.findSubNodeIds(currentIndex);
            if ("0".equals(newValue)) {
                this.setEmpty4ReplaceValue(currentIndex);
                for (int lowerNodeId : lowerNodeIds) {
                    this.updateImportTypeChooseItemCache(lowerNodeId, this.getOnlyNewImportTypeChooseItem());
                    this.setEmpty4ReplaceValue(lowerNodeId);
                    Object sheetChoose = this.getView().getModel().getValue("detailsheetchoose", lowerNodeId);
                    if (ObjectUtils.isEmpty((Object)sheetChoose)) continue;
                    this.getModel().setValue(FILED_IMPORTTYPECHOOSE, (Object)"0", lowerNodeId);
                }
                this.getView().updateView("treeentryentity");
                this.setLock();
                return;
            }
            if ("1".equals(newValue) || "2".equals(newValue)) {
                for (int lowerNodeId : lowerNodeIds) {
                    this.updateImportTypeChooseItemCache(lowerNodeId, this.getAllImportTypeChooseItem());
                    this.getView().setEnable(Boolean.valueOf(true), lowerNodeId, new String[]{FILED_IMPORTTYPECHOOSE});
                    this.getModel().setValue(FILED_IMPORTTYPECHOOSE, (Object)"", lowerNodeId);
                }
                this.getView().updateView("treeentryentity");
                this.setLock();
                return;
            }
            if (ObjectUtils.isEmpty((Object)newValue)) {
                this.setEmpty4ReplaceValue(currentIndex);
                for (int lowerNodeId : lowerNodeIds) {
                    this.setEmpty4ReplaceValue(lowerNodeId);
                    this.getModel().setValue(FILED_IMPORTTYPECHOOSE, (Object)"", lowerNodeId);
                }
                boolean isUpdateCombo = false;
                String mulNodeDetailVosStr = pageCache.get("mul_import_mulTreeNodeMapping");
                if (StringUtils.isNotBlank((CharSequence)mulNodeDetailVosStr)) {
                    List mulNodeDetailVos = SerializationUtils.fromJsonStringToList((String)mulNodeDetailVosStr, MulNodeDetailVo.class);
                    MulNodeDetailVo mulNodeDetailVo = (MulNodeDetailVo)mulNodeDetailVos.get(currentIndex);
                    int nodeType = mulNodeDetailVo.getNodeType();
                    if (nodeType == MulImportResolveTypeEnum.ENTRY.getType()) {
                        int parentRowId = mulNodeDetailVo.getParentRowId();
                        String parentImportType = String.valueOf(this.getModel().getValue(FILED_IMPORTTYPECHOOSE, parentRowId));
                        if (!StringUtils.equals((CharSequence)parentImportType, (CharSequence)"0")) {
                            isUpdateCombo = true;
                        }
                    }
                    if (nodeType == MulImportResolveTypeEnum.SUB_ENTRY.getType()) {
                        int entryRowId = mulNodeDetailVo.getParentRowId();
                        String entryImportType = String.valueOf(this.getModel().getValue(FILED_IMPORTTYPECHOOSE, entryRowId));
                        if (!StringUtils.equals((CharSequence)entryImportType, (CharSequence)"0")) {
                            isUpdateCombo = true;
                        }
                    }
                }
                if (isUpdateCombo) {
                    this.updateImportTypeChooseItemCache(currentIndex, this.getAllImportTypeChooseItem());
                    for (int lowerNodeId : lowerNodeIds) {
                        this.updateImportTypeChooseItemCache(lowerNodeId, this.getAllImportTypeChooseItem());
                    }
                }
                this.getView().updateView("treeentryentity");
                this.setLock();
            }
            this.getModel().endInit();
            return;
        }
        if (STARTROW.equals(changedName) && StringUtils.isNotBlank((Object)changeData.getOldValue())) {
            int currentIndex = changeData.getRowIndex();
            Object newData = changeData.getNewValue();
            int startRow = Integer.parseInt(newData.toString());
            this.cacheExcelHead(currentIndex, startRow);
            String startColStr = ((DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(currentIndex)).getString(STARTCOLUMN);
            if (StringUtils.isNotBlank((CharSequence)startColStr)) {
                this.changeStartCol();
            }
            this.getView().getPageCache().put("all_mul_import_auto_match", "1");
            return;
        }
        if (STARTCOLUMN.equals(changedName) && StringUtils.isNotBlank((Object)changeData.getOldValue())) {
            this.changeStartCol();
            this.getView().getPageCache().remove("mul_import_last_tree_node_id");
            this.clearPageCache("mul_import_mul_field_mapping_");
            this.getView().getPageCache().put("all_mul_import_auto_match", "1");
            return;
        }
        if ("datareplacevalueshow".equals(changedName)) {
            int rowIndex = changeData.getRowIndex();
            String selectValue = String.valueOf(newValue);
            this.getModel().setValue("datareplacevalue", (Object)selectValue, rowIndex);
        }
    }

    protected void setLock() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
            String importType = String.valueOf(this.getModel().getValue(FILED_IMPORTTYPECHOOSE, rowIndex));
            if (StringUtils.equals((CharSequence)importType, (CharSequence)"0")) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"datareplacevalueshow"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"datareplacevalueshow"});
        }
    }

    private List<Integer> findSubNodeIds(int currentIndex) {
        List<Integer> lowerNodeIds = MulImportStepPluginUtil.getLowerNodeIdByCurrentId(currentIndex, this.getView().getPageCache(), true, true);
        if (CollectionUtils.isEmpty(lowerNodeIds)) {
            return MulImportStepPluginUtil.getSubEntryIdByEntryId(currentIndex, this.getView().getPageCache(), true);
        }
        return lowerNodeIds;
    }

    private void setEmpty4ReplaceValue(int nodeId) {
        this.getModel().setValue("datareplacevalueshow", (Object)"", nodeId);
        this.getModel().setValue("datareplacevalue", (Object)"", nodeId);
    }

    private void cacheExcelHead(int currentIndex, int startRow) {
        ArrayList<MulSheetVo> mulSheetVos;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("treeentryentity");
        if (dynamicObjects.size() <= currentIndex) {
            return;
        }
        String sheetHeadCache = this.getView().getPageCache().get("mul_import_sheet_head");
        String changedSheetStr = ((DynamicObject)dynamicObjects.get(currentIndex)).getString("detailsheetchoose");
        if (StringUtils.isBlank((CharSequence)changedSheetStr)) {
            return;
        }
        int changedSheet = Integer.parseInt(changedSheetStr);
        String path = this.getView().getPageCache().get("mul_import_file_path");
        this.getView().getPageCache().remove("mul_import_last_tree_node_id");
        this.clearPageCache("mul_import_mul_field_mapping_");
        this.buildContext(path);
        if (StringUtils.isNotBlank((CharSequence)sheetHeadCache)) {
            mulSheetVos = SerializationUtils.fromJsonStringToList((String)sheetHeadCache, MulSheetVo.class);
            MulSheetVo existVo = mulSheetVos.stream().filter(sheetVo -> sheetVo.getEntityRow() == currentIndex).findFirst().orElse(null);
            if (null == existVo) {
                mulSheetVos.add(this.resolveHead(changedSheet, startRow, currentIndex));
            } else {
                int existVoIndex = IntStream.range(0, mulSheetVos.size()).filter(i -> currentIndex == ((MulSheetVo)mulSheetVos.get(i)).getEntityRow()).findFirst().orElse(-1);
                mulSheetVos.set(existVoIndex, this.resolveHead(changedSheet, startRow, currentIndex));
            }
        } else {
            mulSheetVos = new ArrayList<MulSheetVo>();
            mulSheetVos.add(this.resolveHead(changedSheet, startRow, currentIndex));
        }
        this.getView().getPageCache().put("mul_import_sheet_head", SerializationUtils.toJsonString(mulSheetVos));
    }

    private MulSheetVo resolveHead(int sheetNo, int startRow, int currentIndex) {
        List<Map<Integer, String>> headInfo = this.convertService.readExcelSheetGetHead(ExcelTypeEnum.XLSX, sheetNo, startRow, 0);
        List<String> cells = this.getHeadCells(headInfo);
        String sheetNameCache = this.getView().getPageCache().get("mul_import_sheet_name");
        List sheetNames = SerializationUtils.fromJsonStringToList((String)sheetNameCache, String.class);
        return new MulSheetVo(sheetNo, currentIndex, (String)sheetNames.get(sheetNo), cells);
    }

    private void changeStartCol() {
        String sheetHeadCache = this.getView().getPageCache().get("mul_import_sheet_head");
        if (StringUtils.isBlank((CharSequence)sheetHeadCache)) {
            return;
        }
        List mulSheetVos = SerializationUtils.fromJsonStringToList((String)sheetHeadCache, MulSheetVo.class);
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("treeentryentity");
        int currentRow = 0;
        for (DynamicObject entry : treeEntryEntity) {
            int currentStartCol = entry.getInt(STARTCOLUMN);
            if (currentStartCol > 1) {
                for (MulSheetVo sheetVo : mulSheetVos) {
                    if (null == sheetVo.getHeadCells() || sheetVo.getEntityRow() != currentRow) continue;
                    int minCol = Math.min(currentStartCol - 1, sheetVo.getHeadCells().size());
                    for (int j = 0; j < minCol; ++j) {
                        sheetVo.getHeadCells().set(j, null);
                    }
                }
            }
            ++currentRow;
        }
        this.getView().getPageCache().put("mul_import_sheet_head_copy", SerializationUtils.toJsonString((Object)mulSheetVos));
    }

    private void initTabPageParam() {
        MulImportStepPluginUtil.createSheetChooseCombo(this.getView(), "detailsheetchoose", MulImportStepPluginUtil.getSheetComboItem(this.getView()));
        List<String> numberList = this.getMulBaseDataNumbers();
        this.getModel().beginInit();
        this.getModel().deleteEntryData("treeentryentity");
        this.getModel().endInit();
        ArrayList<MulNodeDetailVo> mulNodeDetailVos = new ArrayList<MulNodeDetailVo>(numberList.size());
        this.autoMappingSheetList = new ArrayList<String>(10);
        for (String number : numberList) {
            this.buildBillTree(number, mulNodeDetailVos);
        }
        this.getView().getPageCache().put("mul_import_mulTreeNodeMapping", SerializationUtils.toJsonString(mulNodeDetailVos));
        this.getView().getPageCache().put("mul_import_set_flag", "1");
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
    }

    private void fillValueByScheme() {
        DynamicObject dynamicObjectScheme = this.getSchemeInfo();
        if (null != dynamicObjectScheme) {
            DynamicObjectCollection savedCollection = dynamicObjectScheme.getDynamicObjectCollection("setentryentity");
            DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity("treeentryentity");
            HashMap<String, Long> schemeNodeMap = new HashMap<String, Long>();
            this.getModel().beginInit();
            String firstImportForm = dynamicObjectScheme.getString("firstimportform");
            if (StringUtils.isNotBlank((CharSequence)firstImportForm)) {
                this.getModel().setValue("firstimportsheetcombo", (Object)firstImportForm);
            }
            for (int i = 0; i < entryEntityCollection.size(); ++i) {
                DynamicObject rowObj = (DynamicObject)entryEntityCollection.get(i);
                for (DynamicObject saveDyn : savedCollection) {
                    if (!StringUtils.equals((CharSequence)rowObj.getString("entitynumber"), (CharSequence)saveDyn.getString("entitynumber")) || !StringUtils.equals((CharSequence)rowObj.getString("mainnumber"), (CharSequence)saveDyn.getString("mainnumber"))) continue;
                    this.setValueForScheme(saveDyn, i);
                    schemeNodeMap.put(String.valueOf(i), saveDyn.getLong("id"));
                }
            }
            this.setImportChoose();
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            this.getView().updateView("firstimportsheetcombo");
            this.setLock();
            this.getView().getPageCache().put("mul_import_scheme_node_map", SerializationUtils.toJsonString(schemeNodeMap));
        }
    }

    private void setImportChoose() {
        String mulNodeDetailVosStr = this.getPageCache().get("mul_import_mulTreeNodeMapping");
        String headImportType = "";
        if (StringUtils.isNotBlank((CharSequence)mulNodeDetailVosStr)) {
            List mulNodeDetailVos = SerializationUtils.fromJsonStringToList((String)mulNodeDetailVosStr, MulNodeDetailVo.class);
            for (MulNodeDetailVo mulNodeDetailVo : mulNodeDetailVos) {
                int nodeType = mulNodeDetailVo.getNodeType();
                int currentRowId = mulNodeDetailVo.getRowId();
                if (nodeType == MulImportResolveTypeEnum.HEAD.getType()) {
                    headImportType = String.valueOf(this.getModel().getValue(FILED_IMPORTTYPECHOOSE, currentRowId));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"0", (CharSequence)headImportType)) continue;
                this.updateImportTypeChooseItemCache(currentRowId, this.getOnlyNewImportTypeChooseItem());
            }
            this.getView().updateView("treeentryentity");
        }
    }

    private void setValueForScheme(DynamicObject saveDyn, int row) {
        this.getModel().setValue("detailsheetchoose", saveDyn.get("detailsheet"), row);
        this.getModel().setValue(FILED_IMPORTTYPECHOOSE, saveDyn.get("importtype"), row);
        this.getModel().setValue("datareplacevalue", saveDyn.get("datareplacenumber"), row);
        String datareplacename = String.valueOf(saveDyn.get("datareplacename"));
        List<Object> allFieldsByRowId = this.getAllFieldsByRowId(row);
        List combos = allFieldsByRowId.stream().map(obj -> (ComboItem)obj).filter(combo -> StringUtils.equals((CharSequence)datareplacename, (CharSequence)combo.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(combos)) {
            this.getModel().setValue("datareplacevalueshow", (Object)datareplacename, row);
        }
        this.getModel().setValue(STARTROW, saveDyn.get(STARTROW), row);
        this.getModel().setValue(STARTCOLUMN, saveDyn.get("startcol"), row);
    }

    private List<String> getMulBaseDataNumbers() {
        ArrayList<String> numberList = new ArrayList<String>(10);
        Object chooseBaseData = this.getModel().getValue("mulbasedatafield");
        if (chooseBaseData instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)chooseBaseData;
            for (DynamicObject object : mulBasedataDynamicObjectCollection) {
                DynamicObject baseData = object.getDynamicObject("fbasedataid");
                BasedataEntityType dataEntityType = (BasedataEntityType)baseData.getDataEntityType();
                String numberProperty = dataEntityType.getNumberProperty();
                Object number = baseData.get(numberProperty);
                numberList.add(String.valueOf(number));
            }
        }
        return numberList;
    }

    private List<Object> getAllFieldsByRowId(int currentRow) {
        List<Object> comboItemList = new ArrayList<Object>();
        MulNodeDetailVo mulNodeDetailVo = this.getCurrentTreeNode(currentRow);
        if (null != mulNodeDetailVo) {
            String comboItemCacheKey = "mul_import_replaceValueForm_" + mulNodeDetailVo.getMainTypeName() + "_" + mulNodeDetailVo.getNodeNumber();
            comboItemList = this.getFieldItem(comboItemCacheKey, mulNodeDetailVo.getMainTypeName(), mulNodeDetailVo.getNodeNumber());
            this.getPageCache().put(comboItemCacheKey, SerializationUtils.toJsonString(comboItemList));
            return comboItemList;
        }
        return comboItemList;
    }

    private MulNodeDetailVo getCurrentTreeNode(int currentRow) {
        List<MulNodeDetailVo> mulNodeDetailVos = MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(this.getView().getPageCache());
        for (MulNodeDetailVo detailVo : mulNodeDetailVos) {
            if (detailVo.getRowId() != currentRow) continue;
            return detailVo;
        }
        return null;
    }

    private List<Object> getFieldItem(String comboItemCacheKey, String mainEntityNumber, String entityNumber) {
        String comboItemCache = this.getPageCache().get(comboItemCacheKey);
        if (StringUtils.isNotBlank((CharSequence)comboItemCache)) {
            return SerializationUtils.fromJsonStringToList((String)comboItemCache, ComboItem.class);
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        Set<String> itemSet = this.getShowFields(entityItems);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        List<Object> fieldItem = new ArrayList<Object>();
        Map entityTypeMap = mainType.getAllEntities();
        for (Map.Entry entityTypeEntry : entityTypeMap.entrySet()) {
            EntityType entityType = (EntityType)entityTypeEntry.getValue();
            if (!entityType.getName().equals(entityNumber)) continue;
            Map allProperties = entityType.getFields();
            fieldItem = this.createFieldChooseItems(itemSet, allProperties);
        }
        return fieldItem;
    }

    private List<Object> createFieldChooseItems(Set<String> itemSet, Map<String, IDataEntityProperty> allProperties) {
        ArrayList<Object> comboItemList = new ArrayList<Object>(allProperties.size());
        for (Map.Entry<String, IDataEntityProperty> entry : allProperties.entrySet()) {
            IDataEntityProperty property = entry.getValue();
            if (!itemSet.contains(property.getName())) continue;
            comboItemList.add(new ComboItem(property.getDisplayName(), property.getName()));
        }
        return comboItemList;
    }

    private List<ComboItem> getOnlyNewImportTypeChooseItem() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u65b0\u7684\u6570\u636e", (String)"BOS_IMPORT_24", (String)"bos-import", (Object[])new Object[0])), "0"));
        return comboItemList;
    }

    private List<ComboItem> getAllImportTypeChooseItem() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u65b0\u7684\u6570\u636e", (String)"BOS_IMPORT_24", (String)"bos-import", (Object[])new Object[0])), "0"));
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u6570\u636e", (String)"BOS_IMPORT_25", (String)"bos-import", (Object[])new Object[0])), "1"));
        comboItemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u7684\u6570\u636e", (String)"BOS_IMPORT_26", (String)"bos-import", (Object[])new Object[0])), "2"));
        return comboItemList;
    }

    private void updateImportTypeChooseItemCache(int rowIndex, List<ComboItem> importTypeCombos) {
        IPageCache pageCache = this.getView().getPageCache();
        String cacheStr = pageCache.get("key");
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            HashMap<Integer, List<ComboItem>> rowImportType = new HashMap<Integer, List<ComboItem>>();
            rowImportType.put(rowIndex, importTypeCombos);
            pageCache.put("key", SerializationUtils.serializeToBase64(rowImportType));
            return;
        }
        Map rowImportType = (Map)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        rowImportType.put(rowIndex, importTypeCombos);
        pageCache.put("key", SerializationUtils.serializeToBase64((Object)rowImportType));
    }

    private List<ComboItem> getImportTypeChooseItemFromCache(int rowIndex) {
        IPageCache pageCache = this.getView().getPageCache();
        String cacheStr = pageCache.get("key");
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            return null;
        }
        Map rowImportType = (Map)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return (List)rowImportType.get(rowIndex);
    }

    private void buildBillTree(String number, List<MulNodeDetailVo> mulNodeDetailVos) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            this.buildFieldTreeRow(mainEntityType, mulNodeDetailVos);
        }
    }

    private void fillPartialFieldsInfo(IDataModel model, String entityName, String entityNumber, int row, String mainNumber) {
        String matchSheetName;
        model.beginInit();
        model.setValue(FILED_IMPORTENTITY, (Object)entityName, row);
        model.setValue("entitynumber", (Object)entityNumber, row);
        model.setValue("mainnumber", (Object)mainNumber, row);
        model.setValue(STARTROW, (Object)1, row);
        model.setValue(STARTCOLUMN, (Object)1, row);
        this.updateImportTypeChooseItemCache(row, this.getAllImportTypeChooseItem());
        if (this.needAutoMatch() && StringUtils.isNotBlank((CharSequence)(matchSheetName = MulImportStepPluginUtil.matchSheetName(this.getView(), entityName))) && !this.autoMappingSheetList.contains(matchSheetName)) {
            this.autoMappingSheetList.add(matchSheetName);
            int value = MulImportStepPluginUtil.getSheetComboIndexByName(this.getView(), matchSheetName);
            model.setValue("detailsheetchoose", (Object)value, row);
        }
        model.endInit();
        this.getView().setEnable(Boolean.FALSE, row, new String[]{FIELD_IMPORTPROP, EXPORTPROPNAME, "datareplacevalueshow"});
    }

    private void buildFieldTreeRow(MainEntityType mainType, List<MulNodeDetailVo> treeMappingInfo) {
        ArrayList<MulNodeDetailVo> oneEntityTree = new ArrayList<MulNodeDetailVo>();
        IDataModel model = this.getModel();
        model.beginInit();
        int currentRow = model.createNewEntryRow("treeentryentity");
        model.endInit();
        oneEntityTree.add(new MulNodeDetailVo(currentRow, mainType.getName(), currentRow, mainType.getDisplayName().toString(), MulImportResolveTypeEnum.HEAD.getType(), mainType.getName()));
        this.fillPartialFieldsInfo(model, mainType.getDisplayName().toString(), mainType.getName(), currentRow, mainType.getName());
        this.buildEntryTreeRowNew(currentRow, model, mainType, oneEntityTree);
        treeMappingInfo.addAll(oneEntityTree);
    }

    private void buildEntryTreeRowNew(int rootRow, IDataModel model, MainEntityType mainType, List<MulNodeDetailVo> treeMappingInfo) {
        int[] row = new int[]{-1};
        Set entryMap = mainType.getAllEntities().entrySet();
        for (Map.Entry<String, EntityType> entry : entryMap) {
            this.entityBuild(rootRow, model, mainType, row, entry, treeMappingInfo);
        }
    }

    private void entityBuild(int rootRow, IDataModel model, MainEntityType mainType, int[] row, Map.Entry<String, EntityType> entry, List<MulNodeDetailVo> treeMappingInfo) {
        EntityType entityType = entry.getValue();
        if (entityType instanceof LinkEntryType || entityType instanceof NameVersionEntryType || entityType instanceof TreeEntryType) {
            return;
        }
        IDataEntityType parentType = entityType.getParent();
        if (null == parentType) {
            return;
        }
        String entityNodeId = entityType.getName();
        String entityNodeName = "";
        if (entityType.getDisplayName() != null) {
            entityNodeName = entityType.getDisplayName().toString();
        }
        int pRow = treeMappingInfo.stream().filter(item -> item.getNodeNumber().equals(parentType.getName())).findFirst().orElseGet(MulNodeDetailVo::new).getRowId();
        model.beginInit();
        row[0] = model.insertEntryRow("treeentryentity", pRow);
        model.endInit();
        boolean isEntry = pRow == rootRow;
        int nodeType = isEntry ? MulImportResolveTypeEnum.ENTRY.getType() : MulImportResolveTypeEnum.SUB_ENTRY.getType();
        treeMappingInfo.add(new MulNodeDetailVo(row[0], entityNodeId, pRow, entityNodeName, nodeType, mainType.getName()));
        this.fillPartialFieldsInfo(model, entityNodeName, entityNodeId, row[0], mainType.getName());
    }

    private String checkData() {
        boolean rowCheck = false;
        ArrayList<FieldPos> cellStyle = new ArrayList<FieldPos>();
        ArrayList<FieldPos> headCellStyle = new ArrayList<FieldPos>();
        ArrayList<FieldPos> parentCellStyle = new ArrayList<FieldPos>();
        ArrayList<String> unFillSheetEntity = new ArrayList<String>();
        StringBuilder parentEntityName = new StringBuilder();
        StringBuilder mulRowTipsBuilder = new StringBuilder();
        DynamicObjectCollection rowObjs = this.getModel().getEntryEntity("treeentryentity");
        int notChooseSheetCount = 0;
        for (int rowIndex = 0; rowIndex < rowObjs.size(); ++rowIndex) {
            String entityName;
            StringBuilder showMsgFileds;
            block14: {
                List<Integer> lowerNodeIds;
                String importType;
                long curPid;
                block13: {
                    showMsgFileds = new StringBuilder();
                    DynamicObject rowObj = (DynamicObject)rowObjs.get(rowIndex);
                    curPid = rowObj.getLong("pid");
                    String sheetName = rowObj.getString("detailsheetchoose");
                    importType = rowObj.getString(FILED_IMPORTTYPECHOOSE);
                    entityName = rowObj.getString(FILED_IMPORTENTITY);
                    if (StringUtils.isNotBlank((CharSequence)importType) && !StringUtils.equals((CharSequence)"0", (CharSequence)importType) && StringUtils.isBlank((CharSequence)rowObj.getString("datareplacevalueshow"))) {
                        cellStyle.add(this.genFieldPos(rowIndex, "datareplacevalueshow"));
                        showMsgFileds.append(ResManager.loadKDString((String)"\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u201d", (String)"MulImportStepPlugin_7", (String)"bos-import", (Object[])new Object[0])).append("\uff1b");
                    }
                    if (!StringUtils.isNotBlank((CharSequence)sheetName)) break block13;
                    if (StringUtils.isBlank((CharSequence)importType)) {
                        cellStyle.add(this.genFieldPos(rowIndex, FILED_IMPORTTYPECHOOSE));
                        showMsgFileds.append(ResManager.loadKDString((String)"\u201c\u5bfc\u5165\u65b9\u5f0f\u201d", (String)"MulImportStepPlugin_6", (String)"bos-import", (Object[])new Object[0])).append("\uff1b");
                    }
                    if (rowObj.getInt(STARTROW) == 0) {
                        cellStyle.add(this.genFieldPos(rowIndex, STARTROW));
                        showMsgFileds.append(ResManager.loadKDString((String)"\u201c\u5bfc\u5165\u6570\u636e\u7684\u8d77\u59cb\u884c\u201d", (String)"MulImportStepPlugin_8", (String)"bos-import", (Object[])new Object[0])).append("\uff1b");
                    }
                    if (rowObj.getInt(STARTCOLUMN) != 0) break block14;
                    cellStyle.add(this.genFieldPos(rowIndex, STARTCOLUMN));
                    showMsgFileds.append(ResManager.loadKDString((String)"\u201c\u5bfc\u5165\u6570\u636e\u7684\u8d77\u59cb\u5217\u201d", (String)"MulImportStepPlugin_9", (String)"bos-import", (Object[])new Object[0])).append("\uff1b");
                    break block14;
                }
                ++notChooseSheetCount;
                if (curPid == 0L) {
                    unFillSheetEntity.add(entityName);
                    headCellStyle.add(this.genFieldPos(rowIndex, "detailsheetchoose"));
                    if (StringUtils.isBlank((CharSequence)importType)) {
                        headCellStyle.add(this.genFieldPos(rowIndex, FILED_IMPORTTYPECHOOSE));
                    }
                }
                if (CollectionUtils.isEmpty(lowerNodeIds = MulImportStepPluginUtil.getLowerNodeIdByCurrentId(rowIndex, this.getView().getPageCache(), true, true))) {
                    lowerNodeIds = MulImportStepPluginUtil.getSubEntryIdByEntryId(rowIndex, this.getView().getPageCache(), true);
                }
                if (CollectionUtils.isNotEmpty(lowerNodeIds)) {
                    for (int lowerNodeId : lowerNodeIds) {
                        DynamicObject subRowObj = (DynamicObject)rowObjs.get(lowerNodeId);
                        if (!StringUtils.isNotBlank((CharSequence)subRowObj.getString("detailsheetchoose"))) continue;
                        FieldPos fieldPos = new FieldPos("treeentryentity", rowIndex, "detailsheetchoose", "", ValidPromtType.NOT_NULL.getType());
                        parentCellStyle.add(fieldPos);
                        parentEntityName.append(entityName).append("\u3001");
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)showMsgFileds)) continue;
            rowCheck = true;
            String oneEntityTips = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%1$s\u201d\u7684%2$s\u3002", (String)"MulImportStepPlugin_5", (String)"bos-import", (Object[])new Object[0]), entityName, showMsgFileds.deleteCharAt(showMsgFileds.length() - 1));
            mulRowTipsBuilder.append(oneEntityTips).append("\r\n");
        }
        if (notChooseSheetCount == rowObjs.size()) {
            this.getView().showFormValidMsg(headCellStyle);
            StringBuilder unFillSheetEntityStr = new StringBuilder();
            for (String entityName : unFillSheetEntity) {
                unFillSheetEntityStr.append("\u201c").append(entityName).append("\u201d").append(ResManager.loadKDString((String)"\u6216", (String)"BOS_IMPORT_10", (String)"bos-import", (Object[])new Object[0]));
            }
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u7684\u201c\u5bf9\u5e94\u7684Excel\u5de5\u4f5c\u8868\u9875\u7b7e\u201d\u548c\u201c\u5bfc\u5165\u65b9\u5f0f\u201d\u3002", (String)"MulImportStepPlugin_23", (String)"bos-import", (Object[])new Object[0]), unFillSheetEntityStr.deleteCharAt(unFillSheetEntityStr.length() - 1));
        }
        if (StringUtils.isNotBlank((CharSequence)parentEntityName)) {
            this.getView().showFormValidMsg(parentCellStyle);
            return String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7684\u201c\u5bf9\u5e94\u7684Excel\u5de5\u4f5c\u8868\u9875\u7b7e\u201d", (String)"MulImportStepPlugin_24", (String)"bos-import", (Object[])new Object[0]), parentEntityName.deleteCharAt(parentEntityName.length() - 1));
        }
        if (rowCheck) {
            this.getView().showFormValidMsg(cellStyle);
            return mulRowTipsBuilder.toString();
        }
        return "";
    }

    private FieldPos genFieldPos(int rowIndex, String fieldKey) {
        return new FieldPos("treeentryentity", rowIndex, fieldKey, "", ValidPromtType.NOT_NULL.getType());
    }

    private void reCacheMulNodeDetail() {
        List<MulNodeDetailVo> mulNodeDetailVos = MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(this.getView().getPageCache());
        if (CollectionUtils.isNotEmpty(mulNodeDetailVos)) {
            DynamicObjectCollection dynCollection = this.getModel().getEntryEntity("treeentryentity");
            ArrayList rePutNodeVos = new ArrayList();
            int id = 0;
            for (DynamicObject dynamicObject : dynCollection) {
                int rowId = id++;
                if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString("detailsheetchoose"))) continue;
                mulNodeDetailVos.stream().filter(detailVo -> detailVo.getRowId() == rowId).findFirst().ifPresent(rePutNodeVos::add);
            }
            this.getView().getPageCache().put("mul_import_mulTreeNodeMapping_reset", SerializationUtils.toJsonString(rePutNodeVos));
        }
    }

    private void initExcelHeadOfAllSheet() {
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity("treeentryentity");
        HashMap<Integer, Integer> sheetInfoMap = new HashMap<Integer, Integer>();
        for (DynamicObject entry : treeEntryEntity) {
            int sheetNo;
            Object sheetNoObj = entry.get("detailsheetchoose");
            if (StringUtils.isBlank((Object)sheetNoObj) || (sheetNo = entry.getInt("detailsheetchoose")) == -1) continue;
            sheetInfoMap.put(sheetNo, entry.getInt(STARTROW));
        }
        String path = this.getView().getPageCache().get("mul_import_file_path");
        String sheetNameCache = this.getView().getPageCache().get("mul_import_sheet_name");
        List sheetNames = SerializationUtils.fromJsonStringToList((String)sheetNameCache, String.class);
        this.buildContext(path);
        Map<Integer, Map<Integer, String>> sheetHeadInfo = this.convertService.getBatchSheetHead(sheetInfoMap);
        ArrayList<MulSheetVo> mulSheetVos = new ArrayList<MulSheetVo>(treeEntryEntity.size());
        for (int i = 0; i < treeEntryEntity.size(); ++i) {
            int sheetNo = ((DynamicObject)treeEntryEntity.get(i)).getInt("detailsheetchoose");
            ArrayList<String> cells = new ArrayList();
            if (null != sheetHeadInfo.get(sheetNo)) {
                cells = new ArrayList<String>(sheetHeadInfo.get(sheetNo).values());
            }
            mulSheetVos.add(new MulSheetVo(sheetNo, i, (String)sheetNames.get(sheetNo), cells));
        }
        this.getView().getPageCache().put("mul_import_sheet_head", SerializationUtils.toJsonString(mulSheetVos));
    }

    private void setFirstImportEntityCombo() {
        List<MulNodeDetailVo> mulNodeDetailVos = MulImportStepPluginUtil.getAllTreeNodeVoFromPageCache(this.getView().getPageCache());
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(mulNodeDetailVos.size());
        for (MulNodeDetailVo mulNodeDetailVo : mulNodeDetailVos) {
            if (mulNodeDetailVo.getNodeType() != MulImportResolveTypeEnum.HEAD.getType()) continue;
            itemList.add(new ComboItem(new LocaleString(mulNodeDetailVo.getNodeName()), mulNodeDetailVo.getNodeNumber()));
        }
        MulImportStepPluginUtil.createSheetChooseCombo(this.getView(), "firstimportsheetcombo", itemList);
    }

    private boolean checkSheetHasChoose(String chooseValue, int currentSheet) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("treeentryentity");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            String sheet;
            if (i == currentSheet || !StringUtils.isNotBlank((CharSequence)(sheet = ((DynamicObject)dynamicObjects.get(i)).getString("detailsheetchoose"))) || !sheet.equals(chooseValue)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getShowFields(List<EntityItem<?>> entityItems) {
        HashSet<String> itemSet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(entityItems)) {
            return itemSet;
        }
        entityItems.forEach(item -> {
            Field f;
            boolean valid = item instanceof Field;
            if (!(!valid || (!StringUtils.isNotBlank((CharSequence)(f = (Field)item).getFieldName()) || !f.getFeatures().isImportable() || f instanceof CheckBoxField || f instanceof DateTimeField || f instanceof RadioField || f instanceof ModifierField || f instanceof CreaterField || f instanceof PictureField || f instanceof UserAvatarField || f instanceof IconField || f instanceof AttachmentCountField || f instanceof AttachmentField || f instanceof PrintCountField || f instanceof FlexField || f instanceof RefBillField || f instanceof SignatureField || f instanceof RichTextField || f instanceof GeoPointField || f instanceof ComboField || f instanceof QtyField || f instanceof AddressField || f instanceof ItemClassField || f instanceof StepperField || f instanceof GroupField || f instanceof PeriodField || f instanceof BillTypeField || f instanceof UnitField || f instanceof MobBasedataField || f instanceof AssistantField || f instanceof CityField || f instanceof NameField || f instanceof CurrencyField || f instanceof AdminDivisionField || f instanceof AmountField || f instanceof DateRangeField || f instanceof TimeRangeField) && !f.getClass().getName().equals("kd.bos.newdevportal.domaindefine.sample.Field.Mybasedatafield") && !f.getClass().getName().equals("kd.bos.ext.fi.metadata.field.AccountField") && !StringUtils.equals((CharSequence)f.getClass().getName(), (CharSequence)"kd.bos.ext.metadata.entity.businessfield.NameSegBasedataField") && !StringUtils.equals((CharSequence)f.getClass().getName(), (CharSequence)"kd.bos.ext.bd.metadata.field.SupplierField") && !StringUtils.equals((CharSequence)f.getClass().getName(), (CharSequence)"kd.bos.ext.bd.metadata.field.ProdcutLineField") && !StringUtils.equals((CharSequence)f.getClass().getName(), (CharSequence)"kd.bos.ext.bd.metadata.field.CustomerField") && !StringUtils.equals((CharSequence)f.getClass().getName(), (CharSequence)"kd.bos.ext.bd.metadata.field.CostCenterField"))) {
                itemSet.add(item.getKey());
            }
        });
        return itemSet;
    }
}

