/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.stepplugin.util.proxy;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.mulimport.stepplugin.util.IStringSimilarity;
import kd.bos.mulimport.stepplugin.util.impl.JaccardStringSimilarity;
import kd.bos.mulimport.stepplugin.util.proxy.StrSimilarityResult;
import kd.bos.util.CollectionUtils;

public class StrSimilarityProxy {
    private static final String SIMILARITY = JaccardStringSimilarity.class.getName();
    private static final double THRESHOLD = 0.75;

    public static StrSimilarityResult getSimilaritiesWord(String first, List<String> wordList, Set<Integer> hasMatched) {
        return StrSimilarityProxy.getSimilaritiesWord(first, wordList, hasMatched, 0.75);
    }

    public static StrSimilarityResult getSimilaritiesWord(String fieldName, List<String> wordList, Set<Integer> hasMatched, double scoreHold) {
        if (StringUtils.isEmpty((CharSequence)fieldName) || CollectionUtils.isEmpty(wordList)) {
            return null;
        }
        int resultIndex = -1;
        double score = 0.0;
        IStringSimilarity iStringSimilarity = StrSimilarityProxy.innerFindSimilarityAlgorithm(SIMILARITY);
        for (int index = 0; index < wordList.size(); ++index) {
            double curScore;
            String word = wordList.get(index);
            if (StringUtils.isEmpty((CharSequence)word) || !((curScore = iStringSimilarity.calcStrSimilarity(fieldName, word)) >= scoreHold) || !(curScore > score) || hasMatched.contains(index)) continue;
            score = curScore;
            resultIndex = index;
        }
        if (resultIndex == -1) {
            return null;
        }
        return new StrSimilarityResult(resultIndex, score);
    }

    private static IStringSimilarity innerFindSimilarityAlgorithm(String algorithm) {
        if (JaccardStringSimilarity.class.getName().equals(algorithm)) {
            return JaccardStringSimilarity.INSTANCE;
        }
        throw new UnsupportedOperationException("Unknown SimilarityAlgorithm\uff1a" + algorithm);
    }
}

