/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.export;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.util.ExcelHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ImportDataReader {
    private final String name;
    private int col = -1;
    private final List<ImportDataReader> next = new ArrayList<ImportDataReader>();
    private final EntityType entityType;
    private final Map<String, Object> adminDivision = new HashMap<String, Object>();

    public ImportDataReader(EntityType entityType, String name) {
        this.name = name;
        this.entityType = entityType;
    }

    public int endRow(XSSFSheet sheet, int rowStart, int rowEnd) {
        XSSFRow row;
        XSSFRow nameRow = sheet.getRow(2);
        if (this.isRowEmpty(sheet, (Row)nameRow, (Row)(row = sheet.getRow(rowStart)))) {
            return rowStart + 1;
        }
        for (int i = rowStart + 1; i <= rowEnd; ++i) {
            row = sheet.getRow(i);
            if (this.isRowEmpty(sheet, (Row)nameRow, (Row)row)) continue;
            return i;
        }
        return sheet.getLastRowNum() + 1;
    }

    private boolean isRowEmpty(XSSFSheet sheet, Row nameRow, Row row) {
        int j;
        if (row == null) {
            return true;
        }
        boolean isEmpty = true;
        int last = this.getLastCellNum(sheet, j + 1, nameRow.getLastCellNum());
        for (j = this.col; j < last; ++j) {
            if (!StringUtils.isNotBlank((Object)this.getValue(row, j, true))) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public static ImportDataReader parse(MainEntityType mainEntityType) {
        HashMap importTree = new HashMap(16);
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            importTree.put(entry.getKey(), new ImportDataReader((EntityType)entry.getValue(), (String)entry.getKey()));
        }
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            ImportDataReader wr;
            IDataEntityType parentType = ((EntityType)entry.getValue()).getParent();
            if (parentType == null || (wr = (ImportDataReader)importTree.get(parentType.getName())) == null) continue;
            wr.next.add((ImportDataReader)importTree.get(entry.getKey()));
        }
        return (ImportDataReader)importTree.get(mainEntityType.getName());
    }

    public void init(XSSFSheet sheet, boolean isFirst) {
        int i = sheet.getLastRowNum();
        while (i > 0) {
            XSSFRow tempRow = sheet.getRow(--i);
            boolean isEmptyRow = true;
            if (tempRow != null) {
                for (int j = tempRow.getFirstCellNum(); j < tempRow.getLastCellNum(); ++j) {
                    if (!StringUtils.isNotBlank((Object)this.getValue((Row)tempRow, j, true))) continue;
                    isEmptyRow = false;
                    break;
                }
            }
            if (!isEmptyRow) continue;
            sheet.shiftRows(i + 1, sheet.getLastRowNum(), -1);
        }
        XSSFRow entityRow = sheet.getRow(0);
        for (i = (int)entityRow.getFirstCellNum(); i < entityRow.getLastCellNum(); ++i) {
            String entityName;
            Cell cell = entityRow.getCell(i);
            String string = entityName = cell != null ? cell.getStringCellValue() : null;
            if (StringUtils.isNotBlank((CharSequence)entityName) && this.name != null && this.name.equalsIgnoreCase(entityName.split(" # ")[1])) {
                this.col = i;
                break;
            }
            if (!isFirst) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataReader_0", (String)"bos-import", (Object[])new Object[0]));
        }
        this.next.forEach(r -> r.init(sheet, false));
    }

    public int read(XSSFSheet sheet, int rowStart, int rowEnd, JSONObject parent) {
        String tempName;
        int i;
        boolean valid = true;
        XSSFRow entityRow = sheet.getRow(0);
        if (!this.next.isEmpty()) {
            for (ImportDataReader r : this.next) {
                if (r.col < 0) continue;
                JSONArray arr = new JSONArray();
                int i2 = rowStart;
                while (i2 < rowEnd) {
                    JSONObject subRow = new JSONObject();
                    int endNext = r.endRow(sheet, i2, rowEnd);
                    int offset = r.read(sheet, i2, endNext, subRow);
                    boolean bl = valid = valid && (offset > 0 || offset == 0 && !((String)this.getValue((Row)entityRow, r.col, true)).startsWith("*"));
                    if (offset == 0) break;
                    arr.add((Object)subRow);
                    i2 = endNext;
                }
                if (arr.isEmpty()) continue;
                parent.put(r.name, (Object)arr);
            }
        }
        XSSFRow nameRow = sheet.getRow(2);
        int rowColCount = 0;
        XSSFRow row = sheet.getRow(rowStart);
        HashSet<String> flexColumn = new HashSet<String>();
        int last = this.getLastCellNum(sheet, i + 1, nameRow.getLastCellNum());
        for (i = this.col; i < last && row != null && !StringUtils.isBlank((CharSequence)(tempName = (String)this.getValue((Row)nameRow, i, false))); ++i) {
            if (flexColumn.contains(tempName.split(" # ")[1].split("\\.")[0])) continue;
            Object value = this.getValue(nameRow, (Row)row, i, last, flexColumn);
            if (StringUtils.isBlank((Object)value)) {
                if (!valid || !tempName.startsWith("*")) continue;
                valid = false;
                continue;
            }
            parent.put(tempName.split(" # ")[1].split("\\.")[0], value);
            ++rowColCount;
        }
        return !valid && rowColCount > 0 ? -rowColCount : rowColCount;
    }

    private int getLastCellNum(XSSFSheet sheet, int col, int last) {
        while (col < last) {
            if (StringUtils.isNotBlank((Object)this.getValue((Row)sheet.getRow(0), col, true))) {
                return col;
            }
            ++col;
        }
        return last;
    }

    private Object getValue(Row row, int column, boolean trim) {
        return this.getValue(row, column, null, trim);
    }

    private Object getValue(Row row, int column, DynamicProperty prop, boolean trim) {
        XSSFCell cell = (XSSFCell)row.getCell(column);
        if (cell == null) {
            return null;
        }
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object cellValue = null;
        if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.STRING)) {
            String val = cell.getStringCellValue();
            if (val != null && trim) {
                val = val.trim();
            }
            cellValue = prop instanceof BooleanProp ? Boolean.valueOf(ResManager.loadKDString((String)"\u662f", (String)"ImportDataReader_1", (String)"bos-form-mvc", (Object[])new Object[0]).equals(val) || !ResManager.loadKDString((String)"\u5426", (String)"ImportDataReader_2", (String)"bos-form-mvc", (Object[])new Object[0]).equals(val) && Boolean.parseBoolean(val)) : (prop instanceof ComboProp && val != null && val.indexOf(" # ") != -1 ? val.split(" # ", -1)[1] : val);
        } else if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.NUMERIC)) {
            cellValue = cell.getNumericCellValue();
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                Date dt = DateUtil.getJavaDate((double)((Double)cellValue));
                cellValue = sFormat.format(dt);
            } else if (prop instanceof DateProp || prop instanceof DateTimeProp) {
                cell.setCellType(CellType.NUMERIC);
                Date dt = DateUtil.getJavaDate((double)((Double)cellValue));
                cellValue = sFormat.format(dt);
            } else if (!(prop instanceof DecimalProp)) {
                cellValue = this.trimZero(NumberToTextConverter.toText((double)((Double)cellValue)));
            }
        } else if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.BLANK)) {
            cellValue = "";
        } else if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.BOOLEAN)) {
            cellValue = cell.getBooleanCellValue();
        } else if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.ERROR)) {
            cellValue = "";
        } else if (ExcelHelper.cellEqual((CellType)cell.getCellType(), (CellType)CellType.FORMULA)) {
            cellValue = cell.getCellFormula();
        }
        return cellValue;
    }

    private String trimZero(String valStr) {
        if (StringUtils.isNotBlank((CharSequence)valStr)) {
            StringBuilder sb = new StringBuilder(valStr);
            int i = sb.indexOf(".");
            if (i >= 0) {
                for (int j = sb.length() - 1; j > i; --j) {
                    if (sb.charAt(j) == '0') continue;
                    sb.setLength(j + 1);
                    return sb.toString();
                }
                valStr = sb.substring(0, i);
            }
        }
        return valStr;
    }

    private Object getValue(XSSFRow nameRow, Row row, int column, int lastColumn, Set<String> flexColumn) {
        Object cellValue = null;
        String fullName = (String)this.getValue((Row)nameRow, column, false);
        if (StringUtils.isNotBlank((CharSequence)fullName) && fullName.contains(" # ")) {
            String propertyName = fullName.split(" # ")[1];
            String[] propertyNameSplit = propertyName.split("\\.");
            DynamicProperty prop = this.entityType.getProperty(propertyNameSplit[0]);
            if (prop instanceof FlexProp && !flexColumn.contains(propertyNameSplit[0])) {
                cellValue = this.getFlexValue(nameRow, row, column, lastColumn, flexColumn, prop, propertyNameSplit);
            } else {
                cellValue = this.getValue(row, column, prop, true);
                if (StringUtils.isNotBlank((Object)cellValue)) {
                    if (prop instanceof AdminDivisionProp) {
                        cellValue = this.getAdminDivisionValue(cellValue.toString());
                    } else {
                        List items;
                        if (prop instanceof BasedataProp) {
                            JSONObject jsonData = new JSONObject();
                            jsonData.put(propertyNameSplit.length > 1 && "name".equalsIgnoreCase(propertyNameSplit[1]) ? "name" : "number", cellValue);
                            return jsonData;
                        }
                        if (prop instanceof ComboProp && (items = ((ComboProp)prop).getComboItems()) != null && !items.isEmpty()) {
                            List<String> cellValueSplit = Arrays.asList(cellValue.toString().split(","));
                            ArrayList<String> values = new ArrayList<String>();
                            for (ValueMapItem item : items) {
                                if (!(prop instanceof MulComboProp ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(cellValue))) continue;
                                values.add(item.getValue());
                            }
                            cellValue = String.join((CharSequence)",", values);
                        }
                    }
                }
            }
        }
        return cellValue;
    }

    private Object getFlexValue(XSSFRow nameRow, Row row, int column, int lastColumn, Set<String> flexColumn, DynamicProperty prop, String[] propertyNameSplit) {
        String tempName;
        flexColumn.add(propertyNameSplit[0]);
        HashMap<String, String[]> flexVal = new HashMap<String, String[]>();
        for (int i = column; i < lastColumn && !StringUtils.isBlank((CharSequence)(tempName = (String)this.getValue((Row)nameRow, i, false))); ++i) {
            String[] tempPropertyNameSplit = tempName.split(" # ")[1].split("\\.");
            if (!propertyNameSplit[0].equals(tempPropertyNameSplit[0])) continue;
            String propertyCaption = tempName.split(" # ")[0];
            Object v = this.getValue(row, i, true);
            if (!StringUtils.isNotBlank((Object)v)) continue;
            flexVal.put(propertyCaption.split("\\.")[1], new String[]{tempPropertyNameSplit[1], v.toString()});
        }
        if (flexVal.isEmpty()) {
            return null;
        }
        return flexVal;
    }

    private Object getAdminDivisionValue(String cellValue) {
        if (this.adminDivision.containsKey(cellValue)) {
            return this.adminDivision.get(cellValue);
        }
        Object adminId = ORMUtil.getAdminDivisionByName((String)cellValue.replace('/', '_'));
        if (StringUtils.isNotBlank((Object)adminId)) {
            this.adminDivision.put(cellValue, adminId);
            return adminId;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u201c%s\u201d\u4e0d\u5b58\u5728", (String)"ImportEntityDataReader_3", (String)"bos-import", (Object[])new Object[0]), cellValue));
    }
}

