/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.impt.ApiServiceLocalCache;

public class ImportCreateViewUtil {
    public static FormShowParameter createShowParameter(String formId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        return parameter;
    }

    public static DynamicObject getBlankDataEntity(IDataModel model, DynamicObject blankDataEntity, boolean isDeleteEntry) {
        if (blankDataEntity == null) {
            blankDataEntity = ApiServiceLocalCache.getBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId());
        }
        if (blankDataEntity != null && !StringUtils.equals((CharSequence)blankDataEntity.getDataEntityType().getVersion(), (CharSequence)model.getDataEntityType().getVersion())) {
            blankDataEntity = null;
        }
        if (blankDataEntity == null) {
            model.beginInit();
            model.createNewData();
            model.endInit();
            blankDataEntity = model.getDataEntity();
            List<String> entryNames = ImportCreateViewUtil.getEntryNames(model);
            if (isDeleteEntry) {
                for (String entryName : entryNames) {
                    model.deleteEntryData(entryName);
                }
            }
            ApiServiceLocalCache.putBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId(), blankDataEntity);
        } else {
            IDataEntityType dt = blankDataEntity.getDataEntityType();
            for (IDataEntityProperty property : dt.getProperties()) {
                if (!(property instanceof CreateDateProp)) continue;
                property.setValue((Object)blankDataEntity, (Object)new Date());
                break;
            }
        }
        return (DynamicObject)OrmUtils.clone((IDataEntityBase)blankDataEntity, (boolean)false, (boolean)true);
    }

    public static List<String> getEntryNames(IDataModel model) {
        Map allEntities = model.getDataEntityType().getAllEntities();
        List<String> entryNames = allEntities.values().stream().filter(entityType -> entityType instanceof EntryType && !(entityType instanceof SubEntryType) && !(entityType instanceof LinkEntryType)).map(DynamicObjectType::getName).collect(Collectors.toList());
        return entryNames;
    }
}

