/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.kit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.designer.earlywarn.kit.CollectionKit;

public class StringKit {
    private static final String COMMA = ",";

    public static String toSafeString(Object value) {
        return null == value ? "" : value.toString();
    }

    public static boolean isNotBlank(String str) {
        return !StringKit.isBlank(str);
    }

    public static boolean isBlank(String str) {
        return null == str || str.trim().equals("");
    }

    public static String formatDate(Date date, String pattern) {
        if (null == date || StringKit.isBlank(pattern)) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Date strToDate(String date, String pattern) {
        if (StringKit.isBlank(date) || StringKit.isBlank(pattern)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String join(Object[] arr) {
        return StringKit.join(arr, COMMA);
    }

    public static String join(Object[] arr, String delimiter) {
        if (CollectionKit.isEmpty(arr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : arr) {
            if (o == null) continue;
            sb.append(o.toString()).append(delimiter);
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    public static String join(Collection<?> list) {
        return StringKit.join(list, COMMA);
    }

    public static String join(Collection<?> list, String delimiter) {
        if (CollectionKit.isEmpty(list)) {
            return "";
        }
        return StringKit.join(list.toArray(), delimiter);
    }

    public static String concat(Collection<?> list, String delimiter) {
        if (CollectionKit.isEmpty(list)) {
            return "";
        }
        return StringKit.concat(list.toArray(), delimiter);
    }

    public static String concat(Object[] arr, String delimiter) {
        if (CollectionKit.isEmpty(arr)) {
            return "";
        }
        String tDelimiter = StringKit.toSafeString(delimiter);
        StringBuilder sb = new StringBuilder();
        for (Object o : arr) {
            sb.append(o.toString()).append(tDelimiter);
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - tDelimiter.length());
    }

    public static String secondToTime(int sec) {
        int hour = sec / 3600;
        int minute = (sec - hour * 3600) / 60;
        int second = sec - hour * 3600 - minute * 60;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public static boolean equals(String s1, String s2) {
        if (null != s1) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static List<String> split(String str) {
        if (StringKit.isBlank(str)) {
            return Collections.EMPTY_LIST;
        }
        String[] arr = str.split(COMMA);
        if (null == arr || arr.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.stream(arr).collect(Collectors.toList());
    }
}

