/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.JobKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermission;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermissionEnum;
import kd.bos.designer.earlywarn.schedule.FormulaConditionPlugin;
import kd.bos.designer.earlywarn.schedule.WSMessageEditPlugin;
import kd.bos.designer.earlywarn.schedule.WarnSchedulePeriodDialogPlugin;
import kd.bos.designer.earlywarn.schedule.WarnSchemeReceiverPlugin;
import kd.bos.designer.earlywarn.schedule.bo.WSPeriodBo;
import kd.bos.designer.earlywarn.schedule.widget.WSEditConditionViewHolder;
import kd.bos.designer.earlywarn.schedule.widget.WSEditDetailViewHolder;
import kd.bos.designer.earlywarn.schedule.widget.WSEditMessageViewHolder;
import kd.bos.designer.earlywarn.schedule.widget.WSPeriodDialogViewHolder;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.designer.earlywarn.utils.ParamsUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.WarnCondition;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageSendType;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleTemplate;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.EarlyWarnServiceResult;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.WarnScheduleMetaServiceHelper;

public class WarnScheduleEditPlugin
extends FormulaConditionPlugin
implements BeforeF7SelectListener {
    private static final String FORM_NUMBER = "bos_warnschedule_detail";
    private static final String PARAM_BIZ_APP_ID = "bizAppId";
    private static final String PARAM_WARN_SCHEDULE_ID = "warnScheduleId";
    private static final String PARAM_COPY = "copy";
    private static final String TOOL_BAR = "toolbarap";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_SAVE_AND_NEW = "btn_save_and_new";
    private static final String BTN_SAVE_AND_COPY = "btn_save_and_copy";
    private static final String BTN_SYNC = "btn_sync";
    private static final String BTN_EXECUTE = "btn_run";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String WARN_SCHEDULE_EDIT_PLUGIN_0 = "WarnScheduleEditPlugin_0";
    private static final String EARLY_WARN_SERVICE = "EarlyWarnService";
    private static final String WARN_SCHEDULE_EDIT_PLUGIN_8 = "WarnScheduleEditPlugin_8";
    private static final String APPID = "cts";
    private static final String ENTITY_NAME = "bos_warnschedule";
    private static final String DATE_RANGE = "date_range";
    private static final String FROM_START_DATE = "from_start_date";
    private static final String MONITOR_START_TIME = "monitor_start_time";
    private static final String MONITOR_TIME_RANGE = "monitor_time_range";
    private static final String START_DATE = "start_date";
    private static final String END_DATE = "end_date";
    private static final String RANGE_TYPE = "range_type";
    private static final String PERIOD_REPEAT = "period_repeat";
    private static final String PERIOD_TYPE = "period_type";
    private static final String PERIOD_CRON = "period_cron";
    private static final String LANG_COMBO = "langcombo";
    public static final String MULTILINGUAL_CONFIG = "mulilangConfig";
    private Map<String, Map<String, String>> mulilangConfigMap = new HashMap<String, Map<String, String>>(16);
    private static final String LANG_TYPE = "langType";
    private static final String TITLE = "title";
    private static final String SINGLE_CONTENT = "singleContent";
    private static final String MERGE_CONTENT = "mergeContent";
    private WSEditDetailViewHolder detailViewHolder;
    private WSEditConditionViewHolder conditionViewHolder;
    private WSEditMessageViewHolder messageViewHolder;
    private WSPeriodDialogViewHolder periodViewHolder;
    private FilterCondition filterCondition;

    @Override
    public void initialize() {
        super.initialize();
        this.detailViewHolder = new WSEditDetailViewHolder(this.getView(), this.getModel(), this.getPageCache());
        this.conditionViewHolder = new WSEditConditionViewHolder(this.getView(), this.getPageCache());
        this.messageViewHolder = new WSEditMessageViewHolder(this.getView(), this.getModel(), this.getPageCache());
        this.periodViewHolder = new WSPeriodDialogViewHolder(this.getView(), this.getModel());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"monitor_period", "msg_receiver", "msg_title", "msg_single_content", "msg_merge_content"});
        BasedataEdit bdEarlyWarn = (BasedataEdit)this.getView().getControl("early_warn");
        if (bdEarlyWarn != null) {
            bdEarlyWarn.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{TOOL_BAR});
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "btn_save": {
                this.doSaveOption();
                break;
            }
            case "btn_save_and_new": {
                this.doSaveAndNewOption();
                break;
            }
            case "btn_save_and_copy": {
                this.doSaveAndCopyOption();
                break;
            }
            case "btn_run": {
                this.doExecute();
                break;
            }
            case "btn_sync": {
                this.doSync();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object bizapp = this.getModel().getValue("biz_app");
        if (bizapp != null) {
            String appid = (String)((DynamicObject)bizapp).get("id");
            if ("early_warn".equals(e.getProperty().getName())) {
                ListShowParameter paramter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = paramter.getListFilterParameter();
                List qfilters = filterParam.getQFilters();
                QFilter qfilter = new QFilter("biz_app_id", "=", (Object)appid);
                if (!qfilters.isEmpty()) {
                    ((QFilter)qfilters.get(0)).and(qfilter);
                } else {
                    qfilters.add(qfilter);
                }
                paramter.setCustomParam("pagetype", (Object)"extend");
                paramter.setCustomParam("refappid", (Object)appid);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getPageCache().get("close") == null) {
            if (this.getModel().getDataChanged()) {
                e.setCancel(true);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"WarnScheduleEditPlugin_15", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"WarnScheduleEditPlugin_16", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"WarnScheduleEditPlugin_17", (String)BOS_EARLYWARN, (Object[])new Object[0]);
                this.getView().showConfirm(msg, String.valueOf(this.getModel().getChangeDesc()), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener("continue_close", (IFormPlugin)this), btnNameMaps);
            } else if (this.getView().getParentView() != null) {
                this.getView().getParentView().getPageCache().remove((String)this.getView().getFormShowParameter().getCustomParam(PARAM_WARN_SCHEDULE_ID));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("continue_close".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("close", "");
            this.getView().getParentView().getPageCache().remove((String)this.getView().getFormShowParameter().getCustomParam(PARAM_WARN_SCHEDULE_ID));
            this.getView().close();
        }
    }

    private void doExecute() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.MANUAL, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"WarnScheduleEditPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (!this.doSave()) {
            return;
        }
        String warnScheduleId = this.detailViewHolder.getId();
        String bizAppId = this.detailViewHolder.getBizAppId();
        WarnScheduleMetadata warnSchedule = this.getWarnSchedule(bizAppId, warnScheduleId, false);
        EngineLog log = EngineLog.getInstance(warnScheduleId, WarnScheduleOperationType.Manual);
        log.logNow(EngineLog.toMultiLangJson("WarnScheduleEditPlugin_1", BOS_EARLYWARN), EngineLog.toMultiLangJson("WarnScheduleEditPlugin_2", BOS_EARLYWARN));
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)warnSchedule.getBizappId());
        EarlyWarnServiceResult result = (EarlyWarnServiceResult)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)EARLY_WARN_SERVICE, (String)"execute", (Object[])new Object[]{warnScheduleId, WarnScheduleOperationType.Manual.toString(), log.getEarlyWarnLogId()});
        log.logNow(EngineLog.toMultiLangJson("WarnScheduleEditPlugin_1", BOS_EARLYWARN), EngineLog.toMultiLangJson("WarnScheduleEditPlugin_3", BOS_EARLYWARN));
        EarlyWarnServiceResult.Status status = result.getStatus();
        if (EarlyWarnServiceResult.Status.SUCCESS == status) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u6210\u529f\u3002", (String)"WarnScheduleEditPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            log.end(WarnScheduleStatus.Success);
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u624b\u52a8\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"WarnScheduleEditPlugin_5", (String)BOS_EARLYWARN, (Object[])new Object[0]), result.getMessage());
            this.getView().showErrorNotification(msg);
            log.end(WarnScheduleStatus.Failure);
        }
    }

    private void doSync() {
        if (!this.doSave()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u81f3\u8c03\u5ea6\u4e2d\u5fc3\u5931\u8d25\u3002", (String)"WarnScheduleEditPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u540c\u6b65\u81f3\u8c03\u5ea6\u4e2d\u5fc3\u3002", (String)"WarnScheduleEditPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
    }

    private void doSaveAndCopyOption() {
        if (!this.doSave()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)WARN_SCHEDULE_EDIT_PLUGIN_0, (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)WARN_SCHEDULE_EDIT_PLUGIN_8, (String)BOS_EARLYWARN, (Object[])new Object[0]));
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.COPY, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u590d\u5236", (String)"WarnScheduleEditPlugin_20", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String warnScheduleId = this.detailViewHolder.getId();
        String bizAppId = this.detailViewHolder.getBizAppId();
        WarnScheduleMetadata warnSchedule = this.getWarnSchedule(bizAppId, warnScheduleId, true);
        this.detailViewHolder.init(warnSchedule);
        this.conditionViewHolder.init(warnSchedule, new CloseCallBack((IFormPlugin)this, "container_custom_form"));
        this.conditionViewHolder.initFilterGridData(new FilterCondition());
        this.messageViewHolder.init(warnSchedule);
    }

    private void doSaveAndNewOption() {
        if (!this.doSave()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)WARN_SCHEDULE_EDIT_PLUGIN_0, (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)WARN_SCHEDULE_EDIT_PLUGIN_8, (String)BOS_EARLYWARN, (Object[])new Object[0]));
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.NEW, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e", (String)"WarnScheduleEditPlugin_21", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        WarnScheduleMetadata warnSchedule = WarnScheduleTemplate.createBlankMeta();
        this.detailViewHolder.init(warnSchedule);
        this.conditionViewHolder.init(warnSchedule, new CloseCallBack((IFormPlugin)this, "container_custom_form"));
        this.conditionViewHolder.initFilterGridData(new FilterCondition());
        this.messageViewHolder.init(warnSchedule);
    }

    private void doSaveOption() {
        if (!this.doSave()) {
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)WARN_SCHEDULE_EDIT_PLUGIN_8, (String)BOS_EARLYWARN, (Object[])new Object[0]));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        String warnScheduleId = (String)formShowParam.getCustomParam(PARAM_WARN_SCHEDULE_ID);
        String bizAppId = (String)formShowParam.getCustomParam(PARAM_BIZ_APP_ID);
        Boolean copyFlag = (Boolean)formShowParam.getCustomParam(PARAM_COPY);
        copyFlag = copyFlag == null ? false : copyFlag;
        WarnScheduleMetadata warnSchedule = this.getWarnSchedule(bizAppId, warnScheduleId, copyFlag);
        this.loadMulilangConfigByMeta(warnSchedule);
        WarnCondition condition = warnSchedule.getWarnSchedule().getWarnCondition();
        this.filterCondition = condition.getFilterCondition();
        this.detailViewHolder.init(warnSchedule);
        this.conditionViewHolder.init(warnSchedule, new CloseCallBack((IFormPlugin)this, "container_custom_form"));
        this.messageViewHolder.init(warnSchedule);
        this.periodViewHolder.init(warnSchedule);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.conditionViewHolder.initFilterGridData(this.filterCondition);
    }

    private WarnScheduleMetadata getWarnSchedule(String bizAppId, String warnScheduleId, boolean copyFlag) {
        WarnScheduleMetadata warnSchedule = WarnScheduleTemplate.createBlankMeta();
        warnSchedule.getWarnSchedule().setBizAppId(bizAppId);
        if (StringKit.isNotBlank(warnScheduleId) && WarnScheduleReader.idExists(warnScheduleId)) {
            String earlyWarnId;
            warnSchedule = WarnScheduleMetaServiceHelper.loadMetaById(warnScheduleId, false);
            if (copyFlag) {
                String newId = StringKit.toSafeString(DBServiceHelper.genGlobalLongId());
                warnSchedule.setId(newId);
                warnSchedule.setNumber(warnSchedule.getNumber() + "_copy");
                LocaleString name = warnSchedule.getName();
                name.setLocaleValue(String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"WarnScheduleEditPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0]), name.getLocaleValue()));
                warnSchedule.setName(name);
            }
            if (!EarlyWarnReader.idExists(earlyWarnId = warnSchedule.getWarnSchedule().getEarlyWarnId())) {
                String msg = !copyFlag ? ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728\uff0c\u8be5\u65b9\u6848\u5df2\u5931\u6548\u3002", (String)"WarnScheduleEditPlugin_10", (String)BOS_EARLYWARN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u590d\u5236\u76d1\u63a7\u65b9\u6848\u5f15\u7528\u4e1a\u52a1\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WarnScheduleEditPlugin_11", (String)BOS_EARLYWARN, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
        return warnSchedule;
    }

    @Override
    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "monitor_period": {
                this.showPeriodDialog();
                break;
            }
            case "msg_receiver": {
                this.showMsgReceiverDialog();
                break;
            }
            case "msg_title": {
                this.showMsgTitleDialog();
                break;
            }
            case "msg_single_content": {
                this.showSingleMsgDialog();
                break;
            }
            case "msg_merge_content": {
                this.showMergeMsgDialog();
                break;
            }
        }
    }

    private void showMsgReceiverDialog() {
        String dataSource = this.detailViewHolder.getDataSource();
        List<WarnMessageReceiverType> selectedItems = this.messageViewHolder.getSelectedReceiverTypes();
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "msg_receiver");
        FormShowParameter param = WarnSchemeReceiverPlugin.getFormShowParameter(dataSource, selectedItems, callback);
        this.getView().showForm(param);
    }

    private void showMergeMsgDialog() {
        TreeNode treeRoot;
        String message = this.messageViewHolder.getMergeContent();
        String earlyWarnId = this.detailViewHolder.getEarlyWarn();
        String dataSourceNumber = this.detailViewHolder.getDataSource();
        if (StringKit.isBlank(earlyWarnId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u65b9\u6848\u5bf9\u5e94\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"WarnScheduleEditPlugin_13", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = this.detailViewHolder.getBizAppId();
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)EARLY_WARN_SERVICE, (String)"getMergeMessageFieldTree", (Object[])new Object[]{earlyWarnId, dataSourceNumber});
        TreeNode treeNode = treeRoot = StringKit.isBlank(result) ? null : (TreeNode)SerializationUtils.fromJsonString((String)result, TreeNode.class);
        if (null == treeRoot) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u9884\u8b66\u5bf9\u8c61\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"WarnScheduleEditPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "msg_merge_content");
        FormShowParameter param = WSMessageEditPlugin.show(message, treeRoot, callback);
        if (ParamsUtils.isUserNewWarnScheme()) {
            param.setFormId("bos_ws_message_edit");
        }
        param.setCustomParam("param_isQuickProcessing", (Object)false);
        param.setCustomParam("param_isMergeSendMessage", (Object)true);
        this.getView().showForm(param);
    }

    private void showSingleMsgDialog() {
        TreeNode treeRoot;
        String message = this.messageViewHolder.getSingleContent();
        String earlyWarnId = this.detailViewHolder.getEarlyWarn();
        String dataSourceNumber = this.detailViewHolder.getDataSource();
        String bizAppId = this.detailViewHolder.getBizAppId();
        if (StringKit.isBlank(earlyWarnId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u65b9\u6848\u5bf9\u5e94\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"WarnScheduleEditPlugin_13", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)EARLY_WARN_SERVICE, (String)"getSingleMessageFieldTree", (Object[])new Object[]{earlyWarnId, dataSourceNumber});
        TreeNode treeNode = treeRoot = StringKit.isBlank(result) ? null : (TreeNode)SerializationUtils.fromJsonString((String)result, TreeNode.class);
        if (null == treeRoot) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u9884\u8b66\u5bf9\u8c61\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"WarnScheduleEditPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "msg_single_content");
        FormShowParameter param = WSMessageEditPlugin.show(message, treeRoot, callback);
        param.setCustomParam("param_isQuickProcessing", (Object)this.messageViewHolder.isQuickProcessing());
        param.setCustomParam("param_isMergeSendMessage", (Object)false);
        this.getView().showForm(param);
    }

    private void showMsgTitleDialog() {
        TreeNode treeRoot;
        String title = this.messageViewHolder.getTitle();
        String earlyWarnId = this.detailViewHolder.getEarlyWarn();
        String dataSourceNumber = this.detailViewHolder.getDataSource();
        String bizAppId = this.detailViewHolder.getBizAppId();
        if (StringKit.isBlank(earlyWarnId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u65b9\u6848\u5bf9\u5e94\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"WarnScheduleEditPlugin_13", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)EARLY_WARN_SERVICE, (String)"getTitleFieldTree", (Object[])new Object[]{earlyWarnId, dataSourceNumber});
        TreeNode treeNode = treeRoot = StringKit.isBlank(result) ? null : (TreeNode)SerializationUtils.fromJsonString((String)result, TreeNode.class);
        if (null == treeRoot) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u9884\u8b66\u5bf9\u8c61\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u9884\u8b66\u5bf9\u8c61\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"WarnScheduleEditPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "msg_title");
        FormShowParameter param = WSMessageEditPlugin.show(title, treeRoot, callback);
        param.setCaption(ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848\u9884\u8b66\u6807\u9898\u7f16\u8f91", (String)"WarnScheduleEditPlugin_24", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        param.setCustomParam("param_isQuickProcessing", (Object)false);
        param.setCustomParam("param_isMergeSendMessage", (Object)true);
        this.getView().showForm(param);
    }

    private boolean doSave() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.SAVE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"WarnScheduleEditPlugin_18", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        String bizAppId = this.detailViewHolder.getBizAppId();
        if (!this.checkData(bizAppId)) {
            return false;
        }
        String langValue = this.getModel().getValue(LANG_COMBO).toString();
        String title = this.getModel().getValue("msg_title").toString();
        String singleContent = this.getModel().getValue("msg_single_content").toString();
        String mergeContent = this.getModel().getValue("msg_merge_content").toString();
        Map<String, String> configMap = this.buildMulilangConfigMap(langValue, title, singleContent, mergeContent);
        this.setMulilangConfigMapByCache();
        this.mulilangConfigMap.put(langValue, configMap);
        this.getPageCache().put("mulilangConfigList", SerializationUtils.toJsonString(this.buildMulilangConfigs(this.mulilangConfigMap)));
        String id = this.detailViewHolder.getId();
        WarnScheduleMetadata metadata = WarnScheduleMetaServiceHelper.idExists(id) ? WarnScheduleMetaServiceHelper.loadMetaById(id, false) : WarnScheduleTemplate.createBlankMeta();
        this.detailViewHolder.assemble(metadata);
        this.conditionViewHolder.assemble(metadata);
        this.messageViewHolder.assemble(metadata);
        this.periodViewHolder.assemble(metadata);
        WarnScheduleMetaServiceHelper.save(metadata);
        JobKit.sync(metadata);
        this.getModel().setDataChanged(false);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "EarlyWarnCommon_Save", BOS_EARLYWARN);
        logInfo.setOpName("save", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", WARN_SCHEDULE_EDIT_PLUGIN_8, BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(FORM_NUMBER);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
        return true;
    }

    private boolean checkData(String bizAppId) {
        return this.detailViewHolder.checkData() && this.conditionViewHolder.checkData(bizAppId) && this.messageViewHolder.checkData() && this.periodViewHolder.checkData();
    }

    private void showPeriodDialog() {
        WSPeriodBo period = this.detailViewHolder.getMonitorPeriod();
        FormShowParameter parameter = WarnSchedulePeriodDialogPlugin.show(period, new CloseCallBack((IFormPlugin)this, "monitor_period"));
        this.getView().showForm(parameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String oldVal;
        super.propertyChanged(e);
        Object[] changeDataArr = e.getChangeSet();
        if (CollectionKit.isEmpty(changeDataArr)) {
            return;
        }
        Object data = changeDataArr[0];
        IDataEntityProperty property = e.getProperty();
        String newVal = StringKit.toSafeString(data.getNewValue());
        if (newVal.equals(oldVal = StringKit.toSafeString(data.getOldValue()))) {
            return;
        }
        String name = property.getName();
        if ("early_warn".equals(name)) {
            DynamicObject oldEarlyWarn = (DynamicObject)data.getOldValue();
            DynamicObject earlyWarn = (DynamicObject)data.getNewValue();
            this.detailViewHolder.changeEarlyWarn(earlyWarn);
            String earlyWarnNumber = earlyWarn == null ? "" : earlyWarn.getString("number");
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, "container_custom_form");
            this.conditionViewHolder.changeEarlyWarn(earlyWarnNumber, callback);
            String oldEarlyWarnNumber = oldEarlyWarn == null ? "" : oldEarlyWarn.getString("number");
            this.messageViewHolder.setMessageType(new ArrayList<WarnMessageSendType>());
            if (earlyWarn != null) {
                this.messageViewHolder.setComboItems(earlyWarn.getString("data_source_id"));
            }
            this.getModel().setValue("msg_type", (Object)"");
            if (!StringKit.equals(oldEarlyWarnNumber, earlyWarnNumber)) {
                this.messageViewHolder.changeEarlyWarn();
                if (StringKit.isNotBlank(oldEarlyWarnNumber)) {
                    String msg = ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u9884\u8b66\u5185\u5bb9\u3002", (String)"WarnScheduleEditPlugin_12", (String)BOS_EARLYWARN, (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                }
            }
        } else if ("biz_app".equals(name)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.getModel().setValue("early_warn", null);
            }
        } else if (LANG_COMBO.equals(name)) {
            String title = this.getModel().getValue("msg_title").toString();
            String singleContent = this.getModel().getValue("msg_single_content").toString();
            String mergeContent = this.getModel().getValue("msg_merge_content").toString();
            Map<String, String> configMap = this.buildMulilangConfigMap(oldVal, title, singleContent, mergeContent);
            this.setMulilangConfigMapByCache();
            this.mulilangConfigMap.put(oldVal, configMap);
            if (this.mulilangConfigMap.containsKey(newVal)) {
                Map<String, String> curMulilangConfig = this.mulilangConfigMap.get(newVal);
                this.getModel().setValue("msg_title", (Object)curMulilangConfig.get(TITLE));
                this.getModel().setValue("msg_single_content", (Object)curMulilangConfig.get(SINGLE_CONTENT));
                this.getModel().setValue("msg_merge_content", (Object)curMulilangConfig.get(MERGE_CONTENT));
            } else {
                this.getModel().setValue("msg_merge_content", (Object)"");
                this.getModel().setValue("msg_single_content", (Object)"");
                this.getModel().setValue("msg_title", (Object)"");
            }
            this.getPageCache().put(MULTILINGUAL_CONFIG, SerializationUtils.toJsonString(this.mulilangConfigMap));
        }
        this.cycleConfigurationPropertyChange((ChangeData[])changeDataArr, property);
    }

    private void cycleConfigurationPropertyChange(ChangeData[] changeDataArr, IDataEntityProperty property) {
        String newValue;
        this.periodViewHolder.propertyChange(property, changeDataArr[0]);
        if (StringUtils.equals((CharSequence)PERIOD_REPEAT, (CharSequence)property.getName()) || StringUtils.equals((CharSequence)PERIOD_TYPE, (CharSequence)property.getName())) {
            int periodValue = changeDataArr[0].getDataEntity().getInt(PERIOD_REPEAT);
            this.checkPeriodData(periodValue);
        }
        if (StringUtils.equals((CharSequence)PERIOD_CRON, (CharSequence)property.getName())) {
            this.periodViewHolder.checkCron(changeDataArr[0].getDataEntity().getString(property));
        }
        if (DATE_RANGE.equals(newValue = (String)changeDataArr[0].getDataEntity().get(RANGE_TYPE))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_START_TIME});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONITOR_TIME_RANGE});
            this.getModel().getDataEntity().set(MONITOR_START_TIME, changeDataArr[0].getDataEntity().get(START_DATE));
        } else if (FROM_START_DATE.equals(newValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_TIME_RANGE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONITOR_START_TIME});
            this.getModel().getDataEntity().set(START_DATE, changeDataArr[0].getDataEntity().get(MONITOR_START_TIME));
            this.getModel().getDataEntity().set(END_DATE, changeDataArr[0].getDataEntity().get(MONITOR_START_TIME));
        }
    }

    private void checkPeriodData(int periodValue) {
        String typeValue = (String)this.getModel().getValue(PERIOD_TYPE);
        RunCyclePeriodType periodType = RunCyclePeriodType.getByValue(typeValue);
        if (RunCyclePeriodType.Minute == periodType && periodValue > 59) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)59);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5206\u949f\uff0c\u6700\u591a\u53ea\u80fd\u6bcf59\u5206\u949f\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Hour == periodType && periodValue > 23) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)23);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5c0f\u65f6\uff0c\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Day == periodType && periodValue > 31) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)31);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5929\uff0c\u6700\u591a\u53ea\u80fd\u6bcf31\u5929\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Week == periodType && periodValue != 1) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5468\uff0c\u6682\u53ea\u652f\u6301\u6bcf\u5468\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Month == periodType && periodValue > 12) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)12);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u6708\uff0c\u6700\u591a\u53ea\u80fd\u6bcf12\u6708\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Year == periodType && periodValue > 1) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5e74\uff0c\u6682\u53ea\u652f\u6301\u6bcf\u5e74\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringKit.isBlank(actionId) || null == returnData) {
            return;
        }
        switch (actionId) {
            case "monitor_period": {
                this.detailViewHolder.changeMonitorPeriod((Map)returnData);
                break;
            }
            case "msg_receiver": {
                this.messageViewHolder.setSelectedReceiverTypes((List)returnData);
                break;
            }
            case "msg_title": {
                Object title = ((Map)returnData).get("text");
                this.messageViewHolder.setTitle((String)title);
                break;
            }
            case "msg_single_content": {
                Object text = ((Map)returnData).get("text");
                boolean isQuickProcessing = false;
                if (((Map)returnData).get("isQuickProcessing") instanceof Boolean) {
                    isQuickProcessing = (Boolean)((Map)returnData).get("isQuickProcessing");
                }
                this.messageViewHolder.setSingleContent((String)text);
                this.messageViewHolder.setQuickProcessing(isQuickProcessing);
                break;
            }
            case "msg_merge_content": {
                if (returnData instanceof MessageContent) {
                    this.messageViewHolder.setMergeContent(SerializationUtils.toJsonString((Object)returnData));
                } else {
                    Object mergetext = ((Map)returnData).get("text");
                    this.messageViewHolder.setMergeContent((String)mergetext);
                }
                this.messageViewHolder.setQuickProcessing(false);
                break;
            }
        }
    }

    public static FormShowParameter show(String bizAppId, String warnScheduleId, boolean copy, CloseCallBack callback) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(FORM_NUMBER);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCloseCallBack(callback);
        parameter.setCustomParam(PARAM_BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(PARAM_WARN_SCHEDULE_ID, (Object)warnScheduleId);
        parameter.setCustomParam(PARAM_COPY, (Object)copy);
        return parameter;
    }

    private void showNoPermissionErrorNotification(String opName) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u201d\u7684\u201c%s\u201d\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u3002", (String)"WarnScheduleEditPlugin_22", (String)BOS_EARLYWARN, (Object[])new Object[0]), opName));
    }

    private void loadMulilangConfigByMeta(WarnScheduleMetadata warnSchedule) {
        List<MulilangConfig> mulilangConfigs = warnSchedule.getWarnSchedule().getMessageConfig().getMulilangConfigs();
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            Map<String, String> configMap = this.buildMulilangConfigMap(mulilangConfig.getLangType(), mulilangConfig.getTitle(), mulilangConfig.getSingleContent(), mulilangConfig.getMergeContent());
            this.mulilangConfigMap.put(mulilangConfig.getLangType(), configMap);
        }
        if (!this.mulilangConfigMap.isEmpty()) {
            this.getPageCache().put(MULTILINGUAL_CONFIG, SerializationUtils.toJsonString(this.mulilangConfigMap));
        }
    }

    private void setMulilangConfigMapByCache() {
        String muliLangConfigStr = this.getPageCache().get(MULTILINGUAL_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)muliLangConfigStr)) {
            this.mulilangConfigMap = (Map)SerializationUtils.fromJsonString((String)muliLangConfigStr, Map.class);
        }
    }

    private Map<String, String> buildMulilangConfigMap(String langValue, String title, String singleContent, String mergeContent) {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        configMap.put(LANG_TYPE, langValue);
        configMap.put(TITLE, title);
        configMap.put(SINGLE_CONTENT, singleContent);
        configMap.put(MERGE_CONTENT, mergeContent);
        return configMap;
    }

    private List<MulilangConfig> buildMulilangConfigs(Map<String, Map<String, String>> mulilangConfigMap) {
        ArrayList<MulilangConfig> mulilangConfigs = new ArrayList<MulilangConfig>(mulilangConfigMap.size());
        for (Map<String, String> configMap : mulilangConfigMap.values()) {
            String langType = configMap.get(LANG_TYPE);
            String title = configMap.get(TITLE);
            String single = configMap.get(SINGLE_CONTENT);
            String Merge = configMap.get(MERGE_CONTENT);
            if (StringUtils.isBlank((CharSequence)langType) || StringUtils.isBlank((CharSequence)title) || StringUtils.isBlank((CharSequence)single)) continue;
            MulilangConfig mulilangConfig = new MulilangConfig();
            mulilangConfig.setLangType(langType);
            mulilangConfig.setTitle(title);
            mulilangConfig.setSingleContent(single);
            mulilangConfig.setMergeContent(Merge);
            mulilangConfigs.add(mulilangConfig);
        }
        return mulilangConfigs;
    }
}

