/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;

public class WarnScheduleReceiverCustomPlugin
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "bos_warn_receiver_custom";
    private static final String PARAM_DATA_RECEIVER = "receivers";
    private static final String TOOL_BAR = "operatepanel";
    private static final String COMBOFIELD = "combofield";
    private static final String BTN_OK = "btnok";
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (!StringKit.equals(BTN_OK, control.getKey())) {
            return;
        }
        LinkedList<WarnMessageReceiver> receivers = new LinkedList<WarnMessageReceiver>();
        String receiverType = WarnMessageReceiverTypeEnum.CustomReceiver.getId();
        String selectedPlugin = (String)this.getModel().getValue(COMBOFIELD);
        if (StringUtils.isBlank((CharSequence)selectedPlugin)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u63a5\u6536\u4eba\u9700\u8981\u6307\u5b9a\u63d2\u4ef6\u3002", (String)"WarnScheduleReceiverCustomPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        WarnMessageReceiver receiver = new WarnMessageReceiver();
        receiver.setReceiverType(receiverType);
        receiver.setId(receiverType);
        receiver.setName(selectedPlugin);
        receivers.add(receiver);
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        type.setType(receiverType);
        type.setReceivers(receivers);
        this.getView().returnDataToParent((Object)type);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        EarlyWarnMetadata meta;
        Object earlyWarn = this.getView().getParentView().getParentView().getModel().getValue("early_warn");
        if (null == earlyWarn) {
            return;
        }
        String earlyWarnNumber = (String)((DynamicObject)earlyWarn).get("number");
        EarlyWarnMetadata earlyWarnMetadata = meta = StringKit.isBlank(earlyWarnNumber) ? null : EarlyWarnMetaServicHelper.loadMetaByNumber(earlyWarnNumber, true);
        if (meta == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e3a\u7a7a\u6216\u8005\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff1a%s", (String)"WarnScheduleReceiverCustomPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]), earlyWarnNumber));
        }
        EarlyWarnElement earlyWarnElement = meta.getWarnElement();
        ArrayList comboItems = new ArrayList();
        if (earlyWarnElement != null && earlyWarnElement.getCustomReceivers() != null) {
            List<EWPlugin> customReceiversPlugins = earlyWarnElement.getCustomReceivers();
            customReceiversPlugins.forEach(plugin -> {
                if (plugin.isEnabled()) {
                    ComboItem comboItem = new ComboItem(new LocaleString(plugin.getClassName()), plugin.getClassName());
                    comboItems.add(comboItem);
                }
            });
        }
        ((ComboEdit)this.getView().getControl(COMBOFIELD)).setComboItems(comboItems);
    }

    public static FormShowParameter show(List<WarnMessageReceiver> receivers, CloseCallBack callBack) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.setCustomParam(PARAM_DATA_RECEIVER, (Object)SerializationUtils.toJsonString(receivers));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callBack);
        return param;
    }
}

