/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.schedule.WarnScheduleReceiverCustomPlugin;
import kd.bos.designer.earlywarn.schedule.WarnScheduleReceiverTypePlugin;
import kd.bos.designer.earlywarn.schedule.WarnScheduleReceiverUserVariablePlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;

public class WarnScheduleReceiverPlugin
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "bos_warnschedule_receiver";
    private static final String BTN_ADD = "tru_btn_add";
    private static final String BTN_MODIFY = "tru_btn_modify";
    private static final String BTN_DELETE = "tru_btn_del";
    private static final String BTN_OK = "btn_ok";
    private static final String ENTRY_ENTITY = "entry_entity";
    private static final String TYPE_NAME = "type_name";
    private static final String TYPE_ID = "type_id";
    private static final String TYPE_VALUE = "type_value";
    private static final String BOS_USER_TREE_LIST_F7 = "bos_usertreelistf7";
    private static final String USER_VARIABLE_CALLBACK = "user_variable_callback";
    private static final String CUSTOM_RECEIVER_CALLBACK = "custom_receiver_callback";
    private static final String PARAM_DATA_SOURCE = "dataSource";
    private static final String PARAM_TYPES = "types";

    public void afterCreateNewData(EventObject e) {
        this.getModel().getEntryEntity(ENTRY_ENTITY).clear();
        FormShowParameter param = this.getView().getFormShowParameter();
        String json = (String)param.getCustomParam(PARAM_TYPES);
        List types = StringKit.isBlank(json) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiverType.class);
        for (WarnMessageReceiverType type : types) {
            this.updateItem(type);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD, BTN_MODIFY, BTN_DELETE, BTN_OK});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "tru_btn_add": {
                this.showTypeForm();
                break;
            }
            case "tru_btn_modify": {
                this.showModifyForm();
                break;
            }
            case "tru_btn_del": {
                this.doDelete();
                break;
            }
            case "btn_ok": {
                this.returnData();
                break;
            }
        }
    }

    private void returnData() {
        DynamicObjectCollection list = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<WarnMessageReceiverType> types = new ArrayList<WarnMessageReceiverType>();
        for (DynamicObject obj : list) {
            String typeId = obj.getString(TYPE_ID);
            WarnMessageReceiverType type = new WarnMessageReceiverType();
            type.setType(typeId);
            type.setReceivers(this.getCacheReceivers(typeId));
            types.add(type);
        }
        this.getView().returnDataToParent(types);
        this.getView().close();
    }

    private void doDelete() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int row = grid.getEntryState().getFocusRow();
        if (-1 == row) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6761\u76ee\u3002", (String)"WarnScheduleReceiverPlugin_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        String typeId = (String)this.getModel().getValue(TYPE_ID, row);
        this.getModel().deleteEntryRow(ENTRY_ENTITY, row);
        this.getPageCache().remove(this.getCacheKey(typeId));
    }

    private void showModifyForm() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int row = grid.getEntryState().getFocusRow();
        if (-1 == row) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u6761\u76ee\u3002", (String)"WarnScheduleReceiverPlugin_3", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        String typeId = (String)this.getModel().getValue(TYPE_ID, row);
        this.onTypeSelected(typeId);
    }

    private void showTypeForm() {
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BTN_ADD);
        FormShowParameter param = WarnScheduleReceiverTypePlugin.show(callBack);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringKit.isBlank(actionId) || returnData == null) {
            return;
        }
        switch (actionId) {
            case "tru_btn_add": {
                this.onTypeSelected((String)returnData);
                break;
            }
            case "bos_usertreelistf7": {
                this.onUserSelected((ListSelectedRowCollection)returnData);
                break;
            }
            case "user_variable_callback": {
                this.updateItem((WarnMessageReceiverType)returnData);
                break;
            }
            case "custom_receiver_callback": {
                this.onCustomReceiverSelected((WarnMessageReceiverType)returnData);
                break;
            }
        }
    }

    private void onCustomReceiverSelected(WarnMessageReceiverType type) {
        this.updateItem(type);
    }

    private void updateItem(WarnMessageReceiverType type) {
        List names = type.getReceivers().stream().map(WarnMessageReceiver::getName).collect(Collectors.toList());
        DynamicObjectCollection list = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int index = -1;
        WarnMessageReceiverTypeEnum userType = WarnMessageReceiverTypeEnum.getBy(type.getType());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject obj = (DynamicObject)list.get(i);
            if (!StringKit.equals(userType.getId(), obj.getString(TYPE_ID))) continue;
            index = i;
            break;
        }
        IDataModel model = this.getModel();
        if (-1 != index) {
            model.setValue(TYPE_VALUE, (Object)StringKit.join(names), index);
        } else {
            index = model.createNewEntryRow(ENTRY_ENTITY);
            model.setValue(TYPE_ID, (Object)userType.getId(), index);
            model.setValue(TYPE_NAME, (Object)(userType.getName() + ":"), index);
            model.setValue(TYPE_VALUE, (Object)StringKit.join(names), index);
        }
        this.getPageCache().put(this.getCacheKey(type.getType()), SerializationUtils.toJsonString(type.getReceivers()));
    }

    private void onUserSelected(ListSelectedRowCollection selectRows) {
        WarnMessageReceiverTypeEnum userType = WarnMessageReceiverTypeEnum.User;
        LinkedList<WarnMessageReceiver> receivers = new LinkedList<WarnMessageReceiver>();
        for (ListSelectedRow row : selectRows) {
            String id = StringKit.toSafeString(row.getPrimaryKeyValue());
            String name = row.getName();
            WarnMessageReceiver receiver = new WarnMessageReceiver();
            receiver.setReceiverType(userType.getId());
            receiver.setId(id);
            receiver.setName(name);
            receivers.add(receiver);
        }
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        type.setType(userType.getId());
        type.setReceivers(receivers);
        this.updateItem(type);
    }

    private void onTypeSelected(String key) {
        WarnMessageReceiverTypeEnum type = WarnMessageReceiverTypeEnum.getBy(key);
        switch (type) {
            case User: {
                this.showUserForm();
                break;
            }
            case RelationPerson: {
                this.showUserVariableForm();
                break;
            }
            case CustomReceiver: {
                this.showCustomReceiverForm();
                break;
            }
        }
    }

    private String getCacheKey(String type) {
        return type + "_cache";
    }

    private List<WarnMessageReceiver> getCacheReceivers(String type) {
        String json = this.getPageCache().get(this.getCacheKey(type));
        return StringKit.isBlank(json) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiver.class);
    }

    private void showCustomReceiverForm() {
        WarnMessageReceiverTypeEnum type = WarnMessageReceiverTypeEnum.CustomReceiver;
        List<WarnMessageReceiver> receivers = this.getCacheReceivers(type.getId());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CUSTOM_RECEIVER_CALLBACK);
        FormShowParameter parameter = WarnScheduleReceiverCustomPlugin.show(receivers, callBack);
        this.getView().showForm(parameter);
    }

    private void showUserVariableForm() {
        String dataSource = this.getDataSource();
        WarnMessageReceiverTypeEnum type = WarnMessageReceiverTypeEnum.RelationPerson;
        List<WarnMessageReceiver> receivers = this.getCacheReceivers(type.getId());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, USER_VARIABLE_CALLBACK);
        FormShowParameter param = WarnScheduleReceiverUserVariablePlugIn.show(dataSource, receivers, callBack);
        this.getView().showForm(param);
    }

    private String getDataSource() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return StringKit.toSafeString(param.getCustomParam(PARAM_DATA_SOURCE));
    }

    private void showUserForm() {
        List<WarnMessageReceiver> receivers = this.getCacheReceivers(WarnMessageReceiverTypeEnum.User.getId());
        Object[] pkIds = new String[receivers.size()];
        for (int i = 0; i < receivers.size(); ++i) {
            WarnMessageReceiver receiver = receivers.get(i);
            pkIds[i] = receiver.getId();
        }
        ListShowParameter param = new ListShowParameter();
        param.setFormId(BOS_USER_TREE_LIST_F7);
        param.setBillFormId("bos_user");
        param.setSelectedRows(pkIds);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getOpenStyle().setInlineStyleCss(css);
        param.setShowTitle(false);
        param.setMultiSelect(true);
        param.setLookUp(true);
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, BOS_USER_TREE_LIST_F7);
        param.setCloseCallBack(callback);
        this.getView().showForm((FormShowParameter)param);
    }

    public static FormShowParameter show(String dataSource, List<WarnMessageReceiverType> types, CloseCallBack callBack) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.setCustomParam(PARAM_TYPES, (Object)SerializationUtils.toJsonString(types));
        param.setCustomParam(PARAM_DATA_SOURCE, (Object)dataSource);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callBack);
        return param;
    }
}

