/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.MessageTableColumn;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextAreaEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class WarnSchemeMessageEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
IConfirmCallBack,
CellClickListener,
InputFocusListener {
    private static final String TREE_VIEW = "tree_view";
    private static final String MESSAGE_HEAD = "message_head";
    private static final String BTN_INSERT_COL = "insertcol";
    private static final String BTN_DELETE_COL = "deletecol";
    private static final String MESSAGE_TABLE = "message_table";
    private static final String MESSAGE_END = "message_end";
    private static final String FIXED_FIELD = "fixedfield";
    private static final String PARAM_TEXT = "param_text";
    private static final String PARAM_TREE = "param_tree";
    private static final String LEFT_BRACKET = "{";
    private static final String RIGHT_BRACKET = "}";
    private static final String CURRENT_HIDE_FIELDS = "currentHideFields";
    private static final String CURRENT_SHOW_FIELDS = "currentShowFields";
    private static final String CURRENT_FOCUS_COL = "currentFocusCol";
    private static final String FOCUS_FIELD = "focusFieldKey";
    private static final String BTN_OK = "btnok";

    public void initialize() {
        super.initialize();
        TextEdit messageHead = (TextEdit)this.getControl(MESSAGE_HEAD);
        messageHead.addInputFocusListener((InputFocusListener)this);
        TextEdit messageEnd = (TextEdit)this.getControl(MESSAGE_END);
        messageEnd.addInputFocusListener((InputFocusListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_INSERT_COL, BTN_DELETE_COL, BTN_OK});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MESSAGE_TABLE);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(FIXED_FIELD, (Object)ResManager.loadKDString((String)"\u6807\u9898\u884c", (String)"WarnSchemeMessageEditPlugin_0", (String)"bos-earlywarn", (Object[])new Object[0]), 0);
        this.getModel().setValue(FIXED_FIELD, (Object)ResManager.loadKDString((String)"\u6570\u636e\u884c", (String)"WarnSchemeMessageEditPlugin_1", (String)"bos-earlywarn", (Object[])new Object[0]), 1);
        EntryGrid entryGrid = (EntryGrid)this.getControl(MESSAGE_TABLE);
        List fieldEdits = entryGrid.getFieldEdits();
        LinkedList<String> fields = new LinkedList<String>();
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getKey();
            if (StringUtils.equals((CharSequence)FIXED_FIELD, (CharSequence)fieldKey) || !(fieldEdit instanceof TextEdit)) continue;
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{fieldKey});
            fields.add(fieldKey);
        }
        TreeNode root = this.getTreeNode();
        if (null != root) {
            root.setIsOpened(true);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            treeView.addNode(root);
        }
        this.initMessageField(fields);
    }

    private void initMessageField(List<String> fields) {
        String text = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TEXT);
        try {
            MessageContent messageContent = (MessageContent)SerializationUtils.fromJsonString((String)text, MessageContent.class);
            this.getModel().setValue(MESSAGE_HEAD, (Object)messageContent.getMessageHead());
            List<MessageTableColumn> messageTable = messageContent.getTableColumns();
            this.initEntryField(fields, messageTable);
            this.getModel().setValue(MESSAGE_END, (Object)messageContent.getMessageEnd());
        }
        catch (Exception e) {
            this.getModel().setValue(MESSAGE_HEAD, (Object)text);
            this.initEntryField(fields, new ArrayList<MessageTableColumn>());
        }
    }

    private void initEntryField(List<String> fields, List<MessageTableColumn> messageTable) {
        if (messageTable == null) {
            messageTable = new ArrayList<MessageTableColumn>();
        }
        int showIndex = Math.max(5, messageTable.size()) - 1;
        Iterator<String> iterator = fields.iterator();
        int index = 0;
        LinkedList<String> showFields = new LinkedList<String>();
        while (iterator.hasNext()) {
            String field = iterator.next();
            if (showIndex >= 0) {
                if (index < messageTable.size()) {
                    MessageTableColumn tableColumn = messageTable.get(index);
                    this.getModel().setValue(field, (Object)tableColumn.getTitle(), 0);
                    this.getModel().setValue(field, (Object)tableColumn.getField(), 1);
                    ++index;
                }
                showFields.add(field);
                iterator.remove();
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{field});
            }
            --showIndex;
        }
        this.cacheCurrentHideFields(fields);
        this.cacheCurrentShowFields(showFields);
    }

    private TreeNode getTreeNode() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String json = (String)param.getCustomParam(PARAM_TREE);
        if (StringKit.isNotBlank(json)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)BTN_INSERT_COL, (CharSequence)key)) {
            List<String> currentHideFields = this.getCurrentHideFields();
            if (CollectionUtils.isEmpty(currentHideFields)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u6700\u5927\u5c55\u793a\u5217\u6570\u3002", (String)"WarnSchemeMessageEditPlugin_2", (String)"bos-earlywarn", (Object[])new Object[0]));
                return;
            }
            String currentFocusCol = this.getCurrentFocusCol();
            List<String> currentShowFields = this.getCurrentShowFields();
            if (StringUtils.isBlank((CharSequence)currentFocusCol)) {
                this.insertColAtEnd(currentHideFields, currentShowFields);
                return;
            }
            int startIndex = currentShowFields.indexOf(currentFocusCol) + 1;
            this.insertColAtEnd(currentHideFields, currentShowFields);
            this.moveBackColData(startIndex, currentShowFields);
            return;
        }
        if (StringUtils.equals((CharSequence)BTN_DELETE_COL, (CharSequence)key)) {
            List<String> currentShowFields = this.getCurrentShowFields();
            if (CollectionUtils.isEmpty(currentShowFields)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5168\u90e8\u5217\u5df2\u5220\u9664\u3002", (String)"WarnSchemeMessageEditPlugin_3", (String)"bos-earlywarn", (Object[])new Object[0]));
                return;
            }
            String currentFocusCol = this.getCurrentFocusCol();
            List<String> currentHideFields = this.getCurrentHideFields();
            if (StringUtils.isBlank((CharSequence)currentFocusCol)) {
                this.hideColAtEnd(currentHideFields, currentShowFields);
                return;
            }
            int hideCol = currentShowFields.indexOf(currentFocusCol);
            if (hideCol >= 0) {
                this.moveForwardColData(hideCol, currentHideFields, currentShowFields);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        MessageContent messageContent = new MessageContent();
        messageContent.setMessageHead((String)this.getModel().getValue(MESSAGE_HEAD));
        messageContent.setMessageEnd((String)this.getModel().getValue(MESSAGE_END));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MESSAGE_TABLE);
        DynamicObject titleRow = (DynamicObject)entryEntity.get(0);
        DynamicObject dataRow = (DynamicObject)entryEntity.get(1);
        List<String> currentShowFields = this.getCurrentShowFields();
        if (CollectionUtils.isEmpty(currentShowFields)) {
            this.getView().returnDataToParent((Object)messageContent);
            this.getView().close();
            return;
        }
        LinkedList<MessageTableColumn> messageTable = new LinkedList<MessageTableColumn>();
        for (String field : currentShowFields) {
            String title = titleRow.getString(field);
            String data = dataRow.getString(field);
            if (StringUtils.isBlank((CharSequence)title) && StringUtils.isBlank((CharSequence)data)) continue;
            MessageTableColumn tableColumn = new MessageTableColumn();
            tableColumn.setId(DBServiceHelper.genStringId());
            tableColumn.setField(data);
            tableColumn.setTitle(title);
            messageTable.add(tableColumn);
        }
        messageContent.setTableColumns(messageTable);
        this.getView().returnDataToParent((Object)messageContent);
        this.getView().close();
    }

    private void moveForwardColData(int hideCol, List<String> currentHideFields, List<String> currentShowFields) {
        String lastField = currentShowFields.get(currentShowFields.size() - 1);
        DynamicObjectCollection messageTable = this.getModel().getEntryEntity(MESSAGE_TABLE);
        DynamicObject titleRow = (DynamicObject)messageTable.get(0);
        DynamicObject dataRow = (DynamicObject)messageTable.get(1);
        String lastTitle = titleRow.getString(lastField);
        String lastData = dataRow.getString(lastField);
        this.hideColAtEnd(currentHideFields, currentShowFields);
        for (int i = currentShowFields.size() - 1; i >= hideCol; --i) {
            String curCol = currentShowFields.get(i);
            String tempTitle = titleRow.getString(curCol);
            String tempData = dataRow.getString(curCol);
            this.getModel().setValue(curCol, (Object)lastTitle, 0);
            this.getModel().setValue(curCol, (Object)lastData, 1);
            lastTitle = tempTitle;
            lastData = tempData;
        }
    }

    private void hideColAtEnd(List<String> currentHideFields, List<String> currentShowFields) {
        String lastHideField = currentShowFields.get(currentShowFields.size() - 1);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{lastHideField});
        this.clearFieldCol(lastHideField);
        currentShowFields.remove(lastHideField);
        currentHideFields.add(0, lastHideField);
        this.cacheCurrentShowFields(currentShowFields);
        this.cacheCurrentHideFields(currentHideFields);
    }

    private void moveBackColData(int startIndex, List<String> currentShowFields) {
        if (CollectionUtils.isEmpty(currentShowFields)) {
            return;
        }
        DynamicObjectCollection messageTable = this.getModel().getEntryEntity(MESSAGE_TABLE);
        DynamicObject titleRow = (DynamicObject)messageTable.get(0);
        DynamicObject dataRow = (DynamicObject)messageTable.get(1);
        String startField = currentShowFields.get(startIndex);
        String preTitle = titleRow.getString(startField);
        String preData = dataRow.getString(startField);
        for (int i = startIndex; i < currentShowFields.size() - 1; ++i) {
            String nextCol = currentShowFields.get(i + 1);
            String tempTitle = titleRow.getString(nextCol);
            String tempData = dataRow.getString(nextCol);
            this.getModel().setValue(nextCol, (Object)preTitle, 0);
            this.getModel().setValue(nextCol, (Object)preData, 1);
            preTitle = tempTitle;
            preData = tempData;
        }
        this.clearFieldCol(startField);
    }

    private void clearFieldCol(String field) {
        this.getModel().setValue(field, (Object)"", 0);
        this.getModel().setValue(field, (Object)"", 1);
    }

    private void insertColAtEnd(List<String> currentHideFields, List<String> currentShowFields) {
        String nextShowField = currentHideFields.get(0);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{nextShowField});
        currentHideFields.remove(0);
        currentShowFields.add(nextShowField);
        this.cacheCurrentHideFields(currentHideFields);
        this.cacheCurrentShowFields(currentShowFields);
    }

    private List<String> getCurrentHideFields() {
        String hideFields = this.getPageCache().get(CURRENT_HIDE_FIELDS);
        if (StringUtils.isBlank((CharSequence)hideFields)) {
            return new LinkedList<String>();
        }
        return SerializationUtils.fromJsonStringToList((String)hideFields, String.class);
    }

    private void cacheCurrentHideFields(List<String> hideFields) {
        this.getPageCache().put(CURRENT_HIDE_FIELDS, SerializationUtils.toJsonString(hideFields));
    }

    private void cacheCurrentShowFields(List<String> showFields) {
        this.getPageCache().put(CURRENT_SHOW_FIELDS, SerializationUtils.toJsonString(showFields));
    }

    private List<String> getCurrentShowFields() {
        String showFields = this.getPageCache().get(CURRENT_SHOW_FIELDS);
        if (StringUtils.isBlank((CharSequence)showFields)) {
            return new LinkedList<String>();
        }
        return SerializationUtils.fromJsonStringToList((String)showFields, String.class);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        this.cacheCurrentFocusCol(fieldKey);
        this.getView().getPageCache().put(FOCUS_FIELD, fieldKey);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        this.cacheCurrentFocusCol(fieldKey);
        this.getView().getPageCache().put(FOCUS_FIELD, fieldKey);
    }

    private void cacheCurrentFocusCol(String fieldKey) {
        this.getPageCache().put(CURRENT_FOCUS_COL, fieldKey);
    }

    private String getCurrentFocusCol() {
        return this.getPageCache().get(CURRENT_FOCUS_COL);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (StringUtils.isBlank((Object)nodeId)) {
            return;
        }
        String fieldKey = this.getView().getPageCache().get(FOCUS_FIELD);
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5b57\u6bb5\u3002", (String)"WarnSchemeMessageEditPlugin_4", (String)"bos-earlywarn", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)MESSAGE_HEAD, (CharSequence)fieldKey) || StringUtils.equals((CharSequence)MESSAGE_END, (CharSequence)fieldKey)) {
            String text = LEFT_BRACKET + nodeId + RIGHT_BRACKET;
            this.getModel().setValue(fieldKey, (Object)(this.getModel().getValue(fieldKey) + text));
            return;
        }
        this.getModel().setValue(fieldKey, nodeId, 1);
    }

    public void inputFocus(FireFocusEvent e) {
        TextAreaEdit textAreaEdit = (TextAreaEdit)e.getSource();
        if (!textAreaEdit.isFireFocus()) {
            this.getView().getPageCache().put(FOCUS_FIELD, textAreaEdit.getKey());
        }
    }
}

