/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnScheduleOrgReceiver;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;

public class WarnSchemeOrgReceiverPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG_ENTRY = "orgentry";
    private static final String FIELD_ADMIN_ORG = "adminorg";
    private static final String FIELD_SUB_ORG = "suborg";
    private static final String FIELD_SCOPE = "scope";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CLEAR = "buttonclear";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_CLEAR});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(FIELD_ADMIN_ORG);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object orgReceivers = parameter.getCustomParam("existed_org_receivers");
        if (orgReceivers == null) {
            return;
        }
        List receivers = SerializationUtils.fromJsonStringToList((String)orgReceivers.toString(), WarnScheduleOrgReceiver.class);
        if (CollectionUtils.isEmpty((Collection)receivers)) {
            return;
        }
        if (receivers.size() > 1) {
            this.getModel().batchCreateNewEntryRow(ORG_ENTRY, receivers.size() - 1);
        }
        for (int i = 0; i < receivers.size(); ++i) {
            WarnScheduleOrgReceiver receiver = (WarnScheduleOrgReceiver)receivers.get(i);
            this.getModel().setValue(FIELD_ADMIN_ORG, (Object)receiver.getPkId(), i);
            this.getModel().setValue(FIELD_SUB_ORG, (Object)receiver.getIncludeType(), i);
            this.getModel().setValue(FIELD_SCOPE, (Object)receiver.getScope(), i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ORG_ENTRY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        ArrayList<Object> selectedPkIds = new ArrayList<Object>();
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject org = dynamicObject.getDynamicObject(FIELD_ADMIN_ORG);
            if (null == org) continue;
            selectedPkIds.add(org.getPkValue());
        }
        evt.addCustomQFilter(new QFilter("id", "not in", selectedPkIds));
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ORG_ENTRY);
            ArrayList<WarnScheduleOrgReceiver> receivers = new ArrayList<WarnScheduleOrgReceiver>();
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                for (DynamicObject dynamicObject : collection) {
                    DynamicObject org = dynamicObject.getDynamicObject(FIELD_ADMIN_ORG);
                    String subOrg = dynamicObject.getString(FIELD_SUB_ORG);
                    String scope = dynamicObject.getString(FIELD_SCOPE);
                    if (org == null || StringUtils.isBlank((CharSequence)subOrg) || StringUtils.isBlank((CharSequence)scope)) continue;
                    receivers.add(new WarnScheduleOrgReceiver(org.getPkValue().toString(), subOrg, scope, org.getString("name")));
                }
            }
            this.getView().returnDataToParent(receivers);
            this.getView().close();
        }
    }
}

