/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.RelationReceiverTypeEnum;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnScheduleRelationReceiver;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WarnSchemeRelationReceiverPlugin
extends AbstractFormPlugin {
    private static final String FIELD_RELATION_TYPE = "relationtype";
    private static final String FIELD_FIELD = "field";
    private static final String RELATION_ENTRY = "relationentry";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CLEAR = "buttonclear";
    private static final String PARAM_DATA_SOURCE = "dataSource";
    private static final String BOS_USER = "bos_user";
    private static final String BOS_ORG = "bos_org";
    private static final String CUSTOM_PARAM = "existed_relation_receivers";
    private static final String FIELD_CACHE_KEY = "relation_all_fields";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_CLEAR});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String dataSource = (String)parameter.getCustomParam(PARAM_DATA_SOURCE);
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return;
        }
        List<String> comboValues = this.initRelationFieldCombo(dataSource);
        Object orgReceivers = parameter.getCustomParam(CUSTOM_PARAM);
        if (orgReceivers == null) {
            return;
        }
        List receivers = SerializationUtils.fromJsonStringToList((String)orgReceivers.toString(), WarnMessageReceiver.class);
        if (CollectionUtils.isEmpty((Collection)receivers)) {
            return;
        }
        StringBuilder notExistField = new StringBuilder();
        int index = 0;
        for (WarnMessageReceiver receiver : receivers) {
            String field = receiver.getField();
            if (!comboValues.contains(field)) {
                notExistField.append(receiver.getFieldName()).append('(').append(field).append(")\u3001");
                continue;
            }
            int newEntryRow = 0;
            if (index > 0) {
                newEntryRow = this.getModel().createNewEntryRow(RELATION_ENTRY);
            }
            this.getModel().setValue(FIELD_FIELD, (Object)field, newEntryRow);
            ++index;
        }
        if (notExistField.length() > 0) {
            notExistField.deleteCharAt(notExistField.length() - 1);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\uff1a%s\u4e0d\u5728\u4e0b\u62c9\u5217\u8868\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WarnSchemeRelationReceiverPlugin_1", (String)"bos-earlywarn", (Object[])new Object[0]), notExistField.toString()));
        }
    }

    private List<String> initRelationFieldCombo(String dataSource) {
        ArrayList<String> comboValues = new ArrayList<String>();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)dataSource, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        HashMap<String, RelationReceiverTypeEnum> phoneAndEmailFields = new HashMap<String, RelationReceiverTypeEnum>();
        for (EntityItem item : items) {
            if (item instanceof TelephoneField) {
                phoneAndEmailFields.put(item.getKey(), RelationReceiverTypeEnum.PHONE);
                continue;
            }
            if (!(item instanceof EmailField)) continue;
            phoneAndEmailFields.put(item.getKey(), RelationReceiverTypeEnum.EMAIL);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        Map allFields = entityType.getAllFields();
        ArrayList<ComboItem> fieldCombos = new ArrayList<ComboItem>();
        ArrayList<WarnScheduleRelationReceiver> allRelationField = new ArrayList<WarnScheduleRelationReceiver>();
        for (IDataEntityProperty property : allFields.values()) {
            if (property.getParent() instanceof LinkEntryType) continue;
            String propertyName = property.getName();
            RelationReceiverTypeEnum relationTypeEnum = null;
            if (this.isUserField(property)) {
                relationTypeEnum = RelationReceiverTypeEnum.PERSON;
            } else if (this.isOrgField(property)) {
                relationTypeEnum = RelationReceiverTypeEnum.ORG;
            } else if (phoneAndEmailFields.containsKey(propertyName)) {
                relationTypeEnum = (RelationReceiverTypeEnum)((Object)phoneAndEmailFields.get(propertyName));
            }
            if (relationTypeEnum == null) continue;
            LocaleString displayName = property.getDisplayName();
            String fullPropertyName = this.getFullPropertyName(property);
            fieldCombos.add(new ComboItem(displayName, fullPropertyName));
            comboValues.add(fullPropertyName);
            allRelationField.add(new WarnScheduleRelationReceiver(dataSource, fullPropertyName, displayName.getLocaleValue(), relationTypeEnum));
        }
        if (CollectionUtils.isEmpty(fieldCombos)) {
            return comboValues;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FIELD_FIELD);
        comboEdit.setComboItems(fieldCombos);
        this.getPageCache().put(FIELD_CACHE_KEY, SerializationUtils.toJsonString(allRelationField));
        return comboValues;
    }

    private String getFullPropertyName(IDataEntityProperty property) {
        IDataEntityType entryEntity = property.getParent();
        IDataEntityType subEntryEntity = null;
        if (entryEntity instanceof EntryType) {
            subEntryEntity = entryEntity.getParent();
            if (subEntryEntity instanceof SubEntryType) {
                return subEntryEntity.getName() + "." + property.getName();
            }
            return entryEntity.getName() + "." + property.getName();
        }
        return property.getName();
    }

    private boolean isUserField(IDataEntityProperty property) {
        if (property instanceof UserProp) {
            return true;
        }
        if (property instanceof BasedataProp && BOS_USER.equals(((BasedataProp)property).getBaseEntityId())) {
            return true;
        }
        return property instanceof MulBasedataProp && BOS_USER.equals(((MulBasedataProp)property).getBaseEntityId());
    }

    private boolean isOrgField(IDataEntityProperty property) {
        if (property instanceof OrgProp && StringUtils.equals((CharSequence)((OrgProp)property).getOrgFunc(), (CharSequence)"01")) {
            return true;
        }
        return property instanceof MulBasedataProp && BOS_ORG.equals(((MulBasedataProp)property).getBaseEntityId()) && StringUtils.equals((CharSequence)((MulBasedataProp)property).getOrgFunc(), (CharSequence)"01");
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(RELATION_ENTRY);
            Map<String, WarnScheduleRelationReceiver> allFields = this.getAllFields();
            ArrayList<WarnScheduleRelationReceiver> receivers = new ArrayList<WarnScheduleRelationReceiver>();
            if (CollectionUtils.isNotEmpty((Collection)collection) && MapUtils.isNotEmpty(allFields)) {
                for (DynamicObject dynamicObject : collection) {
                    WarnScheduleRelationReceiver relationReceiver;
                    String fieldKey = dynamicObject.getString(FIELD_FIELD);
                    if (StringUtils.isBlank((CharSequence)fieldKey) || (relationReceiver = allFields.get(fieldKey)) == null) continue;
                    receivers.add(relationReceiver);
                }
            }
            this.getView().returnDataToParent(receivers);
            this.getView().close();
        }
    }

    private Map<String, WarnScheduleRelationReceiver> getAllFields() {
        String fieldString = this.getPageCache().get(FIELD_CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)fieldString)) {
            return null;
        }
        List receiverList = SerializationUtils.fromJsonStringToList((String)fieldString, WarnScheduleRelationReceiver.class);
        return receiverList.stream().collect(Collectors.toMap(WarnScheduleRelationReceiver::getField, Function.identity(), (oldValue, newValue) -> newValue));
    }
}

