/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule.widget;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.schedule.bo.WSPeriodBo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.earlywarn.WarnScheduleMetaServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class WSEditDetailViewHolder {
    public static final String EARLY_WARN = "early_warn";
    private static final String BIZ_APP = "biz_app";
    public static final String MONITOR_PERIOD = "monitor_period";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ENABLE = "enable";
    private static final String BY_ENTRY = "byentry";
    private static final String DISABLE_INTEGRITY = "disableintegrity";
    private static final String WARN_EARLY_WARN = "warn_earlywarn";
    private static final String MASTER_ID = "master_id";
    private static final String LEAF = "leaf";
    private static final String CACHE_MONITOR_PERIOD = "monitor_period";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String LANG_COMBO = "langcombo";
    private IFormView view;
    private IDataModel model;
    private IPageCache cache;

    public WSEditDetailViewHolder(IFormView view, IDataModel model, IPageCache cache) {
        this.view = view;
        this.model = model;
        this.cache = cache;
    }

    public void init(WarnScheduleMetadata meta) {
        WarnSchedule schedule = meta.getWarnSchedule();
        this.model.setValue(ID, (Object)meta.getId());
        this.model.setValue(EARLY_WARN, (Object)this.getLeafEarlyWarn(schedule.getEarlyWarnId()));
        this.model.setValue(BIZ_APP, (Object)schedule.getBizAppId());
        this.model.setValue(NUMBER, (Object)meta.getNumber());
        this.model.setValue(NAME, (Object)meta.getName());
        this.model.setValue(ENABLE, (Object)schedule.isEnable());
        this.model.setValue(BY_ENTRY, (Object)schedule.isByEntry());
        this.model.setValue(DISABLE_INTEGRITY, (Object)schedule.isDisableIntegrity());
        this.setLangCombo();
    }

    private void setLangCombo() {
        List enabledLangs = InteServiceHelper.getMultiLangEnabledLang();
        ArrayList<ComboItem> langItems = new ArrayList<ComboItem>(10);
        for (EnabledLang enabledLang : enabledLangs) {
            ComboItem langItem = new ComboItem();
            langItem.setValue(enabledLang.getNumber());
            langItem.setCaption(new LocaleString(enabledLang.getName()));
            langItems.add(langItem);
        }
        ComboEdit langcombo = (ComboEdit)this.view.getControl(LANG_COMBO);
        langcombo.setComboItems(langItems);
        this.model.setValue(LANG_COMBO, (Object)Lang.get().toString());
    }

    private String getLeafEarlyWarn(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        DynamicObject curData = QueryServiceHelper.queryOne((String)WARN_EARLY_WARN, (String)this.getSelectFields(), (QFilter[])new QFilter(ID, "=", (Object)id).toArray());
        if (null == curData || curData.getBoolean(LEAF)) {
            return id;
        }
        QFilter leafQFilter = new QFilter(LEAF, "=", (Object)true);
        QFilter masterIdQFilter = new QFilter(MASTER_ID, "=", (Object)curData.getString(MASTER_ID));
        curData = QueryServiceHelper.queryOne((String)WARN_EARLY_WARN, (String)this.getSelectFields(), (QFilter[])new QFilter[]{masterIdQFilter, leafQFilter});
        return curData.getString(ID);
    }

    private String getSelectFields() {
        return "id,master_id,leaf";
    }

    public String getId() {
        return StringKit.toSafeString(this.model.getValue(ID));
    }

    public void changeEarlyWarn(DynamicObject earlyWarn) {
        if (earlyWarn == null) {
            return;
        }
        DynamicObject bizApp = earlyWarn == null ? null : earlyWarn.getDynamicObject("biz_app_id");
        this.model.setValue(BIZ_APP, (Object)bizApp);
    }

    public void changeMonitorPeriod(Map<String, Object> period) {
        WSPeriodBo periodBo = new WSPeriodBo(period);
        this.model.setValue("monitor_period", (Object)periodBo.getDescription());
        String json = JSONObject.toJSONString(period);
        this.cache.put("monitor_period", json);
    }

    public WSPeriodBo getMonitorPeriod() {
        String json = this.cache.get("monitor_period");
        if (StringKit.isBlank(json)) {
            return new WSPeriodBo();
        }
        JSONObject obj = JSONObject.parseObject((String)json);
        return new WSPeriodBo((Map<String, Object>)obj);
    }

    public String getDataSource() {
        DynamicObject earlyWarn = (DynamicObject)this.model.getValue(EARLY_WARN);
        DynamicObject dataSource = earlyWarn == null ? null : earlyWarn.getDynamicObject("data_source");
        return dataSource == null ? "" : dataSource.getString(NUMBER);
    }

    public boolean checkData() {
        String number = this.getNumber();
        if (StringKit.isBlank(number)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u76d1\u63a7\u65b9\u6848\u7f16\u7801\u3002", (String)"WSEditDetailViewHolder_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String id = this.getId();
        String tId = WarnScheduleMetaServiceHelper.getIdByNumber(number);
        if (StringKit.isNotBlank(tId) && !StringKit.equals(id, tId)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u88ab\u5176\u4ed6\u76d1\u63a7\u65b9\u6848\u4f7f\u7528\u3002", (String)"WSEditDetailViewHolder_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        LocaleString name = this.getName();
        if (null == name || name.isEmpty()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u76d1\u63a7\u65b9\u6848\u7684\u540d\u79f0\u3002", (String)"WSEditDetailViewHolder_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringKit.isBlank(this.getEarlyWarn())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u65b9\u6848\u5bf9\u5e94\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"WSEditDetailViewHolder_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringKit.isBlank(this.getBizAppId())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76d1\u63a7\u65b9\u6848\u5c5e\u4e1a\u52a1\u5e94\u7528\u3002", (String)"WSEditDetailViewHolder_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void assemble(WarnScheduleMetadata meta) {
        String id = this.getId();
        meta.setId(id);
        meta.setMasterId(id);
        meta.setInheritPath(id);
        meta.setNumber(this.getNumber());
        meta.setName(this.getName());
        WarnSchedule schedule = meta.getWarnSchedule();
        schedule.setEarlyWarnId(this.getRootEarlyWarn());
        schedule.setBizAppId(this.getBizAppId());
        schedule.setEnable(this.isEnable());
        schedule.setByEntry(this.isByEntry());
        schedule.setDisableIntegrity(this.isDisableIntegrity());
    }

    private String getNumber() {
        return StringKit.toSafeString(this.model.getValue(NUMBER));
    }

    private LocaleString getName() {
        OrmLocaleValue value = (OrmLocaleValue)this.model.getValue(NAME);
        if (null == value) {
            return null;
        }
        HashMap dataMap = new HashMap(16);
        for (Map.Entry entry : value.entrySet()) {
            dataMap.put(entry.getKey(), entry.getValue());
        }
        return LocaleString.fromMap(dataMap);
    }

    public String getEarlyWarn() {
        DynamicObject obj = (DynamicObject)this.model.getValue(EARLY_WARN);
        return obj == null ? "" : obj.getString(ID);
    }

    private String getRootEarlyWarn() {
        DynamicObject obj = (DynamicObject)this.model.getValue(EARLY_WARN);
        String masterId = obj.getString(MASTER_ID);
        return StringUtils.isBlank((CharSequence)masterId) ? obj.getString(ID) : masterId;
    }

    public String getBizAppId() {
        DynamicObject obj = (DynamicObject)this.model.getValue(BIZ_APP);
        return obj == null ? "" : obj.getString(ID);
    }

    public String getMonitorPeriodFormPage() {
        String monitorPeriod = (String)this.model.getValue("monitor_period");
        return monitorPeriod == null ? "" : monitorPeriod;
    }

    private boolean isEnable() {
        Boolean enable = (Boolean)this.model.getValue(ENABLE);
        return enable == null ? false : enable;
    }

    private boolean isByEntry() {
        Boolean byEntry = (Boolean)this.model.getValue(BY_ENTRY);
        return byEntry == null ? false : byEntry;
    }

    private boolean isDisableIntegrity() {
        Boolean disableIntegrity = (Boolean)this.model.getValue(DISABLE_INTEGRITY);
        return disableIntegrity == null ? false : disableIntegrity;
    }
}

