/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule.widget;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.schedule.bo.WSPeriodBo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.earlywarn.warnschedule.RunCycle;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriod;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCycleRangeType;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import org.apache.commons.collections4.MapUtils;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class WSPeriodDialogViewHolder {
    private static final String MONITOR_DESCRIPTION = "monitor_description";
    private static final String RANGE_TYPE = "range_type";
    private static final String START_DATE = "start_date";
    private static final String END_DATE = "end_date";
    private static final String PERIOD_TYPE = "period_type";
    private static final String PERIOD_WEEKS = "period_weeks";
    private static final String PERIOD_MONTH_DAYS = "period_month_days";
    private static final String PERIOD_CRON = "period_cron";
    private static final String PERIOD_MONTH = "period_month";
    private static final String PERIOD_REPEAT = "period_repeat";
    private static final String EXECUTE_TYPE = "execute_type";
    private static final String WHICH_WEEK = "which_week";
    private static final String PERIOD_SINGLE_WEEK = "period_single_week";
    private static final String RUN_TIME = "run_time";
    private static final String DATE_RANGE = "date_range";
    private static final String MONITOR_TIME_RANGE = "monitor_time_range";
    private static final String MONITOR_START_TIME = "monitor_start_time";
    private static final String FROM_START_DATE = "from_start_date";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private IDataModel model;
    private IFormView view;

    public WSPeriodDialogViewHolder(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    @Deprecated
    public void init() {
        this.initComboList();
    }

    public void init(WarnScheduleMetadata warnSchedule) {
        this.initComboList();
        RunCycle runCycle = warnSchedule.getWarnSchedule().getRunCycle();
        WSPeriodBo period = new WSPeriodBo(runCycle);
        this.show(period);
        if (DATE_RANGE.equals(period.getRangeType().getName())) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{MONITOR_START_TIME});
        } else if (FROM_START_DATE.equals(period.getRangeType().getName())) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{MONITOR_TIME_RANGE});
            this.model.getDataEntity().set(MONITOR_START_TIME, this.model.getDataEntity().get(START_DATE));
        }
    }

    private void initComboList() {
        ArrayList<ComboItem> periodTypeItems = new ArrayList<ComboItem>(10);
        for (RunCyclePeriodType v : RunCyclePeriodType.values()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(v.getName()));
            comboItem.setValue(v.getValue());
            periodTypeItems.add(comboItem);
        }
        ComboEdit periodType = (ComboEdit)this.view.getControl(PERIOD_TYPE);
        periodType.setComboItems(periodTypeItems);
        ArrayList<Object> weekItems = new ArrayList<Object>(10);
        RunCyclePeriod runCyclePeriod = new RunCyclePeriod();
        for (RunCyclePeriod v : runCyclePeriod.getWeeks()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(v.getName()));
            comboItem.setValue(v.getValue());
            weekItems.add(comboItem);
        }
        MulComboEdit weekCombo = (MulComboEdit)this.view.getControl(PERIOD_WEEKS);
        weekCombo.setComboItems(weekItems);
        ArrayList<Object> singleWeekItems = new ArrayList<Object>(10);
        for (RunCyclePeriod v : runCyclePeriod.getWeeks()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(v.getName()));
            comboItem.setValue(v.getValue());
            singleWeekItems.add(comboItem);
        }
        ComboEdit singleWeekCombo = (ComboEdit)this.view.getControl(PERIOD_SINGLE_WEEK);
        singleWeekCombo.setComboItems(singleWeekItems);
        ArrayList<Object> monthDaysItems = new ArrayList<Object>(10);
        for (RunCyclePeriod v : runCyclePeriod.getMonthDays()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(v.getName()));
            comboItem.setValue(v.getValue());
            monthDaysItems.add(comboItem);
        }
        MulComboEdit monthDayCombo = (MulComboEdit)this.view.getControl(PERIOD_MONTH_DAYS);
        monthDayCombo.setComboItems(monthDaysItems);
        ArrayList<ComboItem> monthItems = new ArrayList<ComboItem>(12);
        for (RunCyclePeriod month : runCyclePeriod.getMonths()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(month.getName()));
            comboItem.setValue(month.getValue());
            monthItems.add(comboItem);
        }
        MulComboEdit monthCombo = (MulComboEdit)this.view.getControl(PERIOD_MONTH);
        monthCombo.setComboItems(monthItems);
    }

    public void show(WSPeriodBo period) {
        String executeType;
        this.model.setValue(MONITOR_DESCRIPTION, (Object)period.getDescription());
        this.model.setValue(RANGE_TYPE, (Object)period.getRangeType());
        this.model.setValue(START_DATE, (Object)period.getStartDateStr());
        this.model.setValue(END_DATE, (Object)period.getEndDateStr());
        RunCyclePeriodType periodType = period.getPeriodType();
        this.model.setValue(PERIOD_TYPE, (Object)periodType.getValue());
        this.model.setValue(PERIOD_REPEAT, (Object)period.getPeriod());
        if (RunCyclePeriodType.Week == periodType) {
            String periodValue = period.getPeriodValueStr();
            this.model.setValue(PERIOD_WEEKS, (Object)periodValue);
        } else if (RunCyclePeriodType.Month == periodType) {
            executeType = period.getExecuteType();
            String periodValue = period.getPeriodValueStr();
            if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                this.model.setValue(WHICH_WEEK, (Object)period.getWhichNumber());
                this.model.setValue(PERIOD_SINGLE_WEEK, (Object)periodValue);
            } else {
                this.model.setValue(PERIOD_MONTH_DAYS, (Object)periodValue);
            }
            this.model.setValue(EXECUTE_TYPE, (Object)executeType);
        } else if (RunCyclePeriodType.Year == periodType) {
            executeType = period.getExecuteType();
            Map<String, String> periodValueStrMap = period.getPeriodValueStrMap();
            if (MapUtils.isNotEmpty(periodValueStrMap)) {
                this.model.setValue(PERIOD_MONTH, (Object)periodValueStrMap.get("month"));
                if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                    this.model.setValue(WHICH_WEEK, (Object)period.getWhichNumber());
                    this.model.setValue(PERIOD_SINGLE_WEEK, (Object)periodValueStrMap.get("dayOrWeek"));
                } else {
                    this.model.setValue(PERIOD_MONTH_DAYS, (Object)periodValueStrMap.get("dayOrWeek"));
                }
            }
            this.model.setValue(EXECUTE_TYPE, (Object)executeType);
        } else if (RunCyclePeriodType.Cron == periodType) {
            this.model.setValue(PERIOD_CRON, (Object)period.getCronExpr());
        }
        Integer runTime = period.getRunTime();
        this.model.setValue(RUN_TIME, (Object)(runTime == null ? "" : String.valueOf(runTime)));
        this.view.setEnable(Boolean.valueOf(false), new String[]{MONITOR_DESCRIPTION});
        this.refreshPeriodValueWidgets(periodType);
    }

    public WSPeriodBo buildPeriodData() {
        String executeType;
        WSPeriodBo period = new WSPeriodBo();
        String rangeType = StringKit.toSafeString(this.model.getValue(RANGE_TYPE));
        period.setRangeType(RunCycleRangeType.getByName(rangeType));
        Date startDate = FROM_START_DATE.equals(this.model.getDataEntity().get(RANGE_TYPE)) ? (Date)this.model.getDataEntity().get(MONITOR_START_TIME) : (Date)this.model.getValue(START_DATE);
        period.setStartDate(startDate);
        Date endDate = (Date)this.model.getValue(END_DATE);
        period.setEndDate(endDate);
        String periodTypeStr = StringKit.toSafeString(this.model.getValue(PERIOD_TYPE));
        RunCyclePeriodType periodType = RunCyclePeriodType.getByValue(periodTypeStr);
        period.setPeriodType(periodType);
        period.setPeriod((Integer)this.model.getValue(PERIOD_REPEAT));
        List<Object> periodValues = new ArrayList();
        if (RunCyclePeriodType.Week == periodType) {
            String periodWeekValue = StringKit.toSafeString(this.model.getValue(PERIOD_WEEKS));
            periodValues = RunCyclePeriod.getList(periodWeekValue);
        } else if (RunCyclePeriodType.Month == periodType) {
            executeType = StringKit.toSafeString(this.model.getValue(EXECUTE_TYPE));
            if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                period.setWhichNumber(StringKit.toSafeString(this.model.getValue(WHICH_WEEK)));
                periodValues = RunCyclePeriod.getList(StringKit.toSafeString(this.model.getValue(PERIOD_SINGLE_WEEK)));
            } else {
                String periodMonthValue = StringKit.toSafeString(this.model.getValue(PERIOD_MONTH_DAYS));
                periodValues = RunCyclePeriod.getList(periodMonthValue);
            }
            period.setExecuteType(executeType);
        } else if (RunCyclePeriodType.Year == periodType) {
            executeType = StringKit.toSafeString(this.model.getValue(EXECUTE_TYPE));
            String periodMonth = StringKit.toSafeString(this.model.getValue(PERIOD_MONTH));
            periodValues.addAll(RunCyclePeriod.getList(periodMonth));
            if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                period.setWhichNumber(StringKit.toSafeString(this.model.getValue(WHICH_WEEK)));
                periodValues.addAll(RunCyclePeriod.getList(StringKit.toSafeString(this.model.getValue(PERIOD_SINGLE_WEEK))));
            } else {
                String periodDay = StringKit.toSafeString(this.model.getValue(PERIOD_MONTH_DAYS));
                periodValues.addAll(RunCyclePeriod.getList(periodDay));
            }
            period.setExecuteType(executeType);
        } else if (RunCyclePeriodType.Cron == periodType) {
            String cronValue = (String)this.model.getValue(PERIOD_CRON);
            period.setCronExpr(cronValue);
        }
        period.setPeriodValues(periodValues);
        String runTimeStr = StringKit.toSafeString(this.model.getValue(RUN_TIME));
        Integer runTime = StringKit.isBlank(runTimeStr) ? null : Integer.valueOf(runTimeStr);
        period.setRunTime(runTime);
        return period;
    }

    public void propertyChange(IDataEntityProperty property, ChangeData data) {
        String oldVal;
        String newVal = StringKit.toSafeString(data.getNewValue());
        if (newVal.equals(oldVal = StringKit.toSafeString(data.getOldValue()))) {
            return;
        }
        String name = property.getName();
        if (PERIOD_TYPE.equals(name)) {
            String periodType = StringKit.toSafeString(this.model.getValue(PERIOD_TYPE));
            this.refreshPeriodValueWidgets(RunCyclePeriodType.getByValue(periodType));
        }
        if (StringUtils.equals((CharSequence)EXECUTE_TYPE, (CharSequence)name)) {
            this.refreshExecuteType();
        }
        WSPeriodBo period = this.buildPeriodData();
        this.model.setValue(MONITOR_DESCRIPTION, (Object)period.getDescription());
        this.view.updateView(MONITOR_DESCRIPTION);
        this.view.updateView(MONITOR_TIME_RANGE);
        this.view.updateView(MONITOR_START_TIME);
    }

    public void assemble(WarnScheduleMetadata metadata) {
        WSPeriodBo wsPeriodBo = this.buildPeriodData();
        metadata.getWarnSchedule().setRunCycle(wsPeriodBo.convertToRunCycle());
    }

    private void refreshPeriodValueWidgets(RunCyclePeriodType periodType) {
        if (RunCyclePeriodType.Minute == periodType) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_WEEKS, PERIOD_MONTH_DAYS, PERIOD_CRON, PERIOD_MONTH, EXECUTE_TYPE, WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_REPEAT, RUN_TIME});
            this.view.setEnable(Boolean.valueOf(true), new String[]{PERIOD_REPEAT});
            return;
        }
        if (RunCyclePeriodType.Hour == periodType) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_WEEKS, PERIOD_MONTH_DAYS, PERIOD_CRON, PERIOD_MONTH, EXECUTE_TYPE, WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_REPEAT, RUN_TIME});
            this.view.setEnable(Boolean.valueOf(true), new String[]{PERIOD_REPEAT});
            return;
        }
        if (RunCyclePeriodType.Day == periodType) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_WEEKS, PERIOD_MONTH_DAYS, PERIOD_CRON, PERIOD_MONTH, EXECUTE_TYPE, WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setVisible(Boolean.valueOf(true), new String[]{RUN_TIME, PERIOD_REPEAT});
            this.view.setEnable(Boolean.valueOf(true), new String[]{PERIOD_REPEAT});
            return;
        }
        if (RunCyclePeriodType.Week == periodType) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_WEEKS, RUN_TIME, PERIOD_REPEAT});
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_MONTH_DAYS, PERIOD_CRON, PERIOD_MONTH, EXECUTE_TYPE, WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setEnable(Boolean.valueOf(false), new String[]{PERIOD_REPEAT});
            return;
        }
        if (RunCyclePeriodType.Month == periodType) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{RUN_TIME, PERIOD_REPEAT, EXECUTE_TYPE});
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_WEEKS, PERIOD_CRON, PERIOD_MONTH});
            this.view.setEnable(Boolean.valueOf(true), new String[]{PERIOD_REPEAT});
            this.refreshExecuteType();
            return;
        }
        if (RunCyclePeriodType.Year == periodType) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_MONTH, RUN_TIME, PERIOD_REPEAT, EXECUTE_TYPE});
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_CRON, PERIOD_WEEKS});
            this.view.setEnable(Boolean.valueOf(false), new String[]{PERIOD_REPEAT});
            this.refreshExecuteType();
            return;
        }
        if (RunCyclePeriodType.Cron == periodType) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_REPEAT, PERIOD_WEEKS, PERIOD_MONTH_DAYS, PERIOD_MONTH, PERIOD_MONTH, EXECUTE_TYPE, WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_CRON});
        }
    }

    private void refreshExecuteType() {
        String executeType = StringKit.toSafeString(this.model.getValue(EXECUTE_TYPE));
        if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{WHICH_WEEK, PERIOD_SINGLE_WEEK});
            this.view.setVisible(Boolean.valueOf(false), new String[]{PERIOD_MONTH_DAYS});
            return;
        }
        this.view.setVisible(Boolean.valueOf(false), new String[]{WHICH_WEEK, PERIOD_SINGLE_WEEK});
        this.view.setVisible(Boolean.valueOf(true), new String[]{PERIOD_MONTH_DAYS});
    }

    public boolean checkData() {
        WSPeriodBo period = this.buildPeriodData();
        if (null == period.getRangeType()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5468\u671f\u8bbe\u5b9a\u3002", (String)"WSPeriodDialogViewHolder_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (null == period.getStartDate()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u65f6\u95f4\u8303\u56f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"WSPeriodDialogViewHolder_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (RunCycleRangeType.DateRange == period.getRangeType() && null == period.getEndDate()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u65f6\u95f4\u8303\u56f4\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"WSPeriodDialogViewHolder_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (null == period.getPeriodType()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u3002", (String)"WSPeriodDialogViewHolder_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (period.getPeriod() <= 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u91cd\u590d\u5468\u671f\u3002", (String)"WSPeriodDialogViewHolder_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (RunCyclePeriodType.Week == period.getPeriodType()) {
            if (CollectionKit.isEmpty(period.getPeriodValues())) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6bcf\u5468\u9700\u8981\u6267\u884c\u7684\u661f\u671f\u3002", (String)"WSPeriodDialogViewHolder_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        } else if (RunCyclePeriodType.Month == period.getPeriodType()) {
            String executeType = period.getExecuteType();
            if (StringUtils.equals((CharSequence)"by_week", (CharSequence)executeType) && null == this.model.getValue(WHICH_WEEK)) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c\u51e0\u5468\u3002", (String)"WSPeriodDialogViewHolder_8", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            if (CollectionKit.isEmpty(period.getPeriodValues())) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6708\u9700\u8981\u6267\u884c\u7684\u65e5\u671f\u3002", (String)"WSPeriodDialogViewHolder_5", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        } else if (RunCyclePeriodType.Year == period.getPeriodType()) {
            if (null == this.model.getValue(PERIOD_MONTH)) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6bcf\u5e74\u9700\u8981\u6267\u884c\u7684\u6708\u3002", (String)"WSPeriodDialogViewHolder_9", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            String executeType = period.getExecuteType();
            if (StringUtils.equals((CharSequence)"by_day", (CharSequence)executeType) && null == this.model.getValue(PERIOD_MONTH_DAYS) || StringUtils.equals((CharSequence)"by_week", (CharSequence)executeType) && (null == this.model.getValue(WHICH_WEEK) || null == this.model.getValue(PERIOD_SINGLE_WEEK))) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6bcf\u5e74\u9700\u8981\u6267\u884c\u7684\u65e5\u671f\u3002", (String)"WSPeriodDialogViewHolder_10", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        if (null == period.getRunTime()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6267\u884c\u65f6\u95f4\u3002", (String)"WSPeriodDialogViewHolder_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return RunCyclePeriodType.Cron != period.getPeriodType() || this.checkCron(period.getCronExpr());
    }

    public boolean checkCron(String cron) {
        try {
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"WarnSchedulePeriodDialogPlugin_5", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception e) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"corn\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u4fee\u6539\u3002", (String)"WarnSchedulePeriodDialogPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

