/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import kd.bos.util.CollectionUtils;

public class TreeNodeUtils {
    public static void removeNullChildNode(TreeNode node) {
        if (node.getChildren() != null) {
            node.getChildren().removeIf(childNode -> CollectionUtils.isEmpty((Collection)childNode.getChildren()));
        }
    }

    public static void filtrationAppById(TreeNode node, String[] appIds) {
        TreeNodeUtils.removeNullChildNode(node);
        if (appIds == null) {
            return;
        }
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                List children = childNode.getChildren();
                for (String appId : appIds) {
                    children.removeIf(appNode -> !appId.equals(appNode.getId()));
                }
            }
        }
        TreeNodeUtils.removeNullChildNode(node);
    }

    public static List<TreeNode> filterCloudTreeNode(List<TreeNode> clouds) {
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        return treeNodeFilter.filterCloudTreeNode(clouds, true);
    }

    public static boolean isUseNewAppInfo() {
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        return Boolean.parseBoolean(customParameter.getOrDefault("SVC_IS_USE_NEW_APP_INFO", "true"));
    }
}

