/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermission;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermissionEnum;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.warn.EarlyWarnXmlEditPlugin;
import kd.bos.designer.earlywarn.warn.kit.IdePluginKit;
import kd.bos.designer.earlywarn.warn.widget.EarlyWarnDesignerEditHolder;
import kd.bos.designer.earlywarn.warn.widget.EarlyWarnDesignerTreeHolder;
import kd.bos.designer.earlywarn.warn.widget.WarnTreeDataNode;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMeta;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnTemplate;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class EarlyWarnDesignerEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String FORM_NUMBER = "warn_earlywarn_designer";
    private static final String FORM_PARAM_NUMBER = "number";
    private static final String FORM_PARAM_NAME = "name";
    private static final String FORM_PARAM_DATA_SOURCE = "data_source";
    private static final String FORM_PARAM_CONDITION_FORM = "condition_form";
    private static final String FORM_PARAM_PLUGIN_GET_DATA = "plugin_get_data";
    private static final String FORM_PARAM_PLUGIN_WRITE_OUT = "plugin_write_out";
    private static final String FORM_PARAM_PLUGIN_MESSAGE_COMPILER = "plugin_message_compiler";
    private static final String FORM_PARAM_PLUGIN_MESSAGE_HANDLER = "plugin_message_handler";
    private static final String FORM_PARAM_PLUGIN_CUSTOM_RECEIVER = "plugin_custom_receiver";
    private static final String[] FORM_PARAM_ALL = new String[]{"number", "name", "data_source", "condition_form", "plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver"};
    private static final String EARLY_WARN_DESIGNER_EDIT_PLUGIN_7 = "EarlyWarnDesignerEditPlugin_7";
    private static final String APPID = "cts";
    private static final String ENTITY_NAME = "warn_earlywarn";
    private static final String EARLYWARN_NUMBER = "number";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    protected static final List<String> PLUGINS = Arrays.asList("plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver");
    private EarlyWarnDesignerEditHolder editHolder;
    private EarlyWarnDesignerTreeHolder treeHolder;
    private static Log log = LogFactory.getLog(EarlyWarnDesignerEditPlugin.class);

    public void initialize() {
        super.initialize();
        this.editHolder = new EarlyWarnDesignerEditHolder(this.getModel(), this.getView());
        this.treeHolder = new EarlyWarnDesignerTreeHolder(this.getView(), this.getPageCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbar_treeview"});
        TreeView treeView = (TreeView)this.getView().getControl("tree_view");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{FORM_PARAM_PLUGIN_GET_DATA, FORM_PARAM_PLUGIN_WRITE_OUT, FORM_PARAM_PLUGIN_MESSAGE_COMPILER, FORM_PARAM_PLUGIN_MESSAGE_HANDLER, FORM_PARAM_PLUGIN_CUSTOM_RECEIVER});
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            return;
        }
        if (!this.checkEditData()) {
            return;
        }
        this.saveCurrent();
        this.treeHolder.focusNode(nodeId);
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        WarnTreeDataNode currentNode = rootNode.findById(nodeId);
        this.editHolder.setEditNode(currentNode);
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (PLUGINS.contains(key)) {
            Object val = this.getModel().getValue(key);
            String formId = this.getView().getFormShowParameter().getFormId();
            List<?> plugins = IdePluginKit.getPluginsArray(val);
            FormShowParameter showParam = IdePluginKit.buildShowParams(formId, plugins, new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(showParam);
            return;
        }
    }

    private void doSaveAll() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.SAVE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"EarlyWarnDesignerEditPlugin_32", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (!this.checkEditData()) {
            return;
        }
        this.saveCurrent();
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        List<WarnTreeDataNode> allNodes = rootNode.getAllChildNodes();
        ArrayList<EarlyWarnMetadata> saveList = new ArrayList<EarlyWarnMetadata>();
        ArrayList<EarlyWarnMetadata> modifyList = new ArrayList<EarlyWarnMetadata>();
        ArrayList<EarlyWarnMetadata> addList = new ArrayList<EarlyWarnMetadata>();
        ArrayList<String> deleteList = new ArrayList<String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashSet<String> entityObjectIds = new HashSet<String>();
        for (WarnTreeDataNode node : allNodes) {
            String conditionFormId;
            if (node.isDeleted()) {
                deleteList.add(node.getId());
                continue;
            }
            EarlyWarnMetadata meta = node.deserialize();
            meta.setLeaf(node.isLeaf());
            saveList.add(meta);
            if (node.isNew()) {
                addList.add(meta);
            } else {
                modifyList.add(meta);
            }
            numberMap.put(meta.getNumber(), meta.getId());
            String dataSourceId = meta.getWarnElement().getDataSourceId();
            if (!StringUtils.isEmpty((String)dataSourceId)) {
                entityObjectIds.add(dataSourceId);
            }
            if (StringUtils.isEmpty((String)(conditionFormId = meta.getWarnElement().getConditionFormId()))) continue;
            entityObjectIds.add(conditionFormId);
        }
        if (!this.checkNumbers(saveList, numberMap)) {
            return;
        }
        if (!this.checkEntityObjects(saveList, entityObjectIds)) {
            return;
        }
        for (EarlyWarnMetadata meta : modifyList) {
            EarlyWarnMetaServicHelper.save(meta);
        }
        for (EarlyWarnMetadata meta : addList) {
            EarlyWarnMetaServicHelper.save(meta);
        }
        EarlyWarnMetaServicHelper.delete(deleteList);
        EarlyWarnMetadata firstMeta = saveList.isEmpty() ? null : (EarlyWarnMetadata)((Object)saveList.get(0));
        String masterId = firstMeta == null ? "" : firstMeta.getMasterId();
        String currentId = firstMeta == null ? "" : firstMeta.getId();
        this.treeHolder.buildTreeNodes(masterId, currentId);
        rootNode = this.treeHolder.getRootTreeNode();
        WarnTreeDataNode currentNode = rootNode.findById(currentId);
        this.editHolder.setEditNode(currentNode);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EarlyWarnDesignerEditPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        ListView parentView = (ListView)this.getView().getParentView();
        parentView.refresh();
        this.getView().sendFormAction((IFormView)parentView);
        this.getModel().setDataChanged(false);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "EarlyWarnCommon_Save", BOS_EARLYWARN);
        logInfo.setOpName("save", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "EarlyWarnDesignerEditPlugin_0", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private LocaleString getLocaleStringName() {
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(FORM_PARAM_NAME);
        HashMap<String, String> localNameMap = new HashMap<String, String>(16);
        for (String loId : name.keySet()) {
            localNameMap.put(loId, name.get((Object)loId));
        }
        return LocaleString.fromMap(localNameMap);
    }

    private boolean checkNumbers(List<EarlyWarnMetadata> list, Map<String, String> numberMap) {
        if (numberMap.isEmpty()) {
            return true;
        }
        for (EarlyWarnMetadata meta : list) {
            if (this.checkSingleNumber(meta, numberMap)) continue;
            return false;
        }
        if (!this.checkSingleNumberLength(numberMap.keySet())) {
            return false;
        }
        DynamicObject[] existNumbers = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", numberMap.keySet())});
        if (null == existNumbers || existNumbers.length == 0) {
            return true;
        }
        numberMap = new HashMap<String, String>(16);
        for (DynamicObject obj : existNumbers) {
            numberMap.put(obj.getString("number"), obj.getString("id"));
        }
        for (EarlyWarnMetadata meta : list) {
            if (this.checkSingleNumber(meta, numberMap)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSingleNumberLength(Set<String> keySet) {
        for (String s : keySet) {
            try {
                if (s.getBytes("utf-8").length <= 36) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc736\u5b57\u8282(UTF-8)\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"EarlyWarnDesignerEditPlugin_29", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean checkSingleNumber(EarlyWarnMetadata meta, Map<String, String> metaMap) {
        boolean flag;
        String tId = metaMap.get(meta.getNumber());
        boolean bl = flag = !StringUtils.isEmpty((String)tId) && !tId.equals(meta.getId());
        if (flag) {
            String msg = String.format(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61%1$s\u7684\u7f16\u7801:%2$s\u5df2\u7ecf\u88ab\u5176\u4ed6\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4f7f\u7528\u3002", (String)"EarlyWarnDesignerEditPlugin_40", (String)BOS_EARLYWARN, (Object[])new Object[0]), meta.getName().getLocaleValue(), meta.getNumber());
            this.getView().showTipNotification(msg);
        }
        return !flag;
    }

    private boolean checkEntityObjects(List<EarlyWarnMetadata> saveList, Set<String> entityObjectIds) {
        if (saveList.isEmpty() || entityObjectIds.isEmpty()) {
            return true;
        }
        DynamicObject[] entityObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", entityObjectIds)});
        HashSet<String> existEntityObjectIds = new HashSet<String>();
        if (null != entityObjects) {
            for (DynamicObject obj : entityObjects) {
                existEntityObjectIds.add(obj.getString("number"));
            }
        }
        for (EarlyWarnMetadata meta : saveList) {
            String dataSourceId = meta.getWarnElement().getDataSourceId();
            if (!StringUtils.isEmpty((String)dataSourceId) && !existEntityObjectIds.contains(dataSourceId)) {
                String msg = String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u9884\u8b66\u5bf9\u8c61%1$s\u8bbe\u7f6e\u7684\u6570\u636e\u6e90\uff1a%2$s\u3002", (String)"EarlyWarnDesignerEditPlugin_41", (String)BOS_EARLYWARN, (Object[])new Object[0]), meta.getName().getLocaleValue(), dataSourceId);
                this.getView().showTipNotification(msg);
                return false;
            }
            String conditionFormId = meta.getWarnElement().getConditionFormId();
            if (!StringUtils.isEmpty((String)conditionFormId) && !existEntityObjectIds.contains(conditionFormId)) {
                String msg = String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u9884\u8b66\u5bf9\u8c61%1$s\u8bbe\u7f6e\u7684\u6761\u4ef6\u8868\u5355\uff1a%2$s\u3002", (String)"EarlyWarnDesignerEditPlugin_42", (String)BOS_EARLYWARN, (Object[])new Object[0]), meta.getName().getLocaleValue(), conditionFormId);
                this.getView().showTipNotification(msg);
                return false;
            }
            if (this.singleMetaCheck(meta)) continue;
            return false;
        }
        return true;
    }

    private String getTipMsg(String warnObjName, String tipContent) {
        return String.format(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61\uff1a%1$s%2$s", (String)"EarlyWarnDesignerEditPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]), warnObjName, tipContent);
    }

    private boolean singleMetaCheck(EarlyWarnMetadata meta) {
        String name = meta.getName().getLocaleValue();
        EarlyWarnElement element = meta.getWarnElement();
        List<EWPlugin> dataSources = element.getDataSources();
        if (StringKit.isBlank(element.getDataSourceId()) && dataSources.isEmpty()) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6570\u636e\u6e90\u6216\u6ce8\u518c\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"EarlyWarnDesignerEditPlugin_8", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        if (StringKit.isNotBlank(element.getConditionFormId()) && dataSources.isEmpty()) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u8868\u5355\u9700\u8981\u4e0e\u6570\u636e\u6e90\u63d2\u4ef6\u914d\u5408\u4f7f\u7528\uff0c\u8bf7\u6ce8\u518c\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"EarlyWarnDesignerEditPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        if (!dataSources.isEmpty() && this.plugInLengthCheckFail(element.getDataSources())) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u63d2\u4ef6\u751f\u6548\u3002", (String)"EarlyWarnDesignerEditPlugin_10", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        if (!element.getWriteOuts().isEmpty() && this.plugInLengthCheckFail(element.getWriteOuts())) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u6570\u636e\u5199\u51fa\u63d2\u4ef6\u91c7\u7528\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u4ec5\u5141\u8bb8\u4e00\u4e2a\u63d2\u4ef6\u751f\u6548\u3002", (String)"EarlyWarnDesignerEditPlugin_12", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        if (!element.getMessageCompilers().isEmpty() && this.plugInLengthCheckFail(element.getMessageCompilers())) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u6d88\u606f\u7f16\u8bd1\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u4ec5\u53ef\u751f\u6548\u4e00\u4e2a\u63d2\u4ef6\u3002", (String)"EarlyWarnDesignerEditPlugin_14", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        if (!element.getMessageHandlers().isEmpty() && this.plugInLengthCheckFail(element.getMessageHandlers())) {
            this.getView().showTipNotification(this.getTipMsg(name, ResManager.loadKDString((String)"\u6d88\u606f\u5904\u7406\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u8bf7\u8fdb\u884c\u68c0\u67e5\u3002", (String)"EarlyWarnDesignerEditPlugin_16", (String)BOS_EARLYWARN, (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    private boolean plugInLengthCheckFail(List<EWPlugin> plugins) {
        long count = plugins.stream().filter(d -> d.isEnabled()).count();
        return count > 1L;
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "btn_save": {
                this.doSaveAll();
                break;
            }
            case "btn_extend": {
                this.doExtend();
                break;
            }
            case "btn_del": {
                this.doDelete();
                break;
            }
            case "btn_xml": {
                this.doShowXml();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getPageCache().get("close") == null && this.getModel().getDataChanged()) {
            e.setCancel(true);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"EarlyWarnDesignerEditPlugin_25", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"EarlyWarnDesignerEditPlugin_26", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"EarlyWarnDesignerEditPlugin_27", (String)BOS_EARLYWARN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, String.valueOf(this.getModel().getChangeDesc()), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener("continue_close", (IFormPlugin)this), btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("continue_close".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("close", "");
            this.getView().close();
        }
    }

    private void doDelete() {
        String currentId;
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.DELETE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u5220\u9664", (String)"EarlyWarnDesignerEditPlugin_33", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        WarnTreeDataNode currentNode = rootNode.findById(currentId = this.treeHolder.getCurrentTreeNodeId());
        if (StringUtils.isEmpty((String)currentNode.getParentId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EarlyWarnDesignerEditPlugin_18", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (!currentNode.isCanModify()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EarlyWarnDesignerEditPlugin_19", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        this.treeHolder.deleteNode(currentId);
        WarnTreeDataNode parentNode = rootNode.findById(currentNode.getParentId());
        this.treeHolder.focusNode(parentNode.getId());
        this.editHolder.setEditNode(parentNode);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "EarlyWarnCommon_Delete", BOS_EARLYWARN);
        logInfo.setOpName("delete", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "EarlyWarnDesignerEditPlugin_34", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private void doExtend() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.EXTEND, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u6269\u5c55", (String)"EarlyWarnDesignerEditPlugin_38", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (!this.checkEditData()) {
            return;
        }
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        if (rootNode.getAllChildNodes().size() >= 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u6700\u591a\u5141\u8bb8\u6269\u5c5510\u6b21\u3002", (String)"EarlyWarnDesignerEditPlugin_31", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String newNodeNumber = this.getModel().getValue("number") + "_extend";
        try {
            if (newNodeNumber.getBytes("utf-8").length > 36) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61\u7f16\u7801\u8fc7\u957f\uff0c\u8bf7\u7f29\u77ed\u7f16\u7801\u957f\u5ea6\uff0c\u5426\u5219\u65e0\u6cd5\u4fdd\u5b58\u5165\u5e93\u3002", (String)"EarlyWarnDesignerEditPlugin_28", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        WarnTreeDataNode currentNode = this.saveCurrent();
        if (!currentNode.isLeaf()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u53ea\u80fd\u6269\u5c55\u4e00\u6b21\u3002", (String)"EarlyWarnDesignerEditPlugin_20", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        WarnTreeDataNode newNode = this.treeHolder.extendNode(currentNode);
        this.editHolder.setEditNode(newNode);
        this.getView().updateView();
    }

    private Boolean permissionVerification(String operation) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        switch (operation) {
            case "extend": {
                Boolean hasNewPermission = PermissionServiceHelper.hasNewPermission((long)userId, (String)APPID, (String)ENTITY_NAME);
                Boolean hasModifyPermission = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)APPID, (String)ENTITY_NAME, (String)"4715a0df000000ac");
                return hasNewPermission != false && hasModifyPermission != false;
            }
            case "delete": {
                return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)APPID, (String)ENTITY_NAME, (String)"4715e1f1000000ac");
            }
        }
        return false;
    }

    private boolean checkEditData() {
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        String currentId = this.treeHolder.getCurrentTreeNodeId();
        WarnTreeDataNode currentNode = rootNode.findById(currentId);
        String number = this.editHolder.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u7f16\u7801\u3002", (String)"EarlyWarnDesignerEditPlugin_21", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        boolean isNumberConflict = false;
        if (!number.equals(currentNode.getNumber())) {
            WarnTreeDataNode cacheTmp = rootNode.findByNumber(number);
            if (null != cacheTmp) {
                isNumberConflict = true;
            } else {
                EarlyWarnMetadata metadata = EarlyWarnMetaServicHelper.loadMetaByNumber(number, false);
                boolean bl = isNumberConflict = metadata != null;
            }
        }
        if (isNumberConflict) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u7ecf\u88ab\u5176\u4ed6\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4f7f\u7528\u3002", (String)"EarlyWarnDesignerEditPlugin_22", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        OrmLocaleValue name = this.editHolder.getName();
        if (null == name || name.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u540d\u79f0\u3002", (String)"EarlyWarnDesignerEditPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        EarlyWarnMetadata meta = currentNode.deserialize();
        this.editHolder.updateMeta(meta);
        return this.singleMetaCheck(meta);
    }

    private WarnTreeDataNode saveCurrent() {
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        String currentId = this.treeHolder.getCurrentTreeNodeId();
        WarnTreeDataNode currentNode = rootNode.findById(currentId);
        currentNode.setModified(true);
        EarlyWarnMetadata meta = currentNode.deserialize();
        if (currentNode.isCanModify()) {
            meta = this.editHolder.updateMeta(meta);
            currentNode.setName(meta.getName().getLocaleValue());
            currentNode.setFormName(this.getLocaleStringName());
        }
        String currentIsv = ISVService.getISVInfo().getId();
        String designJson = WarnTreeDataNode.buildDesignJson(new EarlyWarnTemplate(), meta, currentIsv);
        currentNode.setDesignJson(designJson);
        this.treeHolder.updateTreeDataNodeCache(rootNode);
        return currentNode;
    }

    private void doShowXml() {
        String currentId;
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        WarnTreeDataNode currentNode = rootNode.findById(currentId = this.treeHolder.getCurrentTreeNodeId());
        if (null == currentNode) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770bXML\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarnDesignerEditPlugin_24", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        WarnTreeDataNode parentNode = rootNode.findById(currentNode.getParentId());
        EarlyWarnTemplate template = new EarlyWarnTemplate();
        EarlyWarnMetadata currentMeta = currentNode.deserialize();
        EarlyWarnMetadata parentMeta = parentNode == null ? null : parentNode.deserialize();
        String xml = template.buildDiffXml(currentMeta, parentMeta, false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "btn_xml");
        FormShowParameter showParam = EarlyWarnXmlEditPlugin.show(xml, !currentNode.isCanModify(), callBack);
        this.getView().showForm(showParam);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParams = this.getView().getFormShowParameter();
        String number = (String)showParams.getCustomParam("number");
        EarlyWarnMetadata rootMeta = EarlyWarnMetaServicHelper.loadMetaByNumber(number, false);
        if (rootMeta == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EarlyWarnDesignerEditPlugin_43", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String masterId = rootMeta == null ? "" : rootMeta.getMasterId();
        String currentId = rootMeta == null ? "" : rootMeta.getId();
        this.treeHolder.buildTreeNodes(masterId, currentId);
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        currentId = this.treeHolder.getCurrentTreeNodeId();
        WarnTreeDataNode currentNode = rootNode.findById(currentId);
        this.editHolder.setEditNode(currentNode);
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.MODIFY, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.getView().setEnable(Boolean.FALSE, FORM_PARAM_ALL);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((String)actionId) || null == returnData) {
            return;
        }
        if (PLUGINS.contains(actionId)) {
            Map dataMap = (Map)returnData;
            List plugins = (List)dataMap.get("value");
            this.getModel().setValue(actionId, (Object)IdePluginKit.getJson(plugins));
            return;
        }
        if ("btn_xml".equals(actionId)) {
            this.updateXml((String)returnData);
        }
    }

    private void updateXml(String xml) {
        if (StringUtils.isEmpty((String)xml)) {
            return;
        }
        WarnTreeDataNode rootNode = this.treeHolder.getRootTreeNode();
        String currentId = this.treeHolder.getCurrentTreeNodeId();
        WarnTreeDataNode currentNode = rootNode.findById(currentId);
        WarnTreeDataNode parentNode = rootNode.findById(currentNode.getParentId());
        EarlyWarnTemplate template = new EarlyWarnTemplate();
        EarlyWarnMetadata parentMeta = parentNode == null ? null : parentNode.deserialize();
        EarlyWarnMetadata newMeta = template.getMetadata(xml, parentMeta);
        DesignEarlyWarnMeta designMeta = currentNode.getDesignMeta();
        newMeta.convertFromDesignMeta(designMeta);
        String fullXml = template.buildDiffXml(newMeta, null, false);
        designMeta.setDataXml(fullXml);
        String designJson = SerializationUtils.toJsonString((Object)((Object)designMeta));
        currentNode.setDesignJson(designJson);
        currentNode.setModified(true);
        this.treeHolder.updateTreeDataNodeCache(rootNode);
        this.editHolder.setEditNode(currentNode);
    }

    public static FormShowParameter show(String number) {
        FormShowParameter params = new FormShowParameter();
        params.setFormId(FORM_NUMBER);
        params.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        params.setCustomParam("number", (Object)number);
        return params;
    }

    private void showNoPermissionErrorNotification(String opName) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u3002", (String)"EarlyWarnDesignerEditPlugin_39", (String)BOS_EARLYWARN, (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption(), opName));
    }
}

