/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.warn.kit.IdePluginKit;
import kd.bos.designer.earlywarn.warn.widget.EarlyWarnHolder;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnWriter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.util.StringUtils;

public class EarlyWarnNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(EarlyWarnNewPlugin.class);
    private static final String DATA_SOURCE = "data_source";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String BTN_SAVE = "btn_save";
    private static final String FORM_NUMBER = "warn_earlywarn_new";
    private static final String FORM_PARAM_BIZ_APP_ID = "bizAppId";
    private static final String BIZ_APP = "biz_app";
    protected static final List<String> PLUGINS = Arrays.asList("plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver");
    private EarlyWarnHolder modelHolder;

    public void initialize() {
        super.initialize();
        this.modelHolder = new EarlyWarnHolder(this.getModel());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ftargetbill = (BasedataEdit)this.getView().getControl(DATA_SOURCE);
        if (ftargetbill != null) {
            ftargetbill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BTN_SAVE, "plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            this.doSave();
            return;
        }
        if (PLUGINS.contains(key)) {
            Object val = this.getModel().getValue(key);
            List<?> plugins = IdePluginKit.getPluginsArray(val);
            String formId = this.getView().getFormShowParameter().getFormId();
            FormShowParameter showParam = IdePluginKit.buildShowParams(formId, plugins, new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm(showParam);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeName = e.getProperty().getName();
        if (DATA_SOURCE.equals(changeName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue instanceof DynamicObject) {
                String newNumber = (String)((DynamicObject)newValue).get("number");
                DynamicObject newObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)FORM_PARAM_BIZ_APP_ID, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)newNumber)});
                DynamicObject newAppInfo = (DynamicObject)newObject.get(FORM_PARAM_BIZ_APP_ID);
                DynamicObject oldAppInfo = this.getModel().getDataEntity().getDynamicObject(BIZ_APP);
                if (newAppInfo != null && oldAppInfo != null && !newAppInfo.getPkValue().equals(oldAppInfo.getPkValue())) {
                    this.getModel().setValue(BIZ_APP, newAppInfo.getPkValue());
                } else if (oldAppInfo == null && newAppInfo != null) {
                    this.getModel().setValue(BIZ_APP, newAppInfo.getPkValue());
                }
            }
        } else if (BIZ_APP.equals(changeName)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
                Object newSourcePk;
                Object oldSourcePk = ((DynamicObject)oldValue).getPkValue();
                if (!oldSourcePk.equals(newSourcePk = ((DynamicObject)newValue).getPkValue())) {
                    this.getModel().setValue(DATA_SOURCE, null);
                }
            } else if (newValue == null && oldValue != null) {
                this.getModel().setValue(DATA_SOURCE, null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object bizapp = this.getModel().getValue(BIZ_APP);
        if (bizapp != null) {
            String appid = (String)((DynamicObject)bizapp).get("id");
            if (DATA_SOURCE.equals(e.getProperty().getName())) {
                ListShowParameter paramter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = paramter.getListFilterParameter();
                List qfilters = filterParam.getQFilters();
                QFilter qfilter = new QFilter("bizappid", "=", (Object)appid);
                if (!qfilters.isEmpty()) {
                    ((QFilter)qfilters.get(0)).and(qfilter);
                } else {
                    qfilters.add(qfilter);
                }
                paramter.setCustomParam("pagetype", (Object)"extend");
                paramter.setCustomParam("refappid", (Object)appid);
            }
        }
    }

    private void doSave() {
        if (!this.checkFields()) {
            return;
        }
        EarlyWarnMetadata meta = this.modelHolder.buildMeta();
        EarlyWarnWriter.save(meta);
        IFormView view = this.getView();
        view.returnDataToParent((Object)"success");
        view.close();
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "EarlyWarnNewPlugin_14", BOS_EARLYWARN);
        logInfo.setOpName("save", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "EarlyWarnNewPlugin_15", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID("warn_earlywarn");
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private boolean checkFields() {
        long enablePluginCount;
        EarlyWarnHolder proxy = this.modelHolder;
        String number = proxy.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u7f16\u7801\u3002", (String)"EarlyWarnNewPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (EarlyWarnMetaServicHelper.exists(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u88ab\u5176\u5b83\u4e1a\u52a1\u5bf9\u8c61\u4f7f\u7528\u3002", (String)"EarlyWarnNewPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        DynamicObject app = proxy.getBizApp();
        if (null == app) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u9884\u8b66\u6240\u5c5e\u5e94\u7528\u3002", (String)"EarlyWarnNewPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        OrmLocaleValue name = proxy.getName();
        if (null == name || name.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0\u3002", (String)"EarlyWarnNewPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        DynamicObject dataSource = proxy.getDataSource();
        EarlyWarnMetadata meta = proxy.buildMeta();
        EarlyWarnElement element = meta.getWarnElement();
        if (null == dataSource && element.getDataSources().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6570\u636e\u6e90\u6216\u6ce8\u518c\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"EarlyWarnNewPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (StringKit.isNotBlank(element.getConditionFormId()) && element.getDataSources().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u8868\u5355\u9700\u8981\u4e0e\u6570\u636e\u6e90\u63d2\u4ef6\u914d\u5408\u4f7f\u7528\uff0c\u8bf7\u6ce8\u518c\u6570\u636e\u6e90\u63d2\u4ef6\u3002", (String)"EarlyWarnNewPlugin_5", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (!element.getDataSources().isEmpty()) {
            enablePluginCount = element.getDataSources().stream().filter(d -> d.isEnabled()).count();
            if (enablePluginCount > 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u63d2\u4ef6\u751f\u6548\u3002", (String)"EarlyWarnNewPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            if (!this.isPluginValid(element, 1, meta.getBizappId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u63d2\u4ef6\u9700\u8981\u5b9e\u73b0\u6216\u7ee7\u627fIEarlyWarnDataSource\u63a5\u53e3\u3002", (String)"EarlyWarnNewPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        if (!element.getWriteOuts().isEmpty()) {
            enablePluginCount = element.getWriteOuts().stream().filter(d -> d.isEnabled()).count();
            if (enablePluginCount > 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5199\u51fa\u63d2\u4ef6\u91c7\u7528\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u4ec5\u5141\u8bb8\u4e00\u4e2a\u63d2\u4ef6\u751f\u6548\u3002", (String)"EarlyWarnNewPlugin_8", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            if (!this.isPluginValid(element, 2, meta.getBizappId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5199\u51fa\u63d2\u4ef6\u9700\u8981\u5b9e\u73b0\u6216\u7ee7\u627fIEarlyWarnWriteOut\u63a5\u53e3\u3002", (String)"EarlyWarnNewPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        if (!element.getMessageCompilers().isEmpty()) {
            enablePluginCount = element.getMessageCompilers().stream().filter(d -> d.isEnabled()).count();
            if (enablePluginCount > 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u7f16\u8bd1\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u4ec5\u53ef\u751f\u6548\u4e00\u4e2a\u63d2\u4ef6\u3002", (String)"EarlyWarnNewPlugin_10", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            if (!this.isPluginValid(element, 3, meta.getBizappId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u7f16\u8bd1\u9700\u8981\u5b9e\u73b0\u6216\u7ee7\u627f\u81eaIEarlyWarnMessageCompiler\u63a5\u53e3\u3002", (String)"EarlyWarnNewPlugin_11", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        if (!element.getMessageHandlers().isEmpty()) {
            enablePluginCount = element.getMessageHandlers().stream().filter(d -> d.isEnabled()).count();
            if (enablePluginCount > 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5904\u7406\u63d2\u4ef6\u4e3a\u5355\u63d2\u4ef6\u673a\u5236\uff0c\u8bf7\u8fdb\u884c\u68c0\u67e5\u3002", (String)"EarlyWarnNewPlugin_12", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
            if (!this.isPluginValid(element, 4, meta.getBizappId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d88\u606f\u5904\u7406\u63d2\u4ef6\u5e94\u5b9e\u73b0\u6216\u7ee7\u627f\u81eaIEarlyWarnMessageHandler\u63a5\u53e3\u3002", (String)"EarlyWarnNewPlugin_13", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean isPluginValid(EarlyWarnElement element, int pluginType, String appId) {
        boolean isValid;
        try {
            String appNumber = BizAppServiceHelp.getAppNumByAppId((String)appId);
            if (StringUtils.isEmpty((String)appNumber)) {
                appNumber = "bos";
            }
            isValid = (Boolean)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"EarlyWarnService", (String)"verifyPluginIsValid", (Object[])new Object[]{element, pluginType});
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return false;
        }
        return isValid;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(FORM_PARAM_BIZ_APP_ID);
        if (StringUtils.isNotEmpty((String)bizAppId)) {
            this.getModel().setValue(BIZ_APP, (Object)bizAppId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((String)actionId) || returnData == null) {
            return;
        }
        if (!PLUGINS.contains(actionId)) {
            return;
        }
        Map dataMap = (Map)returnData;
        List plugins = (List)dataMap.get("value");
        this.getModel().setValue(actionId, (Object)IdePluginKit.getJson(plugins));
    }

    public static FormShowParameter show(String bizAppId, CloseCallBack callBack) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(FORM_NUMBER);
        parameter.setCustomParam(FORM_PARAM_BIZ_APP_ID, (Object)bizAppId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(callBack);
        return parameter;
    }
}

