/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.earlywarn.kit.BillListKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermission;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermissionEnum;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.utils.TreeNodeUtils;
import kd.bos.designer.earlywarn.warn.EarlyWarnCopyPlugin;
import kd.bos.designer.earlywarn.warn.EarlyWarnDesignerEditPlugin;
import kd.bos.designer.earlywarn.warn.EarlyWarnExportPlugin;
import kd.bos.designer.earlywarn.warn.EarlyWarnImportPlugin;
import kd.bos.designer.earlywarn.warn.EarlyWarnNewPlugin;
import kd.bos.designer.earlywarn.warn.bo.EWCopyBo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import kd.bos.util.StringUtils;

public class EarlyWarnTreeListPlugin
extends StandardTreeListPlugin {
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String NEW_PAGE_ID = "newPageId";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_COPY = "btn_copy";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_IMPORT = "btn_import";
    private static final String BTN_DEL = "btn_del";
    private static final String ENTITY_NAME = "warn_earlywarn";
    private static final String APPID = "cts";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey;
        super.itemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "btn_add": {
                this.doAdd();
                return;
            }
            case "btn_copy": {
                this.showCopyForm();
                return;
            }
            case "btn_import": {
                this.showImportForm();
                return;
            }
            case "btn_export": {
                this.showExportForm();
                return;
            }
            case "btn_del": {
                this.showDelConfirm();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getTreeListView().focusRootNode();
    }

    private void showImportForm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.IMPORT, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"EarlyWarnTreeListPlugin_15", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = EarlyWarnImportPlugin.show(new CloseCallBack((IFormPlugin)this, BTN_IMPORT));
        this.getView().showForm(param);
    }

    private void showExportForm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.EXPORT, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"EarlyWarnTreeListPlugin_16", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarnTreeListPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u6682\u4e0d\u652f\u6301\u6279\u91cf\u5bfc\u51fa\u3002", (String)"EarlyWarnTreeListPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String id = String.valueOf(collection.get(0).getPrimaryKeyValue());
        EarlyWarnMetadata meta = EarlyWarnMetaServicHelper.loadMetaById(id, false);
        FormShowParameter param = EarlyWarnExportPlugin.show(meta.getMasterId());
        this.getView().showForm(param);
    }

    private void showCopyForm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.COPY, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u590d\u5236", (String)"EarlyWarnTreeListPlugin_17", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u62f7\u8d1d\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarnTreeListPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4e0d\u80fd\u6279\u91cf\u590d\u5236\u3002", (String)"EarlyWarnTreeListPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String id = String.valueOf(collection.get(0).getPrimaryKeyValue());
        EarlyWarnMetadata meta = EarlyWarnMetaServicHelper.loadMetaById(id, false);
        FormShowParameter param = EarlyWarnCopyPlugin.show(meta.getNumber() + "_copy", this.copy(meta.getName(), ResManager.loadKDString((String)"_\u590d\u5236", (String)"EarlyWarnTreeListPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0])).getLocaleValue(), meta.getBizappId(), new CloseCallBack((IFormPlugin)this, BTN_COPY));
        this.getView().showForm(param);
    }

    private LocaleString copy(LocaleString str, String suffix) {
        return new LocaleString(str.getLocaleValue() + suffix);
    }

    private void showDelConfirm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.DELETE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u5220\u9664", (String)"EarlyWarnTreeListPlugin_18", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (null == selectedRows || selectedRows.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarnTreeListPlugin_5", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4e0d\u80fd\u6279\u91cf\u5220\u9664\u3002", (String)"EarlyWarnTreeListPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String deleteId = StringKit.toSafeString(selectedRows.get(0).getPrimaryKeyValue());
        if (EarlyWarnMetaServicHelper.hasUsedByWarnSchedule(deleteId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u5df2\u7ecf\u88ab\u9884\u8b66\u65b9\u6848\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EarlyWarnTreeListPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DEL, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EarlyWarnTreeListPlugin_25", (String)BOS_EARLYWARN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, callBack);
    }

    private void doAdd() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.NEW, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e", (String)"EarlyWarnTreeListPlugin_20", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = this.getSelectedAppId();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BTN_ADD);
        FormShowParameter parameter = EarlyWarnNewPlugin.show(bizAppId, callBack);
        this.getView().showForm(parameter);
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "EarlyWarnTreeListPlugin_20", BOS_EARLYWARN);
        logInfo.setOpName("add", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f\u3002", "EarlyWarnTreeListPlugin_21", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private String getSelectedAppId() {
        String currentNodeId;
        Object nodeId = this.getTreeModel().getCurrentNodeId();
        String string = currentNodeId = nodeId == null ? "" : nodeId.toString();
        if (StringUtils.isEmpty((String)currentNodeId) || "rootNode".equals(nodeId)) {
            return "";
        }
        List appIds = BizAppServiceHelp.getAppsIdByCloudId((String)currentNodeId);
        if (appIds != null && !appIds.isEmpty()) {
            return "";
        }
        return currentNodeId;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String number;
        args.setCancel(true);
        HyperLinkClickEvent e = args.getHyperLinkClickEvent();
        BillList billList = (BillList)e.getSource();
        if (BillListKit.isF7Open(billList)) {
            ListSelectedRowCollection currentSelectedRowCollection = new ListSelectedRowCollection();
            currentSelectedRowCollection.add((Object)billList.getCurrentSelectedRowInfo());
            this.getView().returnDataToParent((Object)currentSelectedRowCollection);
            this.getView().close();
            return;
        }
        DynamicObject obj = BillListKit.getSelectedRow(billList);
        String string = number = obj == null ? "" : obj.getString("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"EarlyWarnTreeListPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter params = EarlyWarnDesignerEditPlugin.show(number);
        String newPageId = this.getPageCache().get(NEW_PAGE_ID + number);
        IFormView iformView = this.getView().getView(newPageId);
        if (iformView != null) {
            iformView.activate();
            this.getView().sendFormAction(iformView);
            return;
        }
        this.getPageCache().remove(NEW_PAGE_ID + number);
        params.setPageId(newPageId);
        params.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61", (String)"EarlyWarnTreeListPlugin_14", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        this.getView().showForm(params);
        this.clearSelection();
        this.getPageCache().put(NEW_PAGE_ID + number, params.getPageId());
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        e.setCancel(true);
        String nodeId = e.getNodeId().toString();
        if ("rootNode".equals(nodeId)) {
            return;
        }
        List appIds = BizAppServiceHelp.getAppsIdByCloudId((String)nodeId);
        if (appIds != null && !appIds.isEmpty()) {
            QFilter filter = new QFilter("biz_app_id", "in", this.getAllAppIds(appIds));
            e.addQFilter(filter);
            return;
        }
        List<Object> extAppIds = this.getAllAppIds(Collections.singletonList(nodeId));
        QFilter filter = new QFilter("biz_app_id", "in", extAppIds);
        e.addQFilter(filter);
    }

    private List<Object> getAllAppIds(List<String> appIds) {
        QFilter qFilter = new QFilter("parentid", "in", appIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Object> extAppIds = new ArrayList<Object>();
        extAppIds.addAll(appIds);
        extAppIds.addAll(dynamicObjectMap.keySet());
        return extAppIds;
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        String appid = (String)this.getView().getFormShowParameter().getCustomParam("refappid");
        String[] appIds = null;
        if (StringUtils.isNotEmpty((String)appid)) {
            appIds = new String[]{appid};
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, appIds, null, (String)"app");
        root.setChildren(TreeNodeUtils.filterCloudTreeNode(root.getChildren()));
        this.getTreeModel().setRoot(root);
        if (root != null) {
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode treeNode;
        String nodeId = StringKit.toSafeString(e.getNodeId());
        if (StringKit.isBlank(nodeId)) {
            return;
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        root.setChildren(TreeNodeUtils.filterCloudTreeNode(root.getChildren()));
        if (root != null && (treeNode = root.getTreeNode(nodeId, 16)) != null) {
            e.setChildNodes(treeNode.getChildren());
        }
    }

    public void setFilter(SetFilterEvent e) {
        TreeNodeFilter treeNodeFilter;
        QFilter appFilter;
        QFilter filter = new QFilter("leaf", "=", (Object)"1");
        if (TreeNodeUtils.isUseNewAppInfo() && (appFilter = (treeNodeFilter = new TreeNodeFilter()).getAppFilter("biz_app_id")) != null) {
            filter.and(appFilter);
        }
        e.addCustomQFilter(filter);
        e.setOrderBy("createdate desc");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.isEmpty((String)actionId) || e.getReturnData() == null) {
            return;
        }
        switch (actionId) {
            case "btn_import": 
            case "btn_add": {
                ((IListView)this.getView()).refresh();
                break;
            }
            case "btn_copy": {
                this.doCopy((EWCopyBo)e.getReturnData());
                break;
            }
        }
    }

    private void doCopy(EWCopyBo data) {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            return;
        }
        String id = String.valueOf(collection.get(0).getPrimaryKeyValue());
        EarlyWarnMetadata currentMeta = EarlyWarnMetaServicHelper.loadMetaById(id, false);
        if (null == currentMeta) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u62f7\u8d1d\u4e1a\u52a1\u5bf9\u8c61\u7684\u5143\u6570\u636e\u3002", (String)"EarlyWarnTreeListPlugin_10", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String masterId = currentMeta.getMasterId();
        List<EarlyWarnMetadata> list = EarlyWarnMetaServicHelper.loadMetasByMasterId(masterId);
        list.sort((m1, m2) -> {
            String s1 = m1.getInheritPath();
            String s2 = m2.getInheritPath();
            s1 = s1 == null ? "" : s1;
            s2 = s2 == null ? "" : s2;
            return Integer.compare(s1.length(), s2.length());
        });
        String newMasterId = String.valueOf(DBServiceHelper.genGlobalLongId());
        String number = data.getNumber();
        LocaleString name = data.getName();
        String bizAppId = data.getBizAppId();
        String parentId = "";
        String inheritPath = "";
        int index = 1;
        for (EarlyWarnMetadata meta : list) {
            String newId = StringUtils.isEmpty((String)meta.getParentId()) ? newMasterId : String.valueOf(DBServiceHelper.genGlobalLongId());
            inheritPath = StringUtils.isBlank((String)inheritPath) ? newId : inheritPath + "," + newId;
            meta.setId(newId);
            meta.setMasterId(newMasterId);
            meta.setParentId(parentId);
            meta.setBizappId(bizAppId);
            meta.setInheritPath(inheritPath);
            parentId = newId;
            String newNumber = number;
            LocaleString newName = name;
            if (index < list.size()) {
                String randomWord = "_" + StringUtils.randomWord((int)4);
                newNumber = number + randomWord;
                newName = new LocaleString(name.getLocaleValue() + randomWord);
            }
            meta.setNumber(newNumber);
            meta.setName(newName);
            EarlyWarnMetaServicHelper.save(meta);
            ++index;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"EarlyWarnTreeListPlugin_12", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        FormShowParameter param = EarlyWarnDesignerEditPlugin.show(number);
        param.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61", (String)"EarlyWarnTreeListPlugin_14", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        this.getView().showForm(param);
        ((IListView)this.getView()).clearSelection();
        ((IListView)this.getView()).refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (BTN_DEL.equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            this.doDelete();
        }
    }

    private void doDelete() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        Map<Object, Object> result = new HashMap(16);
        String deleteId = StringKit.toSafeString(selectedRows.get(0).getPrimaryKeyValue());
        DynamicObject earlyObj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,parentid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)deleteId)});
        String parentId = earlyObj.getString("parentid");
        DynamicObject parentObj = null;
        if (!StringUtils.isBlank((String)parentId) && null != (parentObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME, (String)"id,leaf", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)}))) {
            parentObj.set("leaf", (Object)true);
        }
        try (TXHandle h = TX.required();){
            try {
                if (null != parentObj) {
                    SaveServiceHelper.update(parentObj);
                }
                result = EarlyWarnMetaServicHelper.delete(Collections.singletonList(deleteId));
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        String message = (String)result.get("message");
        this.getView().showSuccessNotification(message);
        ((IListView)this.getView()).clearSelection();
        ((IListView)this.getView()).refresh();
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "EarlyWarnTreeListPlugin_18", BOS_EARLYWARN);
        logInfo.setOpName("delete", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "EarlyWarnTreeListPlugin_22", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private void showNoPermissionErrorNotification(String opName) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u3002", (String)"EarlyWarnTreeListPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption(), opName));
    }
}

