/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.designer.earlywarn.warn.kit.IdePluginKit;
import kd.bos.designer.earlywarn.warn.widget.WarnTreeDataNode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.entity.earlywarn.warn.EarlyWarnDataSourceType;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.form.IFormView;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;

public class EarlyWarnDesignerEditHolder {
    private static final String ID = "id";
    private static final String TXT_NUMBER = "number";
    private static final String BIZ_APP = "biz_app";
    private static final String TXT_NAME = "name";
    private static final String DATA_SOURCE = "data_source";
    private static final String CONDITION_FORM = "condition_form";
    public static final String DATA_SOURCE_PLUGIN = "plugin_get_data";
    public static final String WRITE_OUT_PLUGIN = "plugin_write_out";
    public static final String MESSAGE_COMPILER_PLUGIN = "plugin_message_compiler";
    public static final String MESSAGE_HANDLER_PLUGIN = "plugin_message_handler";
    public static final String CUSTOM_RECEIVER_PLUGIN = "plugin_custom_receiver";
    private static final String ISV_TIP = "isv_tip";
    private static final String ENABLED = "enabled";
    public static final List<String> PLUGINS = Arrays.asList("plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver");
    private IDataModel model;
    private IFormView view;

    public EarlyWarnDesignerEditHolder(IDataModel model, IFormView view) {
        this.model = model;
        this.view = view;
    }

    public void setEditNode(WarnTreeDataNode node) {
        if (null == node) {
            return;
        }
        EarlyWarnMetadata meta = node.deserialize();
        if (null == meta) {
            return;
        }
        EarlyWarnElement element = meta.getWarnElement();
        this.model.setValue(BIZ_APP, (Object)meta.getBizappId());
        this.view.setEnable(Boolean.valueOf(false), new String[]{BIZ_APP});
        this.model.setValue(TXT_NUMBER, (Object)element.getNumber());
        this.model.setValue(TXT_NAME, (Object)meta.getName());
        this.model.setValue(DATA_SOURCE, (Object)element.getDataSourceId());
        this.model.setValue(CONDITION_FORM, (Object)element.getConditionFormId());
        this.model.setValue(DATA_SOURCE_PLUGIN, (Object)IdePluginKit.getIdeJson(element.getDataSources()));
        this.model.setValue(WRITE_OUT_PLUGIN, (Object)IdePluginKit.getIdeJson(element.getWriteOuts()));
        this.model.setValue(MESSAGE_COMPILER_PLUGIN, (Object)IdePluginKit.getIdeJson(element.getMessageCompilers()));
        this.model.setValue(MESSAGE_HANDLER_PLUGIN, (Object)IdePluginKit.getIdeJson(element.getMessageHandlers()));
        this.model.setValue(CUSTOM_RECEIVER_PLUGIN, (Object)IdePluginKit.getIdeJson(element.getCustomReceivers()));
        this.view.setEnable(Boolean.valueOf(node.isCanModify()), new String[]{TXT_NUMBER, TXT_NAME, DATA_SOURCE, CONDITION_FORM, DATA_SOURCE_PLUGIN, WRITE_OUT_PLUGIN, MESSAGE_COMPILER_PLUGIN, MESSAGE_HANDLER_PLUGIN, CUSTOM_RECEIVER_PLUGIN});
        this.view.setVisible(Boolean.valueOf(!node.isCanModify()), new String[]{ISV_TIP});
    }

    public String getId() {
        return this.getStr(ID);
    }

    public OrmLocaleValue getName() {
        return (OrmLocaleValue)this.model.getValue(TXT_NAME);
    }

    public String getNumber() {
        return this.getStr(TXT_NUMBER);
    }

    public boolean getEnabled() {
        return (Boolean)this.model.getValue(ENABLED);
    }

    private DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.model.getValue(key);
    }

    private String getStr(String key) {
        return (String)this.model.getValue(key);
    }

    private String getFid(String key) {
        DynamicObject obj = this.getDynamicObject(key);
        if (null == obj) {
            return "";
        }
        String primaryKey = obj.getDynamicObjectType().getPrimaryKey().getName();
        return (String)obj.get(primaryKey);
    }

    private LocaleString getLocaleStringName() {
        OrmLocaleValue name = this.getName();
        HashMap<String, String> localNameMap = new HashMap<String, String>(16);
        for (String loId : name.keySet()) {
            localNameMap.put(loId, name.get((Object)loId));
        }
        return LocaleString.fromMap((Map)LocaleString.fromMap(localNameMap));
    }

    public EarlyWarnMetadata updateMeta(EarlyWarnMetadata meta) {
        meta.setNumber(this.getStr(TXT_NUMBER));
        meta.setName(this.getLocaleStringName());
        EarlyWarnElement element = meta.getWarnElement();
        element.setDataSources(this.getPlugins(DATA_SOURCE_PLUGIN));
        element.setWriteOuts(this.getPlugins(WRITE_OUT_PLUGIN));
        element.setMessageCompilers(this.getPlugins(MESSAGE_COMPILER_PLUGIN));
        element.setMessageHandlers(this.getPlugins(MESSAGE_HANDLER_PLUGIN));
        element.setCustomReceivers(this.getPlugins(CUSTOM_RECEIVER_PLUGIN));
        element.setConditionFormId(this.getFid(CONDITION_FORM));
        DynamicObject dataSource = this.getDynamicObject(DATA_SOURCE);
        String dataSourceId = dataSource == null ? "" : dataSource.getString(ID);
        String dataSourceModelType = dataSource == null ? "" : (String)dataSource.get("modeltype");
        String dataSourceType = EarlyWarnDataSourceType.getByModelType(dataSourceModelType).getName();
        element.setDataSourceId(dataSourceId);
        element.setDataSourceType(dataSourceType);
        return meta;
    }

    private List<EWPlugin> getPlugins(String key) {
        String json = (String)this.model.getValue(key);
        return IdePluginKit.getEWPlugins(json);
    }
}

