/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.earlywarn.warn.widget.WarnTreeDataNode;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.isv.ISVService;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnTemplate;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.util.StringUtils;

public class EarlyWarnDesignerTreeHolder {
    public static final String TREE_VIEW = "tree_view";
    private static final String TREE_ROOT_CACHE = "Warns";
    private static final String TREE_CURRENT_NODE_ID = "currentNodeId";
    public static final String BTN_EXTEND = "btn_extend";
    public static final String BTN_DELETE = "btn_del";
    public static final String BTN_XML = "btn_xml";
    public static final String BTN_SAVE = "btn_save";
    public static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private WarnTreeDataNode rootTreeNode;
    private IFormView view;
    private IPageCache pageCache;

    public EarlyWarnDesignerTreeHolder(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.pageCache = pageCache;
    }

    public void buildTreeNodes(String masterId, String currentId) {
        List<EarlyWarnMetadata> metas = EarlyWarnMetaServicHelper.loadMetasByMasterId(masterId);
        boolean rebuildFlag = this.pageCache.get(TREE_ROOT_CACHE) != null;
        String currentIsv = ISVService.getISVInfo().getId();
        WarnTreeDataNode rootDataNode = this.buildDataNodes(metas, currentIsv);
        List<WarnTreeDataNode> listNode = new ArrayList<WarnTreeDataNode>();
        listNode = WarnTreeDataNode.treeToList(rootDataNode, listNode);
        this.pageCache.put(TREE_ROOT_CACHE, SerializationUtils.toJsonString(listNode));
        this.rootTreeNode = rootDataNode;
        TreeNode rootNode = rootDataNode.buildTreeNodes();
        TreeView tView = (TreeView)this.view.getControl(TREE_VIEW);
        for (TreeNode childNode : rootNode.getChildren()) {
            if (rebuildFlag) {
                tView.updateNode(childNode);
                continue;
            }
            tView.addNode(childNode);
        }
        this.focusNode(currentId);
    }

    private WarnTreeDataNode buildDataNodes(List<EarlyWarnMetadata> metas, String currentIsv) {
        EarlyWarnTemplate template = new EarlyWarnTemplate();
        WarnTreeDataNode rootNode = new WarnTreeDataNode("0", ResManager.loadKDString((String)"\u5168\u90e8\u9884\u8b66\u5bf9\u8c61", (String)"EarlyWarnDesignerTreeHolder_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "", "", "");
        HashMap<String, WarnTreeDataNode> metaMap = new HashMap<String, WarnTreeDataNode>(16);
        for (EarlyWarnMetadata meta : metas) {
            WarnTreeDataNode node = WarnTreeDataNode.build(template, meta, currentIsv);
            metaMap.put(meta.getId(), node);
        }
        for (WarnTreeDataNode node : metaMap.values()) {
            String parentId = node.getParentId();
            if (StringUtils.isEmpty((String)parentId)) {
                rootNode.addChild(node);
                continue;
            }
            WarnTreeDataNode parent = (WarnTreeDataNode)metaMap.get(parentId);
            parent.addChild(node);
        }
        return rootNode;
    }

    public WarnTreeDataNode getRootTreeNode() {
        if (null != this.rootTreeNode) {
            return this.rootTreeNode;
        }
        String json = this.pageCache.get(TREE_ROOT_CACHE);
        if (StringUtils.isEmpty((String)json)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u6811\u5931\u8d25\uff01", (String)"EarlyWarnDesignerTreeHolder_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        List listNode = SerializationUtils.fromJsonStringToList((String)json, WarnTreeDataNode.class);
        this.rootTreeNode = WarnTreeDataNode.listToTree(listNode);
        return this.rootTreeNode;
    }

    public String getCurrentTreeNodeId() {
        String currentNodeId = this.pageCache.get(TREE_CURRENT_NODE_ID);
        WarnTreeDataNode rootTreeNode = this.getRootTreeNode();
        WarnTreeDataNode currentTreeNode = StringUtils.isEmpty((String)currentNodeId) ? (rootTreeNode.getChildren().isEmpty() ? null : rootTreeNode.getChildren().get(0)) : rootTreeNode.findById(currentNodeId);
        currentNodeId = currentTreeNode == null ? "" : currentTreeNode.getId();
        this.pageCache.put(TREE_CURRENT_NODE_ID, currentNodeId);
        return currentNodeId;
    }

    public void updateTreeDataNodeCache(WarnTreeDataNode rootDataNode) {
        List<WarnTreeDataNode> listNode = new ArrayList<WarnTreeDataNode>();
        listNode = WarnTreeDataNode.treeToList(rootDataNode, listNode);
        this.pageCache.put(TREE_ROOT_CACHE, SerializationUtils.toJsonString(listNode));
        this.rootTreeNode = rootDataNode;
    }

    public void deleteNode(String currentNodeId) {
        WarnTreeDataNode rootNode = this.getRootTreeNode();
        WarnTreeDataNode currentNode = rootNode.findById(currentNodeId);
        currentNode.delete();
        this.updateTreeDataNodeCache(rootNode);
        TreeView tView = (TreeView)this.view.getControl(TREE_VIEW);
        tView.deleteNode(currentNode.getId());
    }

    public void focusNode(String id) {
        id = StringUtils.isEmpty((String)id) ? this.getCurrentTreeNodeId() : id;
        TreeView tView = (TreeView)this.view.getControl(TREE_VIEW);
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        tView.focusNode(treeNode);
        this.pageCache.put(TREE_CURRENT_NODE_ID, id);
    }

    public WarnTreeDataNode extendNode(WarnTreeDataNode currentNode) {
        EarlyWarnMetadata meta = currentNode.deserialize();
        String newId = String.valueOf(DBServiceHelper.genGlobalLongId());
        String parentId = currentNode.getId();
        LocaleString name = meta.getName();
        name.setLocaleValue(String.format(ResManager.loadKDString((String)"%s_\u6269\u5c55", (String)"EarlyWarnDesignerTreeHolder_2", (String)"bos-earlywarn", (Object[])new Object[0]), name.getLocaleValue()));
        meta.setId(newId);
        meta.setParentId(parentId);
        meta.setName(name);
        meta.setDevType("2");
        meta.setNumber(meta.getNumber() + "_extend");
        meta.setInheritPath(meta.getInheritPath() + "," + newId);
        WarnTreeDataNode rootNode = this.getRootTreeNode();
        EarlyWarnTemplate template = new EarlyWarnTemplate();
        String currentIsv = ISVService.getISVInfo().getId();
        WarnTreeDataNode newNode = WarnTreeDataNode.build(template, meta, currentIsv);
        newNode.setNew(true);
        currentNode.addChild(newNode);
        this.updateTreeDataNodeCache(rootNode);
        TreeView tView = (TreeView)this.view.getControl(TREE_VIEW);
        tView.addNode(newNode.buildTreeNodes());
        this.focusNode(newNode.getId());
        return newNode;
    }
}

