/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.widget;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMeta;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnTemplate;
import kd.bos.util.StringUtils;

public class WarnTreeDataNode
implements Serializable {
    private static final long serialVersionUID = -5194313819439632308L;
    private String id;
    private String name;
    private String number;
    private String parentId;
    private String designJson;
    private boolean isNew_i;
    private boolean isModified_i;
    private boolean isDeleted_i;
    private boolean canModify;
    private List<WarnTreeDataNode> children = new ArrayList<WarnTreeDataNode>();
    private LocaleString formName;
    private static final String ISV_KINGDEE = "kingdee";

    public WarnTreeDataNode() {
    }

    public WarnTreeDataNode(String id, String name, String number, String parentId, String designJson) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.parentId = parentId;
        this.designJson = designJson;
    }

    public WarnTreeDataNode(EarlyWarnMetadata meta, String designJson) {
        this.id = meta.getId();
        this.name = meta.getName().getLocaleValue();
        this.number = meta.getNumber();
        this.parentId = meta.getParentId();
        this.designJson = designJson;
        this.formName = meta.getName();
    }

    public static WarnTreeDataNode build(EarlyWarnTemplate template, EarlyWarnMetadata metadata, String currentIsv) {
        String designJson = WarnTreeDataNode.buildDesignJson(template, metadata, currentIsv);
        WarnTreeDataNode node = new WarnTreeDataNode(metadata, designJson);
        boolean canModify = StringUtils.isNotEmpty((String)currentIsv) && StringUtils.isNotEmpty((String)metadata.getIsv()) && currentIsv.equals(metadata.getIsv());
        node.setCanModify(canModify);
        return node;
    }

    public static String buildDesignJson(EarlyWarnTemplate template, EarlyWarnMetadata metadata, String currentIsv) {
        if (ISV_KINGDEE.equals(currentIsv) && StringUtils.isEmpty((String)metadata.getIsv())) {
            metadata.setIsv(currentIsv);
        }
        String xml = template.buildDiffXml(metadata, null, false);
        DesignEarlyWarnMeta designMeta = (DesignEarlyWarnMeta)metadata.convertToDesignMeta(xml);
        return SerializationUtils.toJsonString((Object)((Object)designMeta));
    }

    public TreeNode buildTreeNodes() {
        TreeNode currNode = new TreeNode();
        currNode.setId(this.id);
        currNode.setParentid(this.parentId);
        currNode.setText(this.name);
        currNode.setIsOpened(true);
        currNode.setChildren(new ArrayList());
        for (WarnTreeDataNode child : this.children) {
            TreeNode childNode = child.buildTreeNodes();
            currNode.addChild(childNode);
        }
        return currNode;
    }

    public WarnTreeDataNode findById(String id) {
        if (null != this.id && this.id.equals(id)) {
            return this;
        }
        for (WarnTreeDataNode child : this.children) {
            WarnTreeDataNode result = child.findById(id);
            if (null == result) continue;
            return result;
        }
        return null;
    }

    public WarnTreeDataNode findByNumber(String number) {
        if (null != this.number && this.number.equalsIgnoreCase(number)) {
            return this;
        }
        for (WarnTreeDataNode child : this.children) {
            WarnTreeDataNode result = child.findByNumber(this.id);
            if (null == result) continue;
            return result;
        }
        return null;
    }

    public EarlyWarnMetadata deserialize() {
        if (StringUtils.isBlank((String)this.designJson)) {
            return null;
        }
        DesignEarlyWarnMeta designMeta = (DesignEarlyWarnMeta)((Object)SerializationUtils.fromJsonString((String)this.designJson, DesignEarlyWarnMeta.class));
        String xml = designMeta.getDataXml();
        EarlyWarnTemplate template = new EarlyWarnTemplate();
        EarlyWarnMetadata meta = template.getMetadata(xml, null);
        meta.convertFromDesignMeta(designMeta);
        meta.setName(LocaleString.fromMap((Map)this.getFormName()));
        return meta;
    }

    public DesignEarlyWarnMeta getDesignMeta() {
        if (StringUtils.isBlank((String)this.designJson)) {
            return null;
        }
        return (DesignEarlyWarnMeta)((Object)SerializationUtils.fromJsonString((String)this.designJson, DesignEarlyWarnMeta.class));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isNew() {
        return this.isNew_i;
    }

    public void setNew(boolean aNew) {
        this.isNew_i = aNew;
    }

    public boolean isModified() {
        return this.isModified_i;
    }

    public void setModified(boolean modified) {
        this.isModified_i = modified;
    }

    public boolean isDeleted() {
        return this.isDeleted_i;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted_i = deleted;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public String getDesignJson() {
        return this.designJson;
    }

    public void setDesignJson(String designJson) {
        this.designJson = designJson;
    }

    public void setChildren(List<WarnTreeDataNode> children) {
        this.children = children;
    }

    public void addChild(WarnTreeDataNode node) {
        this.children.add(node);
    }

    public List<WarnTreeDataNode> getChildren() {
        return this.children;
    }

    public LocaleString getFormName() {
        return this.formName;
    }

    public void setFormName(LocaleString formName) {
        this.formName = formName;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public boolean isLeaf() {
        if (this.isDeleted_i) {
            return false;
        }
        if (this.children.isEmpty()) {
            return true;
        }
        for (WarnTreeDataNode child : this.children) {
            if (child.isDeleted()) continue;
            return false;
        }
        return true;
    }

    public void delete() {
        this.setDeleted(true);
        for (WarnTreeDataNode child : this.children) {
            child.delete();
        }
    }

    public List<WarnTreeDataNode> getAllChildNodes() {
        ArrayList<WarnTreeDataNode> list = new ArrayList<WarnTreeDataNode>();
        for (WarnTreeDataNode node : this.children) {
            list.add(node);
            list.addAll(node.getAllChildNodes());
        }
        return list;
    }

    public static WarnTreeDataNode listToTree(List<WarnTreeDataNode> list) {
        WarnTreeDataNode dataNode = new WarnTreeDataNode();
        String rootId = "0";
        HashMap<String, WarnTreeDataNode> map = new HashMap<String, WarnTreeDataNode>(16);
        for (WarnTreeDataNode node : list) {
            node.setChildren(new ArrayList<WarnTreeDataNode>());
            map.put(node.getId(), node);
        }
        for (WarnTreeDataNode node : list) {
            if (rootId.equals(node.getId())) {
                dataNode = (WarnTreeDataNode)map.get(rootId);
                continue;
            }
            WarnTreeDataNode parent = (WarnTreeDataNode)map.get(node.getParentId());
            if (parent != null) {
                parent.getChildren().add(node);
                continue;
            }
            dataNode.getChildren().add(node);
        }
        return dataNode;
    }

    public static List<WarnTreeDataNode> treeToList(WarnTreeDataNode node, List<WarnTreeDataNode> list) {
        WarnTreeDataNode rootNode = new WarnTreeDataNode();
        rootNode.setId(node.getId());
        rootNode.setName(node.getName());
        rootNode.setNumber(node.getNumber());
        rootNode.setParentId(node.getParentId());
        rootNode.setDesignJson(node.getDesignJson());
        rootNode.setChildren(new ArrayList<WarnTreeDataNode>());
        rootNode.setCanModify(node.isCanModify());
        rootNode.setModified(node.isModified());
        rootNode.setNew(node.isNew());
        rootNode.setDeleted(node.isDeleted());
        rootNode.setFormName(node.getFormName());
        list.add(rootNode);
        if (!node.getChildren().isEmpty()) {
            for (WarnTreeDataNode cnode : node.getChildren()) {
                WarnTreeDataNode.treeToList(cnode, list);
            }
        }
        return list;
    }
}

