/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class EarlyWarnContext {
    private WarnSchedule warnSchedule;
    private EarlyWarnElement earlyWarn;
    private Map<String, Object> customConditionMap;
    private Map<String, Object> customDataMap = new HashMap<String, Object>();
    private DynamicObjectCollection warnDataList;
    private DynamicObjectCollection plainWarnData;
    private long earlyWarnLogId;

    public EarlyWarnContext(WarnSchedule warnSchedule, EarlyWarnElement earlyWarn, long earlyWarnLogId) {
        this.warnSchedule = warnSchedule;
        this.earlyWarn = earlyWarn;
        this.earlyWarnLogId = earlyWarnLogId;
        this.customConditionMap = warnSchedule.getWarnCondition().getCustomDataMap();
    }

    @KSMethod
    public WarnSchedule getWarnSchedule() {
        return this.warnSchedule;
    }

    @KSMethod
    public EarlyWarnElement getEarlyWarn() {
        return this.earlyWarn;
    }

    @KSMethod
    public DynamicObjectCollection getWarnDataList() {
        return this.warnDataList;
    }

    @KSMethod
    public void setWarnDataList(DynamicObjectCollection warnDataList) {
        this.warnDataList = warnDataList;
    }

    @KSMethod
    public DynamicObjectCollection getPlainWarnData() {
        return this.plainWarnData;
    }

    @KSMethod
    public void setPlainWarnData(DynamicObjectCollection plainWarnData) {
        this.plainWarnData = plainWarnData;
    }

    @KSMethod
    public EarlyWarnContext putCustomConditionData(String key, Object value) {
        this.customConditionMap.put(key, value);
        return this;
    }

    @KSMethod
    public Object getCustomConditionData(String key) {
        return this.customConditionMap.get(key);
    }

    @KSMethod
    public Map<String, Object> getCustomConditionDataMap() {
        return this.customConditionMap;
    }

    @KSMethod
    public EarlyWarnContext putCustomData(String key, Object value) {
        this.customDataMap.put(key, value);
        return this;
    }

    @KSMethod
    public Object getCustomData(String key) {
        return this.customDataMap.get(key);
    }

    @KSMethod
    public Map<String, Object> getCustomDataMap() {
        return this.customDataMap;
    }

    @KSMethod
    public long getEarlyWarnLogId() {
        return this.earlyWarnLogId;
    }
}

