/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;

@DataEntityTypeAttribute(tableName="T_Warn_MonitorLog", dbRouteKey="basedata")
public class EarlyWarnLog {
    private long id;
    private String warnScheduleId;
    private String earlyWarnId;
    private String operationType;
    private String status;
    private Date startTime;
    private Date endTime;
    private Long executionMillis;
    private String executionTime;
    private String comment;
    private long operatorId;

    public EarlyWarnLog() {
    }

    public EarlyWarnLog(DynamicObject log) {
        this.id = log.getLong("id");
        DynamicObject warnSchedule = log.getDynamicObject("warn_schedule");
        this.warnScheduleId = warnSchedule == null ? "" : warnSchedule.getString("id");
        DynamicObject earlyWarn = log.getDynamicObject("early_warn");
        this.earlyWarnId = earlyWarn == null ? "" : earlyWarn.getString("id");
        this.operationType = log.getString("operation_type");
        this.status = log.getString("status");
        this.startTime = log.getDate("start_time");
        this.endTime = log.getDate("end_time");
        this.comment = log.getString("comment");
        DynamicObject operator = log.getDynamicObject("operator");
        this.operatorId = operator == null ? 0L : operator.getLong("id");
    }

    @SimplePropertyAttribute(alias="FId", isPrimaryKey=true, dbType=-5)
    public long getId() {
        return this.id;
    }

    public EarlyWarnLog setId(long id) {
        this.id = id;
        return this;
    }

    @SimplePropertyAttribute(alias="FWarnScheduleId", dbType=-9)
    public String getWarnScheduleId() {
        return this.warnScheduleId;
    }

    public EarlyWarnLog setWarnScheduleId(String warnScheduleId) {
        this.warnScheduleId = warnScheduleId;
        return this;
    }

    @SimplePropertyAttribute(alias="FEarlyWarnId", dbType=-9)
    public String getEarlyWarnId() {
        return this.earlyWarnId;
    }

    public EarlyWarnLog setEarlyWarnId(String earlyWarnId) {
        this.earlyWarnId = earlyWarnId;
        return this;
    }

    @SimplePropertyAttribute(alias="FOperationType", dbType=12)
    public String getOperationType() {
        return this.operationType;
    }

    public WarnScheduleOperationType getOperationTypeObj() {
        return WarnScheduleOperationType.getBy(this.operationType);
    }

    public EarlyWarnLog setOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    @SimplePropertyAttribute(alias="FStatus", dbType=1)
    public String getStatus() {
        return this.status;
    }

    public WarnScheduleStatus getStatusObj() {
        return WarnScheduleStatus.getBy(this.status);
    }

    public EarlyWarnLog setStatus(String status) {
        this.status = status;
        return this;
    }

    @SimplePropertyAttribute(alias="FStartTime", dbType=91)
    public Date getStartTime() {
        return this.startTime;
    }

    public EarlyWarnLog setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @SimplePropertyAttribute(alias="FEndTime", dbType=91)
    public Date getEndTime() {
        return this.endTime;
    }

    public EarlyWarnLog setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @SimplePropertyAttribute(alias="FExecutionMillis", dbType=-5)
    public long getExecutionMillis() {
        if (null == this.startTime || this.endTime == null) {
            return 0L;
        }
        return this.endTime.getTime() - this.startTime.getTime();
    }

    @SimplePropertyAttribute(alias="FExecutionTime", dbType=12)
    public String getExecutionTime() {
        return this.executionTime;
    }

    @SimplePropertyAttribute(alias="FComment", dbType=-9)
    public String getComment() {
        return this.comment;
    }

    public EarlyWarnLog setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @SimplePropertyAttribute(alias="FOperatorId", dbType=-5)
    public long getOperatorId() {
        return this.operatorId;
    }

    public EarlyWarnLog setOperatorId(long operatorId) {
        this.operatorId = operatorId;
        return this;
    }

    public void setExecutionMillis(Long executionMillis) {
        this.executionMillis = executionMillis;
        this.executionTime = this.formatMillis(executionMillis);
    }

    private String formatMillis(long millis) {
        long DAY_MILLIS = 86400000L;
        if (millis < 86400000L) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            return format.format(new Date(millis));
        }
        return String.format(ResManager.loadKDString((String)"%s\u5929", (String)"EarlyWarnLog_0", (String)"bos-earlywarn", (Object[])new Object[0]), millis % 86400000L);
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }
}

