/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.warnschedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriod;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCycleRangeType;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.KDDateUtils;

@KSObject
public class RunCycle
implements Serializable {
    private static final String BLANK_STR = " ";
    private static final String ASTERISK = "*";
    private static final String COMMA = ",";
    private static final String QUESTION_MARK = "?";
    private static final long serialVersionUID = -7020462465095240839L;
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private String startDate;
    private String endDate;
    private String rangeType = RunCycleRangeType.FromStartDate.getName();
    private String periodType = RunCyclePeriodType.Minute.getValue();
    private List<RunCyclePeriod> periodValues = new ArrayList<RunCyclePeriod>();
    private int runTime;
    private LocaleString description;
    private int period = 1;
    private String cronExpr;
    private String executeType;
    private String whichNumber;

    @SimplePropertyAttribute
    @KSMethod
    public String getStartDate() {
        return this.startDate;
    }

    public Date getStartDateObj() {
        if (StringUtils.isBlank((CharSequence)this.startDate)) {
            return null;
        }
        return KDDateUtils.parseDate((String)this.startDate);
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getEndDate() {
        return this.endDate;
    }

    public Date getEndDateObj() {
        if (StringUtils.isBlank((CharSequence)this.endDate)) {
            return null;
        }
        return KDDateUtils.parseDate((String)this.endDate);
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(String rangeType) {
        this.rangeType = rangeType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=RunCyclePeriod.class)
    @KSMethod
    public List<RunCyclePeriod> getPeriodValues() {
        return this.periodValues;
    }

    public void setPeriodValues(List<RunCyclePeriod> periodValues) {
        this.periodValues = periodValues;
    }

    @SimplePropertyAttribute
    @KSMethod
    public int getRunTime() {
        return this.runTime;
    }

    public void setRunTime(int runTime) {
        this.runTime = runTime;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getDescription() {
        return this.description;
    }

    public void setDescription(LocaleString description) {
        this.description = description;
    }

    @SimplePropertyAttribute
    @KSMethod
    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getCronExpr() {
        return this.cronExpr;
    }

    public void setCronExpr(String cronExpr) {
        this.cronExpr = cronExpr;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getExecuteType() {
        return this.executeType;
    }

    public void setExecuteType(String executeType) {
        this.executeType = executeType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getWhichNumber() {
        return this.whichNumber;
    }

    public void setWhichNumber(String whichNumber) {
        this.whichNumber = whichNumber;
    }

    public RunCycleRangeType getRunCycleRangeType() {
        return RunCycleRangeType.getByName(this.rangeType);
    }

    private RunCyclePeriodType getRunCyclePeriodType() {
        return RunCyclePeriodType.getByValue(this.periodType);
    }

    public String getMonitorPeriodRange() {
        RunCycleRangeType rangeType = this.getRunCycleRangeType();
        if (null == rangeType) {
            return "";
        }
        StringBuilder description = new StringBuilder();
        description.append(ResManager.loadKDString((String)"\u4ece", (String)"RunCycle_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0])).append(this.getStartDate()).append(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"RunCycle_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        if (RunCycleRangeType.DateRange == rangeType) {
            description.append(ResManager.loadKDString((String)"\uff0c\u81f3", (String)"RunCycle_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0])).append(this.getEndDate());
        }
        return description.toString();
    }

    public String getMonitorFrequency() {
        RunCyclePeriodType periodType = this.getRunCyclePeriodType();
        if (null == this.rangeType) {
            return "";
        }
        StringBuilder description = new StringBuilder();
        if (RunCyclePeriodType.Day == periodType) {
            description.append(ResManager.loadKDString((String)"\u6bcf\u5929", (String)"RunCycle_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Week == periodType) {
            description.append(ResManager.loadKDString((String)"\u6bcf\u5468", (String)"RunCycle_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0])).append(' ').append(this.getPeriodNameStr());
        } else if (RunCyclePeriodType.Month == periodType) {
            description.append(ResManager.loadKDString((String)"\u6bcf\u6708", (String)"RunCycle_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0])).append(' ').append(this.getPeriodNameStr());
        }
        description.append('-').append(this.getRunTimeStr());
        return description.toString();
    }

    private String getPeriodNameStr() {
        StringBuilder sb = new StringBuilder();
        for (RunCyclePeriod period : this.periodValues) {
            sb.append(period.getName()).append(',');
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    public String getRunTimeStr() {
        return RunCycle.secondToTime(this.runTime);
    }

    private static String secondToTime(int sec) {
        int hour = sec / 3600;
        int minute = (sec - hour * 3600) / 60;
        int second = sec - hour * 3600 - minute * 60;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    public String getCronExpression() {
        int hour = this.runTime / 3600;
        int minute = (this.runTime - hour * 3600) / 60;
        int second = this.runTime - hour * 3600 - minute * 60;
        StringBuilder expression = new StringBuilder();
        expression.append(second).append(BLANK_STR).append(minute).append(BLANK_STR).append(hour).append(BLANK_STR);
        RunCyclePeriodType periodType = this.getRunCyclePeriodType();
        if (RunCyclePeriodType.Day == periodType) {
            expression.append(QUESTION_MARK).append(BLANK_STR).append(ASTERISK).append(BLANK_STR).append(ASTERISK).append(BLANK_STR);
        } else {
            String express;
            List<RunCyclePeriod> periods = this.getPeriodValues();
            List values = periods.stream().map(RunCyclePeriod::getCronValue).collect(Collectors.toList());
            if (RunCyclePeriodType.Week == periodType) {
                express = values.isEmpty() ? ASTERISK : this.join(values);
                expression.append(QUESTION_MARK).append(BLANK_STR).append(ASTERISK).append(BLANK_STR).append(express).append(BLANK_STR);
            } else if (RunCyclePeriodType.Month == periodType) {
                express = values.isEmpty() ? QUESTION_MARK : this.join(values);
                expression.append(express).append(BLANK_STR).append(ASTERISK).append(BLANK_STR).append(QUESTION_MARK).append(BLANK_STR);
            }
        }
        RunCycleRangeType rangeType = this.getRunCycleRangeType();
        if (RunCycleRangeType.DateRange == rangeType) {
            String startYear = this.getYear(this.getStartDateObj());
            String endYear = this.getYear(this.getEndDateObj());
            String express = startYear + "-" + endYear;
            expression.append(express);
        } else {
            expression.append(ASTERISK);
        }
        return expression.toString();
    }

    private String getYear(Date date) {
        if (null == date) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(1));
    }

    private String join(Collection<?> list) {
        if (null == list || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : list) {
            sb.append(o.toString()).append(COMMA);
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }
}

