/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.warnschedule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageSendType;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class WarnMessageConfig
implements Serializable {
    private static final long serialVersionUID = 3437242050724870098L;
    private List<WarnMessageSendType> sendTypes = new ArrayList<WarnMessageSendType>();
    private List<WarnMessageReceiverType> receiverTypes = new ArrayList<WarnMessageReceiverType>();
    private String title;
    private boolean mergeSendMessage;
    private boolean quickProcessing;
    private String singleContent;
    private String mergeContent;
    private MessageContent mergeMessageContent;
    private String groupField;
    private List<MulilangConfig> mulilangConfigs = new ArrayList<MulilangConfig>();

    @CollectionPropertyAttribute(collectionItemPropertyType=WarnMessageSendType.class)
    @KSMethod
    public List<WarnMessageSendType> getSendTypes() {
        return this.sendTypes;
    }

    public void setSendTypes(List<WarnMessageSendType> sendTypes) {
        this.sendTypes = sendTypes;
    }

    public String getSendTypeNumbers() {
        if (this.sendTypes.isEmpty()) {
            return "";
        }
        StringBuilder typeNumbers = new StringBuilder();
        for (WarnMessageSendType sendType : this.sendTypes) {
            String realSendType = sendType.getRealSendType();
            WarnMessageSendType.SendType type = sendType.getSendType();
            if (WarnMessageSendType.SendType.MessageCenter == type) {
                realSendType = WarnMessageSendType.SendType.MessageCenter.getValue();
            }
            typeNumbers.append(',');
            typeNumbers.append(realSendType);
        }
        typeNumbers.append(',');
        return typeNumbers.toString();
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=WarnMessageReceiverType.class)
    @KSMethod
    public List<WarnMessageReceiverType> getReceiverTypes() {
        return this.receiverTypes;
    }

    public void setReceiverTypes(List<WarnMessageReceiverType> receiverTypes) {
        this.receiverTypes = receiverTypes;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isMergeSendMessage() {
        return this.mergeSendMessage;
    }

    public void setMergeSendMessage(boolean mergeSendMessage) {
        this.mergeSendMessage = mergeSendMessage;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isQuickProcessing() {
        return this.quickProcessing;
    }

    public void setQuickProcessing(boolean quickProcessing) {
        this.quickProcessing = quickProcessing;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSingleContent() {
        return this.singleContent;
    }

    public void setSingleContent(String singleContent) {
        this.singleContent = singleContent;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getMergeContent() {
        return this.mergeContent;
    }

    public void setMergeContent(String mergeContent) {
        this.mergeContent = mergeContent;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public MessageContent getMergeMessageContent() {
        return this.mergeMessageContent;
    }

    public void setMergeMessageContent(MessageContent mergeMessageContent) {
        this.mergeMessageContent = mergeMessageContent;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=MulilangConfig.class)
    @KSMethod
    public List<MulilangConfig> getMulilangConfigs() {
        return this.mulilangConfigs;
    }

    public void setMulilangConfigs(List<MulilangConfig> mulilangConfigs) {
        this.mulilangConfigs = mulilangConfigs;
    }
}

