/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.warnschedule.runcycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class RunCyclePeriod
implements Serializable {
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String MONTH_TAG = "month";
    public static final List<RunCyclePeriod> WEEKS = Arrays.asList(new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"RunCyclePeriod_0", (String)"bos-entity-core", (Object[])new Object[0]), "Monday", "2"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"RunCyclePeriod_1", (String)"bos-entity-core", (Object[])new Object[0]), "Tuesday", "3"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"RunCyclePeriod_2", (String)"bos-entity-core", (Object[])new Object[0]), "Wednesday", "4"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"RunCyclePeriod_3", (String)"bos-entity-core", (Object[])new Object[0]), "Thursday", "5"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"RunCyclePeriod_4", (String)"bos-entity-core", (Object[])new Object[0]), "Friday", "6"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"RunCyclePeriod_5", (String)"bos-entity-core", (Object[])new Object[0]), "Saturday", "7"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"RunCyclePeriod_6", (String)"bos-entity-core", (Object[])new Object[0]), "Sunday", "1"));
    public static final Map<String, RunCyclePeriod> VALUE_MAPS;
    public static final List<RunCyclePeriod> MONTH_DAYS;
    private static final long serialVersionUID = -8263938506549124688L;
    private String name;
    private String value;
    private String cronValue;

    public List<RunCyclePeriod> getWeeks() {
        return Arrays.asList(new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"RunCyclePeriod_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Monday", "2"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"RunCyclePeriod_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Tuesday", "3"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"RunCyclePeriod_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Wednesday", "4"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"RunCyclePeriod_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Thursday", "5"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"RunCyclePeriod_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Friday", "6"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"RunCyclePeriod_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Saturday", "7"), new RunCyclePeriod(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"RunCyclePeriod_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), "Sunday", "1"));
    }

    public List<RunCyclePeriod> getAllWeeks() {
        ArrayList<RunCyclePeriod> runCyclePeriods = new ArrayList<RunCyclePeriod>(this.getWeeks());
        runCyclePeriods.add(new RunCyclePeriod(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"RunCyclePeriod_9", (String)BOS_EARLYWARN, (Object[])new Object[0]), "NatureDay", "8"));
        runCyclePeriods.add(new RunCyclePeriod(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"RunCyclePeriod_10", (String)BOS_EARLYWARN, (Object[])new Object[0]), "weekday", "9"));
        return runCyclePeriods;
    }

    public List<RunCyclePeriod> getMonthDays() {
        ArrayList<RunCyclePeriod> list = new ArrayList<RunCyclePeriod>(31);
        for (int i = 0; i < 31; ++i) {
            String day = String.valueOf(i + 1);
            RunCyclePeriod v = new RunCyclePeriod(String.format(ResManager.loadKDString((String)"%s\u65e5", (String)"RunCyclePeriod_7", (String)BOS_EARLYWARN, (Object[])new Object[0]), i + 1), day, day);
            list.add(v);
        }
        return Collections.unmodifiableList(list);
    }

    public List<RunCyclePeriod> getMonths() {
        ArrayList<RunCyclePeriod> months = new ArrayList<RunCyclePeriod>(12);
        String monthDesc = ResManager.loadKDString((String)"\u6708", (String)"RunCyclePeriod_8", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        for (int i = 0; i < 12; ++i) {
            String month = String.valueOf(i + 1);
            months.add(new RunCyclePeriod(month + monthDesc, month + MONTH_TAG, month));
        }
        return Collections.unmodifiableList(months);
    }

    public static RunCyclePeriod getBy(String value) {
        return VALUE_MAPS.get(value);
    }

    public static List<RunCyclePeriod> getList(String value) {
        String[] arr;
        ArrayList<RunCyclePeriod> list = new ArrayList<RunCyclePeriod>();
        if (StringUtils.isBlank((CharSequence)value)) {
            return list;
        }
        for (String s : arr = value.split(",")) {
            RunCyclePeriod v = VALUE_MAPS.get(s);
            if (!StringUtils.isNotBlank((CharSequence)s) || null == v) continue;
            list.add(v);
        }
        return list;
    }

    public RunCyclePeriod() {
    }

    private RunCyclePeriod(String name, String value, String cronValue) {
        this.name = name;
        this.value = value;
        this.cronValue = cronValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCronValue() {
        if (StringUtils.isNotBlank((CharSequence)this.cronValue)) {
            return this.cronValue;
        }
        RunCyclePeriod runCyclePeriod = VALUE_MAPS.get(this.value);
        return runCyclePeriod == null ? "" : runCyclePeriod.getCronValue();
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getName() {
        return this.name;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        String tmp = StringUtils.isBlank((CharSequence)this.value) ? "" : this.value;
        return tmp.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof RunCyclePeriod) {
            RunCyclePeriod tmp = (RunCyclePeriod)obj;
            if (null == this.value) {
                return tmp.getValue() == null;
            }
            return this.value.equals(tmp.getValue());
        }
        return false;
    }

    static {
        HashMap<String, RunCyclePeriod> map = new HashMap<String, RunCyclePeriod>(16);
        ArrayList<RunCyclePeriod> list = new ArrayList<RunCyclePeriod>(31);
        for (int i = 0; i < 31; ++i) {
            String day = String.valueOf(i + 1);
            RunCyclePeriod v = new RunCyclePeriod(String.format(ResManager.loadKDString((String)"%s\u65e5", (String)"RunCyclePeriod_7", (String)BOS_EARLYWARN, (Object[])new Object[0]), i + 1), day, day);
            map.put(v.getValue(), v);
            list.add(v);
        }
        MONTH_DAYS = Collections.unmodifiableList(list);
        for (RunCyclePeriod v : WEEKS) {
            map.put(v.getValue(), v);
        }
        String monthDesc = ResManager.loadKDString((String)"\u6708", (String)"RunCyclePeriod_8", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        for (int i = 0; i < 12; ++i) {
            String month = String.valueOf(i + 1);
            RunCyclePeriod runCyclePeriod = new RunCyclePeriod(month + monthDesc, month + MONTH_TAG, month);
            map.put(runCyclePeriod.getValue(), runCyclePeriod);
        }
        VALUE_MAPS = Collections.unmodifiableMap(map);
    }
}

