/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.earlywarn.EarlyWarnService;
import kd.bos.service.earlywarn.engine.action.EngineLog;

public class EarlyWarnScheduleTask
extends AbstractTask {
    private static final String WARN_SCHEDULE_ID = "warnScheduleId";
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    private String getActionTag() {
        return EngineLog.toMultiLangJson("DataSourceAction_7", BOS_EARLYWARN);
    }

    public void setTaskId(String id) {
        super.setTaskId("EarlyWarnScheduleTask_" + id);
    }

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        String warnScheduleId;
        String string = warnScheduleId = null == params ? "" : (String)params.get(WARN_SCHEDULE_ID);
        if (StringUtils.isBlank((CharSequence)warnScheduleId)) {
            return;
        }
        WarnScheduleOperationType operationType = WarnScheduleOperationType.Task;
        EngineLog log = EngineLog.getInstance(warnScheduleId, operationType);
        log.logNow(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnScheduleTask_0", BOS_EARLYWARN));
        WarnScheduleStatus status = WarnScheduleStatus.Success;
        try {
            EarlyWarnService service = (EarlyWarnService)ServiceFactory.getService(EarlyWarnService.class);
            service.execute(warnScheduleId, operationType.toString(), log.getEarlyWarnLogId());
        }
        catch (Throwable e) {
            status = WarnScheduleStatus.Failure;
            throw e;
        }
        finally {
            log.logNow(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnScheduleTask_1", BOS_EARLYWARN));
            log.end(status);
        }
    }
}

