/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDExceptionKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.service.earlywarn.EarlyWarnService;
import kd.bos.service.earlywarn.EarlyWarnServiceResult;
import kd.bos.service.earlywarn.engine.EarlyWarnEngine;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EarlyWarnServiceImpl
implements EarlyWarnService {
    private static Log logger = LogFactory.getLog(EarlyWarnServiceImpl.class);
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    private String getActionTag() {
        return EngineLog.toMultiLangJson("EarlyWarnServiceImpl_0", BOS_EARLYWARN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EarlyWarnServiceResult execute(String warnScheduleId, String operationType, long earlyWarnLogId) {
        EarlyWarnServiceResult result;
        WarnScheduleOperationType type = WarnScheduleOperationType.getBy(operationType);
        EngineLog log = EngineLog.getInstance(earlyWarnLogId, warnScheduleId, type);
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnServiceImpl_1", BOS_EARLYWARN));
        try {
            EarlyWarnEngine engine = new EarlyWarnEngine(warnScheduleId, log);
            engine.execute();
            log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnServiceImpl_2", BOS_EARLYWARN));
            result = EarlyWarnServiceResult.success(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"EarlyWarnServiceImpl_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
        catch (Throwable e) {
            log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnServiceImpl_4", BOS_EARLYWARN));
            String msg = e.getMessage();
            msg = msg == null ? "" : msg;
            String info = KDExceptionKit.formatErrorMessage((ErrorCode)new ErrorCode("500", msg), (Object[])new Object[]{e});
            log.logBatch(this.getActionTag(), info);
            logger.error(this.getActionTag(), e);
            result = EarlyWarnServiceResult.failure(info);
        }
        finally {
            log.batchSaveLogs();
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getCommonFilterColumns(String earlyWarnId, String entityNumber) {
        IEarlyWarnDataSource dataSource = this.getDataSource(earlyWarnId);
        return dataSource == null ? new ArrayList() : dataSource.getCommonFilterColumns(entityNumber);
    }

    @Override
    public String getSingleMessageFieldTree(String earlyWarnId, String dataSourceNumber) {
        TreeNode treeNode = this.getSingleMessageTreeNode(earlyWarnId, dataSourceNumber);
        return SerializationUtils.toJsonString((Object)treeNode);
    }

    private TreeNode getSingleMessageTreeNode(String earlyWarnId, String dataSourceNumber) {
        IEarlyWarnDataSource dataSource = this.getDataSource(earlyWarnId);
        return dataSource == null ? null : dataSource.getSingleMessageFieldTree(dataSourceNumber);
    }

    @Override
    public String getTitleFieldTree(String earlyWarnId, String dataSourceNumber) {
        TreeNode treeNode = this.getSingleMessageTreeNode(earlyWarnId, dataSourceNumber);
        if (treeNode != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            for (TreeNode child : treeNode.getChildren()) {
                if (!"billhead".equals(child.getId())) continue;
                children.add(child);
                break;
            }
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
        }
        return SerializationUtils.toJsonString((Object)treeNode);
    }

    @Override
    public String getMergeMessageFieldTree(String earlyWarnId, String dataSourceNumber) {
        IEarlyWarnDataSource dataSource = this.getDataSource(earlyWarnId);
        TreeNode treeNode = dataSource == null ? null : dataSource.getMergeMessageFieldTree(dataSourceNumber);
        return SerializationUtils.toJsonString((Object)treeNode);
    }

    @Override
    @SdkInternal
    public boolean verifyPluginIsValid(EarlyWarnElement element, int pluginType) {
        try {
            if (1 == pluginType) {
                element.getDataSource();
                return true;
            }
            if (2 == pluginType) {
                element.getWriteOutPlugIn();
                return true;
            }
            if (3 == pluginType) {
                element.getMessageCompiler();
                return true;
            }
            if (4 == pluginType) {
                element.getMessageHandler();
                return true;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
        return false;
    }

    private IEarlyWarnDataSource getDataSource(String earlyWarnId) {
        EarlyWarnElement earlyWarn;
        EarlyWarnMetadata meta = StringUtils.isBlank((CharSequence)earlyWarnId) ? null : EarlyWarnReader.loadMeta(earlyWarnId, true);
        EarlyWarnElement earlyWarnElement = earlyWarn = meta == null ? null : meta.getWarnElement();
        if (null == earlyWarn) {
            return new DefaultEarlyWarnBillDataSource();
        }
        IEarlyWarnDataSource dataSource = earlyWarn.getDataSource();
        if (null != dataSource) {
            return dataSource;
        }
        switch (earlyWarn.getDataSourceTypeObj()) {
            case BASEDATA: 
            case BILL: {
                return new DefaultEarlyWarnBillDataSource();
            }
        }
        return null;
    }
}

