/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.warnschedule.MessageTableColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;

public class MessageTableBuilder {
    private static final Log log = LogFactory.getLog(MessageTableBuilder.class);
    private List<MessageTableColumn> tableContent;
    private List<Map<String, List<String>>> fieldsValue;
    private String dataSource;
    private int tableWidth;
    private int lengthLimit = 520000;

    public MessageTableBuilder(List<MessageTableColumn> tableContent, List<Map<String, List<String>>> fieldsValue, String dataSource) {
        this.tableContent = tableContent;
        this.fieldsValue = fieldsValue;
        this.dataSource = dataSource;
    }

    public MessageTableBuilder(List<MessageTableColumn> tableContent, List<Map<String, List<String>>> fieldsValue, String dataSource, int lengthLimit) {
        this(tableContent, fieldsValue, dataSource);
        this.lengthLimit = lengthLimit;
    }

    public String build() {
        if (CollectionUtils.isEmpty(this.tableContent) || this.lengthLimit < 0) {
            return "";
        }
        StringBuilder tableHtml = new StringBuilder();
        String tableHeadHtml = this.getTableHeadHtml();
        this.updateRemainingLimitLength(tableHeadHtml.length());
        if (this.lengthLimit < 0) {
            return "";
        }
        String tableBodyHtml = this.getTableBodyHtml();
        tableHtml.append("<table border=\"1\" style=\"width: ").append(Math.max(Math.min(3000, this.tableWidth), 200)).append("px;border: 1px solid #cccccc;\" align=\"center\">");
        tableHtml.append(tableHeadHtml);
        tableHtml.append(tableBodyHtml);
        tableHtml.append("</table>");
        return tableHtml.toString();
    }

    private void updateRemainingLimitLength(int increasedLength) {
        this.lengthLimit -= increasedLength;
    }

    private String getTableBodyHtml() {
        if (CollectionUtils.isEmpty(this.fieldsValue)) {
            return "";
        }
        String hyperlinkField = this.getBillNoKey();
        StringBuilder tableBodyHtml = new StringBuilder();
        tableBodyHtml.append("<tbody>");
        int maxColWidth = 0;
        for (Map<String, List<String>> rowMap : this.fieldsValue) {
            int maxRow = -1;
            for (MessageTableColumn tableColumn : this.tableContent) {
                if (StringUtils.isBlank((CharSequence)tableColumn.getField())) continue;
                List<String> value = rowMap.get(tableColumn.getField());
                maxRow = Math.max(maxRow, value == null ? -1 : value.size());
            }
            StringBuilder bodyRow = new StringBuilder();
            for (int i = 0; i < maxRow; ++i) {
                bodyRow.append("<tr>");
                for (MessageTableColumn tableColumn : this.tableContent) {
                    List<String> data;
                    String fieldRowValue = "";
                    String columnField = tableColumn.getField();
                    if (StringUtils.isNotBlank((CharSequence)columnField) && (data = rowMap.get(columnField)) != null && i < data.size()) {
                        fieldRowValue = data.get(i);
                        maxColWidth = Math.max(maxColWidth, this.getTableWidth(fieldRowValue));
                    }
                    if (StringUtils.isNotBlank((CharSequence)hyperlinkField) && StringUtils.equals((CharSequence)hyperlinkField, (CharSequence)columnField)) {
                        fieldRowValue = this.getHyperLinkFieldHtml(fieldRowValue, rowMap.get("pkid"));
                    }
                    bodyRow.append("<td>").append(fieldRowValue).append("</td>");
                }
                bodyRow.append("</tr>");
            }
            this.updateRemainingLimitLength(bodyRow.length());
            if (this.lengthLimit < 0) break;
            tableBodyHtml.append((CharSequence)bodyRow);
        }
        tableBodyHtml.append("</tbody>");
        int totalWidth = maxColWidth * this.tableContent.size() * 10;
        this.tableWidth = Math.max(this.tableWidth, totalWidth);
        return tableBodyHtml.toString();
    }

    private String getHyperLinkFieldHtml(String fieldRowValue, List<String> pkId) {
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        String clientPath = UrlService.getDomainContextUrlByTenantCode((String)tenantCode);
        if (StringUtils.isBlank((CharSequence)fieldRowValue) || CollectionUtils.isEmpty(pkId) || StringUtils.isBlank((CharSequence)clientPath)) {
            return fieldRowValue;
        }
        String url = clientPath + "?formId=" + this.dataSource + "&pkId=" + pkId.get(0);
        String accountCookieUrl = UrlService.getAccountCookieUrl((String)url, (String)tenantCode, (String)accountId);
        return "<a href=\"" + accountCookieUrl + "\" target=\"_blank\">" + fieldRowValue + "</a>";
    }

    private String getBillNoKey() {
        MainEntityType dataEntityType;
        if (StringUtils.isNotBlank((CharSequence)this.dataSource) && (dataEntityType = EntityMetadataCache.getDataEntityType((String)this.dataSource)) instanceof BillEntityType) {
            return ((BillEntityType)dataEntityType).getBillNo();
        }
        return "";
    }

    private int getTableWidth(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return 0;
        }
        try {
            return message.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u957f\u5ea6\u5931\u8d25\u3002", (Throwable)e);
            return 0;
        }
    }

    private String getTableHeadHtml() {
        StringBuilder tableHeadHtml = new StringBuilder();
        tableHeadHtml.append("<thead><tr>");
        int maxColWidth = 0;
        for (MessageTableColumn tableColumn : this.tableContent) {
            tableHeadHtml.append("<th>");
            String columnTitle = tableColumn.getTitle();
            tableHeadHtml.append(StringUtils.isBlank((CharSequence)columnTitle) ? "" : columnTitle);
            tableHeadHtml.append("</th>");
            maxColWidth = Math.max(maxColWidth, this.getTableWidth(columnTitle));
        }
        tableHeadHtml.append("</tr></thead>");
        int totalWidth = maxColWidth * this.tableContent.size() * 10;
        this.tableWidth = Math.max(this.tableWidth, totalWidth);
        return tableHeadHtml.toString();
    }
}

