/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnCache;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.WarnScheduleCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.earlywarn.engine.action.DataSourceAction;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.service.earlywarn.engine.action.GetDataAction;
import kd.bos.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.bos.service.earlywarn.engine.action.MessageAction;
import kd.bos.service.earlywarn.engine.action.WriteOutAction;

public class EarlyWarnEngine {
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final List<IEarlyWarnAction> actionChains = new ArrayList<IEarlyWarnAction>();
    private EarlyWarnContext context;
    private EngineLog log;

    private String getActionTag() {
        return EngineLog.toMultiLangJson("EarlyWarnEngine_0", BOS_EARLYWARN);
    }

    public EarlyWarnEngine(String warnScheduleId, EngineLog log) {
        this.log = log;
        this.init(warnScheduleId);
    }

    private void init(String warnScheduleId) {
        this.log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnEngine_1", BOS_EARLYWARN));
        WarnSchedule warnSchedule = WarnScheduleCache.load(warnScheduleId);
        if (null == warnSchedule) {
            throw new KDException(new ErrorCode("engine_init", ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848\u83b7\u53d6\u5931\u8d25", (String)"EarlyWarnEngine_2", (String)BOS_EARLYWARN, (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848\u83b7\u53d6\u5931\u8d25...", (String)"EarlyWarnEngine_3", (String)BOS_EARLYWARN, (Object[])new Object[0])});
        }
        EarlyWarnElement earlyWarn = EarlyWarnCache.load(warnSchedule.getEarlyWarnId());
        this.context = new EarlyWarnContext(warnSchedule, earlyWarn, this.log.getEarlyWarnLogId());
        this.log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnEngine_6", BOS_EARLYWARN));
    }

    public void execute() {
        this.log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnEngine_7", BOS_EARLYWARN));
        for (IEarlyWarnAction action : actionChains) {
            action.execute(this.context, this.log);
        }
        this.log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("EarlyWarnEngine_8", BOS_EARLYWARN));
    }

    static {
        actionChains.add(new DataSourceAction());
        actionChains.add(new GetDataAction());
        actionChains.add(new WriteOutAction());
        actionChains.add(new MessageAction());
    }
}

