/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import org.apache.commons.collections4.CollectionUtils;

public class MessageReceiver {
    private Set<Long> commonReceivers = new HashSet<Long>();
    private Map<DynamicObject, Set<Long>> receiversGroup = new HashMap<DynamicObject, Set<Long>>();
    private Set<String> commonPhones = new HashSet<String>();
    private Map<DynamicObject, Set<String>> phonesGroup;
    private Set<String> commonEmails = new HashSet<String>();
    private Map<DynamicObject, Set<String>> emailsGroup;
    private Map<DynamicObjectCollection, Set<Long>> groupFieldReceivers;

    public MessageReceiver() {
        this.phonesGroup = new HashMap<DynamicObject, Set<String>>();
        this.emailsGroup = new HashMap<DynamicObject, Set<String>>();
        this.groupFieldReceivers = new HashMap<DynamicObjectCollection, Set<Long>>();
    }

    public Set<Long> getAllReceivers() {
        HashSet<Long> allReceiver = new HashSet<Long>(this.commonReceivers);
        this.receiversGroup.values().forEach(r -> {
            if (r != null) {
                allReceiver.addAll((Collection<Long>)r);
            }
        });
        return allReceiver;
    }

    public Set<Long> getReceiversByGroup(DynamicObject groupKey) {
        HashSet<Long> allReceiver = new HashSet<Long>(this.commonReceivers);
        Set<Long> receivers = this.receiversGroup.get(groupKey);
        if (null != receivers) {
            allReceiver.addAll(receivers);
        }
        return allReceiver;
    }

    public Map<String, List<String>> getCustomReceivers(DynamicObjectCollection collection) {
        HashMap<String, List<String>> customReceivers = new HashMap<String, List<String>>();
        ArrayList<String> phone = new ArrayList<String>(this.getCommonPhones());
        ArrayList<String> email = new ArrayList<String>(this.getCommonEmails());
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            for (DynamicObject dynamicObject : collection) {
                Set<String> emailGroup;
                Set<String> phoneGroup = this.phonesGroup.get(dynamicObject);
                if (CollectionUtils.isNotEmpty(phoneGroup)) {
                    phone.addAll(phoneGroup);
                }
                if (!CollectionUtils.isNotEmpty(emailGroup = this.emailsGroup.get(dynamicObject))) continue;
                email.addAll(emailGroup);
            }
        }
        if (CollectionUtils.isNotEmpty(phone)) {
            customReceivers.put("phone", phone);
        }
        if (CollectionUtils.isNotEmpty(email)) {
            customReceivers.put("email", email);
        }
        return customReceivers;
    }

    public Map<String, List<String>> getCustomReceiversByGroup(DynamicObject groupKey) {
        HashMap<String, List<String>> customReceivers = new HashMap<String, List<String>>();
        ArrayList<String> phone = new ArrayList<String>(this.getCommonPhones());
        Set<String> phoneGroup = this.phonesGroup.get(groupKey);
        if (null != phoneGroup) {
            phone.addAll(phoneGroup);
        }
        if (CollectionUtils.isNotEmpty(phone)) {
            customReceivers.put("phone", phone);
        }
        ArrayList<String> email = new ArrayList<String>(this.getCommonEmails());
        Set<String> emailGroup = this.emailsGroup.get(groupKey);
        if (null != emailGroup) {
            email.addAll(emailGroup);
        }
        if (CollectionUtils.isNotEmpty(email)) {
            customReceivers.put("email", email);
        }
        return customReceivers;
    }

    public void setCommonReceivers(Set<Long> commonReceivers) {
        this.commonReceivers = commonReceivers;
    }

    public void addCommonReceiver(Long userId) {
        if (null != userId) {
            this.commonReceivers.add(userId);
        }
    }

    public void addCommonReceivers(Collection<Long> userIds) {
        if (null != userIds) {
            this.commonReceivers.addAll(userIds);
        }
    }

    public void setReceiversGroup(Map<DynamicObject, Set<Long>> receiversGroup) {
        this.receiversGroup = receiversGroup;
    }

    public void addReceiverToGroup(DynamicObject groupKey, Collection<Long> userIds) {
        if (null != userIds) {
            this.receiversGroup.computeIfAbsent(groupKey, s -> new HashSet()).addAll(userIds);
        }
    }

    public Set<String> getCommonPhones() {
        return this.commonPhones;
    }

    public void setCommonPhones(Set<String> commonPhones) {
        this.commonPhones = commonPhones;
    }

    public void addCommonPhones(Set<String> phones) {
        if (null != phones) {
            this.getCommonPhones().addAll(phones);
        }
    }

    public void addCommonPhones(String phone) {
        this.getCommonPhones().add(phone);
    }

    public Set<String> getCommonEmails() {
        return this.commonEmails;
    }

    public void setCommonEmails(Set<String> commonEmails) {
        this.commonEmails = commonEmails;
    }

    public void addCommonEmails(Set<String> emails) {
        if (null != emails) {
            this.getCommonEmails().addAll(emails);
        }
    }

    public void addCommonEmails(String email) {
        this.getCommonEmails().add(email);
    }

    public Map<DynamicObject, Set<String>> getPhonesGroup() {
        return this.phonesGroup;
    }

    public void addPhonesGroup(DynamicObject groupKey, Set<String> phones) {
        if (null != phones) {
            this.phonesGroup.computeIfAbsent(groupKey, s -> new HashSet()).addAll(phones);
        }
    }

    public Map<DynamicObject, Set<String>> getEmailsGroup() {
        return this.emailsGroup;
    }

    public void addEmailsGroup(DynamicObject groupKey, Set<String> emails) {
        if (null != emails) {
            this.emailsGroup.computeIfAbsent(groupKey, s -> new HashSet()).addAll(emails);
        }
    }

    public void addGroupFieldReceivers(DynamicObjectCollection collection, Set<Long> receivers) {
        if (CollectionUtils.isEmpty(receivers)) {
            return;
        }
        this.groupFieldReceivers.put(collection, receivers);
    }

    public Set<Long> getGroupFieldReceiversByValue(DynamicObjectCollection collection) {
        HashSet<Long> allReceiver = new HashSet<Long>(this.commonReceivers);
        Set<Long> fieldReceivers = this.groupFieldReceivers.get(collection);
        if (CollectionUtils.isNotEmpty(fieldReceivers)) {
            allReceiver.addAll(fieldReceivers);
        }
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            for (DynamicObject dynamicObject : collection) {
                Set<Long> receivers = this.receiversGroup.get(dynamicObject);
                if (CollectionUtils.isEmpty(receivers)) continue;
                allReceiver.addAll(receivers);
            }
        }
        return allReceiver;
    }
}

