/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine.action;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.log.EarlyWarnDetailLog;
import kd.bos.entity.earlywarn.log.MultiLangLog;
import kd.bos.entity.earlywarn.log.MultiLangLogWithArgs;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.earlywarn.EarlyWarnLogHelper;
import org.apache.commons.collections4.CollectionUtils;

public class EngineLog {
    private static final Log log = LogFactory.getLog(EngineLog.class);
    private String warnScheduleId;
    private long earlyWarnLogId;
    private List<EarlyWarnDetailLog> detailLogs = new ArrayList<EarlyWarnDetailLog>();
    protected static Map<String, String> resIdDescMapping = EngineLog.loadResIdDescMapping();

    public static EngineLog getInstance(long earlyWarnLogId, String warnScheduleId, WarnScheduleOperationType operationType) {
        DynamicObject object = EarlyWarnLogHelper.findById(earlyWarnLogId, "id,warnScheduleId");
        long tId = object != null ? earlyWarnLogId : EarlyWarnLogHelper.createLog(warnScheduleId, operationType);
        return new EngineLog(warnScheduleId, tId);
    }

    public static EngineLog getInstance(String warnScheduleId, WarnScheduleOperationType operationType) {
        long earlyWarnLogId = EarlyWarnLogHelper.createLog(warnScheduleId, operationType);
        return new EngineLog(warnScheduleId, earlyWarnLogId);
    }

    public EngineLog(String warnScheduleId, long earlyWarnLogId) {
        this.warnScheduleId = warnScheduleId;
        this.earlyWarnLogId = earlyWarnLogId;
    }

    public String getWarnScheduleId() {
        return this.warnScheduleId;
    }

    public long getEarlyWarnLogId() {
        return this.earlyWarnLogId;
    }

    public void logNow(String action, String message) {
        EarlyWarnLogHelper.saveDetailLog(this.earlyWarnLogId, action, message);
    }

    public void logBatch(String action, String message) {
        EarlyWarnDetailLog log = EarlyWarnLogHelper.createBlankDetailLog(this.earlyWarnLogId, action, message);
        this.detailLogs.add(log);
    }

    public void batchSaveLogs() {
        EarlyWarnLogHelper.batchSaveDetailLogs(this.detailLogs);
        this.detailLogs.clear();
    }

    public void end(WarnScheduleStatus status) {
        EarlyWarnLogHelper.endLog(this.earlyWarnLogId, status);
    }

    private static String loadDescByResID(String resourceID) {
        return resIdDescMapping.get(resourceID);
    }

    public static String toMultiLangJson(String resourceID, String sysType) {
        String description = EngineLog.loadDescByResID(resourceID);
        return SerializationUtils.toJsonString((Object)new MultiLangLog(description, resourceID));
    }

    public static String toMultiLangWithArgsJson(String resourceID, String sysType, List<String> args) {
        String description = EngineLog.loadDescByResID(resourceID);
        return SerializationUtils.toJsonString((Object)new MultiLangLogWithArgs(description, resourceID, args));
    }

    public static String toMultiLangLog(String multiLangJson) {
        try {
            MultiLangLogWithArgs multiLangLog = (MultiLangLogWithArgs)SerializationUtils.fromJsonString((String)multiLangJson, MultiLangLogWithArgs.class);
            if (multiLangLog == null || StringUtil.isBlank((CharSequence)multiLangLog.getResID())) {
                return multiLangJson;
            }
            if (StringUtil.isBlank((CharSequence)multiLangLog.getDesc())) {
                multiLangLog.setDesc(EngineLog.loadDescByResID(multiLangLog.getResID()));
            }
            if (StringUtil.isBlank((CharSequence)multiLangLog.getDesc())) {
                return multiLangJson;
            }
            if (StringUtil.isBlank((CharSequence)multiLangLog.getSysType())) {
                multiLangLog.setSysType("bos-earlywarn");
            }
            if (CollectionUtils.isEmpty(multiLangLog.getArgs())) {
                return ResManager.loadKDString((String)multiLangLog.getDesc(), (String)multiLangLog.getResID(), (String)multiLangLog.getSysType(), (Object[])new Object[0]);
            }
            List<String> args = multiLangLog.getArgs();
            int size = args.size();
            String multiLangDesc = multiLangLog.getDesc();
            String resID = multiLangLog.getResID();
            String sysType = multiLangLog.getSysType();
            if (size == 1) {
                multiLangDesc = String.format(ResManager.loadKDString((String)multiLangDesc, (String)resID, (String)sysType, (Object[])new Object[0]), args.get(0));
            } else if (size == 2) {
                multiLangDesc = String.format(ResManager.loadKDString((String)multiLangDesc, (String)resID, (String)sysType, (Object[])new Object[0]), args.get(0), args.get(1));
            } else if (size == 3) {
                multiLangDesc = String.format(ResManager.loadKDString((String)multiLangDesc, (String)resID, (String)sysType, (Object[])new Object[0]), args.get(0), args.get(1), args.get(2));
            }
            return multiLangDesc;
        }
        catch (Exception e) {
            return multiLangJson;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadResIdDescMapping() {
        HashMap<String, String> resIdDescMapping = new HashMap<String, String>(16);
        InputStream resourceAsStream = null;
        InputStreamReader streamReader = null;
        BufferedReader xmlStringReader = null;
        try {
            String str;
            String resFile = "/resources/bos-earlywarn_zh_CN.properties";
            resourceAsStream = EngineLog.class.getResourceAsStream(resFile);
            streamReader = new InputStreamReader(resourceAsStream);
            xmlStringReader = new BufferedReader(streamReader);
            while ((str = xmlStringReader.readLine()) != null) {
                int index;
                if (str.startsWith("#") || (index = str.indexOf(61)) == -1) continue;
                String resID = str.substring(0, index);
                String desc = str.substring(index + 1);
                resIdDescMapping.put(resID, desc);
            }
        }
        catch (Exception e) {
            HashMap<String, String> hashMap = resIdDescMapping;
            return hashMap;
        }
        finally {
            try {
                if (resourceAsStream != null) {
                    resourceAsStream.close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            try {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            try {
                if (xmlStringReader != null) {
                    xmlStringReader.close();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return resIdDescMapping;
    }
}

