/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.impl;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.events.MergeMessageArgs;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageCompiler;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.MessageContentFields;
import kd.bos.entity.earlywarn.warnschedule.MessageTableColumn;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.InteTimeZone;
import kd.bos.service.earlywarn.MessageTableBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DefaultBillMessageCompiler
implements IEarlyWarnMessageCompiler {
    private static final String TOTAL_COUNT = "totalCount";
    private static final String WARN_SCHEDULE_NAME = "warnSchedule.name";
    private static final String WARN_SCHEDULE_NUMBER = "warnSchedule.number";
    private static final String EARLY_WARN_NAME = "earlyWarn.name";
    private static final String EARLY_WARN_NUMBER = "earlyWarn.number";
    private static final List<String> commonFields = Arrays.asList("totalCount", "warnSchedule.name", "warnSchedule.number", "earlyWarn.name", "earlyWarn.number");
    private static final String FBASEDATAFIELDINFO = "fbasedataid";
    private static final Log logger = LogFactory.getLog(DefaultBillMessageCompiler.class);
    private InteTimeZone timeZone;
    private static final int MESSAGE_CONTENT_LIMIT = 520000;
    private static final int ROW_TAG_LENGTH = 5;

    @Override
    public String getSingleTitle(String expression, List<String> fields, DynamicObject data, EarlyWarnContext context) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        if (data != null) {
            return this.assembleMsgByData(expression, fields, data, context);
        }
        return this.getMergeTitle(expression, fields, null, context);
    }

    @Override
    public String getMergeTitle(String expression, List<String> fields, DynamicObjectCollection dataList, EarlyWarnContext context) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        int msgCounts = this.getMergeMessageCounts();
        HashMap<String, String> macroMap = new HashMap<String, String>();
        for (String field : fields) {
            List<String> processResult = this.getMergeFieldResult(dataList, context, field, msgCounts);
            if (processResult.isEmpty()) {
                macroMap.put(field, "");
                continue;
            }
            macroMap.put(field, processResult.get(0));
        }
        StringTemplateParser parser = new StringTemplateParser();
        return parser.parse(expression, macroMap::get);
    }

    @Override
    public MulilangConfig buildSingleMulilangConfig(MulilangConfig mulilangConfig, List<String> fields, DynamicObject data, EarlyWarnContext context) {
        String title = this.getSingleTitle(mulilangConfig.getTitle(), fields, data, context);
        String singleMessage = this.getSingleMessage(mulilangConfig.getSingleContent(), fields, data, context);
        MulilangConfig newMulilangConfig = mulilangConfig.copy();
        newMulilangConfig.setTitle(title);
        newMulilangConfig.setSingleContent(singleMessage);
        return newMulilangConfig;
    }

    @Override
    public String getSingleMessage(String expression, List<String> fields, DynamicObject data, EarlyWarnContext context) {
        if (null == expression || null == data) {
            return "";
        }
        return this.assembleMsgByData(expression, fields, data, context);
    }

    private String assembleMsgByData(String expression, List<String> fields, DynamicObject data, EarlyWarnContext context) {
        HashMap<String, String> macroMap = new HashMap<String, String>(fields.size());
        for (String field : fields) {
            String processResult = "";
            try {
                processResult = String.join((CharSequence)"\uff0c", this.dataProcessing(null, field, data, null, context, null));
            }
            catch (KDBizException e) {
                if ("NoFieldError".equalsIgnoreCase(e.getErrorCode().getCode())) {
                    processResult = "{" + field + "}";
                }
                throw e;
            }
            macroMap.put(field, processResult);
        }
        StringTemplateParser parser = new StringTemplateParser();
        return parser.parse(expression, macroName -> (String)macroMap.get(macroName));
    }

    private List<String> dataProcessing(String parentFieldKey, String fieldKey, DynamicObject data, IDataEntityProperty entityProperty, EarlyWarnContext context, DynamicObject currentData) {
        ArrayList<String> dataValue = new ArrayList<String>();
        if (fieldKey.contains(".")) {
            Object[] specialFiled = StringUtils.split((String)fieldKey, (String)"\\.", (int)2);
            parentFieldKey = specialFiled[0];
            fieldKey = specialFiled[1];
            entityProperty = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)parentFieldKey);
            if (entityProperty == null) {
                throw new KDBizException(new ErrorCode("NoFieldError", "NoFieldError"), new Object[0]);
            }
            Object parentDynamicObject = data.get(parentFieldKey);
            if (parentDynamicObject instanceof DynamicObjectCollection) {
                return this.collectionPropProcessing(parentFieldKey, fieldKey, entityProperty, context, (DynamicObjectCollection)parentDynamicObject, data);
            }
            if (entityProperty instanceof BasedataProp) {
                dataValue.add(this.getDataValue(StringUtils.join((Object[])specialFiled, (String)"."), data, entityProperty, null));
                return dataValue;
            }
            if (!(parentDynamicObject instanceof DynamicObject)) {
                throw new KDBizException(new ErrorCode("NoFieldError", "NoFieldError"), new Object[0]);
            }
            dataValue.addAll(this.dataProcessing(parentFieldKey, fieldKey, (DynamicObject)parentDynamicObject, entityProperty, context, null));
            return dataValue;
        }
        if (entityProperty instanceof EntryProp) {
            return this.dataProcessing(parentFieldKey, fieldKey, data, null, context, currentData);
        }
        if (entityProperty == null && (entityProperty = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)fieldKey)) == null) {
            throw new KDBizException(new ErrorCode("NoFieldError", "NoFieldError"), new Object[0]);
        }
        if (entityProperty instanceof MulBasedataProp) {
            dataValue.add(this.getDataValue(fieldKey, data, entityProperty, null));
        } else if (entityProperty instanceof ComboProp) {
            dataValue.add(this.getDataValue(fieldKey, data, entityProperty, data.getDataEntityType().getProperties().get((Object)fieldKey)));
        } else if (entityProperty instanceof DateTimeProp) {
            dataValue.add(this.getDataValue(fieldKey, data, entityProperty, null));
        } else if (entityProperty instanceof TimeProp) {
            dataValue.add(this.getDataValue(fieldKey, data, entityProperty, null));
        } else {
            dataValue.add(this.getDataValue(fieldKey, data, entityProperty, currentData));
        }
        return dataValue;
    }

    private List<String> collectionPropProcessing(String parentFieldKey, String fieldKey, IDataEntityProperty entityProperty, EarlyWarnContext context, DynamicObjectCollection parentDynamicObject, DynamicObject currentData) {
        ArrayList<String> dataValue = new ArrayList<String>();
        boolean isNeedCheck = false;
        if (entityProperty instanceof EntryProp && context.getWarnSchedule().isByEntry()) {
            isNeedCheck = true;
        }
        DynamicObjectType type = ((DynamicCollectionProperty)entityProperty).getDynamicCollectionItemPropertyType();
        String entryIdName = "";
        if (null != type) {
            String id = type.getPrimaryKey().getName();
            entryIdName = StringUtils.join((Object[])new Object[]{parentFieldKey, id}, (String)".");
        }
        for (DynamicObject dynamicObject : parentDynamicObject) {
            boolean flag = true;
            if (isNeedCheck) {
                flag = this.checkEntryRowIsNeedSend(entryIdName, context, dynamicObject.getPkValue());
            }
            if (!flag) continue;
            dataValue.addAll(this.dataProcessing(parentFieldKey, fieldKey, dynamicObject, entityProperty, context, currentData));
        }
        return dataValue;
    }

    private boolean checkEntryRowIsNeedSend(String entryIdName, EarlyWarnContext context, Object entryId) {
        DynamicObjectCollection plainWarnDataList = context.getPlainWarnData();
        if (null == plainWarnDataList || 0 == plainWarnDataList.size()) {
            return false;
        }
        for (DynamicObject plainData : plainWarnDataList) {
            if (!StringUtils.isNotBlank((CharSequence)entryIdName) || !entryId.equals(plainData.get(entryIdName))) continue;
            return true;
        }
        return false;
    }

    private String getDataValue(String fieldKey, DynamicObject data, IDataEntityProperty property, Object otherObject) {
        StringBuilder dataValue = new StringBuilder();
        try {
            if (property instanceof ComboProp) {
                List comboItems = ((ComboProp)otherObject).getComboItems();
                String selectedValues = (String)data.get(fieldKey);
                if (selectedValues.startsWith(",") && selectedValues.endsWith(",")) {
                    selectedValues = selectedValues.substring(1, selectedValues.length() - 1);
                }
                if (selectedValues.length() > 0) {
                    List<String> selectedValuesList = Arrays.asList(selectedValues.split(","));
                    comboItems.forEach(comboItem -> selectedValuesList.forEach(selectedValue -> {
                        if (selectedValue.equals(comboItem.getValue())) {
                            dataValue.append(comboItem.getName()).append("\uff0c");
                        }
                    }));
                    dataValue.deleteCharAt(dataValue.length() - 1);
                }
            } else if (property instanceof MulBasedataProp) {
                DynamicObject basedata = (DynamicObject)data.get(FBASEDATAFIELDINFO);
                property = (IDataEntityProperty)basedata.getDataEntityType().getProperties().get((Object)fieldKey);
                dataValue.append(this.getDataValue(fieldKey, basedata, property, null)).append("\uff0c");
            } else if (property instanceof DateTimeProp) {
                dataValue.append(this.formatDateTimeValue(fieldKey, data, (DateTimeProp)property));
            } else if (property instanceof TimeProp) {
                dataValue.append(this.formatTimeValue(fieldKey, data, (TimeProp)property));
            } else {
                Object fieldValue = data.get(fieldKey);
                if (null == fieldValue) {
                    fieldValue = "";
                } else if (fieldValue instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)fieldValue;
                    fieldValue = this.setScale(fieldKey, data, property, bigDecimal, (DynamicObject)otherObject);
                } else if (fieldValue instanceof Integer) {
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    fieldValue = numberFormat.format(fieldValue);
                }
                dataValue.append(fieldValue);
            }
        }
        catch (ORMDesignException e) {
            throw new KDBizException(new ErrorCode("NoFieldError", "NoFieldError"), new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        String value = dataValue.toString();
        if (value.endsWith("\uff0c")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String setScale(String fieldKey, DynamicObject data, IDataEntityProperty property, BigDecimal bigDecimal, DynamicObject currentData) {
        String controlPropName = "";
        int scale = 2;
        int roundingMode = 4;
        DynamicObject controlDyn = null;
        if (property instanceof DecimalProp) {
            controlPropName = ((DecimalProp)property).getControlPropName();
            scale = ((DecimalProp)property).getScale();
            if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                IDataEntityProperty controlProp = (IDataEntityProperty)data.getDynamicObjectType().getProperties().get((Object)controlPropName);
                controlDyn = controlProp != null ? (DynamicObject)data.get(controlPropName) : (currentData != null ? (DynamicObject)currentData.get(controlPropName) : null);
            }
        } else if (property instanceof BasedataProp) {
            String[] specialFiled = StringUtils.split((String)fieldKey, (String)"\\.", (int)2);
            String parentFieldKey = specialFiled[0];
            fieldKey = specialFiled[1];
            DynamicObject baseDataDyn = (DynamicObject)data.get(parentFieldKey);
            DynamicObjectType baseDataType = baseDataDyn.getDynamicObjectType();
            DynamicProperty baseDataProp = baseDataType.getProperty(fieldKey);
            scale = ((DecimalProp)baseDataProp).getScale();
            controlPropName = ((DecimalProp)baseDataProp).getControlPropName();
            if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                controlDyn = (DynamicObject)baseDataDyn.get(controlPropName);
            }
            property = baseDataProp;
        }
        Map mainCurrencyFmt = FmtInfoUtils.getMainCurrencyFmt();
        if (property instanceof PriceProp) {
            scale = controlDyn != null ? ((Integer)controlDyn.get("priceprecision")).intValue() : ((Integer)mainCurrencyFmt.get("pp")).intValue();
        } else if (property instanceof AmountProp) {
            scale = controlDyn != null ? ((Integer)controlDyn.get("amtprecision")).intValue() : ((Integer)mainCurrencyFmt.get("ap")).intValue();
        } else if (property instanceof QtyProp && controlDyn != null) {
            scale = (Integer)controlDyn.get("precision");
            Object precisionaccount = controlDyn.get("precisionaccount");
            if (precisionaccount.equals("2")) {
                roundingMode = 1;
            } else if (precisionaccount.equals("3")) {
                roundingMode = 0;
            }
        }
        bigDecimal = bigDecimal.setScale(scale, roundingMode);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(scale);
        return numberFormat.format(bigDecimal);
    }

    private Object formatTimeValue(String fieldKey, DynamicObject data, TimeProp property) {
        Object formatValue = data.get(fieldKey);
        if (null == formatValue) {
            formatValue = "";
        } else {
            try {
                formatValue = property.getDateFormat().format(data.get(fieldKey));
            }
            catch (Exception e) {
                logger.error("\u65f6\u95f4\u5b57\u6bb5\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        }
        return formatValue;
    }

    private Object formatDateTimeValue(String fieldKey, DynamicObject data, DateTimeProp property) {
        Date dateValue = data.getDate(fieldKey);
        Object formatValue = dateValue;
        if (null == dateValue) {
            return "";
        }
        try {
            formatValue = this.getTimeZone().format(dateValue, property.getDateFormat());
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u5b57\u6bb5\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return formatValue;
    }

    @Override
    public String getMergeMessage(String expression, List<String> fields, EarlyWarnContext context) {
        if (null == expression) {
            return "";
        }
        int msgCounts = this.getMergeMessageCounts();
        HashMap<String, Object> macroMap = new HashMap<String, Object>();
        HashMap<String, Object> allDataMap = new HashMap<String, Object>();
        for (String field : fields) {
            Object value;
            if (StringUtils.equals((CharSequence)TOTAL_COUNT, (CharSequence)field)) {
                value = context.getWarnDataList().size();
                macroMap.put(field, StringUtil.toSafeString((Object)value));
                allDataMap.put(field, StringUtil.toSafeString((Object)value));
                continue;
            }
            if (StringUtils.equals((CharSequence)EARLY_WARN_NAME, (CharSequence)field)) {
                value = context.getEarlyWarn().getName().toString();
                macroMap.put(field, value);
                allDataMap.put(field, value);
                continue;
            }
            if (StringUtils.equals((CharSequence)EARLY_WARN_NUMBER, (CharSequence)field)) {
                value = context.getEarlyWarn().getNumber();
                macroMap.put(field, value);
                allDataMap.put(field, value);
                continue;
            }
            if (StringUtils.equals((CharSequence)WARN_SCHEDULE_NAME, (CharSequence)field)) {
                value = context.getWarnSchedule().getName().toString();
                macroMap.put(field, value);
                allDataMap.put(field, value);
                continue;
            }
            if (StringUtils.equals((CharSequence)WARN_SCHEDULE_NUMBER, (CharSequence)field)) {
                value = context.getWarnSchedule().getNumber();
                macroMap.put(field, value);
                allDataMap.put(field, value);
                continue;
            }
            List<String> processResult = this.getMergeFieldResult(null, context, field, msgCounts);
            if (processResult.isEmpty()) {
                macroMap.put(field, "");
                allDataMap.put(field, "");
                continue;
            }
            macroMap.put(field, processResult.get(0));
            allDataMap.put(field, processResult.get(1));
        }
        String title = context.getWarnSchedule().getMessageConfig().getTitle();
        StringTemplateParser logParser = new StringTemplateParser();
        try {
            logger.info(ResManager.loadKDString((String)"\u9884\u8b66\u5b8c\u6574\u6d88\u606f\uff1a", (String)"DefaultBillMessageCompiler_0", (String)"bos-earlywarn", (Object[])new Object[0]) + title + logParser.parse(expression, allDataMap::get));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        StringTemplateParser parser = new StringTemplateParser();
        return parser.parse(expression, macroName -> (String)macroMap.get(macroName));
    }

    private int getMergeMessageCounts() {
        String messageCounts = System.getProperty("earlywarn_merge_message_counts", "20");
        Pattern pattern = Pattern.compile("[0-9]*");
        if (!pattern.matcher(messageCounts).matches()) {
            return 20;
        }
        int counts = Integer.parseInt(messageCounts);
        if (counts < 1) {
            counts = 1;
        } else if (counts > 1000) {
            counts = 1000;
        }
        return counts;
    }

    private List<String> getMergeFieldResult(DynamicObjectCollection dataList, EarlyWarnContext context, String field, int msgCounts) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (null == dataList || dataList.isEmpty()) {
            dataList = context.getWarnDataList();
        }
        if (null == dataList || dataList.isEmpty()) {
            return resultList;
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> allResult = new ArrayList<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            DynamicObject data = (DynamicObject)dataList.get(i);
            try {
                List<String> oneDataList = this.dataProcessing(null, field, data, null, context, null);
                if (i < msgCounts) {
                    result.addAll(oneDataList);
                }
                allResult.addAll(oneDataList);
                continue;
            }
            catch (KDBizException e) {
                if ("NoFieldError".equalsIgnoreCase(e.getErrorCode().getCode())) {
                    result.add("{" + field + "}");
                    allResult.add("{" + field + "}");
                    continue;
                }
                throw e;
            }
        }
        String dots = "";
        if (result.size() < allResult.size()) {
            dots = "...";
        }
        if (result.size() > msgCounts) {
            result.subList(msgCounts - 1, result.size() - 1).clear();
            dots = "...";
        }
        resultList.add(String.join((CharSequence)"\uff0c", result) + dots);
        resultList.add(String.join((CharSequence)"\uff0c", allResult));
        return resultList;
    }

    @Override
    public String getGroupMergeMessage(MergeMessageArgs mergeMessageArgs) {
        ArrayList<String> headMessages = new ArrayList<String>();
        ArrayList<String> endMessages = new ArrayList<String>();
        StringTemplateParser parser = new StringTemplateParser();
        ArrayList<Map<String, List<String>>> tableFieldValue = new ArrayList<Map<String, List<String>>>();
        MessageContentFields fields = mergeMessageArgs.getContentFields();
        List<String> messageHeadFields = fields.getMessageHeadFields();
        List<String> messageEndFields = fields.getMessageEndFields();
        boolean isContinueHead = !this.isOnlyContainCommonFields(messageHeadFields);
        boolean isContinueEnd = !this.isOnlyContainCommonFields(messageEndFields);
        MessageContent messageContent = mergeMessageArgs.getMessageContent();
        EarlyWarnContext context = mergeMessageArgs.getContext();
        int remainingLength = 520000;
        int messageHeadLength = 0;
        for (DynamicObject row : mergeMessageArgs.getCurrentData()) {
            HashMap<String, String> macroMap = new HashMap<String, String>();
            if (isContinueHead || CollectionUtils.isEmpty(headMessages)) {
                if (CollectionUtils.isNotEmpty(messageHeadFields)) {
                    for (String headField : messageHeadFields) {
                        if (macroMap.containsKey(headField)) continue;
                        macroMap.put(headField, this.convertToMessageString(this.getRowFieldValue(context, headField, row)));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)messageContent.getMessageHead())) {
                    String headContent = parser.parse(messageContent.getMessageHead(), macroMap::get);
                    headMessages.add(headContent);
                    messageHeadLength = messageHeadLength + headContent.length() + 5;
                }
            }
            HashMap<String, List<String>> rowTableValue = new HashMap<String, List<String>>();
            List<String> messageTableFields = fields.getMessageTableFields();
            if (CollectionUtils.isNotEmpty(messageTableFields)) {
                for (String tableField : messageTableFields) {
                    if (rowTableValue.containsKey(tableField)) continue;
                    rowTableValue.put(tableField, this.getRowFieldValue(context, tableField, row));
                }
                if (MapUtils.isNotEmpty(rowTableValue)) {
                    rowTableValue.put("pkid", Collections.singletonList(row.getPkValue().toString()));
                    tableFieldValue.add(rowTableValue);
                }
            }
            if (!isContinueEnd && !CollectionUtils.isEmpty(endMessages)) continue;
            if (CollectionUtils.isNotEmpty(messageEndFields)) {
                for (String endField : messageEndFields) {
                    if (macroMap.containsKey(endField)) continue;
                    macroMap.put(endField, this.convertToMessageString(this.getRowFieldValue(context, endField, row)));
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)messageContent.getMessageEnd())) continue;
            endMessages.add(parser.parse(messageContent.getMessageEnd(), macroMap::get));
        }
        String tableMessage = "";
        List<MessageTableColumn> messageTable = messageContent.getTableColumns();
        if (CollectionUtils.isNotEmpty(messageTable) && (remainingLength -= messageHeadLength) > 0) {
            tableMessage = new MessageTableBuilder(messageTable, tableFieldValue, context.getEarlyWarn().getDataSourceId(), remainingLength).build();
        }
        return this.buildMergeMessage(headMessages, tableMessage, endMessages);
    }

    private String buildMergeMessage(List<String> headMessages, String tableMessage, List<String> endMessages) {
        StringBuilder message = new StringBuilder();
        String messageHead = "";
        String messageEnd = "";
        boolean isContainTable = StringUtils.isNotBlank((CharSequence)tableMessage);
        if (CollectionUtils.isNotEmpty(headMessages)) {
            messageHead = isContainTable ? "<p>" + String.join((CharSequence)"</br>", headMessages) + "</p>" : String.join((CharSequence)System.lineSeparator(), headMessages) + System.lineSeparator();
        }
        message.append(messageHead);
        if (520000 - messageHead.length() <= 0) {
            return message.substring(0, 520000) + "...";
        }
        message.append(tableMessage);
        int remainingLength = 520000 - message.length();
        if (remainingLength <= 0) {
            return message.toString();
        }
        if (CollectionUtils.isNotEmpty(endMessages)) {
            messageEnd = isContainTable ? "<p>" + String.join((CharSequence)"</br>", endMessages) + "</p>" : String.join((CharSequence)System.lineSeparator(), endMessages);
        }
        if (remainingLength < messageEnd.length()) {
            messageEnd = messageEnd.substring(0, remainingLength) + "...";
        }
        message.append(messageEnd);
        return message.toString();
    }

    private List<String> getRowFieldValue(EarlyWarnContext context, String field, DynamicObject row) {
        ArrayList<String> fieldValue = new ArrayList<String>(2);
        if (StringUtils.equals((CharSequence)TOTAL_COUNT, (CharSequence)field)) {
            Integer value = context.getWarnDataList().size();
            fieldValue.add(StringUtil.toSafeString((Object)value));
        } else if (StringUtils.equals((CharSequence)EARLY_WARN_NAME, (CharSequence)field)) {
            fieldValue.add(context.getEarlyWarn().getName().toString());
        } else if (StringUtils.equals((CharSequence)EARLY_WARN_NUMBER, (CharSequence)field)) {
            fieldValue.add(context.getEarlyWarn().getNumber());
        } else if (StringUtils.equals((CharSequence)WARN_SCHEDULE_NAME, (CharSequence)field)) {
            fieldValue.add(context.getWarnSchedule().getName().toString());
        } else if (StringUtils.equals((CharSequence)WARN_SCHEDULE_NUMBER, (CharSequence)field)) {
            fieldValue.add(context.getWarnSchedule().getNumber());
        }
        if (CollectionUtils.isNotEmpty(fieldValue)) {
            return fieldValue;
        }
        try {
            return this.dataProcessing(null, field, row, null, context, null);
        }
        catch (KDBizException e) {
            if ("NoFieldError".equalsIgnoreCase(e.getErrorCode().getCode())) {
                fieldValue.add("{" + field + "}");
                return fieldValue;
            }
            throw e;
        }
    }

    private String convertToMessageString(List<String> fieldValue) {
        return "(" + String.join((CharSequence)"\uff0c", fieldValue) + ")";
    }

    private boolean isOnlyContainCommonFields(List<String> fields) {
        boolean isOnlyContainCommonFields = true;
        if (CollectionUtils.isEmpty(fields)) {
            return isOnlyContainCommonFields;
        }
        for (String field : fields) {
            if (commonFields.contains(field)) continue;
            isOnlyContainCommonFields = false;
            break;
        }
        return isOnlyContainCommonFields;
    }

    private InteTimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = InteTimeZone.getUserTimeZone((long)RequestContext.getOrCreate().getCurrUserId());
        }
        return this.timeZone;
    }

    @Override
    public List<MulilangConfig> buildGroupMergeMulilangConfig(Map<MulilangConfig, MessageContentFields> muilangContentFieldMap, DynamicObjectCollection list, List<String> titleFields, EarlyWarnContext context) {
        ArrayList<MulilangConfig> mulilangConfigs = new ArrayList<MulilangConfig>(muilangContentFieldMap.size());
        for (Map.Entry<MulilangConfig, MessageContentFields> entry : muilangContentFieldMap.entrySet()) {
            MulilangConfig mulilangConfigTemplate = entry.getKey();
            MulilangConfig mulilangConfig = mulilangConfigTemplate.copy();
            MergeMessageArgs mergeMessageArgs = new MergeMessageArgs(mulilangConfig.getMessageContent(), entry.getValue(), list, context);
            String groupMergeMessage = this.getGroupMergeMessage(mergeMessageArgs);
            mulilangConfig.setMergeContent(groupMergeMessage);
            String title = this.getMergeTitle(mulilangConfig.getTitle(), titleFields, list, context);
            mulilangConfig.setTitle(title);
            mulilangConfigs.add(mulilangConfig);
        }
        return mulilangConfigs;
    }

    @Override
    public List<MulilangConfig> buildMergeMulilangConfig(List<MulilangConfig> mulilangConfigs, List<String> fields, List<String> titleFields, EarlyWarnContext context) {
        ArrayList<MulilangConfig> newMulilangConfigs = new ArrayList<MulilangConfig>(mulilangConfigs.size());
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            MulilangConfig newMulilangConfig = mulilangConfig.copy();
            String mergeMessage = this.getMergeMessage(newMulilangConfig.getMergeContent(), fields, context);
            newMulilangConfig.setMergeContent(mergeMessage);
            String title = this.getMergeTitle(newMulilangConfig.getTitle(), titleFields, null, context);
            newMulilangConfig.setTitle(title);
            newMulilangConfigs.add(newMulilangConfig);
        }
        return newMulilangConfigs;
    }

    @Override
    public boolean isExistMulilangConfig(EarlyWarnContext context, List<MulilangConfig> mulilangConfigTemplates) {
        return CollectionUtils.isNotEmpty(mulilangConfigTemplates);
    }
}

