/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.impl;

import java.sql.ResultSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnMessageInfo;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;

public class DefaultWarnMessageHandler
implements IEarlyWarnMessageHandler {
    private final Log logger = LogFactory.getLog(DefaultWarnMessageHandler.class);
    private String clientPath = "";
    private String formId = "";
    private String mobFormId = "";

    public DefaultWarnMessageHandler(EarlyWarnContext context) {
        RequestContext ctx = RequestContext.get();
        this.clientPath = UrlService.getDomainContextUrlByTenantCode((String)ctx.getTenantCode());
        this.logger.info("DefaultWarnMessageHandler:" + this.clientPath);
        this.logger.info("DefaultWarnMessageHandler:" + UrlService.getDomainContextUrl());
        this.formId = context.getEarlyWarn().getDataSourceId();
        if (StringUtils.isNotEmpty((CharSequence)this.formId)) {
            try {
                ResultSetHandler<String> action = new ResultSetHandler<String>(){

                    public String handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getString("fnumber");
                        }
                        return null;
                    }
                };
                String sql = "select fnumber from t_meta_form where fid = (select fid  from t_meta_entitydesign where fnumber = '" + this.formId + "') and ftype = 1 and fnumber != '" + this.formId + "'";
                this.mobFormId = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)action);
            }
            catch (Exception e) {
                this.logger.error("GETMOB_ERROR \uff1a " + e);
            }
        }
    }

    @Override
    public EarlyWarnMessageInfo singleMessageBuilder(DynamicObject data, EarlyWarnContext context) {
        if (StringUtils.isNotEmpty((CharSequence)this.clientPath) && StringUtils.isNotEmpty((CharSequence)this.formId) && data != null) {
            EarlyWarnMessageInfo messageInfo = new EarlyWarnMessageInfo();
            String pkId = data.get("id").toString();
            StringBuilder contentUrl = new StringBuilder(this.clientPath);
            contentUrl = contentUrl.append("?formId=").append(this.formId).append("&pkId=").append(pkId);
            if (StringUtils.isNotEmpty((CharSequence)this.mobFormId)) {
                StringBuilder mobContentUrl = new StringBuilder(this.clientPath);
                if (!this.clientPath.endsWith("/")) {
                    mobContentUrl = mobContentUrl.append("/");
                }
                mobContentUrl = mobContentUrl.append("integration/yzjShareOpen.do?formId=").append(this.formId).append("&mb_formId=").append(this.mobFormId).append("&pkId=").append(pkId).append("&src=wf");
                this.logger.info("DefaultWarnMessageHandler:" + mobContentUrl);
                messageInfo.setMobContentUrl(mobContentUrl.toString());
            }
            messageInfo.setContentUrl(contentUrl.toString());
            return messageInfo;
        }
        return null;
    }

    @Override
    public EarlyWarnMessageInfo mergeMessageBuilder(EarlyWarnContext context) {
        return null;
    }
}

