/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.var;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.service.earlywarn.var.IVariableMode;

public class SourceFieldVariable
implements IVariableMode {
    private String var;
    private String[] keyItems;
    private String[] refProps;
    private IDataEntityProperty sourceField;
    private String fullPropName;

    public SourceFieldVariable(String var, String[] keyItems, IDataEntityProperty sourceField) {
        this.var = var;
        this.keyItems = keyItems;
        this.sourceField = sourceField;
        ArrayList<String> propNames = new ArrayList<String>(Arrays.asList(keyItems));
        if (sourceField instanceof EntryProp) {
            EntryType entryType;
            propNames.remove(0);
            if (keyItems.length == 1) {
                entryType = (EntryType)((EntryProp)this.sourceField).getItemType();
                this.sourceField = entryType.getPrimaryKey();
            } else {
                entryType = (EntryType)((EntryProp)this.sourceField).getItemType();
                IDataEntityProperty subProp = entryType.findProperty(keyItems[1]);
                if (subProp == null) {
                    subProp = entryType.findProperty(var);
                }
                if (subProp != null) {
                    this.sourceField = subProp;
                }
            }
        }
        if (this.sourceField.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)this.sourceField.getParent();
            this.fullPropName = subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".");
        } else {
            this.fullPropName = this.sourceField.getParent() instanceof EntryType ? this.sourceField.getParent().getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".") : var;
        }
        if (propNames.size() <= 1) {
            this.refProps = new String[0];
        } else {
            propNames.remove(0);
            this.refProps = StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)propNames.get(0)), (CharSequence)"id") ? new String[0] : propNames.toArray(new String[0]);
        }
    }

    @Override
    public String getVar() {
        return this.var;
    }

    @Override
    public void setVar(String var) {
        this.var = var;
        this.keyItems = StringUtils.split((String)var, (String)".");
    }

    @Override
    public String[] getKeyItems() {
        return this.keyItems;
    }

    @Override
    public void setKeyItems(String[] keyItems) {
        this.keyItems = keyItems;
    }

    public String[] getRefProps() {
        return this.refProps;
    }

    @Override
    public String getFldKey() {
        return this.keyItems[0];
    }

    public IDataEntityProperty getSourceField() {
        return this.sourceField;
    }

    public String getFullPropName() {
        return this.fullPropName;
    }

    @Override
    public Object getValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        DynamicProperty prop = fldProperties.get(this.var);
        return prop.getValueFast((Object)sourceRow);
    }
}

