/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ksql.util.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.log.service.LogSaveService;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.log.OperateConfirmLog;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class LogConsumer
implements MessageConsumer {
    private static String ENTITY_LOG_OPERATION = "bos_log_operation_v3";
    private static String ENTITY_LOG_OPERATION_OTHER = "bos_log_operation_other";
    private static final String PROPERTY_USER = "user";
    private static final String PROPERTY_BIZ_APP = "bizapp";
    private static final String PROPERTY_BIZ_OBJ = "bizobj";
    private static final String PROPERTY_ORG = "org";
    private static final String PROPERTY_OP_TIME = "optime";
    private static final String PROPERTY_CLIENT_TYPE = "clienttype";
    private static final String PROPERTY_CLIENT_IP = "clientip";
    private static final String PROPERTY_CLIENT_NAME = "clientnamee";
    private static final String PROPERTY_OP_NAME = "opnamee";
    private static final String PROPERTY_OP_DESCRIPTION = "opdescriptione";
    private static final String PROPERTY_OP_MODIFYBILLID = "modifybillid";
    private static final String PROPERTY_OP_MODIFYBILLNO = "modifybillno";
    private static final String PROPERTY_OP_MODIFYCONTENT = "modifycontent";
    private static final String PROPERTY_OP_MODIFYCONTENTTAG = "modifyContent_tag";
    private static final String PROPERTY_OP_MODIFYFIELDS = "modifyfields";
    private static Log logger = LogFactory.getLog(LogConsumer.class);
    private final String USERNAME_KEY = "username";
    private final String APP_KEY = "bizappname";
    private final String OBJ_KEY = "bizobjname";
    private final String ORG_KEY = "orgname";
    private static final int BATCH_SIZE = 1000;
    private static List<String> ADMINID_LIST = Arrays.asList("1", "2", "3");

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        List<AppLogInfo> logInfos = new ArrayList<AppLogInfo>();
        if (body instanceof OperateConfirmLog) {
            LogSaveService logSaveService = new LogSaveService();
            logSaveService.saveAuthOpLog((OperateConfirmLog)body);
            acker.ack(messageId);
            return;
        }
        if (body instanceof AppLogInfo) {
            logInfos.add((AppLogInfo)body);
        } else if (body instanceof List) {
            logInfos = (List)body;
        } else {
            logger.debug("\u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u65e5\u5fd7\u4fe1\u606f\uff01");
            acker.ack(messageId);
            return;
        }
        try {
            if (CollectionUtils.isNotEmpty(logInfos)) {
                long t1 = System.currentTimeMillis();
                AppLogInfo logInfo = (AppLogInfo)logInfos.get(0);
                LogSaveService logSaveService = new LogSaveService();
                if (logInfo.getLogType() == 1) {
                    logSaveService.saveLoginLog(logInfos);
                    acker.ack(messageId);
                } else {
                    Tuple<Boolean, String> deployEs = this.hasDeployedEs();
                    if (StringUtils.isEmpty((String)logInfo.getModifyBillID()) && ((Boolean)deployEs.item1).booleanValue()) {
                        try {
                            logSaveService.saveToEs(logInfos, (String)deployEs.item2);
                            acker.ack(messageId);
                        }
                        catch (Exception e) {
                            logger.error("\u6d88\u606f\u65e5\u5fd7\u5199\u5165Elasticsearch \u5f02\u5e38", (Throwable)e);
                            acker.deny(messageId);
                        }
                    } else {
                        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(logInfos.size());
                        ArrayList<AppLogInfo> adminLogInfos = new ArrayList<AppLogInfo>(8);
                        ArrayList<DynamicObject> othersLogInfos = new ArrayList<DynamicObject>(1000);
                        for (AppLogInfo appLogInfo : logInfos) {
                            try {
                                DynamicObject appLogObj;
                                this.shortIpAddr(appLogInfo);
                                if (LogConsumer.isAdminLog(appLogInfo).booleanValue()) {
                                    adminLogInfos.add(appLogInfo);
                                    continue;
                                }
                                if (LogConsumer.isOtherLog(appLogInfo).booleanValue()) {
                                    appLogObj = this.createOtherLogInfoDynamicObject(appLogInfo);
                                    othersLogInfos.add(appLogObj);
                                    continue;
                                }
                                appLogObj = this.createOpLogInfoDynamicObject(appLogInfo);
                                logObjs.add(appLogObj);
                            }
                            catch (Exception e) {
                                logger.error("createLogDynamicObject error:", (Throwable)e);
                            }
                        }
                        this.saveLogEntity(logObjs, acker, messageId);
                        this.saveLogEntity(othersLogInfos, acker, messageId);
                        logSaveService.saveSupperAdminLog(adminLogInfos);
                        acker.ack(messageId);
                    }
                    logger.debug("consumer log size={},costs={}", (Object)logInfos.size(), (Object)(System.currentTimeMillis() - t1));
                }
            } else {
                acker.ack(messageId);
            }
        }
        catch (Exception e) {
            logger.error("not hand exception\u3002 discard message\u3002", (Throwable)e);
            acker.discard(messageId);
        }
    }

    private void shortIpAddr(AppLogInfo appLogInfo) {
        String ipAddr = appLogInfo.getClientIP();
        if (StringUtils.isNotEmpty((String)ipAddr)) {
            appLogInfo.setClientIP(ipAddr.split(",")[0]);
        }
    }

    private void saveLogEntity(List<DynamicObject> logObjs, MessageAcker acker, String messageId) {
        if (!logObjs.isEmpty()) {
            if (logObjs.size() > 1000) {
                ArrayList<DynamicObject> dataBuffer = new ArrayList<DynamicObject>(1000);
                for (DynamicObject temp : logObjs) {
                    dataBuffer.add(temp);
                    if (dataBuffer.size() < 1000) continue;
                    this.batchInsertWithDowngrade(dataBuffer.toArray(new DynamicObject[0]));
                    dataBuffer.clear();
                }
                if (!dataBuffer.isEmpty()) {
                    this.batchInsertWithDowngrade(dataBuffer.toArray(new DynamicObject[0]));
                    dataBuffer.clear();
                }
            } else {
                DynamicObject[] dataEntities = logObjs.toArray(new DynamicObject[0]);
                try (TXHandle h = TX.beginRequired();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])dataEntities);
                    }
                    catch (Exception e) {
                        logger.debug("deny op log:", (Object)e);
                        h.markRollback();
                        acker.deny(messageId);
                    }
                }
            }
        }
    }

    private DynamicObject createOtherLogInfoDynamicObject(AppLogInfo appLogInfo) {
        DynamicObject appLogObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LOG_OPERATION_OTHER);
        this.setLogCommonInfo(appLogObj, appLogInfo);
        appLogObj.set(PROPERTY_OP_MODIFYBILLID, (Object)appLogInfo.getModifyBillID());
        appLogObj.set(PROPERTY_OP_MODIFYBILLNO, (Object)appLogInfo.getModifyBillNo());
        appLogObj.set(PROPERTY_OP_MODIFYCONTENTTAG, (Object)appLogInfo.getModifyContentTag());
        appLogObj.set(PROPERTY_OP_MODIFYFIELDS, (Object)appLogInfo.getModifyFields());
        appLogObj.set(PROPERTY_CLIENT_NAME, (Object)appLogInfo.getClientName());
        String opName = LogSaveService.getOpName(appLogInfo);
        appLogObj.set(PROPERTY_OP_NAME, (Object)opName);
        appLogObj.set(PROPERTY_CLIENT_IP, (Object)appLogInfo.getClientIP());
        if (appLogInfo instanceof OpLogAppInfo) {
            OpLogAppInfo logAppInfo = (OpLogAppInfo)appLogInfo;
            String opDesc = logAppInfo.getOpDescription();
            opDesc = LogSaveService.getOpDisplayDesc(Lang.zh_CN, opDesc, logAppInfo.getOpDescProjId(), logAppInfo.getOpDescResId(), logAppInfo.getOpDescArgs());
            logAppInfo.setOpDescription(opDesc);
        }
        if (StringUtils.isNotEmpty((String)appLogInfo.getOpDescription())) {
            appLogObj.set(PROPERTY_OP_DESCRIPTION, (Object)(appLogInfo.getOpDescription().length() > 255 ? appLogInfo.getOpDescription().substring(0, 255) : appLogInfo.getOpDescription()));
        }
        return appLogObj;
    }

    private DynamicObject createOpLogInfoDynamicObject(AppLogInfo appLogInfo) {
        DynamicObject appLogObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LOG_OPERATION);
        this.setLogCommonInfo(appLogObj, appLogInfo);
        appLogObj.set("status", (Object)appLogInfo.getStatus());
        String opName = appLogInfo.getOpName();
        if (StringUtils.isNotEmpty((String)opName)) {
            opName = opName.length() > 90 ? opName.substring(0, 90) : opName;
            appLogObj.set("opname", (Object)opName);
        }
        if (StringUtils.isNotEmpty((String)appLogInfo.getClientIP())) {
            appLogObj.set(PROPERTY_CLIENT_IP, (Object)(appLogInfo.getClientIP().length() > 50 ? appLogInfo.getClientIP().substring(0, 50) : appLogInfo.getClientIP()));
        }
        if (StringUtils.isNotEmpty((String)appLogInfo.getOpDescription())) {
            appLogObj.set("opdesc", (Object)(appLogInfo.getOpDescription().length() > 255 ? appLogInfo.getOpDescription().substring(0, 255) : appLogInfo.getOpDescription()));
        }
        if (appLogInfo instanceof OpLogAppInfo) {
            OpLogAppInfo opLogAppInfo = (OpLogAppInfo)appLogInfo;
            appLogObj.set("keyword", (Object)opLogAppInfo.getModifyBillNo());
            appLogObj.set("opkey", (Object)opLogAppInfo.getOpKey());
            appLogObj.set("opproj", (Object)opLogAppInfo.getOpProjId());
            appLogObj.set("opres", (Object)opLogAppInfo.getOpResId());
            appLogObj.set("opdescproj", (Object)opLogAppInfo.getOpDescProjId());
            appLogObj.set("opdescres", (Object)opLogAppInfo.getOpDescResId());
            String opDescArgs = opLogAppInfo.getOpDescArgs();
            try {
                if (StringUtils.isNotEmpty((String)opDescArgs) && opDescArgs.length() > 255) {
                    String[] array = (String[])SerializationUtils.fromJsonString((String)opDescArgs, String[].class);
                    int needSubLen = opDescArgs.length() - 254;
                    for (int i = array.length - 1; i >= 0; --i) {
                        String str = array[i];
                        if (needSubLen <= 0) break;
                        if (str.length() <= needSubLen) {
                            array[i] = "";
                            needSubLen -= str.length();
                            continue;
                        }
                        array[i] = str = str.substring(0, str.length() - needSubLen);
                        break;
                    }
                    opDescArgs = SerializationUtils.toJsonString((Object)array);
                }
            }
            catch (Exception e) {
                logger.error("log args hand exception:", (Throwable)e);
                opDescArgs = "";
            }
            appLogObj.set("opdescargs", (Object)opDescArgs);
            opName = LogSaveService.getOpName(appLogInfo);
            appLogObj.set("opname", (Object)opName);
        }
        return appLogObj;
    }

    private void setLogCommonInfo(DynamicObject appLogObj, AppLogInfo appLogInfo) {
        try {
            DynamicObject obj;
            String bizAppID;
            appLogObj.set(PROPERTY_USER, (Object)appLogInfo.getUserID());
            if (0L != appLogInfo.getUserID()) {
                MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u533f\u540d\u7528\u6237", "LogOperactionListPluginV3_0", "bos-log-formplugin");
                String userName = bridge.getDescription();
                DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getUserID(), (String)"bos_user", (String)"name");
                if (null != user) {
                    userName = this.getLocaleValue_zh_CN(user, "name", userName);
                }
                appLogObj.set("username", (Object)userName);
            }
            if (!StringUtil.isEmpty((String)(bizAppID = appLogInfo.getBizAppID()))) {
                try {
                    String appIdByAppNumber = BizAppServiceHelp.getAppIdByAppNumber((String)bizAppID);
                    if (!StringUtil.isEmpty((String)appIdByAppNumber)) {
                        bizAppID = appIdByAppNumber;
                    }
                }
                catch (Exception appIdByAppNumber) {
                    // empty catch block
                }
            }
            appLogObj.set(PROPERTY_BIZ_APP, (Object)bizAppID);
            appLogObj.set(PROPERTY_BIZ_OBJ, (Object)appLogInfo.getBizObjID());
            String bizObjName = new MultiLangEnumBridge("\u7a7a\u5bf9\u8c61", "LogConsumer_7", "bos-mservice-log").getDescription();
            if (StringUtils.isNotEmpty((String)appLogInfo.getBizObjID()) && null != (obj = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getBizObjID(), (String)"bos_objecttype", (String)"id,name"))) {
                bizObjName = this.getLocaleValue_zh_CN(obj, "name", bizObjName);
            }
            appLogObj.set("bizobjname", (Object)bizObjName);
            appLogObj.set(PROPERTY_ORG, (Object)appLogInfo.getOrgID());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        appLogObj.set(PROPERTY_OP_TIME, (Object)appLogInfo.getOpTime());
        appLogObj.set(PROPERTY_CLIENT_TYPE, (Object)appLogInfo.getClientType());
    }

    private String getLocaleValue_zh_CN(DynamicObject obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        Object objVal = obj.get(key);
        if (objVal instanceof ILocaleString) {
            ILocaleString localeString = (ILocaleString)objVal;
            String returnVal = localeString.getLocaleValue_zh_CN();
            if (StringUtils.isEmpty((String)returnVal)) {
                returnVal = localeString.getLocaleValue_en();
            }
            if (StringUtils.isNotEmpty((String)returnVal)) {
                return returnVal;
            }
        }
        return defaultValue;
    }

    private void batchInsertWithDowngrade(DynamicObject[] data) {
        block17: {
            try (TXHandle h = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])data);
            }
            catch (Exception e) {
                logger.debug("save oplog error:", (Object)e);
                if (!e.getCause().toString().contains("java.sql.SQLException")) break block17;
                for (DynamicObject record : data) {
                    try {
                        this.insertOne(record);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void insertOne(DynamicObject record) {
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
        catch (Exception ignore) {
            logger.debug("discare op log:", (Object)ignore);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tuple<Boolean, String> hasDeployedEs() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties == null) return new Tuple((Object)false, null);
        if (properties.size() <= 0) return new Tuple((Object)false, null);
        String sql = "select top 1,0 fid,fname from t_log_index where fstatus='1' order by fcreatetime desc";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (dataSet.isEmpty()) return new Tuple((Object)false, null);
            Tuple tuple = new Tuple((Object)true, (Object)dataSet.next().getString(1));
            return tuple;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7d22\u5f15\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return new Tuple((Object)false, null);
        }
    }

    private static Boolean isAdminLog(AppLogInfo appLogInfo) {
        Boolean flag = false;
        if (StringUtils.isNotEmpty((String)appLogInfo.getModifyBillID())) {
            return flag;
        }
        if (null != appLogInfo.getUserID() && ADMINID_LIST.contains(appLogInfo.getUserID().toString())) {
            flag = true;
        }
        return flag;
    }

    private static Boolean isOtherLog(AppLogInfo appLogInfo) {
        if ("web".equals(appLogInfo.getClientType()) || "mobile".equals(appLogInfo.getClientType())) {
            return false;
        }
        return true;
    }
}

